/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.log.CFLogs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class FileUtils {
    public static void copy(String source, String dest) {
        Path sourceP = Paths.get(source, new String[0]);
        Path destP = Paths.get(dest, new String[0]);
        try {
            Files.copy(sourceP, destP, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e.getMessage());
        }
    }

    public static boolean deleteDirectoryRecusrively(String directoryForDeleteS) {
        final File directoryForDelete = new File(directoryForDeleteS);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return FileUtils._deleteDirectoryRecusrively(directoryForDelete);
                }
            });
        }
        catch (PrivilegedActionException e) {
            CFLogs.SERVER_LOG.error(e.getMessage());
        }
        return false;
    }

    static boolean _deleteDirectoryRecusrively(File directoryForDelete) {
        File[] files = directoryForDelete.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils._deleteDirectoryRecusrively(file);
            }
        }
        try {
            Files.delete(Paths.get(directoryForDelete.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

