/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;

public class FormatSource {
    boolean tagDef = false;
    boolean commentDef = false;
    public static final String TAG_COLOR = "<font color=\"#0033CC\">";
    public static final String ATTR_COLOR = "<font color=\"#663366\">";
    public static final String VAL_COLOR = "<font color=\"#009900\">";
    public static final String BIND_COLOR = "<font color=\"#FF9900\">";
    public static final String COMMENT_COLOR = "<font color=\"#009999\">";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatFile(String fileName) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), this.getEncoding(fileName)));
            String string = this.format(in);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return "";
    }

    public String formatString(String code) {
        BufferedReader in = null;
        in = new BufferedReader(new InputStreamReader(new StringBufferInputStream(code)));
        return this.format(in);
    }

    private void getCSS(StringBuffer sb) {
        sb.append("<style>\n");
        sb.append(".cfsource_tag{ color:#0033CC; font-family:arial; }\n");
        sb.append(".cfsource_attribute{ color:#663366; font-family:arial; }\n");
        sb.append(".cfsource_value{ color:#009900; font-family:arial; }\n");
        sb.append(".cfsource_bind{ color:#FF9900; font-family:arial; }\n");
        sb.append(".cfsource_comment{ color:#009999; font-family:arial; }\n");
        sb.append("</style>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(BufferedReader in) {
        StringBuffer source = new StringBuffer();
        try {
            String line;
            boolean scriptDef = false;
            while ((line = in.readLine()) != null) {
                if (line.toLowerCase().indexOf("<mx:script>") >= 0 || line.toLowerCase().indexOf("<cfscript>") >= 0 || line.toLowerCase().indexOf("<script>") >= 0) {
                    scriptDef = true;
                    source.append(this.formatLine(line));
                    source.append("<br>");
                    continue;
                }
                if (scriptDef) {
                    if (line.toLowerCase().indexOf("</mx:Script>") >= 0 || line.toLowerCase().indexOf("</cfscript>") >= 0 || line.toLowerCase().indexOf("</script>") >= 0) {
                        scriptDef = false;
                        source.append(this.formatLine(line));
                        source.append("<br>");
                        continue;
                    }
                    source.append(this.formatPlainLine(line));
                    source.append("<br>");
                    continue;
                }
                source.append(this.formatLine(line));
                source.append("<br>");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return source.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEncoding(String fileName) {
        String encoding = "UTF-8";
        BufferedReader in = null;
        try {
            int index;
            in = new BufferedReader(new FileReader(fileName));
            String line = in.readLine();
            if (line != null && (index = line.indexOf("encoding")) != -1) {
                line = line.substring(index + "encoding=\"".length());
                encoding = line.substring(0, line.indexOf("\""));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return encoding;
    }

    private StringBuffer formatLine(String line) {
        int length = line.length();
        StringBuffer newLine = new StringBuffer();
        int prevChar = 42;
        boolean attrDef = false;
        for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (c == '<') {
                if (line.charAt(i + 1) == '!') {
                    newLine.append(COMMENT_COLOR);
                    this.commentDef = true;
                } else {
                    newLine.append(TAG_COLOR);
                    this.tagDef = true;
                }
                newLine.append("&lt;");
            } else if (c == ' ') {
                if (this.tagDef && !attrDef && prevChar != 32 && prevChar != 34 && i != 0) {
                    newLine.append("</font>&#32;");
                } else if (attrDef) {
                    newLine.append(c);
                } else {
                    newLine.append("&#32;");
                }
            } else if (c == '/') {
                if (prevChar == 60 || attrDef) {
                    newLine.append(c);
                } else {
                    newLine.append(TAG_COLOR);
                    newLine.append("/</font>");
                }
            } else if (c == '>') {
                if (this.commentDef) {
                    this.commentDef = false;
                    newLine.append("&gt;</font>");
                } else {
                    if (prevChar != 32 && prevChar != 34 && prevChar != 47 && prevChar != 63) {
                        newLine.append("&gt;</font>");
                    } else {
                        newLine.append(TAG_COLOR);
                        newLine.append("&gt;</font>");
                    }
                    this.tagDef = false;
                }
            } else if (c == '=' && this.tagDef) {
                newLine.append("=</font>");
                newLine.append(VAL_COLOR);
            } else if (c == '\"' && this.tagDef) {
                if (attrDef) {
                    newLine.append("\"</font>");
                } else {
                    newLine.append(c);
                }
                attrDef = !attrDef;
            } else if (c == '{') {
                newLine.append(BIND_COLOR);
                newLine.append("{");
            } else if (c == '}') {
                newLine.append("}</font>");
            } else if (c == '\t') {
                newLine.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            } else if (prevChar == 32 && this.tagDef && !attrDef) {
                newLine.append(ATTR_COLOR);
                newLine.append(c);
            } else {
                newLine.append(c);
            }
            prevChar = c;
        }
        return newLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatPlain(String fileName) {
        StringBuffer source = new StringBuffer();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(fileName));
            while ((line = in.readLine()) != null) {
                source.append(this.formatPlainLine(line));
                source.append("<br>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return source.toString();
    }

    private StringBuffer formatPlainLine(String line) {
        int length = line.length();
        StringBuffer newLine = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (c == '<') {
                newLine.append("&lt;");
                continue;
            }
            if (c == '>') {
                newLine.append("&gt;");
                continue;
            }
            if (c == '\t') {
                newLine.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                continue;
            }
            newLine.append(c);
        }
        return newLine;
    }
}

