/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.ApplicationException;
import coldfusion.scheduling.RunnableFactory;
import coldfusion.scheduling.ThreadPool;
import coldfusion.security.SandBoxSecurityContext;
import java.util.LinkedList;

public class GenericThreadPool {
    private final LinkedList taskQueue;
    private final ThreadPool threadPool;
    private int maxQueueSize;
    private int idleTimeOut;
    private boolean fixedSize = false;

    public GenericThreadPool(String groupName, int maxQueueSize, int threadCount) {
        this(groupName, maxQueueSize, threadCount, threadCount, 0);
        this.fixedSize = true;
    }

    public GenericThreadPool(String groupName, int maxQueueSize, int minThreadCount, int maxThreadCount, int idleTimeout) {
        this.maxQueueSize = maxQueueSize;
        if (idleTimeout > 0) {
            this.idleTimeOut = idleTimeout;
        }
        this.taskQueue = new LinkedList();
        this.threadPool = new ThreadPool(groupName, new ThreadPoolRunnableFactory());
        this.setPoolSize(minThreadCount, maxThreadCount);
    }

    public GenericThreadPool(String groupName, int maxQueueSize, int minThreadCount, int maxThreadCount, int idleTimeout, SandBoxSecurityContext threadSandboxContext) {
        this.maxQueueSize = maxQueueSize;
        if (idleTimeout > 0) {
            this.idleTimeOut = idleTimeout;
        }
        this.taskQueue = new LinkedList();
        this.threadPool = new ThreadPool(groupName, new ThreadPoolRunnableFactory(), threadSandboxContext);
        this.setPoolSize(minThreadCount, maxThreadCount);
    }

    public void setPoolSize(int minThreadCount, int maxThreadCount) {
        if (this.fixedSize) {
            return;
        }
        this.threadPool.setMaxThreads(maxThreadCount);
        this.threadPool.setActiveThreads(maxThreadCount);
        this.threadPool.setMinThreads(minThreadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(Runnable task2) throws QueueFullException {
        LinkedList linkedList = this.taskQueue;
        synchronized (linkedList) {
            if (this.taskQueue.size() == this.maxQueueSize) {
                throw new QueueFullException(this.maxQueueSize);
            }
            this.taskQueue.addLast(task2);
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTask(Runnable task2) {
        LinkedList linkedList = this.taskQueue;
        synchronized (linkedList) {
            return this.taskQueue.remove(task2);
        }
    }

    public int getQueueSize() {
        return this.taskQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.taskQueue;
        synchronized (linkedList) {
            this.taskQueue.clear();
        }
        this.threadPool.shutdown();
    }

    public boolean allThreadsBusy() {
        return this.threadPool.allThreadsBusy();
    }

    private class ThreadPoolRunnableFactory
    implements RunnableFactory {
        private ThreadPoolRunnableFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable createRunnable() throws InterruptedException {
            LinkedList linkedList = GenericThreadPool.this.taskQueue;
            synchronized (linkedList) {
                while (GenericThreadPool.this.taskQueue.isEmpty()) {
                    if (GenericThreadPool.this.idleTimeOut == 0) {
                        GenericThreadPool.this.taskQueue.wait();
                        continue;
                    }
                    long startTime = System.currentTimeMillis();
                    GenericThreadPool.this.taskQueue.wait(GenericThreadPool.this.idleTimeOut);
                    if (System.currentTimeMillis() - startTime < (long)GenericThreadPool.this.idleTimeOut) continue;
                    break;
                }
                if (GenericThreadPool.this.taskQueue.isEmpty()) {
                    return null;
                }
                return (Runnable)GenericThreadPool.this.taskQueue.removeFirst();
            }
        }

        @Override
        public Runnable swapRunnable(Runnable r) throws InterruptedException {
            return null;
        }

        @Override
        public void destroyRunnable(Runnable r, int reason) {
        }
    }

    public static class QueueFullException
    extends ApplicationException {
        public int maxQueueSize;

        public QueueFullException(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }
    }
}

