/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class IOUtils {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static final byte[] toByteArray(InputStream stream) {
        return IOUtils.toByteArray(stream, new ByteArrayOutputStream(), -1);
    }

    public static final byte[] toByteArray(InputStream stream, int maxSize) {
        return IOUtils.toByteArray(stream, new ByteArrayOutputStream(), maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final byte[] toByteArray(InputStream stream, ByteArrayOutputStream baos, int maxSize) {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
            out = new BufferedOutputStream(baos);
            int len = 0;
            int count = 0;
            byte[] bytes = new byte[8192];
            try {
                while ((len = in.read(bytes, 0, 8192)) != -1) {
                    if (count + len > maxSize && maxSize != -1) {
                        ((BufferedOutputStream)out).write(bytes, 0, maxSize - count);
                        break;
                    }
                    ((BufferedOutputStream)out).write(bytes, 0, len);
                    count += len;
                }
            }
            catch (IOException e) {
                ((BufferedOutputStream)out).flush();
                out.close();
                if (bytes.length > 0 && e.getMessage().indexOf("EOF") != -1) {
                    byte[] byArray = bytes;
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return byArray;
                }
                byte[] byArray = new byte[]{};
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return byArray;
            }
            ((BufferedOutputStream)out).flush();
            out.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
            {
                catch (Exception ex) {
                    byte[] byArray2 = new byte[]{};
                    return byArray2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toString(Reader r) {
        BufferedReader in = null;
        StringBuffer buffer = new StringBuffer();
        try {
            in = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
            String str = "";
            while ((str = in.readLine()) != null) {
                buffer.append(str);
                buffer.append(lineSeparator);
            }
            String string = buffer.toString();
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final char[] toCharArray(Reader r, int maxSize) {
        return IOUtils.toCharArray(r, new CharArrayWriter(), maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] toCharArray(Reader r, CharArrayWriter w, int maxSize) {
        BufferedReader in = null;
        try {
            in = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
            char[] chars = new char[8192];
            int count = 0;
            int len = 0;
            while ((len = in.read(chars)) != -1) {
                if (count + len > maxSize && maxSize != -1) {
                    w.write(chars, 0, maxSize - count);
                    break;
                }
                w.write(chars, 0, len);
                count += len;
            }
            char[] cArray = w.toCharArray();
            return cArray;
        }
        catch (Exception ex) {
            char[] cArray = new char[]{};
            return cArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveFile(File f, String str) throws IOException {
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        OutputStreamWriter w = null;
        try {
            w = new OutputStreamWriter(VFSFileFactory.getOutputStream(f));
            w.write(str);
            w.flush();
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveFile(File f, InputStream stream) throws IOException {
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(stream);
            out = new BufferedOutputStream(VFSFileFactory.getOutputStream(f));
            IOUtils.write(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.flush();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void copyFile(String src, String destination) throws IOException {
        IOUtils.copyFile(VFSFileFactory.getFileObject(src), VFSFileFactory.getFileObject(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File destination) throws IOException {
        File parent;
        if (destination.isDirectory()) {
            destination = VFSFileFactory.getFileObject(destination, src.getName());
        }
        if ((parent = destination.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        InputStream fis = null;
        OutputStream fos = null;
        try {
            fis = VFSFileFactory.getInputStream(src);
            fos = VFSFileFactory.getOutputStream(destination);
            IOUtils.write(fis, fos);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void write(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[2048];
        while ((read = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                IOUtils.delete(files[i]);
            }
        }
        file.delete();
    }

    public static void closeSilently(Closeable ... streams) {
        for (Closeable stream : streams) {
            try {
                if (stream == null) continue;
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

