/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.ConcurrentReferenceHashMap;
import coldfusion.util.CaseKey;
import coldfusion.util.Utils;
import java.io.Serializable;
import java.util.Map;

public class Key
implements Serializable {
    private String keyStr;
    private String ucasedKeyStr;
    private int hashcode;
    private static final Map<String, Key> keys = new ConcurrentReferenceHashMap<String, Key>(4096, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    public static final Key THIS = Key.getInstance("THIS");
    public static final Key VARIABLES = Key.getInstance("VARIABLES");
    public static final Key LOCAL = Key.getInstance("LOCAL");
    public static final Key ARGUMENTS = Key.getInstance("ARGUMENTS");
    public static final Key ATTRIBUTE = Key.getInstance("ATTRIBUTES");
    public static final Key SUPER = Key.getInstance("SUPER");
    public static final Key NAME = Key.getInstance("NAME");
    public static final Key FULLNAME = Key.getInstance("FULLNAME");
    public static final Key EXTENDS = Key.getInstance("EXTENDS");
    public static final Key PERSISTENT = Key.getInstance("PERSISTENT");
    public static final Key ACCESSORS = Key.getInstance("ACCESSORS");
    public static final Key EMBEDDED = Key.getInstance("EMBEDDED");
    public static final Key PATH = Key.getInstance("PATH");
    public static final Key TYPE = Key.getInstance("TYPE");
    public static final Key PROPERTIES = Key.getInstance("PROPERTIES");
    public static final Key PROPERTY_STRUCT = Key.getInstance("PROPERTY_STRUCT");
    public static final Key FUNCTIONS = Key.getInstance("FUNCTIONS");
    public static final Key ARGUMENTCOLLECTION = Key.getInstance("ARGUMENTCOLLECTION");
    public static final Key SERIALIZABLE = Key.getInstance("SERIALIZABLE");
    public static final Key PARAMETERS = Key.getInstance("PARAMETERS");
    public static final Key REQUIRED = Key.getInstance("REQUIRED");
    public static final Key IMPLEMENTS = Key.getInstance("IMPLEMENTS");
    public static final Key SETTER = Key.getInstance("SETTER");
    public static final Key GETTER = Key.getInstance("GETTER");
    public static final Key DEFAULT = Key.getInstance("DEFAULT");
    public static final Key NEWLY_COMPILED = Key.getInstance("NEWLY_COMPILED");
    public static final Key THREADSCOPE_NAME = Key.getInstance("CFTHREAD");
    public static final Key REST_PATH = Key.getInstance("restpath");
    public static final Key PRODUCES = Key.getInstance("produces");
    public static final Key HTTP_METHOD = Key.getInstance("httpmethod");

    public static Key getInstance(String str) {
        Key key = keys.get(str);
        if (key == null || key instanceof CaseKey) {
            key = new Key(str);
            if (str.length() < 40) {
                keys.put(str, key);
            }
        }
        return key;
    }

    protected Key() {
        this.keyStr = "";
    }

    Key(String key) {
        this.keyStr = key;
    }

    public String getKeyString() {
        return this.keyStr;
    }

    public String getUCasedString() {
        if (this.ucasedKeyStr == null) {
            this.ucasedKeyStr = Utils.toUpperCase(this.keyStr);
        }
        return this.ucasedKeyStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.hashCode() == o.hashCode() && o instanceof Key) {
            return this.getUCasedString().compareTo(((Key)o).getUCasedString()) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.getUCasedString().hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        return this.keyStr;
    }
}

