/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.ApplicationException;
import coldfusion.util.RB;
import coldfusion.util.SamlKeyPairGeneratorData;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class KeystoreUtils {
    private static final String BC = "BC";
    private static final String JKS_TYPE = "jks";
    private static final String PKCS12_TYPE = "pkcs12";

    public static KeyStore getKeyStore(String keystoreFile, String keystorePassword) {
        try {
            return KeystoreUtils.getKeyStore(keystoreFile, keystorePassword, JKS_TYPE);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return KeystoreUtils.getKeyStore(keystoreFile, keystorePassword, PKCS12_TYPE);
            }
            catch (ApplicationException e1) {
                throw e1;
            }
            catch (Throwable t) {
                throw new InvalidKeystoreException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String keystoreFile, String keystorePassword, String storeType) throws Exception {
        FileInputStream fis = null;
        boolean isAdded = storeType == PKCS12_TYPE && KeystoreUtils.addBCProvider();
        try {
            fis = new FileInputStream(keystoreFile);
            KeyStore keystore = storeType == PKCS12_TYPE ? KeyStore.getInstance(storeType, BC) : KeyStore.getInstance(storeType);
            keystore.load(fis, keystorePassword != null ? keystorePassword.toCharArray() : null);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (isAdded) {
                KeystoreUtils.removeBCProvider();
            }
        }
    }

    public static KeyPair getKeyPair(Map config) {
        String keyStoreFilePath = (String)config.get("keystore");
        if (keyStoreFilePath == null || keyStoreFilePath.trim().isEmpty()) {
            throw new InvalidKeystoreException();
        }
        String keystorePassword = (String)config.get("keystorePassword");
        KeyStore keyStore = KeystoreUtils.getKeyStore(keyStoreFilePath, keystorePassword);
        String keyPairPassword = (String)config.get("keypairPassword");
        return KeystoreUtils.getKeyPair(keyStore, (String)config.get("keystoreAlias"), keyPairPassword != null ? keyPairPassword : keystorePassword);
    }

    private static KeyPair getKeyPair(KeyStore keyStore, String keyAlias, String keyPassword) {
        try {
            Certificate cert;
            Key key;
            if (keyAlias == null) {
                if (keyStore.size() == 1) {
                    keyAlias = keyStore.aliases().nextElement();
                } else {
                    throw new MissingKeyPairAliasException();
                }
            }
            if ((key = keyStore.getKey(keyAlias, keyPassword != null ? keyPassword.toCharArray() : null)) instanceof PrivateKey && (cert = keyStore.getCertificate(keyAlias)) != null) {
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
            throw new InvalidKeypairEntryException();
        }
        catch (Exception up) {
            throw new InvalidKeypairEntryException(up);
        }
    }

    public static String getKeyAlias(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        if (aliases.hasMoreElements()) {
            return aliases.nextElement();
        }
        return null;
    }

    public static Map<String, Object> generateSAMLSPMetadataKeyPair() {
        SamlKeyPairGeneratorData signingKeyPairGeneratorData = new SamlKeyPairGeneratorData();
        String keyStorePassword = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        String keyStoreName = RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        signingKeyPairGeneratorData.setSubjectDN(KeystoreUtils.getSubjectDN(signingKeyPairGeneratorData.getSubjectDN(), keyStoreName));
        KeyStore keyStore = KeystoreUtils.generateSAMLSPMetadataKeyPairs(signingKeyPairGeneratorData, keyStorePassword);
        HashMap<String, Object> keyStoreInfo = new HashMap<String, Object>();
        keyStoreInfo.put("keystorename", keyStoreName);
        keyStoreInfo.put("keystorepassword", keyStorePassword);
        keyStoreInfo.put("keystore", keyStore);
        keyStoreInfo.put("keystorealias", "signing");
        return keyStoreInfo;
    }

    protected static String getSubjectDN(String subjectDN, String spName) {
        if (subjectDN == null || ((String)subjectDN).trim().length() == 0) {
            subjectDN = "CN=cfserviceprovider_" + spName + "_signer";
        }
        return subjectDN;
    }

    public static KeyStore generateSAMLSPMetadataKeyPairs(SamlKeyPairGeneratorData signingKeyPairGeneratorData, String keyStorePassword) {
        KeyStore keyStore = KeystoreUtils.generateKeyStore(signingKeyPairGeneratorData, keyStorePassword, "signing", PKCS12_TYPE);
        return keyStore;
    }

    public static KeyStore generateKeyStore(SamlKeyPairGeneratorData keyPairGeneratorData, String password, String keyEntryName, String type) {
        KeyPair keyPair = KeystoreUtils.generateKeyPair(keyPairGeneratorData);
        KeyStore keyStore = null;
        try {
            keyStore = KeystoreUtils.getNewKeystore(type, password);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeystoreException(RB.getString(KeystoreUtils.class, "KeystoreCreateError"));
        }
        try {
            KeystoreUtils.saveKeyPairToKeyStore(keyStore, keyEntryName, password, keyPair, keyPairGeneratorData);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeystoreException(RB.getString(KeystoreUtils.class, "KeystoreSaveError"));
        }
        return keyStore;
    }

    public static KeyPair generateKeyPair(SamlKeyPairGeneratorData keyPairGeneratorData) {
        if (!KeystoreUtils.isPolicyFilesInstalled() && keyPairGeneratorData.getKeySize() > 128) {
            throw new KeystoreException(RB.getString(KeystoreUtils.class, "UnlimitedStrengthPolicyFilesError"));
        }
        KeyPairGenerator keyPairGenerator = null;
        boolean bcAdded = KeystoreUtils.addBCProvider();
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(keyPairGeneratorData.getAlgorithm(), BC);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeystoreException(RB.getString(KeystoreUtils.class, "KeyPairError"));
        }
        finally {
            if (bcAdded) {
                KeystoreUtils.removeBCProvider();
            }
        }
        keyPairGenerator.initialize(keyPairGeneratorData.getKeySize(), new SecureRandom());
        KeyPair keypair = keyPairGenerator.generateKeyPair();
        return keypair;
    }

    public static boolean addBCProvider() {
        if (Security.getProvider(BC) == null) {
            BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider((Provider)bouncyCastleProvider);
            return true;
        }
        return false;
    }

    public static void removeBCProvider() {
        if (Security.getProvider(BC) != null) {
            Security.removeProvider(BC);
        }
    }

    private static boolean isPolicyFilesInstalled() {
        try {
            int keyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (keyLength == Integer.MAX_VALUE) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    public static KeyStore getNewKeystore(String type, String password) throws GeneralSecurityException, IOException {
        KeystoreUtils.addBCProvider();
        KeyStore instance = null;
        instance = PKCS12_TYPE.equalsIgnoreCase(type) ? KeyStore.getInstance(type, BC) : KeyStore.getInstance(type);
        instance.load(null, password.toCharArray());
        KeystoreUtils.removeBCProvider();
        return instance;
    }

    public static void saveKeyPairToKeyStore(KeyStore keyStore, String keyEntryName, String password, KeyPair keyPair, SamlKeyPairGeneratorData keyPairGeneratorData) throws GeneralSecurityException, IOException {
        KeystoreUtils.addBCProvider();
        keyStore.setKeyEntry(keyEntryName, keyPair.getPrivate(), password.toCharArray(), new Certificate[]{KeystoreUtils.generateCertificate(keyPair, keyPairGeneratorData)});
        KeystoreUtils.removeBCProvider();
    }

    public static X509Certificate generateCertificate(KeyPair keyPair, SamlKeyPairGeneratorData keyPairData) throws GeneralSecurityException {
        if (!KeystoreUtils.isPolicyFilesInstalled() && keyPair.getPublic().getEncoded().length > 128) {
            throw new KeystoreException(RB.getString(KeystoreUtils.class, "UnlimitedStrengthPolicyFilesError"));
        }
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        X500Principal dnName = new X500Principal(keyPairData.getSubjectDN());
        certGen.setSerialNumber(BigInteger.valueOf(Math.abs(new Random().nextInt())));
        certGen.setSubjectDN(dnName);
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(new Date(System.currentTimeMillis()));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(keyPairData.getValidityPeriod(), TimeUnit.DAYS)));
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm(keyPairData.getSignatureAlgorithm());
        KeyUsage usage = new KeyUsage(144);
        certGen.addExtension(X509Extensions.ExtendedKeyUsage, false, (ASN1Encodable)usage);
        return certGen.generate(keyPair.getPrivate());
    }

    public static void writeKeystoreToFile(KeyStore keystore, OutputStream os, char[] password) throws FileNotFoundException, KeyStoreException, IOException, java.security.cert.CertificateException, NoSuchAlgorithmException {
        keystore.store(os, password);
    }

    public static class InvalidKeystoreException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public InvalidKeystoreException(Throwable e) {
            super(e);
        }

        public InvalidKeystoreException() {
        }
    }

    public static class MissingKeyPairAliasException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidKeypairEntryException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public InvalidKeypairEntryException(Throwable e) {
            super(e);
        }

        public InvalidKeypairEntryException() {
        }
    }

    public static class KeystoreException
    extends ApplicationException {
        public String exceptionMessage = "";

        public KeystoreException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }

    public static class CertificateException
    extends ApplicationException {
        public String exceptionMessage = "";

        public CertificateException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }
}

