/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.log.CFLogs;
import coldfusion.util.RB;
import sun.security.tools.keytool.Main;

public class KeytoolUtils {
    public boolean generateKeyAndCertificate(String dname, String keystoreFileName, String password) {
        boolean retVal = this.generateCertificate(dname, keystoreFileName, password);
        if (retVal) {
            retVal = this.generatePublicKey(keystoreFileName, password);
        }
        return retVal;
    }

    private String getConfPathWithFilename(String fileName) {
        return System.getProperty("coldfusion.home") + "/runtime/conf/" + fileName;
    }

    private boolean generateCertificate(String dname, String keystoreFileName, String password) {
        String confPathWithFileName = this.getConfPathWithFilename(keystoreFileName);
        String alias = keystoreFileName.split("\\.")[0];
        String command = " -debug  -genkeypair  -alias " + alias + " -keyalg RSA  -sigalg SHA256withRSA  -dname " + dname + " -validity 365 -storetype pkcs12  -keypass " + password + " -keystore " + confPathWithFileName + " -storepass " + password;
        return this.execute(command);
    }

    private boolean generatePublicKey(String keystoreFileName, String password) {
        String fileNameWithoutExtension = keystoreFileName.split("\\.")[0];
        String publicKeyFileName = fileNameWithoutExtension + "_public.pem";
        String confPathWithKeyStoreName = this.getConfPathWithFilename(keystoreFileName);
        String confPathWithPublicKeyFileName = this.getConfPathWithFilename(publicKeyFileName);
        String command = " -debug  -export  -alias " + fileNameWithoutExtension + " -keystore " + confPathWithKeyStoreName + " -rfc -file " + confPathWithPublicKeyFileName + " -storepass " + password;
        return this.execute(command);
    }

    public boolean execute(String command) {
        try {
            CFLogs.SERVER_LOG.info(command);
            Main.main(this.parse(command));
        }
        catch (Exception ex) {
            CFLogs.SERVER_LOG.error(RB.getString(KeytoolUtils.class, "KeystoreGenerationError"), ex);
            return false;
        }
        return true;
    }

    private String[] parse(String command) {
        String[] options = command.trim().split("\\s+");
        return options;
    }
}

