/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.InvalidListIndexException;
import coldfusion.util.Utils;

public class ListTokenizer {
    private int currentPos;
    private final int length;
    private final String str;
    private final String delimiters;
    private boolean hasSurrogates;
    private int[] delimiterCodePoints;

    public ListTokenizer(String str, String delim) {
        this.str = str;
        this.length = str.length();
        this.currentPos = 0;
        this.delimiters = delim;
        this.checkForSurrogatePairs();
    }

    private void checkForSurrogatePairs() {
        int i;
        int c;
        int count = 0;
        for (i = 0; i < this.delimiters.length(); i += Character.charCount(c)) {
            c = this.delimiters.charAt(i);
            if (c >= 55296 && c <= 57343) {
                c = this.delimiters.codePointAt(i);
                this.hasSurrogates = true;
            }
            ++count;
        }
        if (this.hasSurrogates) {
            this.delimiterCodePoints = new int[count];
            i = 0;
            int j = 0;
            while (i < count) {
                this.delimiterCodePoints[i] = c = this.delimiters.codePointAt(j);
                ++i;
                j += Character.charCount(c);
            }
        }
    }

    private int skipDelimiters(int startPos, int[] skipped) {
        int position = startPos;
        int count = 0;
        while (position < this.length) {
            int c;
            if (!this.hasSurrogates) {
                c = this.str.charAt(position);
                if (this.delimiters.indexOf(c) == -1) break;
                ++position;
                continue;
            }
            c = this.str.codePointAt(position);
            if (!this.isDelimiter(c)) break;
            position += Character.charCount(c);
            if (skipped == null) continue;
            skipped[0] = ++count;
        }
        return position;
    }

    private int skip1Delimiter(int startPos) {
        int position = startPos;
        if (position < this.length) {
            if (!this.hasSurrogates) {
                char c = this.str.charAt(position);
                if (this.delimiters.indexOf(c) != -1) {
                    ++position;
                }
            } else {
                int c = this.str.codePointAt(position);
                if (this.isDelimiter(c)) {
                    position += Character.charCount(c);
                }
            }
        }
        return position;
    }

    private boolean isDelimiter(int codePoint) {
        for (int i = 0; i < this.delimiterCodePoints.length; ++i) {
            if (this.delimiterCodePoints[i] != codePoint) continue;
            return true;
        }
        return false;
    }

    private int scanToken(int startPos) {
        int position = startPos;
        while (position < this.length) {
            int c;
            if (!this.hasSurrogates) {
                c = this.str.charAt(position);
                if (this.delimiters.indexOf(c) >= 0) break;
                ++position;
                continue;
            }
            c = this.str.codePointAt(position);
            if (this.isDelimiter(c)) break;
            position += Character.charCount(c);
        }
        return position;
    }

    public String getToken(int position, boolean includeEmpty) {
        int skip;
        int tmp;
        int[] skipped;
        int count = 0;
        int currpos = this.currentPos;
        if (includeEmpty && this.hasSurrogates) {
            int[] nArray = new int[1];
            v1 = nArray;
            nArray[0] = 0;
        } else {
            v1 = skipped = null;
        }
        if (currpos < this.length && (tmp = currpos) < (currpos = this.skipDelimiters(currpos, skipped)) && includeEmpty && position <= (count = (skip = skipped != null ? skipped[0] : currpos - tmp) + (currpos < this.length ? 0 : 1))) {
            return "";
        }
        while (currpos < this.length) {
            int start = currpos;
            currpos = this.scanToken(currpos);
            if (++count == position) {
                return this.str.substring(start, currpos);
            }
            if (currpos >= this.length) break;
            start = currpos;
            currpos = this.skipDelimiters(currpos, skipped);
            if (!includeEmpty || position > (count += (skip = skipped != null ? skipped[0] : currpos - start) - 1 + (currpos < this.length ? 0 : 1))) continue;
            return "";
        }
        throw new InvalidListIndexException("ListGetAt", position, count);
    }

    public int findToken(String token, boolean includeEmpty) {
        int tmp;
        int[] nArray;
        int currpos = this.currentPos;
        boolean isEmpty = "".equals(token);
        if (includeEmpty && this.hasSurrogates) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = null;
        }
        int[] skipped = nArray;
        int count = 0;
        if (currpos < this.length && (tmp = currpos) < (currpos = this.skipDelimiters(currpos, skipped)) && includeEmpty) {
            if (isEmpty) {
                return 1;
            }
            count = (skipped != null ? skipped[0] : currpos - tmp) + (currpos < this.length ? 0 : 1);
        }
        while (currpos < this.length) {
            int skippedCount;
            int start = currpos;
            currpos = this.scanToken(currpos);
            ++count;
            if (!isEmpty && this.str.regionMatches(start, token, 0, token.length())) {
                return count;
            }
            if (currpos >= this.length) break;
            start = currpos;
            currpos = this.skipDelimiters(currpos, skipped);
            if (!includeEmpty) continue;
            int n = skipped != null ? skipped[0] - 1 : (skippedCount = currpos - start - 1 + (currpos < this.length ? 0 : 1));
            if (skippedCount > 0 && isEmpty) {
                return ++count;
            }
            count += skippedCount;
        }
        return 0;
    }

    public int count(boolean includeEmpty) {
        int skip;
        int tmp;
        int[] skipped;
        int count = 0;
        int currpos = this.currentPos;
        if (includeEmpty && this.hasSurrogates) {
            int[] nArray = new int[1];
            v1 = nArray;
            nArray[0] = 0;
        } else {
            v1 = skipped = null;
        }
        if (currpos < this.length && (tmp = currpos) < (currpos = this.skipDelimiters(currpos, skipped)) && includeEmpty) {
            skip = skipped != null ? skipped[0] : currpos - tmp;
            count = skip + (currpos < this.length ? 0 : 1);
        }
        while (currpos < this.length) {
            int start = currpos;
            currpos = this.scanToken(currpos);
            ++count;
            if (currpos >= this.length) break;
            start = currpos;
            currpos = this.skipDelimiters(currpos, skipped);
            if (!includeEmpty) continue;
            skip = skipped != null ? skipped[0] : currpos - start;
            count += skip - 1 + (currpos < this.length ? 0 : 1);
        }
        return count;
    }

    public String insertToken(int position, String value, boolean includeEmpty) {
        if ("".equals(this.str)) {
            if (includeEmpty) {
                return value + new String(Character.toChars(this.delimiterCodePoints[0]));
            }
            return "";
        }
        int count = 0;
        int currpos = this.currentPos;
        String delim = new String(Character.toChars(this.delimiterCodePoints[0]));
        if (currpos < this.length) {
            if (includeEmpty) {
                int tmp = currpos;
                while (tmp < (currpos = this.skip1Delimiter(currpos))) {
                    if (++count == position) {
                        return this.str.substring(0, tmp) + value + delim + this.str.substring(tmp);
                    }
                    tmp = currpos;
                }
                if (currpos >= this.length && ++count == position) {
                    return this.str + value + delim;
                }
            } else {
                currpos = this.skipDelimiters(0, null);
                if (currpos == this.length && position == 1) {
                    return this.str;
                }
                if (position == 1) {
                    return this.str.substring(0, currpos) + value + delim + this.str.substring(currpos);
                }
            }
        }
        while (currpos < this.length) {
            int start = currpos;
            currpos = this.scanToken(currpos);
            if (++count == position) {
                return this.str.substring(0, start) + value + delim + this.str.substring(start);
            }
            if (currpos >= this.length) break;
            start = currpos;
            if (includeEmpty) {
                start = currpos = this.skip1Delimiter(currpos);
                while (start < (currpos = this.skip1Delimiter(currpos))) {
                    if (++count == position) {
                        return this.str.substring(0, start) + value + delim + this.str.substring(start);
                    }
                    start = currpos;
                }
                if (currpos < this.length - 1 || ++count != position) continue;
                return this.str + value + delim;
            }
            currpos = this.skipDelimiters(currpos, null);
        }
        throw new InvalidListIndexException("ListInsertAt", position, count);
    }

    public String setToken(int position, String value, boolean includeEmpty) {
        String delim = new String(Character.toChars(this.delimiterCodePoints[0]));
        if (this.length == 0) {
            if (includeEmpty && position == 1) {
                return value + delim;
            }
            throw new InvalidListIndexException("ListSetAt", position, 0);
        }
        int count = 0;
        int currpos = this.currentPos;
        if (currpos < this.length) {
            int tmp = currpos;
            if (includeEmpty) {
                while (tmp < (currpos = this.skip1Delimiter(currpos))) {
                    if (++count == position) {
                        return this.str.substring(0, tmp) + value + this.str.substring(tmp);
                    }
                    tmp = currpos;
                }
                if (currpos >= this.length && ++count == position) {
                    return this.str + value + delim;
                }
            } else {
                currpos = this.skipDelimiters(0, null);
            }
        }
        while (currpos < this.length) {
            int start = currpos;
            if ((currpos = this.scanToken(currpos)) >= this.length) {
                if (++count != position) break;
                return this.str.substring(0, start) + value;
            }
            if (includeEmpty) {
                if (++count == position) {
                    return this.str.substring(0, start) + value + this.str.substring(currpos);
                }
                start = currpos = this.skip1Delimiter(currpos);
                while (start < (currpos = this.skip1Delimiter(currpos))) {
                    if (++count == position) {
                        return this.str.substring(0, start) + value + this.str.substring(start);
                    }
                    start = currpos;
                }
                if (currpos < this.length || ++count != position) continue;
                return this.str + value + delim;
            }
            currpos = this.skipDelimiters(currpos, null);
            if (++count != position) continue;
            return this.str.substring(0, start) + value + (String)(currpos >= this.length ? "" : delim + this.str.substring(currpos));
        }
        throw new InvalidListIndexException("ListSetAt", position, count);
    }

    public int containsToken(String subs, boolean includeEmpty) {
        int tmp;
        int[] nArray;
        int currpos = this.currentPos;
        if (this.hasSurrogates) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = null;
        }
        int[] skipped = nArray;
        int count = 0;
        if (currpos < this.length && (tmp = currpos) < (currpos = this.skipDelimiters(currpos, skipped)) && includeEmpty) {
            count = (skipped != null ? skipped[0] : currpos - tmp) + (currpos < this.length ? 0 : 1);
        }
        while (currpos < this.length) {
            int start = currpos;
            currpos = this.scanToken(currpos);
            ++count;
            if (Utils.contains(this.str, subs, start, currpos - 1) != -1) {
                return count;
            }
            if (currpos >= this.length) break;
            start = currpos;
            currpos = this.skipDelimiters(currpos, skipped);
            if (!includeEmpty) continue;
            count += skipped != null ? skipped[0] - 1 : currpos - start - 1 + (currpos < this.length ? 0 : 1);
        }
        return 0;
    }

    public String lastToken(boolean includeEmpty) {
        int currpos = this.skipDelimiters(this.currentPos, null);
        while (currpos < this.length) {
            int start = currpos;
            if ((currpos = this.scanToken(currpos)) == this.length) {
                return this.str.substring(start, currpos);
            }
            int start1 = currpos;
            if ((currpos = this.skipDelimiters(currpos, null)) != this.length) continue;
            if (includeEmpty) {
                return "";
            }
            return this.str.substring(start, start1);
        }
        return "";
    }

    public String restOfList(boolean includeEmptyFields) {
        int currpos = this.currentPos;
        if (currpos < this.length) {
            int tmp = currpos;
            if (includeEmptyFields) {
                if (tmp < (currpos = this.skip1Delimiter(currpos))) {
                    return this.str.substring(currpos);
                }
            } else {
                currpos = this.skipDelimiters(0, null);
            }
        }
        if (currpos < this.length) {
            if ((currpos = this.scanToken(currpos)) >= this.length) {
                return "";
            }
            currpos = !includeEmptyFields ? this.skipDelimiters(currpos, null) : this.skip1Delimiter(currpos);
            if (currpos <= this.length - 1) {
                return this.str.substring(currpos);
            }
        }
        return "";
    }

    public int valueCount(String token) {
        int currpos = this.currentPos;
        int count = 0;
        if (currpos < this.length) {
            currpos = this.skipDelimiters(currpos, null);
        }
        int vLen = token.length();
        while (currpos < this.length) {
            int start = currpos;
            if ((currpos = this.scanToken(currpos)) - start == vLen && this.str.regionMatches(start, token, 0, vLen)) {
                ++count;
            }
            if (currpos >= this.length) break;
            start = currpos;
            currpos = this.skipDelimiters(currpos, null);
        }
        return count;
    }

    public String first(boolean includeEmptyFields) {
        int currpos = this.skipDelimiters(this.currentPos, null);
        if (includeEmptyFields && currpos > this.currentPos) {
            return "";
        }
        if (currpos < this.length) {
            int start = currpos;
            currpos = this.scanToken(currpos);
            return this.str.substring(start, currpos);
        }
        return "";
    }

    public String deleteToken(int position, boolean includeEmpty) {
        int count = 0;
        int currpos = this.currentPos;
        if (currpos < this.length) {
            int tmp = currpos;
            if (includeEmpty) {
                while (tmp < (currpos = this.skip1Delimiter(currpos))) {
                    if (++count == position) {
                        return this.str.substring(0, tmp) + this.str.substring(currpos);
                    }
                    tmp = currpos;
                }
                if (currpos >= this.length && ++count == position) {
                    return this.str.substring(0, tmp);
                }
            } else {
                currpos = this.skipDelimiters(0, null);
            }
        }
        int lastDelimiter = -1;
        while (currpos < this.length) {
            int tmp;
            int start = currpos;
            if ((currpos = this.scanToken(currpos)) >= this.length && ++count == position) {
                return this.str.substring(0, start);
            }
            if (includeEmpty) {
                tmp = currpos;
                if ((currpos = this.skip1Delimiter(currpos)) >= this.length) {
                    if (++count == position) {
                        return this.str.substring(0, start);
                    }
                    if (++count != position) break;
                    return this.str.substring(0, tmp);
                }
                if (++count == position) {
                    return this.str.substring(0, start) + this.str.substring(currpos);
                }
                start = currpos;
                while (start < (currpos = this.skip1Delimiter(currpos))) {
                    if (++count == position) {
                        return this.str.substring(0, start) + this.str.substring(currpos);
                    }
                    if (currpos >= this.length && ++count == position) {
                        return this.str.substring(0, start);
                    }
                    start = currpos;
                }
                continue;
            }
            tmp = currpos;
            currpos = this.skipDelimiters(currpos, null);
            if (++count == position) {
                if (currpos >= this.length) {
                    return this.str.substring(0, lastDelimiter == -1 ? start : lastDelimiter);
                }
                return this.str.substring(0, start) + this.str.substring(currpos);
            }
            lastDelimiter = tmp;
        }
        throw new InvalidListIndexException("ListDeleteAt", position, count);
    }

    public String removeEmptyFields() {
        int currpos = this.currentPos;
        if (currpos < this.length) {
            currpos = this.skipDelimiters(currpos, null);
        }
        StringBuilder builder = new StringBuilder();
        while (currpos < this.length) {
            int start = currpos;
            currpos = this.scanToken(currpos);
            this.buildString(start, currpos, builder);
            if (currpos >= this.length) break;
            start = currpos;
            int delimPos = this.skip1Delimiter(currpos);
            if ((currpos = this.skipDelimiters(delimPos, null)) >= this.length) break;
            this.buildString(start, delimPos, builder);
        }
        return builder.toString();
    }

    private void buildString(int startPos, int currPos, StringBuilder builder) {
        for (int i = startPos; i < currPos; ++i) {
            int codePoint = this.str.codePointAt(i);
            if (Character.isBmpCodePoint(codePoint)) {
                builder.append((char)codePoint);
                continue;
            }
            if (Character.isValidCodePoint(codePoint)) {
                builder.append(Character.highSurrogate(codePoint));
                builder.append(Character.lowSurrogate(codePoint));
                continue;
            }
            builder.append(Character.toChars(codePoint));
        }
    }
}

