/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.AbstractCache;
import coldfusion.util.SoftCache;
import java.util.ArrayList;
import java.util.List;

public abstract class LruCache
extends AbstractCache {
    private Entry[] entries;
    private Entry newest;
    private Entry oldest;
    private int size;

    public LruCache() {
        this(100);
    }

    public LruCache(int capacity) {
        this.entries = new Entry[capacity];
    }

    private int slot(Object key) {
        int i = key.hashCode();
        i = i < 0 ? ~i % this.entries.length : i % this.entries.length;
        return i;
    }

    private Entry getEntry(Object key) {
        int i = this.slot(key);
        Entry e = this.entries[i];
        while (e != null) {
            if (e.key.equals(key)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private void putEntry(Object key, Object value, long penalty) {
        int i = this.slot(key);
        Entry e = this.entries[i];
        while (e != null) {
            if (e.key.equals(key)) {
                if (e.penalty != -1L) {
                    this.missPenalty -= e.penalty;
                }
                e.penalty = penalty;
                e.value = value;
                return;
            }
            e = e.next;
        }
        e = new Entry(key, value, penalty);
        e.next = this.entries[i];
        this.entries[i] = e;
        this.rankNewest(e);
    }

    private void removeEntry(Object key) {
        int i = this.slot(key);
        if (this.entries[i] == null) {
            return;
        }
        if (this.entries[i].key.equals(key)) {
            Entry e = this.entries[i];
            if (e.penalty != -1L) {
                this.missPenalty -= e.penalty;
            }
            this.deRank(e);
            this.entries[i] = e.next;
        } else {
            Entry prev = this.entries[i];
            Entry e = prev.next;
            while (e != null) {
                if (e.key.equals(key)) {
                    if (e.penalty != -1L) {
                        this.missPenalty -= e.penalty;
                    }
                    this.deRank(e);
                    prev.next = e.next;
                    return;
                }
                prev = e;
                e = e.next;
            }
        }
    }

    private void deRank(Entry e) {
        if (e.older != null) {
            e.older.newer = e.newer;
        } else {
            this.oldest = e.newer;
        }
        if (e.newer != null) {
            e.newer.older = e.older;
        } else {
            this.newest = e.older;
        }
        --this.size;
    }

    private void rankNewest(Entry e) {
        e.newer = null;
        e.older = this.newest;
        if (this.newest != null) {
            this.newest.newer = e;
        }
        if (this.oldest == null) {
            this.oldest = e;
        }
        this.newest = e;
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        LruCache lruCache = this;
        synchronized (lruCache) {
            Entry entry = this.getEntry(key);
            if (entry != null) {
                ++this.hits;
                ++entry.hits;
                this.deRank(entry);
                this.rankNewest(entry);
                return entry.value;
            }
            ++this.misses;
        }
        long before = System.currentTimeMillis();
        Object value = this.fetch(key);
        long penalty = System.currentTimeMillis() - before;
        LruCache lruCache2 = this;
        synchronized (lruCache2) {
            this.missPenalty += penalty;
            this.reap();
            if (SoftCache.cacheEval != null && SoftCache.cacheEval.equalsIgnoreCase("true")) {
                if (value == null || !value.toString().startsWith("Statement")) {
                    this.putEntry(key, value, penalty);
                }
            } else {
                this.putEntry(key, value, penalty);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, Object value) {
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.putEntry(key, value, -1L);
        }
    }

    private void reap() {
        if (this.size >= this.entries.length) {
            do {
                int origSize = this.size;
                this.removeEntry(this.oldest.key);
                if (this.size != origSize) continue;
                throw new IllegalStateException("corrupt table");
            } while (this.size >= this.entries.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.removeEntry(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(int capacity) {
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.entries = new Entry[capacity < 1 ? 1 : capacity];
            this.oldest = null;
            this.newest = null;
            this.size = 0;
            this.hits = 0L;
            this.misses = 0L;
            this.missPenalty = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.entries = new Entry[this.entries.length];
            this.newest = null;
            this.oldest = null;
            this.size = 0;
            this.hits = 0L;
            this.misses = 0L;
            this.missPenalty = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List keys() {
        ArrayList<Object> keyArr = new ArrayList<Object>();
        LruCache lruCache = this;
        synchronized (lruCache) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i] == null) continue;
                Entry entry = this.entries[i];
                while (entry != null) {
                    keyArr.add(entry.key);
                    entry = entry.next;
                }
            }
        }
        return keyArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List values() {
        ArrayList<Object> valueArr = new ArrayList<Object>();
        LruCache lruCache = this;
        synchronized (lruCache) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i] == null) continue;
                Entry entry = this.entries[i];
                while (entry != null) {
                    valueArr.add(entry.value);
                    entry = entry.next;
                }
            }
        }
        return valueArr;
    }

    static class Entry {
        Object key;
        Object value;
        long hits;
        long penalty;
        Entry next;
        Entry older;
        Entry newer;

        public Entry(Object key, Object value, long penalty) {
            this.key = key;
            this.value = value;
            this.penalty = penalty;
        }
    }
}

