/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class MimeTypeUtils {
    public static final Map<String, String> mimeMap = new HashMap<String, String>(68);

    public static String guessMimeType(String fileName) {
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        if (mimeType != null) {
            return mimeType;
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0 || index + 1 == fileName.length()) {
            return null;
        }
        String ext = fileName.substring(index + 1);
        String mimeObj = mimeMap.get(ext.toLowerCase());
        if (mimeObj == null) {
            return null;
        }
        return mimeObj.toString();
    }

    public static boolean canAccept(String mimePattern, String mimeType) {
        if (mimePattern.lastIndexOf("*/*") >= 0 || mimeType.trim().equalsIgnoreCase(mimePattern.trim())) {
            return true;
        }
        int endWildCardPos = mimePattern.trim().lastIndexOf("/*");
        int startWildCardPos = mimePattern.trim().lastIndexOf("*/");
        return endWildCardPos >= 0 ? mimeType.startsWith(mimePattern.trim().substring(0, endWildCardPos + 1)) : startWildCardPos >= 0 && mimeType.endsWith(mimePattern.trim().substring(startWildCardPos + 1, mimePattern.length()));
    }

    static {
        mimeMap.put("html", "text/html");
        mimeMap.put("htm", "text/html");
        mimeMap.put("txt", "text/plain");
        mimeMap.put("java", "text/plain");
        mimeMap.put("cpp", "text/plain");
        mimeMap.put("c", "text/plain");
        mimeMap.put("css ", "text/css");
        mimeMap.put("gif", "image/gif");
        mimeMap.put("xbm", "image/x-xbitmap");
        mimeMap.put("xpm", "image/x-xpixmap");
        mimeMap.put("png", "image/x-png");
        mimeMap.put("jpeg", "image/jpeg");
        mimeMap.put("jpg", "image/jpeg");
        mimeMap.put("tiff", "image/tiff");
        mimeMap.put("tif", "image/tiff");
        mimeMap.put("rgb", "image/rgb");
        mimeMap.put("pict", "image/x-pict");
        mimeMap.put("ppm", "image/x-portable-pixmap");
        mimeMap.put("pgm", "image/x-portable-graymap");
        mimeMap.put("pbm", "image/x-portable-bitmap");
        mimeMap.put("pnm", "image/x-portable-anymap");
        mimeMap.put("bmp", "image/x-ms-bmp");
        mimeMap.put("pcd", "image/x-photo-cd");
        mimeMap.put("cgm", "image/cgm");
        mimeMap.put("cmx", "image/x-cmx");
        mimeMap.put("au", "audio/basic");
        mimeMap.put("aif", "audio/x-aiff");
        mimeMap.put("aiff", "audio/x-aiff");
        mimeMap.put("aifc", "audio/x-aiff");
        mimeMap.put("mpa", "audio/x-mpeg");
        mimeMap.put("mpega", "audio/x-mpeg");
        mimeMap.put("mp2a", "audio/x-mpeg-2");
        mimeMap.put("mpa2", "audio/x-mpeg-2");
        mimeMap.put("mmid", "x-music/x-midi");
        mimeMap.put("mpeg", "video/mpeg");
        mimeMap.put("mpg", "video/mpeg");
        mimeMap.put("mpv2", "video/mpeg-2");
        mimeMap.put("mp2v", "video/mpeg-2");
        mimeMap.put("qt", "video/quicktime");
        mimeMap.put("mov", "video/quicktime");
        mimeMap.put("avi", "video/x-msvideo");
        mimeMap.put("ai", "application/postscript");
        mimeMap.put("eps", "application/postscript");
        mimeMap.put("ps", "application/postscript");
        mimeMap.put("rtf", "application/rtf");
        mimeMap.put("pdf", "application/pdf");
        mimeMap.put("gtar", "application/x-gtar");
        mimeMap.put("tar", "application/x-tar");
        mimeMap.put("zip", "application/zip");
        mimeMap.put("hqx", "application/mac-binhex40");
        mimeMap.put("sit", "application/x-stuffit");
        mimeMap.put("bin", "application/octet-stream");
        mimeMap.put("exe", "application/octet-stream");
        mimeMap.put("js", "text/javascript");
        mimeMap.put("sh", "application/x-sh");
        mimeMap.put("csh", "application/x-csh");
        mimeMap.put("pl", "application/x-perl");
        mimeMap.put("tcl", "application/x-tcl");
        mimeMap.put("ppt", "application/vnd.ms-powerpoint");
        mimeMap.put("doc", "application/msword");
        mimeMap.put("xhtml", "application/xhtml+xml");
        mimeMap.put("swf", "application/x-shockwave-flash");
        mimeMap.put("mp3", "audio/mpeg");
        mimeMap.put("wav", "audio/x-wav");
        mimeMap.put("wma", "audio/x-ms-wma");
        mimeMap.put("mp4", "video/mp4");
        mimeMap.put("wmv", "video/x-ms-wmv");
        mimeMap.put("doc", "application/msword");
        mimeMap.put("xls", "application/vnd.ms-excel");
        mimeMap.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    }
}

