/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.Scope;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OSNameFinder {
    private static String OSName;
    private static final Map<Double, String> macOsNames;

    public static String getOSName() {
        if (OSName == null) {
            RuntimeService runtime = ServiceFactory.getRuntimeService();
            Scope serverScope = runtime.getServerScope();
            Scope osScope = (Scope)serverScope.get("os");
            OSName = (String)osScope.get("name");
            if (OSName.toUpperCase().startsWith("MAC")) {
                try {
                    OSName = OSNameFinder.getMacOsName(System.getProperty("os.version"));
                }
                catch (Exception exception) {}
            } else if (OSName.toUpperCase().startsWith("UNIX")) {
                OSName = OSNameFinder.getLinuxOsName(OSName);
            }
        }
        return OSName;
    }

    private static String getMacOsName(String version) {
        String[] versions = version.split("\\.");
        double numericVersion = Double.parseDouble(versions[0] + "." + versions[1]);
        if (numericVersion < 10.0) {
            return "Mac OS " + version;
        }
        return "Mac OS X " + macOsNames.get(numericVersion) + " (" + version + ")";
    }

    private static String getLinuxOsName(String defaultName) {
        String osName = OSNameFinder.getPlatformNameFromLsbRelease();
        if (osName == null && (osName = OSNameFinder.getPlatformNameFromFile("/etc/system-release")) == null) {
            File fileVersion;
            File dir = new File("/etc/");
            if (dir.exists() && (osName = OSNameFinder.getPlatformNameFromFile(OSNameFinder.getFileEndingWith(dir, "-release"))) == null && (osName = OSNameFinder.getPlatformNameFromFile(OSNameFinder.getFileEndingWith(dir, "_version"))) == null) {
                osName = OSNameFinder.getPlatformNameFromFile("/etc/issue");
            }
            if (osName == null && (fileVersion = new File("/proc/version")).exists()) {
                osName = OSNameFinder.getPlatformNameFromFile(fileVersion.getAbsolutePath());
            }
        }
        if (osName == null) {
            return defaultName;
        }
        return osName;
    }

    private static String getFileEndingWith(File dir, final String fileEndingWith) {
        File[] fileList = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(fileEndingWith);
            }
        });
        if (fileList.length > 0) {
            return fileList[0].getAbsolutePath();
        }
        return null;
    }

    private static String getPlatformNameFromFile(String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                return OSNameFinder.readPlatformName(br);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static String readPlatformName(BufferedReader br) throws IOException {
        String line;
        String lineToReturn = null;
        int lineNb = 0;
        while ((line = br.readLine()) != null) {
            if (lineNb++ == 0) {
                lineToReturn = line;
            }
            if (!line.startsWith("PRETTY_NAME")) continue;
            return line.substring(13, line.length() - 1);
        }
        return lineToReturn;
    }

    private static String getPlatformNameFromLsbRelease() {
        File file = new File("/etc/lsb-release");
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                return OSNameFinder.readPlatformNameFromLsb(reader);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static String readPlatformNameFromLsb(BufferedReader reader) throws IOException {
        String line;
        String distribDescription = null;
        String distribCodename = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("DISTRIB_DESCRIPTION")) {
                distribDescription = line.replace("DISTRIB_DESCRIPTION=", "").replace("\"", "");
            }
            if (!line.startsWith("DISTRIB_CODENAME")) continue;
            distribCodename = line.replace("DISTRIB_CODENAME=", "");
        }
        if (distribDescription != null && distribCodename != null) {
            return distribDescription + " - " + distribCodename;
        }
        return null;
    }

    static {
        macOsNames = new HashMap<Double, String>();
        macOsNames.put(10.0, "Puma");
        macOsNames.put(10.1, "Cheetah");
        macOsNames.put(10.2, "Jaguar");
        macOsNames.put(10.3, "Panther");
        macOsNames.put(10.4, "Tiger");
        macOsNames.put(10.5, "Leopard");
        macOsNames.put(10.6, "Snow Leopard");
        macOsNames.put(10.7, "Snow Lion");
        macOsNames.put(10.8, "Mountain Lion");
        macOsNames.put(10.9, "Mavericks");
        macOsNames.put(10.1, "Yosemite");
    }
}

