/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.ApplicationException;
import coldfusion.util.SimpleThreadWorkDone;
import coldfusion.util.SimpleWorkerThread;
import java.util.LinkedList;

public class SimpleThreadPool {
    protected Thread[] threads = null;
    LinkedList assignments = new LinkedList();
    protected SimpleThreadWorkDone done = new SimpleThreadWorkDone();
    int queuesizelimit = -1;

    public SimpleThreadPool(int size) {
        this.threads = new SimpleWorkerThread[size];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new SimpleWorkerThread(this);
            this.threads[i].start();
        }
    }

    public SimpleThreadPool(int size, int queuesize) {
        this.threads = new SimpleWorkerThread[size];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new SimpleWorkerThread(this);
            this.threads[i].start();
        }
        this.queuesizelimit = queuesize;
    }

    public synchronized void assign(Runnable r) throws QueueSizeExceeded {
        if (this.queuesizelimit != -1 && this.queuesizelimit <= this.assignments.size()) {
            throw new QueueSizeExceeded(this.queuesizelimit);
        }
        this.done.workerBegin();
        this.assignments.addLast(r);
        this.notify();
    }

    public synchronized Runnable getAssignment() {
        try {
            while (!this.assignments.iterator().hasNext()) {
                this.wait();
            }
            return (Runnable)this.assignments.removeFirst();
        }
        catch (InterruptedException e) {
            this.done.workerEnd();
            return null;
        }
    }

    public synchronized int getQueueSize() {
        return this.assignments.size();
    }

    public void complete() {
        this.done.waitBegin();
        this.done.waitDone();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void shutdown() {
        this.done.reset();
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].interrupt();
            this.done.workerBegin();
        }
        this.done.waitDone();
    }

    public static class QueueSizeExceeded
    extends ApplicationException {
        public int size = -1;

        public QueueSizeExceeded(int queuesize) {
            this.size = queuesize;
        }
    }
}

