/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TreeHashMultiMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -2428566263570975088L;
    protected Multimap<K, Entry<K, V>> map;
    protected Multiset<V> set;
    private final Comparator<? super K> comparator;
    private final transient V DUMMYVALUE = null;
    private final transient K DUMMYKEY = null;
    transient int modCount;
    private volatile transient Collection<V> values;
    private volatile transient Set<K> keySet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;

    public TreeHashMultiMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.map = Multimaps.newMultimap(new TreeMap(comparator), (Supplier)new Supplier<Collection<Entry<K, V>>>(){

            public Collection<Entry<K, V>> get() {
                return new LinkedHashSet();
            }
        });
    }

    public TreeHashMultiMap() {
        this.comparator = null;
        this.map = Multimaps.newMultimap(new TreeMap(), (Supplier)new Supplier<Collection<Entry<K, V>>>(){

            public Collection<Entry<K, V>> get() {
                return new LinkedHashSet();
            }
        });
    }

    public TreeHashMultiMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    private Entry<?, ?> getDummyEntryForKey(Object key) {
        return new Entry<Object, V>(key, this.DUMMYVALUE);
    }

    private Entry<?, ?> getDummyEntryForValue(Object value) {
        return new Entry<K, Object>(this.DUMMYKEY, value);
    }

    private Entry<K, V> getEntryObject(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.map.containsKey(key)) {
            Entry<?, ?> present = this.getDummyEntryForKey(key);
            try {
                Object castedKey = key;
                Collection collection = this.map.get(castedKey);
                return collection.contains(present);
            }
            catch (ClassCastException e) {
                return this.map.containsValue(present);
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<?, ?> present = this.getDummyEntryForValue(value);
        for (Entry entry : this.map.values()) {
            if (!entry.valueEquals(present)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private Entry<K, V> getEntry(Object key) {
        Object k;
        Entry<?, ?> present = this.getDummyEntryForKey(key);
        try {
            k = key;
        }
        catch (ClassCastException e) {
            return null;
        }
        for (Entry entry : this.map.get(k)) {
            if (!entry.equals(present)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> existingEntry = this.getEntry(key);
        if (existingEntry == null) {
            Entry<K, V> present = new Entry<K, V>(key, value);
            this.map.put(key, present);
            ++this.modCount;
            return null;
        }
        V oldValue = existingEntry.getValue();
        existingEntry.setValue(value);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.get(key);
        Entry<?, ?> present = this.getDummyEntryForKey(key);
        if (this.map.remove(key, present)) {
            ++this.modCount;
            return oldValue;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m.size() == 0) {
            return;
        }
        for (Map.Entry<K, V> mapEntry : m.entrySet()) {
            this.put(mapEntry.getKey(), mapEntry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        ++this.modCount;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs == null ? (this.values = new Values()) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    private MapEntry<K, V> newMapEntry(Entry<K, V> entry) {
        return new MapEntry<K, V>(entry);
    }

    private class Entry<Key, Value> {
        private Key key;
        private Value value;

        public Entry(Key key, Value value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            int keyHash = this.getKey() == null ? 0 : this.getKey().hashCode();
            return keyHash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return this.valEquals(this.getKey(), e.getKey());
        }

        public boolean valueEquals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return this.valEquals(this.getValue(), e.getValue());
        }

        final boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public Key getKey() {
            return this.key;
        }

        public Value getValue() {
            return this.value;
        }

        private Value setValue(Value value) {
            Value oldValue = this.getValue();
            this.value = value;
            return oldValue;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TreeHashMultiMap.this.map.entries().size();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return TreeHashMultiMap.this.map.entries().size();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return TreeHashMultiMap.this.map.entries().size();
        }
    }

    private class MapEntry<K, V>
    implements Map.Entry<K, V> {
        Entry<K, V> entry;

        public MapEntry(Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }

        @Override
        public int hashCode() {
            return (this.entry.getKey() == null ? 0 : this.entry.getKey().hashCode()) ^ (this.entry.getValue() == null ? 0 : this.entry.getValue().hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MapEntry) {
                MapEntry meo = (MapEntry)o;
                return (this.entry.getKey() == null ? meo.getKey() == null : this.entry.getKey().equals(meo.getKey())) && (this.entry.getValue() == null ? meo.getValue() == null : this.entry.getValue().equals(meo.getValue()));
            }
            return false;
        }
    }

    private abstract class TreeHashEntryIterator<E>
    implements Iterator<E> {
        protected int expectedCount;
        Iterator<Map.Entry<K, Entry<K, V>>> entriesIterator;

        public TreeHashEntryIterator() {
            this.entriesIterator = TreeHashMultiMap.this.map.entries().iterator();
            this.expectedCount = TreeHashMultiMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.entriesIterator.hasNext();
        }

        @Override
        public void remove() {
            if (TreeHashMultiMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            this.entriesIterator.remove();
            this.expectedCount = TreeHashMultiMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            Map.Entry treeEntry = this.entriesIterator.next();
            return treeEntry.getValue();
        }
    }

    private class ValueIterator
    extends TreeHashEntryIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (TreeHashMultiMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends TreeHashEntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            if (TreeHashMultiMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends TreeHashEntryIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (TreeHashMultiMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            return TreeHashMultiMap.this.newMapEntry(this.nextEntry());
        }
    }
}

