/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.vfs.VFSFileFactory;
import coldfusion.xml.XmlNodeList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    public static Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        return docBuilder.newDocument();
    }

    public static Document getDocument(String file) throws IOException, SAXException, ParserConfigurationException {
        return XmlUtils.getDocument(VFSFileFactory.getFileObject(file));
    }

    public static Document getDocument(String file, EntityResolver resolver, boolean validate) throws IOException, SAXException, ParserConfigurationException {
        return XmlUtils.getDocument(VFSFileFactory.getFileObject(file), resolver, validate);
    }

    public static Document getDocument(File file) throws IOException, SAXException, ParserConfigurationException {
        return XmlUtils.getDocument(file, null, false);
    }

    public static Document getDocument(File file, EntityResolver resolver, boolean validate) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validate);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        if (resolver != null) {
            docBuilder.setEntityResolver(resolver);
        }
        if (validate) {
            docBuilder.setErrorHandler(new SAXErrorHandler());
        }
        return docBuilder.parse(file);
    }

    public static Element addNode(Element parent, String tagName) {
        Document document = parent.getOwnerDocument();
        if (document == null) {
            throw new IllegalArgumentException("parent does not belong to any document");
        }
        return XmlUtils.addNode(document, parent, tagName);
    }

    public static Element addNode(Document ownerDoc, Element parent, String tagName) {
        Element element = ownerDoc.createElement(tagName);
        parent.appendChild(element);
        return element;
    }

    public static Element addTextNode(Element parent, String tagName, String text) {
        Document document = parent.getOwnerDocument();
        if (document == null) {
            throw new IllegalArgumentException("parent does not belong to any document");
        }
        return XmlUtils.addTextNode(document, tagName, text, parent);
    }

    public static Element addTextNode(Document document, String tagName, String text, Element parent) {
        Element element = document.createElement(tagName);
        element.appendChild(document.createTextNode(text));
        parent.appendChild(element);
        return element;
    }

    public static void setText(Element node, String text) {
        Text newNode = node.getOwnerDocument().createTextNode(text);
        if (node.hasChildNodes()) {
            Node oldNode = node.getFirstChild();
            node.replaceChild(newNode, oldNode);
        } else {
            node.appendChild(newNode);
        }
    }

    public static void saveDocument(Document document, File file) throws IOException {
        try (OutputStream fos = null;){
            fos = VFSFileFactory.getOutputStream(file);
            XmlUtils.saveDocument(document, fos);
        }
    }

    private static void saveDocument(Document document, OutputStream os) throws IOException {
        OutputFormat format = XmlUtils.createDefaultFormat();
        XmlUtils.saveDocument(document, format, os);
    }

    public static void saveDocument(Document document, OutputFormat format, OutputStream os) throws IOException {
        XMLSerializer serializer = new XMLSerializer(os, format);
        serializer.serialize(document);
    }

    public static OutputFormat createDefaultFormat() {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        format.setPreserveEmptyAttributes(true);
        format.setLineWidth(1000);
        format.setIndenting(true);
        format.setIndent(4);
        return format;
    }

    public static String serialize(Node node, OutputFormat format, boolean namespace) throws IOException {
        StringWriter sw = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)sw, format);
        serializer.setNamespaces(namespace);
        if (node instanceof Document) {
            serializer.serialize((Document)node);
        } else if (node instanceof Element) {
            serializer.serialize((Element)node);
        }
        return sw.toString();
    }

    public static boolean hasChild(XmlNodeList xmlNode) {
        if (xmlNode == null) {
            return false;
        }
        NodeList children = ((Node)xmlNode.getNodesList().get(0)).getChildNodes();
        return children.getLength() > 0 && XmlUtils.hasChild(children);
    }

    public static boolean hasChild(XmlNodeList xmlNode, String childName) {
        if (xmlNode == null) {
            return false;
        }
        NodeList children = ((Node)xmlNode.getNodesList().get(0)).getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName() != childName || children.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChild(NodeList children) {
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static void deleteAt(XmlNodeList xmlNode, int position) {
        xmlNode.remove(position - 1);
    }

    private static class SAXErrorHandler
    implements ErrorHandler {
        private SAXErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

