/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.vfs2.RandomAccessContent;

public class RamRandomAccessFile
extends RandomAccessFile
implements RandomAccessContent {
    private final byte[] singleByteBuf = new byte[1];
    private RandomAccessContent rac;

    public RamRandomAccessFile(RandomAccessContent rac) throws IOException {
        this(RamRandomAccessFile.createTempFile());
        this.rac = rac;
    }

    private RamRandomAccessFile(File tempFile) throws IOException {
        super(tempFile, "r");
        this.deleteTempFile(tempFile);
    }

    private static File createTempFile() throws IOException {
        return File.createTempFile("fraf", "");
    }

    private void deleteTempFile(File tempFile) {
        try {
            super.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            tempFile.delete();
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.rac.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.rac.seek(pos);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.rac.skipBytes(n);
    }

    @Override
    public long length() throws IOException {
        return this.rac.length();
    }

    @Override
    public void setLength(long newLength) throws IOException {
        throw new IOException("Underlying RandomAccessContent instance length cannot be modified.");
    }

    public InputStream getInputStream() throws IOException {
        return this.rac.getInputStream();
    }

    @Override
    public void close() throws IOException {
        this.rac.close();
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final int read() throws IOException {
        byte[] buf = this.singleByteBuf;
        int count = this.read(buf, 0, 1);
        return count < 0 ? -1 : buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.rac.readFully(b, off, len);
        return len;
    }

    @Override
    public final void write(int b) throws IOException {
        byte[] buf = this.singleByteBuf;
        buf[0] = (byte)b;
        this.write(buf, 0, 1);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.rac.write(b, off, len);
    }
}

