/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.FileTag;
import coldfusion.vfs.RamRandomAccessFile;
import coldfusion.vfs.VFSApplicationException;
import coldfusion.vfs.VFSException;
import coldfusion.vfs.VFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ram.RamFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class VFSFileFactory {
    private static final String RAM_PROTOCOL_PREFIX = "ram:/";
    public static final String FORWARD_PATH_SEPERATOR = "/";
    public static final String BACKWARD_PATH_SEPERATOR = "\\";

    public static File getFileObject(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (VFSFileFactory.checkIfVFile(path)) {
            try {
                return new VFile(path);
            }
            catch (FileSystemException e) {
                throw new FileTag.SingleFileOperationException("create", e, path);
            }
        }
        return new File(path);
    }

    public static File getFileObject(String parent, String child) {
        if (parent == null || child == null) {
            throw new NullPointerException();
        }
        if (VFSFileFactory.checkIfVFile(parent)) {
            String finalPath = parent;
            if (!VFSFileFactory.endsWithSeperator(finalPath)) {
                finalPath = finalPath.concat(FORWARD_PATH_SEPERATOR);
            }
            finalPath = finalPath.concat(child);
            try {
                return new VFile(finalPath);
            }
            catch (FileSystemException e) {
                throw new FileTag.SingleFileOperationException("create", e, finalPath);
            }
        }
        return new File(parent, child);
    }

    public static File getFileObject(File parent, String child) {
        if (parent == null || child == null) {
            throw new NullPointerException();
        }
        if (VFSFileFactory.checkIfVFile(parent.getAbsolutePath())) {
            String finalPath = parent.getAbsolutePath();
            if (!VFSFileFactory.endsWithSeperator(parent.getAbsolutePath())) {
                finalPath = finalPath.concat(FORWARD_PATH_SEPERATOR);
            }
            finalPath = finalPath.concat(child);
            try {
                return new VFile(finalPath);
            }
            catch (FileSystemException e) {
                throw new FileTag.SingleFileOperationException("create", e, finalPath);
            }
        }
        return new File(parent, child);
    }

    public static File getFileObject(URI uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (VFSFileFactory.checkIfVFile(uri.toString())) {
            try {
                return new VFile(uri.toString());
            }
            catch (FileSystemException e) {
                throw new FileTag.SingleFileOperationException("create", e, uri.toString());
            }
        }
        return new File(uri);
    }

    public static InputStream getInputStream(String url) throws FileNotFoundException {
        if (url == null) {
            throw new NullPointerException();
        }
        if (VFSFileFactory.checkIfVFile(url)) {
            VFile file = null;
            try {
                file = new VFile(url);
                return file.getInputStream();
            }
            catch (FileSystemException e) {
                String path = file != null ? file.getFriendlyName() : url;
                throw new FileNotFoundException(path);
            }
        }
        return new FileInputStream(url);
    }

    public static InputStream getInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (file instanceof VFile) {
            VFile vfile = (VFile)file;
            try {
                return vfile.getInputStream();
            }
            catch (FileSystemException e) {
                throw new FileNotFoundException(vfile.getFriendlyName());
            }
        }
        return new FileInputStream(file);
    }

    public static boolean exists(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        if (file instanceof VFile) {
            VFile vfile = (VFile)file;
            try {
                InputStream is = vfile.getInputStream();
                if (is != null) {
                    is.close();
                }
                return true;
            }
            catch (Exception exception) {}
        } else {
            return file.exists();
        }
        return false;
    }

    public static OutputStream getOutputStream(String url) throws FileNotFoundException {
        if (url == null) {
            throw new NullPointerException();
        }
        return VFSFileFactory.fetchOutputStream(url, false);
    }

    public static OutputStream getOutputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException();
        }
        return VFSFileFactory.fetchOutputStreamFromFile(file, false);
    }

    public static OutputStream getOutputStream(String url, boolean append) throws FileNotFoundException {
        if (url == null) {
            throw new NullPointerException();
        }
        return VFSFileFactory.fetchOutputStream(url, append);
    }

    public static OutputStream getOutputStream(File file, boolean append) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException();
        }
        return VFSFileFactory.fetchOutputStreamFromFile(file, false);
    }

    public static boolean checkIfVFile(String url) {
        String scheme = UriParser.extractScheme((String)url);
        if (scheme != null && VFile.isSchemeSupported(scheme)) {
            if (scheme.equalsIgnoreCase("ram")) {
                try {
                    ApplicationSettings appSettings;
                    if (!ServiceFactory.getRuntimeService().isInMemoryFileSystemEnabled()) {
                        throw new VFSException();
                    }
                    ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
                    if (appScope != null && !(appSettings = appScope.getApplicationSettings()).isInMemoryEnabled()) {
                        throw new VFSApplicationException();
                    }
                }
                catch (ServiceFactory.ServiceNotAvailableException serviceNotAvailableException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public static boolean needsPermissionCheck(String url) {
        String scheme = UriParser.extractScheme((String)url);
        if (scheme != null && VFile.isSchemeSupported(scheme)) {
            return scheme.equalsIgnoreCase("ram");
        }
        return true;
    }

    public static char getSeperatorChar(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        if (VFSFileFactory.checkIfVFile(url)) {
            return FORWARD_PATH_SEPERATOR.charAt(0);
        }
        return File.separatorChar;
    }

    private static OutputStream fetchOutputStream(String url, boolean append) throws FileNotFoundException {
        if (VFSFileFactory.checkIfVFile(url)) {
            VFile vfile = null;
            try {
                vfile = new VFile(url);
                if (vfile.getParentFile() != null && vfile.getParentFile().exists()) {
                    return new VFile(url).getOutputStream(append);
                }
                throw new FileNotFoundException(vfile.getFriendlyName());
            }
            catch (FileSystemException e) {
                String path = vfile != null ? vfile.getFriendlyName() : url;
                throw new FileNotFoundException(path);
            }
        }
        return new FileOutputStream(url, append);
    }

    private static OutputStream fetchOutputStreamFromFile(File file, boolean append) throws FileNotFoundException {
        if (file instanceof VFile) {
            VFile vfile = (VFile)file;
            try {
                if (vfile.getParentFile() != null && vfile.getParentFile().exists()) {
                    return vfile.getOutputStream(append);
                }
                throw new FileNotFoundException(vfile.getFriendlyName());
            }
            catch (FileSystemException e) {
                throw new FileNotFoundException(vfile.getFriendlyName());
            }
        }
        return new FileOutputStream(file, append);
    }

    public static RandomAccessFile getRandomAccessFile(File file, String mode) throws IOException {
        if (file instanceof VFile && ((VFile)file).getFileObject() instanceof RamFileObject) {
            RamFileRandomAccessContent randomAccessContent = new RamFileRandomAccessContent((RamFileObject)((VFile)file).getFileObject(), mode.contains("w") ? RandomAccessMode.READWRITE : RandomAccessMode.READ);
            return new RamRandomAccessFile((RandomAccessContent)randomAccessContent);
        }
        return new RandomAccessFile(file, mode);
    }

    private static boolean endsWithSeperator(String path) {
        return path != null && (path.endsWith(FORWARD_PATH_SEPERATOR) || path.endsWith(BACKWARD_PATH_SEPERATOR));
    }
}

