/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileSystemOptionFactory;
import java.util.Map;

public class VFSUtils {
    public static Map getVFSMetaData() {
        Struct map = new Struct();
        ApplicationSettings appSettings = null;
        String appName = FusionContext.getCurrent().getApplicationName();
        boolean vfsenabled = VFSUtils.isVFSEnabled(appName);
        map.put("Enabled", (Object)vfsenabled);
        if (vfsenabled) {
            long sizelimit = 0L;
            long usedsize = 0L;
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            if (appScope != null) {
                appSettings = appScope.getApplicationSettings();
                sizelimit = appSettings.getInMemorySize() * 1024 * 1024;
            } else {
                sizelimit = ServiceFactory.getRuntimeService().getInMemoryFileSystemAppLimit() * 1024 * 1024;
            }
            map.put("Limit", (Object)Long.toString(sizelimit));
            usedsize = VFSUtils.getUsedSize(appName);
            map.put("Used", (Object)Long.toString(usedsize));
            long remainigsize = sizelimit - usedsize;
            if (remainigsize < 0L) {
                remainigsize = 0L;
            }
            map.put("Free", (Object)Long.toString(remainigsize));
        }
        return map;
    }

    public static Map getGlobalVFSMetaData() {
        Struct map = new Struct();
        boolean vfsenabled = ServiceFactory.getRuntimeService().isInMemoryFileSystemEnabled();
        map.put("Enabled", (Object)vfsenabled);
        if (vfsenabled) {
            long usedsize;
            long sizelimit = ServiceFactory.getRuntimeService().getInMemoryFileSystemLimit() * 1024 * 1024;
            long remainigsize = sizelimit - (usedsize = (long)(VFSFileSystemOptionFactory.getTotalAppRamSize() * 1024 * 1024));
            if (remainigsize < 0L) {
                remainigsize = 0L;
            }
            map.put("Limit", (Object)Long.toString(sizelimit));
            map.put("Used", (Object)Long.toString(usedsize));
            map.put("Free", (Object)Long.toString(remainigsize));
        }
        return map;
    }

    public static long getUsedSize(String appName) {
        if (appName != null && VFSFileSystemOptionFactory.fileSystemExists(appName)) {
            String path = "ram:///";
            FileUtils.verifyFile(path);
            path = Utils.getFileFullPath(path, FusionContext.getCurrent().pageContext);
            return FileUtils.getDirectorySize(path);
        }
        return 0L;
    }

    public static boolean isVFSEnabled(String appName) {
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        boolean vfsenabled = false;
        if (appScope != null) {
            ApplicationSettings appSettings = appScope.getApplicationSettings();
            vfsenabled = ServiceFactory.getRuntimeService().isInMemoryFileSystemEnabled() && appSettings.isInMemoryEnabled();
        } else {
            vfsenabled = ServiceFactory.getRuntimeService().isInMemoryFileSystemEnabled();
        }
        return vfsenabled;
    }
}

