/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.watch;

import coldfusion.log.CFLogs;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class Watcher
implements Runnable,
FilenameFilter {
    private static final int TWO_MINUTES = 120;
    private long pollInterval = 120L;
    private List listeners = new ArrayList();
    private List directories = new ArrayList();
    private Map directoryMap = new HashMap();
    protected String[] extensions = new String[]{"xml", "properties"};
    protected boolean recursive = false;
    private static SchedulerService schedulerService = null;
    private boolean watchForRecentChange = true;

    public Watcher(String dirName, long pollInterval, Listener listener, String extensionsString) {
        if (pollInterval < 1L) {
            pollInterval = 120L;
        }
        this.setInterval(pollInterval);
        this.addWatchedDirectory(dirName);
        this.addListener(listener);
        if (extensionsString != null) {
            this.setExtensions(extensionsString);
        }
        schedulerService = ServiceFactory.getSchedulerService();
    }

    public Watcher(long pollInterval) {
        if (pollInterval < 1L) {
            pollInterval = 120L;
        }
        this.setInterval(pollInterval);
        schedulerService = ServiceFactory.getSchedulerService();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void addWatchedDirectory(String watchedDirectory) {
        try {
            File file = new File(watchedDirectory);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (file.exists() && file.isDirectory()) {
                this.directories.add(file.getCanonicalFile());
                String message = RB.getString((Object)this, "Watcher.Watching", (Object)watchedDirectory);
                CFLogs.SERVER_LOG.debug(message);
            } else {
                String message = RB.getString((Object)this, "Watcher.WatchFailed", (Object)watchedDirectory);
                CFLogs.SERVER_LOG.error(message);
            }
        }
        catch (IOException ioException) {
            String message = RB.getString((Object)this, "Watcher.WatchFailed", (Object)watchedDirectory);
            CFLogs.SERVER_LOG.error(message, ioException);
        }
    }

    public void checkWatchedDirectories() {
        for (File directory : this.directories) {
            HashMap<File, Long> contents = (HashMap<File, Long>)this.directoryMap.get(directory);
            if (contents == null) {
                contents = new HashMap<File, Long>();
                this.directoryMap.put(directory, contents);
            }
            ArrayList files = new ArrayList();
            this.getFiles(directory, files);
            ArrayList<File> filesModified = new ArrayList<File>();
            for (int i = 0; i < files.size(); ++i) {
                File file = (File)files.get(i);
                if (directory.equals(file)) continue;
                if (contents.containsKey(file)) {
                    Long oldLastModified = (Long)contents.get(file);
                    if (this.watchForRecentChange) {
                        if (oldLastModified < file.lastModified()) {
                            filesModified.add(file);
                        }
                    } else if (oldLastModified.longValue() != file.lastModified()) {
                        filesModified.add(file);
                    }
                }
                contents.put(file, new Long(file.lastModified()));
            }
            if (filesModified.size() <= 0) continue;
            try {
                this.fireFileModifiedEvent(directory, filesModified);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void run() {
        CFLogs.SERVER_LOG.debug("Watcher::run() " + new Date());
        try {
            this.checkWatchedDirectories();
        }
        finally {
            try {
                schedulerService.schedule(this, System.currentTimeMillis() + this.pollInterval * 1000L);
            }
            catch (Exception exception) {
                String message = RB.getString(this, "Watcher.ScheduleFailed");
                CFLogs.SERVER_LOG.error(message, exception);
            }
        }
    }

    public void start() throws ServiceException {
        try {
            schedulerService.schedule(this, System.currentTimeMillis() + this.pollInterval * 1000L);
        }
        catch (Exception exception) {
            String message = RB.getString(this, "Watcher.ScheduleFailed");
            CFLogs.SERVER_LOG.error(message, exception);
            throw new ServiceException(exception);
        }
    }

    public void stop() throws ServiceException {
        try {
            schedulerService.cancel(this);
        }
        catch (Exception exception) {
            String message = RB.getString(this, "Watcher.UnscheduleFailed");
            CFLogs.SERVER_LOG.error(message, exception);
            throw new ServiceException(exception);
        }
    }

    public long getInterval() {
        return this.pollInterval;
    }

    public void setInterval(long newInterval) {
        if (newInterval != this.pollInterval && newInterval >= 1L) {
            this.pollInterval = newInterval;
        }
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensionsString) {
        if (extensionsString != null && extensionsString.trim().length() > 0) {
            ArrayList<String> extensionList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(extensionsString, ",");
            while (tokenizer.hasMoreTokens()) {
                extensionList.add(tokenizer.nextToken());
            }
            String[] extensionArray = extensionList.toArray(new String[extensionList.size()]);
            if (extensionList.size() > 0) {
                this.extensions = extensionArray;
            }
        }
    }

    private void fireFileModifiedEvent(File file, List fileList) {
        for (Listener listener : this.listeners) {
            ArrayList toBeNotified = new ArrayList();
            for (int i = 0; i < fileList.size(); ++i) {
                if (!listener.isInterested((File)fileList.get(i))) continue;
                toBeNotified.add(fileList.get(i));
            }
            if (toBeNotified.size() <= 0) continue;
            listener.filesModified(toBeNotified);
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.recursive && new File(dir.toString() + File.separator + name).isDirectory()) {
            return true;
        }
        for (int i = 0; i < this.extensions.length; ++i) {
            String extension = this.extensions[i];
            if ("*".equals(extension)) {
                return true;
            }
            if (name.length() <= extension.length() || extension.compareToIgnoreCase(name.substring(name.length() - extension.length())) != 0) continue;
            return true;
        }
        return false;
    }

    private void getFiles(File d, List lf) {
        File[] files = d.listFiles(this);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File tmp = files[i];
                if (tmp.isDirectory()) {
                    if (!this.recursive) continue;
                    this.getFiles(tmp, lf);
                    continue;
                }
                lf.add(tmp);
            }
        }
    }

    public void setWatchForRecentChange(boolean watchForRecentChange) {
        this.watchForRecentChange = watchForRecentChange;
    }

    public static interface Listener {
        public void filesModified(List var1);

        public boolean isInterested(File var1);
    }
}

