/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.WddxDeserializationException;
import java.io.ByteArrayOutputStream;
import java.util.Base64;

public class Base64Encoder {
    private static final Base64.Encoder BASE64URLENCODER;
    private static final Base64.Decoder BASE64URLDECODER;
    public static final char PADCHAR = '=';
    private static final char[] encode_table;
    private static byte[] decode_table;

    public static String encodeUrl(byte[] inputbytes) {
        String encodedURL = BASE64URLENCODER.encodeToString(inputbytes);
        return encodedURL;
    }

    public static String encode(byte[] data) {
        int count = data.length;
        StringBuffer result = new StringBuffer(4 * ((data.length + 2) / 3));
        block4: for (int offset = 0; offset < count; offset += 3) {
            int bytesRemaining = data.length - offset;
            switch (bytesRemaining) {
                case 1: {
                    byte a = data[offset];
                    byte b = 0;
                    byte c = 0;
                    result.append(encode_table[a >>> 2 & 0x3F]);
                    result.append(encode_table[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                    result.append('=');
                    result.append('=');
                    continue block4;
                }
                case 2: {
                    byte a = data[offset];
                    byte b = data[offset + 1];
                    byte c = 0;
                    result.append(encode_table[a >>> 2 & 0x3F]);
                    result.append(encode_table[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                    result.append(encode_table[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
                    result.append('=');
                    continue block4;
                }
                default: {
                    byte a = data[offset];
                    byte b = data[offset + 1];
                    byte c = data[offset + 2];
                    result.append(encode_table[a >>> 2 & 0x3F]);
                    result.append(encode_table[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                    result.append(encode_table[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
                    result.append(encode_table[c & 0x3F]);
                }
            }
        }
        return result.toString();
    }

    public static String fixPadding(String str) {
        int remainder;
        int strLength;
        if (str != null && (strLength = str.length()) > 0 && (remainder = strLength % 4) > 0) {
            StringBuffer strBuf = new StringBuffer(str);
            for (int i = 4; i > remainder; --i) {
                strBuf.append('=');
            }
            str = strBuf.toString();
        }
        return str;
    }

    public static byte[] decodeUrl(String encodedStr) {
        byte[] decodedBytes = BASE64URLDECODER.decode(encodedStr);
        return decodedBytes;
    }

    public static byte[] decode(String s) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int stringLength = s.length();
        int lastIndex = stringLength - 1;
        int bitCount = 0;
        int currentBits = 0;
        for (int i = 0; i < stringLength; ++i) {
            char c = s.charAt(i);
            if (c == '=' || Character.isWhitespace(c)) continue;
            byte decodedValue = decode_table[c];
            if (decodedValue == -1) {
                throw new InvalidEncodedStringException(s);
            }
            currentBits <<= 6;
            currentBits |= decodedValue;
            if (i == lastIndex && (bitCount += 6) != 8) {
                throw new InvalidEncodedStringException(s);
            }
            if (bitCount < 8) continue;
            result.write((byte)(currentBits >> (bitCount %= 8) & 0xFF));
        }
        return result.toByteArray();
    }

    static {
        int i;
        BASE64URLENCODER = Base64.getUrlEncoder().withoutPadding();
        BASE64URLDECODER = Base64.getUrlDecoder();
        encode_table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        decode_table = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64Encoder.decode_table[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64Encoder.decode_table[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64Encoder.decode_table[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64Encoder.decode_table[i] = (byte)(52 + i - 48);
        }
        Base64Encoder.decode_table[43] = 62;
        Base64Encoder.decode_table[47] = 63;
    }

    public static class InvalidEncodedStringException
    extends WddxDeserializationException {
        public String input;

        public InvalidEncodedStringException(String input) {
            this.input = input;
        }
    }
}

