/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.UDFMethod;
import coldfusion.wddx.WddxObjectSerializer;
import coldfusion.wddx.WddxOutputStream;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

class BeanSerializer
implements WddxObjectSerializer {
    BeanSerializer() {
    }

    @Override
    public void writeObject(WddxOutputStream out, Object obj) throws IOException {
        block19: {
            Class<?> cls = obj.getClass();
            if (obj instanceof Class || cls == Object.class) {
                out.writeNull();
                return;
            }
            try {
                if (cls.isArray()) {
                    Object[] array = (Object[])obj;
                    out.writeArrayBegin(array.length);
                    for (int i = 0; i < array.length; ++i) {
                        out.writeObject(array[i]);
                    }
                    out.writeArrayEnd();
                    break block19;
                }
                BeanInfo binfo = Introspector.getBeanInfo(cls, Object.class);
                PropertyDescriptor[] descriptors = binfo.getPropertyDescriptors();
                out.writeStructBegin(BeanSerializer.getTypeSignature(obj.getClass()));
                for (int i = 0; i < descriptors.length; ++i) {
                    PropertyDescriptor pd = descriptors[i];
                    String name = pd.getName();
                    try {
                        if (obj instanceof UDFMethod && "superscope".equalsIgnoreCase(name)) continue;
                        if (pd instanceof IndexedPropertyDescriptor) {
                            Vector<Object> values;
                            block20: {
                                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                                values = new Vector<Object>();
                                Method getter = ipd.getIndexedReadMethod();
                                if (getter == null) continue;
                                try {
                                    getter.setAccessible(true);
                                }
                                catch (Error error) {
                                    // empty catch block
                                }
                                try {
                                    int index = 0;
                                    while (true) {
                                        Object value = getter.invoke(obj, new Integer(index));
                                        values.addElement(value);
                                        ++index;
                                    }
                                }
                                catch (IllegalAccessException index) {
                                }
                                catch (InvocationTargetException e) {
                                    if (e.getTargetException() instanceof IndexOutOfBoundsException) break block20;
                                    throw new IllegalPropertyAccessException(cls.getName() + "." + name, e);
                                }
                            }
                            int size = values.size();
                            out.writeVarBegin(name);
                            out.writeArrayBegin(size);
                            for (int index = 0; index < size; ++index) {
                                out.writeObject(values.elementAt(index));
                            }
                            out.writeArrayEnd();
                            out.writeVarEnd();
                            continue;
                        }
                        Method getter = pd.getReadMethod();
                        if (getter == null) continue;
                        try {
                            getter.setAccessible(true);
                        }
                        catch (Error values) {
                            // empty catch block
                        }
                        Object value = getter.invoke(obj, new Object[0]);
                        if (value == null) continue;
                        out.writeVarBegin(name);
                        out.writeObject(value);
                        out.writeVarEnd();
                        continue;
                    }
                    catch (IllegalAccessException getter) {
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalPropertyAccessException(cls.getName() + "." + name, e);
                    }
                }
                out.writeStructEnd();
            }
            catch (IntrospectionException e) {
                throw new ClassIntrospectionError(cls.getName(), e);
            }
        }
    }

    static String getTypeSignature(Class cls) {
        StringBuffer sig = new StringBuffer();
        if (cls.isArray()) {
            return cls.getName();
        }
        if (cls.isPrimitive()) {
            if (cls == Integer.TYPE) {
                sig.append('I');
            } else if (cls == Byte.TYPE) {
                sig.append('B');
            } else if (cls == Long.TYPE) {
                sig.append('J');
            } else if (cls == Float.TYPE) {
                sig.append('F');
            } else if (cls == Double.TYPE) {
                sig.append('D');
            } else if (cls == Short.TYPE) {
                sig.append('S');
            } else if (cls == Character.TYPE) {
                sig.append('C');
            } else if (cls == Boolean.TYPE) {
                sig.append('Z');
            }
        } else {
            sig.append('L');
            sig.append(cls.getName());
            sig.append(';');
        }
        return sig.toString();
    }

    public static class IllegalPropertyAccessException
    extends ApplicationException {
        public String propName;
        public String detailMessage;

        public IllegalPropertyAccessException(String propName, Exception rootCause) {
            this.propName = propName;
            this.detailMessage = rootCause.getMessage();
        }
    }

    public static class ClassIntrospectionError
    extends ApplicationException {
        public String className;
        public String detailMessage;

        public ClassIntrospectionError(String className, Exception rootCause) {
            this.className = className;
            this.detailMessage = rootCause.getMessage();
        }
    }
}

