/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.DeserializationContext;
import coldfusion.wddx.ElementFactory;
import coldfusion.wddx.ElementFactoryMgr;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import coldfusion.wddx.WddxFilter;
import coldfusion.wddx.WddxParseException;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DeserializerWorker
extends HandlerBase
implements DeserializationContext {
    private static final String ROOT_ELEMENT_NAME = "wddxPacket";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static ElementFactoryMgr m_elementFactoryMgr = null;
    private ElementFactory m_elementFactory = null;
    private Vector m_stackElements = new Vector();
    private SAXParser m_parser = null;
    private Locator m_locator = null;
    private Object m_result = null;
    private static final String JNI_L = "L";
    private static final String SEMICOLON = ";";
    private static final String JNI_BRACE = "[";
    private static final String STRUCT_TYPE = "type";

    DeserializerWorker(SAXParser parser) throws WddxDeserializationException {
        this.createElementFactoryMgr();
        this.m_parser = parser;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
        try {
            if (this.m_stackElements.isEmpty()) {
                if (!name.equals(ROOT_ELEMENT_NAME) || atts.getLength() != 1 || !atts.getName(0).equals(VERSION_ATTRIBUTE_NAME)) {
                    throw new InvalidWddxPacketException();
                }
                this.m_elementFactory = m_elementFactoryMgr.getElementFactory(atts.getValue(0));
            }
            if (name.equalsIgnoreCase("struct") && atts.getType(0) != null && atts.getValue(STRUCT_TYPE) != null && atts.getValue(STRUCT_TYPE).trim().length() > 0) {
                this.validateWddxFilter(atts);
            }
            if (!this.m_stackElements.isEmpty()) {
                this.getTopElement().onBeforeChild(name, atts);
            }
            WddxElement currentElement = this.m_elementFactory.makeWddxElement(name);
            currentElement.setDeserializationContext(this);
            currentElement.onStartElement(name, atts);
            this.pushElement(currentElement);
        }
        catch (WddxDeserializationException e) {
            this.throwSAXException(e);
        }
    }

    private void validateWddxFilter(AttributeList atts) throws InvalidWddxPacketException {
        String attributeType;
        boolean logOnFailure = true;
        String attributeTypeCopy = attributeType = atts.getValue(STRUCT_TYPE);
        if (attributeType.endsWith(SEMICOLON)) {
            attributeType = attributeType.replace(SEMICOLON, "");
        }
        if (attributeType.startsWith(JNI_BRACE)) {
            attributeType = attributeType.replace(JNI_BRACE, "");
        }
        if (attributeType.startsWith(JNI_L)) {
            if (WddxFilter.validateAllowedClass(attributeType.replaceFirst(JNI_L, ""), logOnFailure)) {
                return;
            }
            logOnFailure = false;
        }
        if (WddxFilter.validateAllowedClass(attributeType, logOnFailure) || WddxFilter.validateAllowedClass(this.getClassBySignature(attributeTypeCopy), false)) {
            return;
        }
        throw new InvalidWddxPacketException();
    }

    private String getClassBySignature(String jniTypeSig) {
        int index = 0;
        char c = jniTypeSig.charAt(index);
        switch (c) {
            case 'Z': {
                return Boolean.TYPE.getName();
            }
            case 'B': {
                return Byte.TYPE.getName();
            }
            case 'C': {
                return Character.TYPE.getName();
            }
            case 'S': {
                return Short.TYPE.getName();
            }
            case 'I': {
                return Integer.TYPE.getName();
            }
            case 'J': {
                return Long.TYPE.getName();
            }
            case 'F': {
                return Float.TYPE.getName();
            }
            case 'D': {
                return Double.TYPE.getName();
            }
            default: {
                return jniTypeSig.substring(index + 1, jniTypeSig.length() - 1);
            }
            case '[': 
        }
        return jniTypeSig.substring(index + 1);
    }

    @Override
    public void endElement(String name) throws SAXException {
        try {
            WddxElement currentElement = this.popElement();
            currentElement.onEndElement();
            if (!this.m_stackElements.isEmpty()) {
                this.getTopElement().onAfterChild(currentElement);
            } else {
                this.m_result = currentElement.getValue();
            }
        }
        catch (WddxDeserializationException e) {
            this.throwSAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.getTopElement().onCharacters(ch, start, length);
        }
        catch (WddxDeserializationException e) {
            this.throwSAXException(e);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.throwSAXException(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.throwSAXException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object deserialize(InputSource source) throws WddxDeserializationException, IOException {
        Object result = null;
        try {
            try {
                this.m_parser.parse(source, (HandlerBase)this);
            }
            catch (SAXException e) {
                this.throwException(e);
            }
            result = this.m_result;
        }
        finally {
            this.m_stackElements.setSize(0);
            this.m_result = null;
            this.m_locator = null;
            this.m_elementFactory = null;
        }
        return result;
    }

    @Override
    public WddxElement getParentElement() throws WddxDeserializationException {
        return this.getTopElement();
    }

    private WddxElement getTopElement() throws WddxDeserializationException {
        WddxElement topElement = null;
        try {
            topElement = (WddxElement)this.m_stackElements.lastElement();
        }
        catch (Throwable rootCause) {
            throw new WddxElementAccessException(rootCause);
        }
        return topElement;
    }

    private void pushElement(WddxElement element) {
        this.m_stackElements.addElement(element);
    }

    private WddxElement popElement() throws WddxDeserializationException {
        WddxElement topElement = this.getTopElement();
        this.m_stackElements.setSize(this.m_stackElements.size() - 1);
        return topElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createElementFactoryMgr() throws WddxDeserializationException {
        if (m_elementFactoryMgr != null) return;
        Class<DeserializerWorker> clazz = DeserializerWorker.class;
        synchronized (DeserializerWorker.class) {
            if (m_elementFactoryMgr != null) return;
            m_elementFactoryMgr = new ElementFactoryMgr();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void throwSAXException(SAXParseException e) throws SAXException {
        WddxDeserializationException error = new WddxDeserializationException(e.getMessage());
        WddxParseException errorContext = new WddxParseException(e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber());
        error.setErrorContext(errorContext.getMessage());
        throw new SAXException(error);
    }

    private void throwSAXException(WddxDeserializationException e) throws SAXException {
        if (this.m_locator != null) {
            WddxParseException errorContext = new WddxParseException(this.m_locator.getPublicId(), this.m_locator.getSystemId(), this.m_locator.getLineNumber(), this.m_locator.getColumnNumber());
            e.setErrorContext(errorContext.getMessage());
        }
        throw new SAXException(e);
    }

    private void throwException(SAXException e) throws WddxDeserializationException {
        Exception heldException = e.getException();
        if (heldException != null) {
            try {
                WddxDeserializationException wddxDeserializationException = (WddxDeserializationException)heldException;
                throw wddxDeserializationException;
            }
            catch (ClassCastException eTemp) {
                throw new WddxDeserializationException(heldException.getMessage());
            }
        }
        throw new WddxDeserializationException(e.getMessage());
    }

    public class InvalidWddxPacketException
    extends WddxDeserializationException {
    }

    public class WddxElementAccessException
    extends WddxDeserializationException {
        public String detailMessage;

        public WddxElementAccessException(Throwable rootCause) {
            this.detailMessage = rootCause.getMessage();
        }
    }
}

