/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.runtime.QueryVector;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.wddx.InvalidChildElementException;
import coldfusion.wddx.MissingAttributeException;
import coldfusion.wddx.NegativeRowNumberException;
import coldfusion.wddx.RecordSet;
import coldfusion.wddx.SimpleRecordSet;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import coldfusion.wddx.WddxFilter;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.AttributeList;

class RecordsetHandler
extends WddxElement {
    private final String ROWCOUNT_ATTRIBUTE_NAME = "rowCount";
    private final String FIELDNAMES_ATTRIBUTE_NAME = "fieldNames";
    private final String FIELD_ELEMENT_NAME = "field";
    private final String NAME_ATTRIBUTE_NAME = "name";
    private final String TYPE_ATTRIBUTE_NAME = "type";
    private RecordSet m_rs = null;
    private String m_currentFieldName = null;
    private QueryTableMetaData m_metaData = new QueryTableMetaData();
    private int[] column_types;
    private String[] type_names;
    private String[] column_labels;
    private boolean[] column_case;
    private int columnIndex = 0;

    RecordsetHandler() {
    }

    @Override
    public void onStartElement(String name, AttributeList attributes) throws WddxDeserializationException {
        String rowCount = attributes.getValue("rowCount");
        if (rowCount == null) {
            throw new MissingAttributeException("recordset", "rowCount");
        }
        String fieldNames = attributes.getValue("fieldNames");
        String type = attributes.getValue("type");
        if (fieldNames == null) {
            throw new MissingAttributeException("recordset", "fieldNames");
        }
        int rows = -1;
        try {
            rows = Integer.parseInt(rowCount);
        }
        catch (NumberFormatException e) {
            throw new InvalidRowCountAttributeException();
        }
        if (rows < 0) {
            throw new NegativeRowNumberException(rows);
        }
        this.createRecordSet(type, rows);
        int columnCount = new StringTokenizer(fieldNames, ",").countTokens();
        this.m_metaData.setColumnCount(columnCount);
        this.column_labels = new String[columnCount];
        this.column_types = new int[columnCount];
        this.column_case = new boolean[columnCount];
        this.type_names = new String[columnCount];
    }

    @Override
    public void onEndElement() throws WddxDeserializationException {
        this.setValue(this.m_rs);
        this.m_metaData.setColumnLabel(this.column_labels);
        this.m_metaData.setColumnType(this.column_types);
        this.m_metaData.setColumnTypeNames(this.type_names);
        this.m_metaData.setColumnCase(this.column_case);
        if (this.m_rs instanceof QueryTable) {
            ((QueryTable)this.m_rs).setMetaData(this.m_metaData);
        } else if (this.m_rs instanceof QueryVector) {
            ((QueryVector)this.m_rs).getQuery().setMetaData(this.m_metaData);
        }
    }

    @Override
    public void onBeforeChild(String name, AttributeList attributes) throws WddxDeserializationException {
        if (!name.equals("field")) {
            throw new InvalidChildElementException("field", "recordset");
        }
        this.m_currentFieldName = attributes.getValue("name");
        if (this.m_currentFieldName == null) {
            throw new MissingAttributeException("field", "name");
        }
    }

    @Override
    public void onAfterChild(WddxElement childElement) throws WddxDeserializationException {
        this.m_rs.addColumn(this.m_currentFieldName, (Vector)childElement.getValue());
        this.column_labels[this.columnIndex] = this.m_currentFieldName;
        this.column_types[this.columnIndex] = childElement.getType();
        this.type_names[this.columnIndex] = childElement.getTypeName();
        this.column_case[this.columnIndex] = false;
        ++this.columnIndex;
    }

    private void createRecordSet(String type, int rows) throws WddxDeserializationException {
        if (type == null || type.equals("")) {
            try {
                this.m_rs = new QueryTable(rows);
            }
            catch (Exception e) {
                this.m_rs = new SimpleRecordSet(rows);
            }
        } else {
            Integer rowCount = new Integer(rows);
            Class[] params = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{rowCount};
            Class<?> beanClass = null;
            Object bean = null;
            Constructor<?> cons = null;
            if (!WddxFilter.validateAllowedClass(type, true)) {
                throw new WddxDeserializationException();
            }
            try {
                beanClass = Class.forName(type);
                cons = beanClass.getConstructor(params);
                bean = cons.newInstance(args);
                this.m_rs = bean;
            }
            catch (Exception e1) {
                try {
                    this.m_rs = new QueryVector(type, new QueryTable(rows));
                }
                catch (Exception e2) {
                    this.m_rs = new SimpleRecordSet(rows);
                }
            }
        }
    }

    public static class InvalidRowCountAttributeException
    extends WddxDeserializationException {
    }
}

