/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.DuplicateColumnNameException;
import coldfusion.wddx.InvalidColumnIndexException;
import coldfusion.wddx.InvalidRowIndexException;
import coldfusion.wddx.NegativeRowNumberException;
import coldfusion.wddx.RecordSet;
import coldfusion.wddx.RowSizeMismatchException;
import java.util.List;
import java.util.Vector;

public class SimpleRecordSet
implements RecordSet {
    private static final int INITIAL_COLUMN_NUMBER = 8;
    private int m_colCount = 0;
    private int m_rowCount = 0;
    private String[] m_colNames = new String[8];
    private Vector[] m_colData = new Vector[8];

    public SimpleRecordSet() {
        this.m_colCount = 0;
        this.m_rowCount = 0;
        this.m_colNames = new String[8];
        this.m_colData = new Vector[8];
    }

    public SimpleRecordSet(int rows) {
        this.m_colCount = 0;
        this.m_rowCount = rows;
        this.m_colNames = new String[8];
        this.m_colData = new Vector[8];
    }

    public SimpleRecordSet(int rows, String[] columns) {
        this.m_rowCount = rows;
        this.m_colCount = 0;
        this.m_colNames = new String[columns.length];
        this.m_colData = new Vector[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.addColumn(columns[i]);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    @Override
    public int addRows(int rowsToAdd) {
        if (rowsToAdd < 0) {
            throw new NegativeRowNumberException(rowsToAdd);
        }
        for (int i = 0; i < this.m_colCount; ++i) {
            for (int j = 0; j < rowsToAdd; ++j) {
                this.m_colData[i].addElement(null);
            }
        }
        this.m_rowCount += rowsToAdd;
        return this.m_rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.m_colCount;
    }

    @Override
    public int addColumn(String columnName) {
        Vector columnData = new Vector(this.m_rowCount);
        columnData.setSize(this.m_rowCount);
        try {
            return this.addColumn(columnName, columnData);
        }
        catch (RowSizeMismatchException e) {
            throw new DuplicateColumnNameException(columnName);
        }
    }

    @Override
    public int addColumn(String columnName, Vector columnData) {
        if (columnData.size() != this.m_rowCount) {
            throw new RowSizeMismatchException(columnData.size(), this.m_rowCount);
        }
        int colId = this.findColumn(columnName);
        if (colId != -1) {
            throw new DuplicateColumnNameException(columnName);
        }
        if (this.m_colNames.length <= this.m_colCount) {
            String[] tempColNames = new String[2 * this.m_colNames.length];
            Vector[] tempColData = new Vector[2 * this.m_colNames.length];
            for (int i = 0; i < this.m_colCount; ++i) {
                tempColNames[i] = this.m_colNames[i];
                tempColData[i] = this.m_colData[i];
            }
            this.m_colNames = tempColNames;
            this.m_colData = tempColData;
        }
        colId = this.m_colCount++;
        this.m_colNames[colId] = columnName;
        this.m_colData[colId] = columnData;
        return colId;
    }

    @Override
    public int findColumn(String columnName) {
        int i;
        for (i = 0; i < this.m_colCount && !this.m_colNames[i].equals(columnName); ++i) {
        }
        if (i != this.m_colCount) {
            return i;
        }
        return -1;
    }

    @Override
    public String[] getColumnNames() {
        String[] colNames = new String[this.m_colCount];
        for (int i = 0; i < this.m_colCount; ++i) {
            colNames[i] = this.m_colNames[i];
        }
        return colNames;
    }

    @Override
    public Object getField(int row, int column) {
        if (row < 0 || row >= this.m_rowCount) {
            throw new InvalidRowIndexException(row);
        }
        if (column < 0 || column >= this.m_colCount) {
            throw new InvalidColumnIndexException(column);
        }
        return this.m_colData[column].elementAt(row);
    }

    @Override
    public void setField(int row, int column, Object value) {
        if (row < 0 || row >= this.m_rowCount) {
            throw new InvalidRowIndexException(row);
        }
        if (column < 0 || column >= this.m_colCount) {
            throw new InvalidColumnIndexException(column);
        }
        this.m_colData[column].setElementAt(value, row);
    }

    public String toString() {
        int column;
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        String[] columnNames = this.getColumnNames();
        StringBuffer sb = new StringBuffer("[RecordSet (rows ");
        sb.append(rowCount);
        sb.append(" columns ");
        for (column = 0; column < columnCount; ++column) {
            if (column > 0) {
                sb.append(", ");
            }
            sb.append(columnNames[column]);
        }
        sb.append("): ");
        for (column = 0; column < columnCount; ++column) {
            sb.append("[");
            sb.append(columnNames[column]);
            sb.append(": ");
            sb.append(this.m_colData[column].toString());
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getRecordsetType() {
        return SimpleRecordSet.class.getName();
    }

    @Override
    public List getColumn(int index) {
        return this.m_colData[index];
    }
}

