/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.BadCharacterDataException;
import coldfusion.wddx.InvalidChildElementException;
import coldfusion.wddx.MissingAttributeException;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import org.xml.sax.AttributeList;

class StringHandler
extends WddxElement {
    private static final String CHAR_ELEMENT_NAME = "char";
    private static final String CODE_ATTRIBUTE_NAME = "code";
    private StringBuffer m_buffer = new StringBuffer();

    StringHandler() {
    }

    @Override
    public void onEndElement() throws WddxDeserializationException {
        this.setValue(this.m_buffer.toString());
        this.setType(12, "VARCHAR");
    }

    @Override
    public void onCharacters(char[] ch, int start, int length) throws WddxDeserializationException {
        this.m_buffer.append(ch, start, length);
    }

    @Override
    public void onBeforeChild(String name, AttributeList attributes) throws WddxDeserializationException {
        if (!name.equals(CHAR_ELEMENT_NAME)) {
            throw new InvalidChildElementException(CHAR_ELEMENT_NAME, "string");
        }
        String code = attributes.getValue(CODE_ATTRIBUTE_NAME);
        if (code == null) {
            throw new MissingAttributeException(CHAR_ELEMENT_NAME, CODE_ATTRIBUTE_NAME);
        }
        try {
            this.m_buffer.append((char)Integer.parseInt(code, 16));
        }
        catch (NumberFormatException e) {
            throw new BadCharacterDataException(CHAR_ELEMENT_NAME);
        }
    }
}

