/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructOrdered;
import coldfusion.runtime.StructSorted;
import coldfusion.wddx.InvalidChildElementException;
import coldfusion.wddx.MissingAttributeException;
import coldfusion.wddx.ObjectConversionException;
import coldfusion.wddx.ObjectConverter;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import coldfusion.wddx.WddxFilter;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.AttributeList;

class StructHandler
extends WddxElement {
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String VAR_ELEMENT_NAME = "var";
    private static final String SORT_ORDER_ATTRIBUTE_NAME = "sortorder";
    private static final String SORT_TYPE_ATTRIBUTE_NAME = "sorttype";
    private static final String LOCALE_SENSITIVE_ATTRIBUTE_NAME = "localesensitive";
    private Map m_ht = new Struct();
    private String m_currentVarName = null;
    private String m_strictType = null;
    private String sortOrder = null;
    private String sortType = null;
    private String localeSensitive = null;

    StructHandler() {
    }

    @Override
    public void onStartElement(String name, AttributeList attributes) throws WddxDeserializationException {
        this.m_strictType = attributes.getValue(TYPE_ATTRIBUTE_NAME);
        this.sortType = attributes.getValue(SORT_TYPE_ATTRIBUTE_NAME);
        this.sortOrder = attributes.getValue(SORT_ORDER_ATTRIBUTE_NAME);
        this.localeSensitive = attributes.getValue(LOCALE_SENSITIVE_ATTRIBUTE_NAME);
        if (this.m_strictType != null && this.m_strictType.equals("ordered")) {
            this.m_ht = this.sortType == null && this.sortOrder == null && this.localeSensitive == null ? new StructOrdered() : (this.localeSensitive.equals("true") ? new StructSorted(this.sortType, this.sortOrder, true) : new StructSorted(this.sortType, this.sortOrder, false));
        }
    }

    @Override
    public void onEndElement() throws WddxDeserializationException {
        if (this.m_strictType == null) {
            this.setTypeAndValue(this.m_ht);
        } else {
            Class<?> beanClass = null;
            Object bean = null;
            try {
                beanClass = StructHandler.getClassBySignature(this.m_strictType);
                String className = beanClass.getName();
                if (!WddxFilter.validateAllowedClass(className, true)) {
                    throw new WddxDeserializationException();
                }
                bean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.setBeanProperties(bean, this.m_ht);
                this.setTypeAndValue(bean);
            }
            catch (Exception e1) {
                try {
                    beanClass = Class.forName(this.m_strictType);
                    if (!WddxFilter.validateAllowedClass(this.m_strictType, true)) {
                        throw new WddxDeserializationException();
                    }
                    bean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.setListProperties(bean, this.m_ht);
                    this.setTypeAndValue(bean);
                }
                catch (Exception e2) {
                    this.setTypeAndValue(this.m_ht);
                }
            }
        }
    }

    private void setTypeAndValue(Object val) {
        this.setValue(val);
        this.setType(2000, "OBJECT");
    }

    @Override
    public void onBeforeChild(String name, AttributeList attributes) throws WddxDeserializationException {
        if (!name.equals(VAR_ELEMENT_NAME)) {
            throw new InvalidChildElementException(VAR_ELEMENT_NAME, "struct");
        }
        this.m_currentVarName = attributes.getValue(NAME_ATTRIBUTE_NAME);
        if (this.m_currentVarName == null) {
            throw new MissingAttributeException(VAR_ELEMENT_NAME, NAME_ATTRIBUTE_NAME);
        }
    }

    @Override
    public void onAfterChild(WddxElement childElement) throws WddxDeserializationException {
        Object o = childElement.getValue();
        if (o != null) {
            this.m_ht.put(this.m_currentVarName, childElement.getValue());
        } else if (FusionContext.isPreserveNullValues()) {
            this.m_ht.put(this.m_currentVarName, null);
        }
    }

    private void setListProperties(Object bean, Map props) {
        if (bean instanceof Map) {
            Map map = (Map)bean;
            for (String key : props.keySet()) {
                map.put(key, props.get(key));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBeanProperties(Object bean, Map props) throws WddxDeserializationException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
            PropertyDescriptor[] descriptorArray = beanInfo.getPropertyDescriptors();
            Hashtable<String, PropertyDescriptor> descriptors = new Hashtable<String, PropertyDescriptor>();
            for (int i = 0; i < descriptorArray.length; ++i) {
                descriptors.put(descriptorArray[i].getName(), descriptorArray[i]);
            }
            for (String propName : props.keySet()) {
                Object propValue = props.get(propName);
                PropertyDescriptor pd = (PropertyDescriptor)descriptors.get(propName);
                if (pd == null) continue;
                if (pd instanceof IndexedPropertyDescriptor) {
                    Vector values = (Vector)propValue;
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                    Method method = ipd.getIndexedWriteMethod();
                    if (method == null) continue;
                    try {
                        int size = values.size();
                        for (int index = 0; index < size; ++index) {
                            Object value = values.elementAt(index);
                            Class<?>[] types = method.getParameterTypes();
                            value = ObjectConverter.convert(value, types[1]);
                            method.invoke(bean, new Integer(index), value);
                        }
                        continue;
                    }
                    catch (IllegalAccessException size) {
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        throw new WddxDeserializationException(e);
                    }
                    catch (ObjectConversionException e) {
                        throw new IncompatibleValueTypeException(pd.getName(), e.getMessage() + e.getDetail());
                    }
                }
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                try {
                    Object value = propValue;
                    Class<?>[] types = method.getParameterTypes();
                    value = ObjectConverter.convert(value, types[0]);
                    method.invoke(bean, value);
                }
                catch (IllegalAccessException value) {
                }
                catch (InvocationTargetException e) {
                    throw new WddxDeserializationException(e);
                }
                catch (ObjectConversionException e) {
                    throw new IncompatibleValueTypeException(pd.getName(), e.getMessage() + e.getDetail());
                    return;
                }
            }
        }
        catch (IntrospectionException e) {
            throw new WddxDeserializationException(e);
        }
    }

    private static Class getClassBySignature(String jniTypeSig) throws ClassNotFoundException {
        int index = 0;
        char c = jniTypeSig.charAt(index);
        switch (c) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            default: {
                String className = jniTypeSig.substring(index + 1, jniTypeSig.length() - 1);
                return Class.forName(className);
            }
            case '[': 
        }
        String className = jniTypeSig.substring(index, jniTypeSig.length());
        return Class.forName(className);
    }

    public static class IncompatibleValueTypeException
    extends WddxDeserializationException {
        public String propName;
        public String detailMessage;

        public IncompatibleValueTypeException(String propName, String detail) {
            this.propName = propName;
            this.detailMessage = detail;
        }
    }
}

