/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.log.CFLogs;
import coldfusion.runtime.StructTypes;
import coldfusion.server.CFService;
import coldfusion.wddx.DeserializerWorker;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class WddxFilter {
    private static final String defaultWhitelistedClasses = "java.util.Locale;java.util.Collections$EmptySet;java.util.HashMap;coldfusion.server.ConfigMap;coldfusion.util.FastHashtable;coldfusion.saml.SpConfiguration;coldfusion.saml.IdpConfiguration;coldfusion.runtime.CaseSensitiveStruct;coldfusion.scheduling.mod.ScheduleTagData;coldfusion.runtime.ArgumentCollection;coldfusion.util.CaseInsensitiveMap;coldfusion.runtime.AttributeCollection;coldfusion.sql.QueryTable;coldfusion.archivedeploy.Archive;coldfusion.scheduling.ScheduleTagData;coldfusion.osgi.to.ScheduleTagTO;";
    private static String pattern = "";
    private static List<Function<String, Status>> filters = new ArrayList<Function<String, Status>>();
    public static final String CF_SERIAL_FILTER_FILE = "cfserialfilter.txt";
    public static final String INVALID_PACKAGE_EXCEPTION = "Due to security reasons, %s is blocked for deserialization. Add the class/package in the file cfusion/lib/cfserialfilter.txt to override the behavior and allow deserialization";
    public static final String LIB_DIRECTORY_EXCEPTION = "Exception while searching for 'lib' directory using CFService.getLibDir(). Trying using JVM argument 'coldfusion.libPath'...";
    private static String SERIAL_FILTER_INPUTS = "";
    private static final int ASCIIOFDOT = 46;
    private static final int ASCIIOFEQUAL = 61;
    private static long maxStreamBytes;
    private static long maxDepth;
    private static long maxReferences;
    private static long maxArrayLength;
    private static boolean checkComponentType;

    public static boolean invoke(String classOrPackageName, boolean logOnFailure) {
        Status status;
        if (SERIAL_FILTER_INPUTS.equals("")) {
            SERIAL_FILTER_INPUTS = WddxFilter.loadWddxSerializationFilter() + defaultWhitelistedClasses;
        }
        if (filters.isEmpty() && !SERIAL_FILTER_INPUTS.equals("")) {
            WddxFilter.createFilter(SERIAL_FILTER_INPUTS, true);
        }
        if (!(status = WddxFilter.checkInput(classOrPackageName)).equals((Object)Status.ALLOWED) && logOnFailure) {
            CFLogs.WDDX_LOG.info(String.format(INVALID_PACKAGE_EXCEPTION, classOrPackageName));
        }
        return status.equals((Object)Status.ALLOWED);
    }

    private static boolean createFilter(String filterString, boolean checkComponentType) {
        pattern = filterString;
        WddxFilter.checkComponentType = checkComponentType;
        maxArrayLength = Long.MAX_VALUE;
        maxDepth = Long.MAX_VALUE;
        maxReferences = Long.MAX_VALUE;
        maxStreamBytes = Long.MAX_VALUE;
        String[] filterArray = filterString.split(";");
        filters = new ArrayList<Function<String, Status>>(filterArray.length);
        for (int i = 0; i < filterArray.length; ++i) {
            String filterPrefix;
            boolean negate;
            String filter = filterArray[i];
            int filterLength = filter.length();
            if (filterLength == 0 || WddxFilter.parseLimit(filter)) continue;
            boolean bl = negate = filter.charAt(0) == '!';
            if (filter.indexOf(47) >= 0) {
                throw new IllegalArgumentException("invalid character \"/\" in: \"" + filterString + "\"");
            }
            if (filter.endsWith("*")) {
                if (filter.endsWith(".*")) {
                    filterPrefix = filter.substring(negate ? 1 : 0, filterLength - 1);
                    if (filterPrefix.length() < 2) {
                        throw new IllegalArgumentException("package missing in: \"" + filterString + "\"");
                    }
                    if (negate) {
                        filters.add(packageName -> WddxFilter.matchesPackage(filterString, filterPrefix) ? Status.REJECTED : Status.UNDECIDED);
                        continue;
                    }
                    filters.add(packageName -> WddxFilter.matchesPackage(filterString, filterPrefix) ? Status.ALLOWED : Status.UNDECIDED);
                    continue;
                }
                if (filter.endsWith(".**")) {
                    filterPrefix = filter.substring(negate ? 1 : 0, filterLength - 2);
                    if (filterPrefix.length() < 2) {
                        throw new IllegalArgumentException("package missing in: \"" + filterString + "\"");
                    }
                    if (negate) {
                        filters.add(packageName -> packageName.startsWith(filterPrefix) ? Status.REJECTED : Status.UNDECIDED);
                        continue;
                    }
                    filters.add(packageName -> packageName.startsWith(filterPrefix) ? Status.ALLOWED : Status.UNDECIDED);
                    continue;
                }
                filterPrefix = filter.substring(negate ? 1 : 0, filterLength - 1);
                if (negate) {
                    filters.add(packageName -> packageName.startsWith(filterPrefix) ? Status.REJECTED : Status.UNDECIDED);
                    continue;
                }
                filters.add(packageName -> packageName.startsWith(filterPrefix) ? Status.ALLOWED : Status.UNDECIDED);
                continue;
            }
            filterPrefix = filter.substring(negate ? 1 : 0);
            if (filterPrefix.isEmpty()) {
                throw new IllegalArgumentException("class or package missing in: \"" + filterString + "\"");
            }
            if (negate) {
                filters.add(packageName -> packageName.equals(filterPrefix) ? Status.REJECTED : Status.UNDECIDED);
                continue;
            }
            filters.add(packageName -> packageName.equals(filterPrefix) ? Status.ALLOWED : Status.UNDECIDED);
        }
        return true;
    }

    private static boolean matchesPackage(String inputString, String filter) {
        if (inputString == null || filter == null) {
            return false;
        }
        return inputString.startsWith(filter) && inputString.lastIndexOf(46) == filter.length() - 1;
    }

    public String toString() {
        return pattern;
    }

    private static boolean parseLimit(String inputString) {
        int equalsIndex = inputString.indexOf(61);
        if (equalsIndex < 0) {
            return false;
        }
        String value = inputString.substring(equalsIndex + 1);
        if (inputString.startsWith("maxdepth=")) {
            maxDepth = WddxFilter.parseValue(value);
        } else if (inputString.startsWith("maxarray=")) {
            maxArrayLength = WddxFilter.parseValue(value);
        } else if (inputString.startsWith("maxrefs=")) {
            maxReferences = WddxFilter.parseValue(value);
        } else {
            if (!inputString.startsWith("maxbytes=")) {
                throw new IllegalArgumentException("unknown limit: " + inputString.substring(0, equalsIndex));
            }
            maxStreamBytes = WddxFilter.parseValue(value);
        }
        return true;
    }

    private static long parseValue(String value) throws IllegalArgumentException {
        long parsedLongValue = Long.parseLong(value);
        if (parsedLongValue < 0L) {
            throw new IllegalArgumentException("negative limit: " + value);
        }
        return parsedLongValue;
    }

    public static Status checkInput(String inputString) {
        Optional<Status> statusOfFilter = filters.stream().map(packageName -> (Status)((Object)((Object)packageName.apply(inputString)))).filter(packageName -> packageName != Status.UNDECIDED).findFirst();
        return statusOfFilter.orElse(Status.UNDECIDED);
    }

    private static String loadWddxSerializationFilter() {
        String libPath = null;
        try {
            libPath = CFService.getLibPath() + File.separator + CF_SERIAL_FILTER_FILE;
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(LIB_DIRECTORY_EXCEPTION);
            libPath = System.getProperty("coldfusion.libPath") + File.separator + CF_SERIAL_FILTER_FILE;
        }
        File file = new File(libPath);
        if (file.exists() && !file.isDirectory()) {
            try {
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                SERIAL_FILTER_INPUTS = new String(fileBytes).trim();
                if (!SERIAL_FILTER_INPUTS.endsWith(";")) {
                    SERIAL_FILTER_INPUTS = SERIAL_FILTER_INPUTS + ";";
                }
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error(e);
                CFLogs.WDDX_LOG.error(e);
            }
        }
        return SERIAL_FILTER_INPUTS;
    }

    public static boolean validateAllowedClass(String attributeType, boolean logOnFailure) throws DeserializerWorker.InvalidWddxPacketException {
        return attributeType == null || attributeType.equalsIgnoreCase(StructTypes.ORDERED.getValue()) || attributeType.equalsIgnoreCase(StructTypes.CASESENSITIVE.getValue()) || attributeType.equalsIgnoreCase(StructTypes.ORDEREDCASESENSITIVE.getValue()) || WddxFilter.invoke(attributeType, logOnFailure);
    }

    static {
        checkComponentType = true;
    }

    public static enum Status {
        UNDECIDED,
        ALLOWED,
        REJECTED;

    }
}

