/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.runtime.ApplicationException;
import coldfusion.wddx.WddxDefaults;
import coldfusion.wddx.WddxException;
import coldfusion.wddx.WddxObjectSerializer;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class WddxObjectSerializerFactory {
    private Hashtable m_serializers = new Hashtable();
    private Vector m_registeredClasses = new Vector();

    public WddxObjectSerializerFactory() {
        this.init(WddxDefaults.getProperties());
    }

    public WddxObjectSerializerFactory(Properties props) throws WddxException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.init(props);
    }

    public synchronized void registerSerializer(String className, WddxObjectSerializer os) {
        try {
            Class<?> cls = Class.forName(className);
            this.m_registeredClasses.addElement(cls);
            this.m_serializers.put(cls.getName(), os);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public synchronized void registerSerializer(Object obj, WddxObjectSerializer os) {
        this.m_registeredClasses.addElement(obj.getClass());
        this.m_serializers.put(obj.getClass().getName(), os);
    }

    public synchronized WddxObjectSerializer getSerializer(String className) {
        WddxObjectSerializer serializer = null;
        Object obj = this.m_serializers.get(className);
        if (obj != null) {
            try {
                serializer = (WddxObjectSerializer)obj;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return serializer;
    }

    public synchronized WddxObjectSerializer getSerializer(Object obj) {
        Class<?> objClass = obj.getClass();
        String className = objClass.getName();
        WddxObjectSerializer ser = this.getSerializer(className);
        if (ser != null) {
            return ser;
        }
        Enumeration classesEnum = this.m_registeredClasses.elements();
        while (classesEnum.hasMoreElements() && ser == null) {
            Class cls = (Class)classesEnum.nextElement();
            if (!cls.isAssignableFrom(objClass)) continue;
            ser = this.getSerializer(cls.getName());
        }
        if (ser != null) {
            this.registerSerializer(objClass.getName(), ser);
        }
        return ser;
    }

    private void init(Properties config) {
        String configVal;
        int i = 1;
        while ((configVal = config.getProperty("serializer." + i)) != null) {
            int index = configVal.indexOf("=");
            String type = configVal.substring(0, index);
            String className = configVal.substring(index + 1);
            try {
                WddxObjectSerializer ser = (WddxObjectSerializer)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.registerSerializer(type, ser);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SerializerLoadError(className, e);
            }
            ++i;
        }
    }

    public class SerializerLoadError
    extends ApplicationException {
        public String className;
        public Throwable rootCause;

        public SerializerLoadError(String className, Throwable ex) {
            this.className = className;
            this.rootCause = ex;
        }
    }

    public class SerializerNotAccessibleException
    extends ApplicationException {
        public String className;
        public Throwable rootCause;

        public SerializerNotAccessibleException(String className, Throwable ex) {
            this.className = className;
            this.rootCause = ex;
        }
    }

    public class SerializerNotFoundException
    extends ApplicationException {
        public String className;
        public Throwable rootCause;

        public SerializerNotFoundException(String className, Throwable ex) {
            this.className = className;
            this.rootCause = ex;
        }
    }
}

