/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Copyable;
import coldfusion.xml.XmlChildIndexException;
import coldfusion.xml.XmlFunctions;
import coldfusion.xml.XmlInvalidIdentifierException;
import coldfusion.xml.XmlNodeMap;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNodeList
implements NodeList,
MemoryTrackable,
Serializable,
Copyable {
    protected Vector nodes;
    protected boolean isCaseSensitive = false;
    protected boolean doNotDuplicate = false;
    private transient MemoryTrackerProxy mtProxy;

    public XmlNodeList(Document doc, boolean caseSensitive) {
        this.nodes = new Vector();
        this.nodes.add(doc);
        this.isCaseSensitive = caseSensitive;
    }

    public XmlNodeList(Vector vect, boolean caseSensitive) {
        this.nodes = vect;
        this.isCaseSensitive = caseSensitive;
    }

    public XmlNodeList(Node node, boolean caseSensitive) {
        this.nodes = new Vector();
        this.nodes.add(node);
        this.isCaseSensitive = caseSensitive;
    }

    public XmlNodeList(XmlNodeList nl, String name) {
        Element newNode;
        this.nodes = new Vector();
        Node node = nl.getFirstNode();
        Document doc = node.getOwnerDocument();
        try {
            newNode = doc.createElement(name);
        }
        catch (DOMException domEx) {
            throw new XmlInvalidIdentifierException(name);
        }
        this.nodes.add(newNode);
        this.doNotDuplicate = true;
    }

    private XmlNodeList getNodeList(int idx) {
        if (idx == 0 && this.nodes.size() == 1) {
            return this;
        }
        Node node = this.getNode(idx);
        return new XmlNodeList(node, this.isCaseSensitive);
    }

    public Node getFirstNode() {
        return (Node)this.nodes.get(0);
    }

    public Node getNode(int idx) {
        if (idx < 0 || idx >= this.nodes.size()) {
            throw new XmlChildIndexException(idx + 1, this.nodes.size());
        }
        return (Node)this.nodes.get(idx);
    }

    @Override
    public Node item(int idx) {
        if (idx < 0 || idx >= this.nodes.size()) {
            return null;
        }
        return (Node)this.nodes.get(idx);
    }

    public int size() {
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    @Override
    public int getLength() {
        return this.size();
    }

    public Object ArrayGet(Object pos) {
        Object obj;
        try {
            int idx = Cast._int(pos) - 1;
            obj = this.getNodeList(idx);
        }
        catch (XmlChildIndexException xe) {
            throw xe;
        }
        catch (Exception ex1) {
            obj = Cast._Map(this).get(Cast._String(pos));
        }
        return obj;
    }

    public void ArraySet(Object pos, Object val, boolean initializer) {
        try {
            int idx = Cast._int(pos) - 1;
            Node oldChild = this.getNode(idx);
            Node node = oldChild.getParentNode();
            Node newChild = XmlNodeMap.verifyElement(val);
            if (this.mtProxy != null) {
                this.mtProxy.onRemoveObject(XmlFunctions.serializeToString((Element)oldChild));
            }
            node.replaceChild(newChild, oldChild);
            if (this.mtProxy != null) {
                this.mtProxy.onAddObject(XmlFunctions.serializeToString((Element)newChild));
            }
        }
        catch (XmlChildIndexException xe) {
            throw xe;
        }
        catch (Exception ex1) {
            XmlNodeMap nodeMap = new XmlNodeMap(this);
            nodeMap.bindName(Cast._String(pos), val);
        }
    }

    protected void clear() {
        if (this.nodes.size() == 0) {
            return;
        }
        Node node = this.getFirstNode();
        if (node instanceof Document) {
            node = XmlFunctions.documentNew();
            this.nodes.set(0, node);
            if (this.mtProxy != null) {
                this.mtProxy.resetMemory();
            }
        } else if (node instanceof Element) {
            Document doc = node.getOwnerDocument();
            Element newNode = doc.createElement(node.getNodeName());
            Node parent = node.getParentNode();
            try {
                parent.replaceChild(newNode, node);
                if (this.mtProxy != null) {
                    this.mtProxy.onRemoveObject(XmlFunctions.serializeToString((Element)node));
                    this.mtProxy.onAddObject(XmlFunctions.serializeToString(newNode));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getScopeType() {
        return -1;
    }

    @Override
    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.mtProxy;
    }

    @Override
    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        this.mtProxy = mtp;
    }

    @Override
    public Iterator valuesIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.toString());
        return list.iterator();
    }

    public XmlNodeList Duplicate() {
        Node copy;
        Node node = this.getFirstNode();
        if (node instanceof Document) {
            copy = XmlFunctions.documentNew();
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (child instanceof DocumentType) continue;
                child = copy.importNode(child, true);
                copy.appendChild(child);
            }
        } else {
            copy = node.cloneNode(true);
        }
        return new XmlNodeList(copy, this.isCaseSensitive);
    }

    public Object get(int idx) {
        return new XmlNodeList(this.getNode(idx), this.isCaseSensitive);
    }

    public Object remove(int idx) {
        Node n = this.getNode(idx);
        Node pn = n.getParentNode();
        pn.removeChild(n);
        Object oldObj = this.nodes.remove(idx);
        try {
            if (this.mtProxy != null) {
                this.mtProxy.onRemoveObject(XmlFunctions.serializeToString((Element)oldObj));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return oldObj;
    }

    public String toString() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String retval = null;
                try {
                    retval = XmlNodeList.this.SerializeToString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (retval == null) {
                    try {
                        Document xmldom;
                        DocumentType doctype;
                        TransformerFactory tFactory = TransformerFactory.newInstance();
                        Transformer transformer = tFactory.newTransformer();
                        Node dom = XmlNodeList.this.getNode(0);
                        if (dom instanceof Document && (doctype = (xmldom = (Document)dom).getDoctype()) != null) {
                            if (doctype.getSystemId() != null) {
                                transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                            }
                            if (doctype.getSystemId() != null) {
                                transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                            }
                        }
                        DOMSource source = new DOMSource(XmlNodeList.this.getNode(0));
                        StringWriter writer = new StringWriter();
                        StreamResult result = new StreamResult(writer);
                        transformer.transform(source, result);
                        retval = writer.toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return retval;
            }
        });
    }

    private String SerializeToString() throws Throwable {
        Node dom = this.getNode(0);
        OutputFormat format = new OutputFormat();
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
        serializer.serialize((Document)dom);
        String retval = writer.toString();
        return retval;
    }

    public List getNodesList() {
        return this.nodes;
    }

    @Override
    public XmlNodeList clone() {
        return new XmlNodeList(this.getFirstNode().cloneNode(false), this.isCaseSensitive);
    }
}

