/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.Scope;
import coldfusion.xml.XmlAttrMap;
import coldfusion.xml.XmlEntityMap;
import coldfusion.xml.XmlFunctions;
import coldfusion.xml.XmlLhsNodeAssignmentException;
import coldfusion.xml.XmlNameMatcher;
import coldfusion.xml.XmlNodeArray;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlNonMatchingNamesAssignException;
import coldfusion.xml.XmlPropertyAssignmentException;
import coldfusion.xml.XmlPropertyDeleteException;
import coldfusion.xml.XmlRhsNodeAssignmentException;
import coldfusion.xml.XmlUndefinedPropertyException;
import coldfusion.xml.XmlWrongNodeTypeAssignmentException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNodeMap
extends Scope {
    private Node node;
    private XmlNodeList nodeList;
    protected boolean isCaseSensitive = false;

    public XmlNodeMap(XmlNodeList xmlNodes) {
        this.nodeList = xmlNodes;
        this.node = xmlNodes.getNode(0);
        this.isCaseSensitive = xmlNodes.isCaseSensitive;
    }

    private boolean isPropertyName(String name) {
        return name.length() > 3 && name.substring(0, 3).equalsIgnoreCase("XML");
    }

    private boolean isAttributeName(String name) {
        return name.length() > 1 && name.substring(0, 1).equalsIgnoreCase("@");
    }

    private void bindNodeProperty(Node node, String name, Object obj) {
        if (name.equalsIgnoreCase("XMLNAME")) {
            throw new XmlPropertyAssignmentException("XmlName");
        }
        if (!name.equalsIgnoreCase("XMLVALUE")) {
            if (name.equalsIgnoreCase("XMLTYPE")) {
                throw new XmlPropertyAssignmentException("XmlType");
            }
            throw new XmlUndefinedPropertyException(name, XmlFunctions.getType(node));
        }
        String val = Cast._String(obj);
        node.setNodeValue(val);
    }

    private void bindDocumentProperty(Document doc, String name, Object obj) {
        if (name.equalsIgnoreCase("XMLCOMMENT")) {
            String comment = Cast._String(obj);
            XmlFunctions.setComment(doc, comment);
            this.addToMemoryTracker(comment);
        } else {
            if (name.equalsIgnoreCase("XMLDOCTYPE")) {
                throw new XmlFeatureException();
            }
            if (name.equalsIgnoreCase("XMLROOT")) {
                Node newRoot = XmlNodeMap.verifyElement(obj);
                Element root = doc.getDocumentElement();
                if (root == null) {
                    this.resetMemoryTrackerMemory();
                    doc.appendChild(newRoot);
                    this.addToMemoryTracker(doc);
                } else {
                    this.removeFromMemoryTracker(root);
                    doc.replaceChild(newRoot, root);
                    this.addToMemoryTracker(newRoot);
                }
            } else {
                this.bindNodeProperty(doc, name, obj);
            }
        }
    }

    private void bindElementProperty(Element elem, String name, Object obj) {
        this.removeFromMemoryTracker(elem);
        if (name.equalsIgnoreCase("XMLATTRIBUTES")) {
            XmlFunctions.setAttributes(elem, obj);
        } else if (!name.equalsIgnoreCase("XMLCHILDREN")) {
            if (name.equalsIgnoreCase("XMLCOMMENT")) {
                String comment = Cast._String(obj);
                XmlFunctions.setComment(elem, comment);
            } else if (name.equalsIgnoreCase("XMLNSPREFIX")) {
                String str = Cast._String(obj);
                XmlFunctions.setNamespacePrefix(elem, str);
            } else if (name.equalsIgnoreCase("XMLNSURI")) {
                String str = Cast._String(obj);
                XmlFunctions.setNamespaceURI(elem, str);
            } else if (name.equalsIgnoreCase("XMLPARENT")) {
                if (obj instanceof XmlNodeList && ((XmlNodeList)obj).size() == 1 && ((XmlNodeList)obj).getNode(0) instanceof Element) {
                    Element parent = (Element)((XmlNodeList)obj).getNode(0);
                    XmlFunctions.setParent(elem, parent);
                }
            } else if (name.equalsIgnoreCase("XMLTEXT")) {
                String text = Cast._String(obj);
                XmlFunctions.setText(elem, text);
            } else if (name.equalsIgnoreCase("XMLCDATA")) {
                String text = Cast._String(obj);
                XmlFunctions.setCData(elem, text);
            } else {
                this.bindNodeProperty(elem, name, obj);
            }
        }
        this.addToMemoryTracker(elem);
    }

    public static Node verifyElement(Object obj) {
        if (!(obj instanceof XmlNodeList)) {
            throw new XmlRhsNodeAssignmentException();
        }
        Node nodeObj = ((XmlNodeList)obj).getFirstNode();
        if (!(nodeObj instanceof Element)) {
            String name1 = nodeObj.getNodeName();
            String type1 = XmlFunctions.getType(nodeObj);
            throw new XmlWrongNodeTypeAssignmentException(name1, type1);
        }
        return nodeObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bindElementName(String name, Object obj) {
        XmlNodeList nodeList = (XmlNodeList)this.resolveElementName(name);
        Node newNode = XmlNodeMap.verifyElement(obj);
        if (!((XmlNodeList)obj).doNotDuplicate) {
            newNode = newNode.cloneNode(true);
        }
        if (nodeList == null) {
            if (!XmlNameMatcher.isMatch(name, newNode.getNodeName(), this.isCaseSensitive)) throw new XmlNonMatchingNamesAssignException(name, newNode.getNodeName());
            this.node.appendChild(newNode);
            this.addToMemoryTracker(newNode);
            return;
        } else {
            this.removeFromMemoryTracker(this.node);
            this.node.replaceChild(newNode, nodeList.getFirstNode());
            this.addToMemoryTracker(this.node);
        }
    }

    @Override
    protected void bindName_Final(String name, Object obj) {
        this.bindName(name, obj);
    }

    @Override
    protected void bindName(String name, Object obj) {
        if (name == null || name.equals("")) {
            throw new XmlUndefinedPropertyException("", XmlFunctions.getType(this.node));
        }
        if (this.isPropertyName(name)) {
            if (this.node instanceof Document) {
                this.bindDocumentProperty((Document)this.node, name, obj);
            } else if (this.node instanceof Element) {
                this.bindElementProperty((Element)this.node, name, obj);
            } else {
                this.bindNodeProperty(this.node, name, obj);
            }
        } else if (this.node instanceof Element || this.node instanceof Document) {
            this.bindElementName(name, obj);
        } else {
            throw new XmlLhsNodeAssignmentException();
        }
    }

    private void unbindNodeProperty(Node node, String name) {
        if (name.equalsIgnoreCase("XMLNAME")) {
            throw new XmlPropertyDeleteException("XmlName");
        }
        if (!name.equalsIgnoreCase("XMLVALUE")) {
            if (name.equalsIgnoreCase("XMLTYPE")) {
                throw new XmlPropertyDeleteException("XmlType");
            }
            throw new XmlUndefinedPropertyException(name, XmlFunctions.getType(node));
        }
        node.setNodeValue("");
    }

    private void unbindDocumentProperty(Document doc, String name) {
        if (name.equalsIgnoreCase("XMLCOMMENT")) {
            this.resetMemoryTrackerMemory();
            XmlFunctions.removeNodes(doc, 8, 8);
            this.addToMemoryTracker(doc);
        } else if (name.equalsIgnoreCase("XMLROOT")) {
            Element root = doc.getDocumentElement();
            if (root != null) {
                this.resetMemoryTrackerMemory();
                doc.removeChild(root);
                this.addToMemoryTracker(doc);
            }
        } else {
            this.unbindNodeProperty(doc, name);
        }
    }

    private void unbindElementProperty(Element elem, String name) {
        this.removeFromMemoryTracker(elem);
        if (name.equalsIgnoreCase("XMLATTRIBUTES")) {
            XmlFunctions.removeAttributes(elem);
        } else if (name.equalsIgnoreCase("XMLCHILDREN")) {
            XmlFunctions.removeChildren(elem);
        } else if (name.equalsIgnoreCase("XMLCOMMENT")) {
            XmlFunctions.removeNodes(elem, 8, 8);
        } else {
            if (name.equalsIgnoreCase("XMLNSPREFIX")) {
                throw new XmlPropertyDeleteException("XmlNsPrefix");
            }
            if (name.equalsIgnoreCase("XMLNSURI")) {
                throw new XmlPropertyDeleteException("XmlNsUri");
            }
            if (name.equalsIgnoreCase("XMLPARENT")) {
                throw new XmlPropertyDeleteException("XmlParent");
            }
            if (name.equalsIgnoreCase("XMLTEXT") || name.equalsIgnoreCase("XMLCDATA")) {
                XmlFunctions.removeNodes(elem, 3, 4);
            } else {
                this.unbindNodeProperty(elem, name);
            }
        }
        this.addToMemoryTracker(elem);
    }

    public void unbindElementName(String name) {
        Node n = this.node.getFirstChild();
        while (n != null) {
            String nn = n.getNodeName();
            Node nextn = n.getNextSibling();
            if (nn != null && XmlNameMatcher.isMatch(name, nn, this.isCaseSensitive)) {
                this.removeFromMemoryTracker(this.node);
                this.node.removeChild(n);
                this.addToMemoryTracker(this.node);
            }
            n = nextn;
        }
    }

    @Override
    protected void unbindName(String name) {
        if (name == null || name.equals("")) {
            throw new XmlUndefinedPropertyException("", XmlFunctions.getType(this.node));
        }
        if (this.isPropertyName(name)) {
            if (this.node instanceof Document) {
                this.unbindDocumentProperty((Document)this.node, name);
            } else if (this.node instanceof Element) {
                this.unbindElementProperty((Element)this.node, name);
            } else {
                this.unbindNodeProperty(this.node, name);
            }
        } else {
            this.unbindElementName(name);
        }
    }

    private Object resolveNodeProperty(Node node, String name) {
        if (name.equalsIgnoreCase("XMLTYPE")) {
            return XmlFunctions.getType(node);
        }
        if (name.equalsIgnoreCase("XMLNAME")) {
            return XmlFunctions.getName(node);
        }
        if (name.equalsIgnoreCase("XMLVALUE")) {
            return XmlFunctions.getValue(node);
        }
        return null;
    }

    private Object resolveEntityProperty(Entity ent, String name) {
        if (name.equalsIgnoreCase("XMLSYSTEM")) {
            return ent.getSystemId();
        }
        if (name.equalsIgnoreCase("XMLNOTATION")) {
            return ent.getNotationName();
        }
        return this.resolveNodeProperty(ent, name);
    }

    private Object resolveDoctypeProperty(DocumentType doctype, String name) {
        if (name.equalsIgnoreCase("XMLENTITIES")) {
            NamedNodeMap map = doctype.getEntities();
            return new XmlEntityMap(doctype, map, this.isCaseSensitive);
        }
        return this.resolveNodeProperty(doctype, name);
    }

    private Object resolveDocumentProperty(Document doc, String name) {
        if (name.equalsIgnoreCase("XMLCOMMENT")) {
            return XmlFunctions.getComment(doc);
        }
        if (name.equalsIgnoreCase("XMLDOCTYPE")) {
            if (doc.getDoctype() == null) {
                return null;
            }
            return new XmlNodeList(doc.getDoctype(), this.isCaseSensitive);
        }
        if (name.equalsIgnoreCase("XMLROOT")) {
            if (doc.getDocumentElement() == null) {
                return null;
            }
            return new XmlNodeList(doc.getDocumentElement(), this.isCaseSensitive);
        }
        return this.resolveNodeProperty(doc, name);
    }

    private Object resolveElementProperty(Element elem, String name) {
        if (name.equalsIgnoreCase("XMLATTRIBUTES")) {
            NamedNodeMap map = elem.getAttributes();
            return new XmlAttrMap(elem, map, this.isCaseSensitive);
        }
        if (name.equalsIgnoreCase("XMLCHILDREN")) {
            XmlNodeArray array = XmlFunctions.getChildren(elem);
            array.setCase(this.isCaseSensitive);
            MemoryTrackerProxy mtp = this.nodeList.getMemoryTrackerProxy();
            if (mtp != null) {
                array.setMemoryTrackerProxy(mtp);
            }
            return array;
        }
        if (name.equalsIgnoreCase("XMLCOMMENT")) {
            return XmlFunctions.getComment(elem);
        }
        if (name.equalsIgnoreCase("XMLNODES")) {
            XmlNodeArray array = XmlFunctions.getNodes(elem);
            array.setCase(this.isCaseSensitive);
            return array;
        }
        if (name.equalsIgnoreCase("XMLNSPREFIX")) {
            return XmlFunctions.getNamespacePrefix(elem);
        }
        if (name.equalsIgnoreCase("XMLNSURI")) {
            return XmlFunctions.getNamespaceURI(elem);
        }
        if (name.equalsIgnoreCase("XMLPARENT")) {
            Node parent = elem.getParentNode();
            return new XmlNodeList(parent, this.isCaseSensitive);
        }
        if (name.equalsIgnoreCase("XMLTEXT") || name.equalsIgnoreCase("XMLCDATA")) {
            return XmlFunctions.getText(elem);
        }
        return this.resolveNodeProperty(elem, name);
    }

    private Object resolveElementName(String name) {
        Vector<Node> children = new Vector<Node>(8, 8);
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            String childName = child.getNodeName();
            if (child.getNodeType() != 1 || !XmlNameMatcher.isMatch(name, childName, this.isCaseSensitive)) continue;
            children.add(child);
        }
        if (children.size() > 0) {
            XmlNodeList xmlNodeList = new XmlNodeList(children, this.isCaseSensitive);
            MemoryTrackerProxy mtp = this.nodeList.getMemoryTrackerProxy();
            if (mtp != null) {
                xmlNodeList.setMemoryTrackerProxy(mtp);
            }
            return xmlNodeList;
        }
        return null;
    }

    @Override
    protected Object resolveName(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        Object result = null;
        if (this.isPropertyName(name)) {
            result = this.node instanceof Document ? this.resolveDocumentProperty((Document)this.node, name) : (this.node instanceof Element ? this.resolveElementProperty((Element)this.node, name) : (this.node instanceof DocumentType ? this.resolveDoctypeProperty((DocumentType)this.node, name) : (this.node instanceof Entity ? this.resolveEntityProperty((Entity)this.node, name) : this.resolveNodeProperty(this.node, name))));
        } else if (this.isAttributeName(name)) {
            if (this.node instanceof Element) {
                String attrName = name.substring(1);
                return ((Element)this.node).getAttribute(attrName);
            }
            return null;
        }
        if (result == null) {
            return this.resolveElementName(name);
        }
        return result;
    }

    @Override
    protected boolean containsName(String name) {
        return this.resolveName(name) != null;
    }

    private void addToMemoryTracker(Object obj) {
        MemoryTrackerProxy mtp = this.nodeList.getMemoryTrackerProxy();
        if (mtp != null) {
            if (obj instanceof Document) {
                obj = ((Document)obj).getDocumentElement();
            }
            if (obj instanceof Element) {
                try {
                    mtp.onAddObject(XmlFunctions.serializeToString((Element)obj));
                }
                catch (IOException iOException) {}
            } else {
                mtp.onAddObject(obj);
            }
        }
    }

    private void removeFromMemoryTracker(Object obj) {
        MemoryTrackerProxy mtp = this.nodeList.getMemoryTrackerProxy();
        if (mtp != null) {
            if (obj instanceof Document) {
                obj = ((Document)obj).getDocumentElement();
            }
            if (obj instanceof Element) {
                try {
                    mtp.onRemoveObject(XmlFunctions.serializeToString((Element)obj));
                }
                catch (IOException iOException) {}
            } else {
                mtp.onRemoveObject(obj);
            }
        }
    }

    private void resetMemoryTrackerMemory() {
        MemoryTrackerProxy mtp = this.nodeList.getMemoryTrackerProxy();
        if (mtp != null) {
            mtp.resetMemory();
        }
    }

    @Override
    protected Iterator getNames() {
        Vector<String> array = new Vector<String>();
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1) continue;
            array.add(item.getNodeName());
        }
        return array.iterator();
    }

    @Override
    public void clear() {
        this.nodeList.clear();
    }

    @Override
    public boolean isEmpty() {
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        int size = 0;
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            ++size;
        }
        return size;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XmlNodeList nl = this.nodeList.Duplicate();
        return new XmlNodeMap(nl);
    }

    public class XmlFeatureException
    extends ExpressionException {
    }
}

