/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.xml.ParamUtil;
import coldfusion.xml.XmlConfigurationException;
import coldfusion.xml.XmlFactoryConfigurationException;
import coldfusion.xml.XmlIOException;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlPathUtil;
import coldfusion.xml.XmlProcessException;
import coldfusion.xml.XmlTransformResolver;
import coldfusion.xml.XmlUnsupportedArgumentException;
import coldfusion.xml.XmlValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.jaxp.DocBuilderHelper;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XmlProcessor {
    public static final String ALLOW_EXTERNAL_ENTITIES = "coldfusion.xml.allowExternalEntities";
    public static final String ENTITY_EXPANSION_LIMIT = "coldfusion.xml.entityExpansionLimit";
    public static final String ALLOW_PATH_CHARACTERS = "coldfusion.xml.allowPathCharacters";
    public static final String EXTERNAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    public static final String SECURITY_MANAGER_FEATURE = "http://apache.org/xml/properties/security-manager";
    public static boolean allowExternalEntities;
    public static final String EXTERNAL_ENTITIES_KEY = "ALLOWEXTERNALENTITIES";
    public static final String ENTITY_EXPANSION_LIMIT_KEY = "ENTITYEXPANSIONLIMIT";
    static final SecurityManager xmlSecurityManager;
    private static Processor processor;
    private static boolean overrideUseXSLT2;
    static Hashtable<String, Object> domDefaultAttributes;
    static Hashtable<String, Object> domDefaultValidationAttributes;

    public static Map SchemaValidate(String xmlStr) {
        return XmlValidator.doValidation(xmlStr);
    }

    public static Map SchemaValidate(Object obj, String XmlSchema) {
        Map retval = obj instanceof String ? XmlValidator.doValidation((String)obj, XmlSchema) : XmlValidator.doValidation(obj.toString(), XmlSchema);
        return retval;
    }

    public static Map SchemaValidate(Object obj, String XmlSchema, Map xmlParserOptions) {
        Map retval = obj instanceof String ? XmlValidator.doValidation((String)obj, XmlSchema, xmlParserOptions) : XmlValidator.doValidation(obj.toString(), XmlSchema, xmlParserOptions);
        return retval;
    }

    public static boolean IsXML(String str) {
        return XmlValidator.isWellFormed(str);
    }

    public static boolean IsXML(String str, Map xmlParserOptions) {
        return XmlValidator.isWellFormed(str, xmlParserOptions);
    }

    public static String getXmlNodeType(Object obj) {
        if (!(obj instanceof XmlNodeList) || ((XmlNodeList)obj).getFirstNode() == null) {
            throw new XmlUnsupportedArgumentException("XmlGetNodeType", "XmlDocument");
        }
        Node node = ((XmlNodeList)obj).getFirstNode();
        short nodeType = node.getNodeType();
        return switch (nodeType) {
            case 2 -> "ATTRIBUTE_NODE";
            case 4 -> "CDATA_SECTION_NODE";
            case 8 -> "COMMENT_NODE";
            case 11 -> "DOCUMENT_FRAGMENT_NODE";
            case 9 -> "DOCUMENT_NODE";
            case 10 -> "DOCUMENT_TYPE_NODE";
            case 1 -> "ELEMENT_NODE";
            case 6 -> "ENTITY_NODE";
            case 5 -> "ENTITY_REFERENCE_NODE";
            case 12 -> "NOTATION_NODE";
            case 7 -> "PROCESSING_INSTRUCTION_NODE";
            case 3 -> "TEXT_NODE";
            default -> "unknown";
        };
    }

    public static XmlNodeList parse(String xmlStr, boolean caseSensitive) {
        return XmlProcessor.parse(xmlStr, caseSensitive, (Map)null);
    }

    public static XmlNodeList parse(String xmlStr, boolean caseSensitive, Map xmlParserOptions) {
        Document doc;
        InputSource input = XmlProcessor.getXMLInputSource(xmlStr);
        DocumentBuilder builder = null;
        try {
            if (xmlParserOptions == null) {
                builder = DocBuilderHelper.getDocumentBuilder(domDefaultAttributes, null, false);
            } else {
                SecurityManager manager;
                Hashtable attributes = domDefaultAttributes;
                Hashtable<String, Object> features = null;
                boolean allowXXE = XmlProcessor.getAllowXXE(xmlParserOptions);
                if (!allowXXE) {
                    features = new Hashtable<String, Object>();
                    features.put(EXTERNAL_ENTITIES_FEATURE, false);
                    features.put(EXTERNAL_PARAMETER_ENTITIES_FEATURE, false);
                }
                if ((manager = XmlProcessor.getXMLSecurityManager(xmlParserOptions)) != xmlSecurityManager) {
                    attributes = (Hashtable)attributes.clone();
                    attributes.put(SECURITY_MANAGER_FEATURE, manager);
                }
                builder = DocBuilderHelper.getDocumentBuilder(attributes, features, false);
            }
            doc = builder.parse(input);
        }
        catch (FactoryConfigurationError e) {
            throw new XmlFactoryConfigurationException("Parser");
        }
        catch (SAXException e) {
            throw new XmlProcessException("Parsing", e.getMessage());
        }
        catch (IOException e) {
            throw new XmlProcessException("Parsing", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        return new XmlNodeList(doc, caseSensitive);
    }

    static void addParserPropertiesFromOptions(Object xmlParser, XmlValidator validator, Map xmlParserOptions) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        boolean allowXXE = XmlProcessor.getAllowXXE(xmlParserOptions);
        boolean allowXXESetOnValidator = false;
        if (validator != null) {
            allowXXESetOnValidator = true;
            if (StringUtils.isBlank((CharSequence)validator.getSchema())) {
                validator.setAllowXXE(allowXXE);
            }
        }
        SecurityManager manager = XmlProcessor.getXMLSecurityManager(xmlParserOptions);
        if (xmlParser instanceof DocumentBuilderFactory) {
            DocumentBuilderFactory factory = (DocumentBuilderFactory)xmlParser;
            if (!allowXXESetOnValidator) {
                factory.setFeature(EXTERNAL_ENTITIES_FEATURE, allowXXE);
                factory.setFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE, allowXXE);
            }
            factory.setAttribute(SECURITY_MANAGER_FEATURE, manager);
        } else if (xmlParser instanceof XMLReader) {
            XMLReader parser = (XMLReader)xmlParser;
            if (!allowXXESetOnValidator) {
                parser.setFeature(EXTERNAL_ENTITIES_FEATURE, allowXXE);
                parser.setFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE, allowXXE);
            }
            parser.setProperty(SECURITY_MANAGER_FEATURE, manager);
        }
    }

    public static boolean getAllowXXE(Map xmlParserOptions) {
        Object value;
        if (xmlParserOptions != null && (value = xmlParserOptions.get(EXTERNAL_ENTITIES_KEY)) != null) {
            return Cast._boolean(value, allowExternalEntities);
        }
        return allowExternalEntities;
    }

    static SecurityManager getXMLSecurityManager(Map xmlParserOptions) {
        Object value;
        SecurityManager manager = xmlSecurityManager;
        if (xmlParserOptions != null && (value = xmlParserOptions.get(ENTITY_EXPANSION_LIMIT_KEY)) != null) {
            try {
                int limit = Cast._int(value);
                if (limit > 0) {
                    manager = new SecurityManager();
                    manager.setEntityExpansionLimit(limit);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return manager;
    }

    public static InputStream getXMLInputStream(String xmlreference) {
        InputStream stream = null;
        try {
            URL url = new URL(xmlreference);
            stream = url.openConnection().getInputStream();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            throw new XmlIOException(e);
        }
        if (stream == null) {
            try {
                File file = XmlProcessor.getFile(xmlreference);
                if (file != null) {
                    stream = new FileInputStream(file);
                } else {
                    Object relPath = XmlPathUtil.getTemplatePathBaseDir();
                    if (relPath != null && ((String)relPath).length() > 0 && (file = XmlProcessor.getFile((String)(relPath = (String)relPath + File.separatorChar + xmlreference))) != null) {
                        stream = new FileInputStream(file);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return stream;
    }

    public static InputSource getInputSource(String xmlreference) {
        if (XmlProcessor.startsWithXMLCharacter(xmlreference) || xmlreference.length() > 2000) {
            return new InputSource(new StringReader(xmlreference));
        }
        InputStream stream = XmlProcessor.getXMLInputStream(xmlreference);
        InputSource input = null;
        input = stream != null ? new InputSource(stream) : new InputSource(new StringReader(xmlreference));
        return input;
    }

    public static InputSource getXMLInputSource(String xmlreference) {
        if (XmlProcessor.startsWithXMLCharacter(xmlreference) || xmlreference.length() > 2000) {
            return new InputSource(new StringReader(xmlreference));
        }
        InputSource source = null;
        try {
            URL url = new URL(xmlreference);
            InputStream stream = url.openConnection().getInputStream();
            source = new InputSource(stream);
            source.setSystemId(url.toString());
            return source;
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            throw new XmlIOException(e);
        }
        try {
            File file = XmlProcessor.getFile(xmlreference);
            if (file != null) {
                source = new InputSource(new FileInputStream(file));
                source.setSystemId(file.toURL().toString());
            } else {
                Object relPath = XmlPathUtil.getTemplatePathBaseDir();
                if (relPath != null && ((String)relPath).length() > 0 && (file = XmlProcessor.getFile((String)(relPath = (String)relPath + File.separatorChar + xmlreference))) != null) {
                    source = new InputSource(new FileInputStream(file));
                    source.setSystemId(file.toURL().toString());
                }
            }
        }
        catch (FileNotFoundException | MalformedURLException iOException) {
            // empty catch block
        }
        if (source == null) {
            return new InputSource(new StringReader(xmlreference));
        }
        return source;
    }

    public static StreamSource getStreamSource(String xmlreference) {
        if (XmlProcessor.startsWithXMLCharacter(xmlreference) || xmlreference.length() > 2000) {
            boolean allowFilePaths = Boolean.getBoolean(ALLOW_PATH_CHARACTERS);
            if (!allowFilePaths && (xmlreference.contains("/") || xmlreference.contains("\\"))) {
                throw new XmlFilePathException();
            }
            return new StreamSource(new StringReader(xmlreference));
        }
        InputStream stream = XmlProcessor.getXMLInputStream(xmlreference);
        if (stream != null) {
            return new StreamSource(stream);
        }
        return new StreamSource(new StringReader(xmlreference));
    }

    private static File getFile(final String str) {
        if (System.getSecurityManager() == null) {
            return XmlProcessor._getFile(str);
        }
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                return XmlProcessor._getFile(str);
            }
        });
    }

    private static File _getFile(String str) {
        try {
            File file = new File(str);
            if (file.isFile()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean startsWithXMLCharacter(String xmlContent) {
        block4: for (int i = 0; i < xmlContent.length(); ++i) {
            switch (xmlContent.charAt(i)) {
                case '<': {
                    return true;
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public static XmlNodeList parse(String xmlStr, boolean caseSensitive, String Schema2) {
        return XmlValidator.parse(xmlStr, caseSensitive, Schema2);
    }

    public static XmlNodeList parse(String xmlStr, boolean caseSensitive, String Schema2, Map xmlParserOptions) {
        return XmlValidator.parse(xmlStr, caseSensitive, Schema2, xmlParserOptions);
    }

    public static String transform(String xmlStr, String xslStr, Map parameters, boolean useXSLT2) {
        boolean allowXXE = XmlProcessor.getAllowXXE(parameters);
        if (!allowXXE) {
            XmlValidator.isWellFormed(xmlStr, parameters);
        }
        StringReader xmlReader = new StringReader(xmlStr);
        StreamSource xmlSource = new StreamSource(xmlReader);
        return XmlProcessor.transform(xmlSource, xslStr, parameters, useXSLT2);
    }

    public static String transform(Node xmlNode, String xslStr, Map parameters, boolean useXSLT2) {
        return XmlProcessor.transform(new DOMSource(xmlNode), xslStr, parameters, useXSLT2);
    }

    private static String transform(final Source xmlSource, final String xslStr, final Map parameters, final boolean useXSLT2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return XmlProcessor.doTransform(xmlSource, xslStr, parameters, useXSLT2);
            }
        });
    }

    private static String doTransform(Source xmlSource, String xslStr, Map params, boolean useXSLT2) {
        StringWriter resultWriter = new StringWriter();
        try {
            XsltTransformer transformer;
            if (useXSLT2 && !overrideUseXSLT2) {
                XsltCompiler comp = XmlProcessor.getProcessor().newXsltCompiler();
                String basePath = null;
                File xslSource = new File(xslStr);
                if (xslSource.isFile()) {
                    basePath = xslSource.getParentFile().getAbsolutePath();
                }
                XMLURIResolver uriResolver = new XMLURIResolver(basePath);
                comp.setURIResolver((URIResolver)uriResolver);
                XsltExecutable expr = comp.compile((Source)XmlProcessor.getStreamSource(xslStr));
                Serializer serializer = XmlProcessor.getProcessor().newSerializer((Writer)resultWriter);
                transformer = expr.load();
                XdmNode convertedSource = XmlProcessor.getProcessor().newDocumentBuilder().build(xmlSource);
                transformer.setInitialContextNode(convertedSource);
                transformer.setDestination((Destination)serializer);
                transformer.setURIResolver((URIResolver)uriResolver);
                transformer.getUnderlyingController().setRecoveryPolicy(0);
                if (params != null) {
                    ParamUtil.setXsltParams(transformer, params);
                }
            } else {
                return XmlProcessor.doXSLTT1ransform(resultWriter, xmlSource, xslStr, params);
            }
            transformer.transform();
            return resultWriter.toString();
        }
        catch (Exception e) {
            throw new XmlProcessException("Transforming", e.getLocalizedMessage());
        }
    }

    private static String doXSLTT1ransform(StringWriter resultWriter, Source xmlSource, String xslStr, Map params) {
        TransformerFactory tFactory;
        try {
            tFactory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new XmlConfigurationException("TransformerFactory", transformerFactoryConfigurationError.getMessage());
        }
        try {
            StreamSource xslSource = null;
            InputStream stream = XmlProcessor.getXMLInputStream(xslStr);
            if (stream != null) {
                xslSource = new StreamSource(stream);
                tFactory.setURIResolver(new XmlTransformResolver(stream, xslStr));
            } else {
                StringReader reader = new StringReader(xslStr);
                xslSource = new StreamSource(reader);
                tFactory.setURIResolver(new XmlTransformResolver(reader, xslStr));
            }
            Transformer transformer = tFactory.newTransformer(xslSource);
            if (params != null) {
                Iterator itr = params.keySet().iterator();
                while (itr.hasNext()) {
                    String key = itr.next().toString();
                    transformer.setParameter(key, params.get(key));
                }
            }
            StreamResult result = new StreamResult(resultWriter);
            transformer.transform(xmlSource, result);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XmlFactoryConfigurationException("Transformer");
        }
        catch (TransformerConfigurationException e) {
            throw new XmlConfigurationException("Transformer", e.getMessage());
        }
        catch (TransformerException e) {
            throw new XmlProcessException("Transforming", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        return resultWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Processor getProcessor() {
        if (processor != null) return processor;
        Class<XmlProcessor> clazz = XmlProcessor.class;
        synchronized (XmlProcessor.class) {
            if (processor != null) return processor;
            processor = new Processor(false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return processor;
        }
    }

    public static Object search(Object xmlList, String xPath, Map params) {
        Object result = null;
        XdmValue xpathReturnObj = null;
        XmlNodeList xNodeList = null;
        if (xmlList instanceof String) {
            boolean allowXXE = XmlProcessor.getAllowXXE(params);
            if (!allowXXE) {
                XmlValidator.isWellFormed((String)xmlList, params);
            }
            xNodeList = Cast._Xml(xmlList);
        } else if (xmlList instanceof XmlNodeList) {
            xNodeList = (XmlNodeList)xmlList;
        } else if (xmlList instanceof Node) {
            xNodeList = Cast._Xml(xmlList);
        }
        xpathReturnObj = XmlProcessor.doSearch(xNodeList, xPath, params);
        if (xpathReturnObj == null) {
            return "";
        }
        if (xpathReturnObj instanceof XdmEmptySequence) {
            result = new Array();
        } else if (xpathReturnObj.size() > 1) {
            XdmSequenceIterator itr = xpathReturnObj.iterator();
            Array nodeArray = new Array();
            XmlNodeList nodeList = null;
            while (itr.hasNext()) {
                Node node;
                XdmItem item = itr.next();
                if (!(item instanceof XdmNode) || (node = XmlProcessor.getNode((XdmNode)item)) == null) continue;
                nodeList = new XmlNodeList(XmlProcessor.getNode((XdmNode)item), xNodeList.isCaseSensitive);
                ArrayUtil.ArrayAppend(nodeArray, nodeList);
            }
            result = nodeArray;
        } else {
            XdmItem item = xpathReturnObj.itemAt(0);
            if (item.isAtomicValue()) {
                if (item.getUnderlyingValue() instanceof BooleanValue) {
                    result = ((BooleanValue)item.getUnderlyingValue()).getBooleanValue();
                } else if (item.getUnderlyingValue() instanceof NumericValue) {
                    result = new Double(((NumericValue)item.getUnderlyingValue()).getStringValue());
                } else if (item.getUnderlyingValue() instanceof StringValue) {
                    result = item.getUnderlyingValue().getStringValue();
                }
            } else if (item instanceof XdmNode) {
                Array nodeArray = new Array();
                XmlNodeList nList = new XmlNodeList(XmlProcessor.getNode((XdmNode)item), xNodeList.isCaseSensitive);
                ArrayUtil.ArrayAppend(nodeArray, nList);
                result = nodeArray;
            } else {
                throw new XmlSearchException(xPath);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XdmValue doSearch(XmlNodeList xmlList, String xPath, Map params) throws XmlSearchException {
        try {
            if (xmlList.size() == 1) {
                XPathCompiler xpath = XmlProcessor.getProcessor().newXPathCompiler();
                if (params != null) {
                    ParamUtil.declareVariables(xpath, params);
                }
                StaticContext staticContext = xpath.getUnderlyingStaticContext();
                final Node rootNode = xmlList.getNode(0);
                if (staticContext instanceof XPathStaticContext) {
                    ((XPathStaticContext)staticContext).setNamespaceResolver(new NamespaceResolver(){

                        public Iterator<String> iteratePrefixes() {
                            ArrayList<String> prefixes = new ArrayList<String>();
                            String prefix = null;
                            prefix = rootNode.getPrefix();
                            prefixes.add(prefix == null ? "" : prefix);
                            return prefixes.iterator();
                        }

                        public String getURIForPrefix(String prefix, boolean useDefault) {
                            try {
                                if (rootNode != null) {
                                    return rootNode.lookupNamespaceURI(prefix);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            return null;
                        }
                    });
                }
                XPathExecutable executableXpath = xpath.compile(xPath);
                DOMSource domSource = new DOMSource(rootNode);
                net.sf.saxon.s9api.DocumentBuilder dBuilder = XmlProcessor.getProcessor().newDocumentBuilder();
                XdmNode wrappedNode = dBuilder.wrap((Object)domSource);
                XPathSelector selector = executableXpath.load();
                if (params != null) {
                    ParamUtil.setXpathParams(selector, params);
                }
                selector.setContextItem((XdmItem)wrappedNode);
                Node node = XmlProcessor.getDocument(rootNode);
                synchronized (node) {
                    return selector.evaluate();
                }
            }
            throw new XmlSearchException(xPath);
        }
        catch (Exception e) {
            throw new XmlSearchException(e.getMessage());
        }
    }

    private static Node getDocument(Node node) {
        Document doc = node.getOwnerDocument();
        if (doc != null) {
            return doc;
        }
        return node;
    }

    private static Node getNode(XdmNode xdmNode) {
        if (xdmNode.getExternalNode() instanceof Node) {
            return (Node)xdmNode.getExternalNode();
        }
        return null;
    }

    static {
        int temp;
        allowExternalEntities = true;
        xmlSecurityManager = new SecurityManager();
        overrideUseXSLT2 = false;
        domDefaultAttributes = new Hashtable();
        domDefaultValidationAttributes = new Hashtable();
        String property = System.getProperty("coldfusion.xml.usexslt1");
        if (property != null) {
            overrideUseXSLT2 = Cast._boolean(property, false);
        }
        if ((property = System.getProperty(ALLOW_EXTERNAL_ENTITIES)) != null) {
            allowExternalEntities = Cast._boolean(property, true);
        }
        if ((temp = Integer.getInteger(ENTITY_EXPANSION_LIMIT, xmlSecurityManager.getEntityExpansionLimit()).intValue()) > 0) {
            xmlSecurityManager.setEntityExpansionLimit(temp);
        }
        domDefaultAttributes.put("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", Boolean.FALSE);
        domDefaultAttributes.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        domDefaultAttributes.put(SECURITY_MANAGER_FEATURE, xmlSecurityManager);
        domDefaultValidationAttributes.put("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
        domDefaultValidationAttributes.put("http://apache.org/xml/features/validation/schema-full-checking", Boolean.TRUE);
        domDefaultValidationAttributes.put(SECURITY_MANAGER_FEATURE, xmlSecurityManager);
    }

    public static class XmlFilePathException
    extends ExpressionException {
    }

    public static class XMLURIResolver
    implements URIResolver {
        private String basePath;

        public XMLURIResolver(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            InputStream stream = null;
            if (base != null && !base.trim().equals("")) {
                stream = XmlProcessor.getXMLInputStream(base);
            } else if (this.basePath != null) {
                stream = XmlProcessor.getXMLInputStream(this.basePath + File.separator + href);
            }
            if (stream == null && (stream = XmlProcessor.getXMLInputStream(href)) == null) {
                return new StreamSource(new StringReader(href));
            }
            return new StreamSource(stream);
        }
    }

    public static class XmlSearchException
    extends ExpressionException {
        public String xpath;

        public XmlSearchException(String xpath) {
            this.xpath = xpath;
        }
    }
}

