/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.util.FastHashtable;
import coldfusion.xml.XmlEntityResolver;
import coldfusion.xml.XmlFactoryConfigurationException;
import coldfusion.xml.XmlIOException;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlProcessException;
import coldfusion.xml.XmlProcessor;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.DocBuilderHelper;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlValidator
extends XmlEntityResolver {
    private List<String> warnings = null;
    private List<String> errors = null;
    private List<String> fatalErrors = null;
    private boolean ParseStatus = true;
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final ThreadLocal<SAXParserFactory> saxTL = new ThreadLocal();
    private static final ThreadLocal<SAXParser> saxParserTL = new ThreadLocal();

    public XmlValidator() {
    }

    public XmlValidator(String XmlSchema) {
        super(XmlSchema);
    }

    @Override
    public void warning(SAXParseException ex) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage() + " ");
    }

    @Override
    public void error(SAXParseException ex) {
        this.ParseStatus = false;
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage() + " ");
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.ParseStatus = false;
        if (this.fatalErrors == null) {
            this.fatalErrors = new ArrayList<String>();
        }
        this.fatalErrors.add("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage() + " ");
    }

    private String getLocationString(SAXParseException ex) {
        StringBuilder str = new StringBuilder();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public Map getValidationResult() {
        FastHashtable result = new FastHashtable();
        result.put("warnings", this.warnings == null ? EMPTY_ARRAY : this.warnings.toArray());
        result.put("errors", this.errors == null ? EMPTY_ARRAY : this.errors.toArray());
        result.put("fatalerrors", this.fatalErrors == null ? EMPTY_ARRAY : this.fatalErrors.toArray());
        result.put("status", this.ParseStatus);
        return result;
    }

    public void resetErrors() {
        if (this.warnings != null) {
            this.warnings.clear();
        }
        if (this.errors != null) {
            this.errors.clear();
        }
        if (this.fatalErrors != null) {
            this.fatalErrors.clear();
        }
        this.ParseStatus = true;
    }

    public boolean getValidationStatus() {
        return this.ParseStatus;
    }

    public static Map doValidation(String xmlStr) {
        return XmlValidator.doValidation(xmlStr, "", true, null);
    }

    public static Map doValidation(String xmlStr, String xmlSchema) {
        return XmlValidator.doValidation(xmlStr, xmlSchema, null);
    }

    public static Map doValidation(String xmlStr, String xmlSchema, Map xmlParserOptions) {
        Boolean status;
        Map resultMap = XmlValidator.doValidation(xmlStr, xmlSchema, false, xmlParserOptions);
        if (resultMap.containsKey("status") && !(status = (Boolean)resultMap.get("status")).booleanValue()) {
            resultMap = XmlValidator.doValidation(xmlStr, xmlSchema, true, xmlParserOptions);
        }
        return resultMap;
    }

    static Map doValidation(String xmlStr, String xmlSchema, boolean validateNamespace, Map xmlParserOptions) {
        InputSource input = XmlProcessor.getInputSource(xmlStr);
        XmlValidator validate = new XmlValidator(xmlSchema);
        try {
            XMLReader parser = XmlValidator.getSAXParser().getXMLReader();
            parser.setContentHandler(validate);
            parser.setErrorHandler(validate);
            parser.setEntityResolver(validate);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            if (validateNamespace) {
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            if (!validateNamespace) {
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", xmlSchema);
            } else if (!xmlSchema.isEmpty()) {
                parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", xmlSchema);
            }
            XmlProcessor.addParserPropertiesFromOptions(parser, validate, xmlParserOptions);
            parser.parse(input);
        }
        catch (SAXException parser) {
        }
        catch (IOException | ParserConfigurationException ie) {
            throw new XmlIOException(ie);
        }
        return validate.getValidationResult();
    }

    public static boolean isWellFormed(String xmlStr) {
        return XmlValidator.isWellFormed(xmlStr, null);
    }

    public static boolean isWellFormed(String xmlStr, Map xmlParserOptions) {
        StringReader reader = new StringReader(xmlStr);
        boolean result = true;
        XmlValidator validate = new XmlValidator();
        try {
            XMLReader parser = XmlValidator.getSAXParser().getXMLReader();
            parser.setContentHandler(validate);
            parser.setErrorHandler(validate);
            parser.setEntityResolver(validate);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/validation/schema", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            XmlProcessor.addParserPropertiesFromOptions(parser, validate, xmlParserOptions);
            parser.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            result = false;
        }
        catch (IOException | ParserConfigurationException ie) {
            throw new XmlIOException(ie);
        }
        return result;
    }

    private String getPrimaryErrorMessage() {
        StringBuilder errorMessage;
        block3: {
            block2: {
                errorMessage = new StringBuilder();
                if (this.fatalErrors == null || this.fatalErrors.size() <= 0) break block2;
                for (int i = 0; i < this.fatalErrors.size(); ++i) {
                    errorMessage.append(this.fatalErrors.get(i));
                }
                break block3;
            }
            if (this.errors == null) break block3;
            for (int i = 0; i < this.errors.size(); ++i) {
                errorMessage.append(this.errors.get(i));
            }
        }
        return errorMessage.toString();
    }

    public static SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        SAXParser saxParser = saxParserTL.get();
        if (saxParser == null) {
            saxParser = XmlValidator.getSAXFactory().newSAXParser();
            saxParserTL.set(saxParser);
        } else {
            saxParser.reset();
            saxParser.getParser().setDocumentHandler(null);
        }
        return saxParser;
    }

    private static SAXParserFactory getSAXFactory() {
        SAXParserFactory saxFactory = saxTL.get();
        if (saxFactory == null) {
            saxFactory = new SAXParserFactoryImpl();
            saxTL.set(saxFactory);
        }
        return saxFactory;
    }

    public static final XmlNodeList parse(String xmlStr, boolean caseSensitive, String Schema2) {
        return XmlValidator.parse(xmlStr, caseSensitive, Schema2, null);
    }

    public static final XmlNodeList parse(String xmlStr, boolean caseSensitive, String Schema2, Map xmlParserOptions) {
        InputSource input = XmlProcessor.getInputSource(xmlStr);
        XmlValidator validator = new XmlValidator(Schema2);
        Document doc = null;
        try {
            DocumentBuilder builder;
            if (xmlParserOptions == null) {
                builder = DocBuilderHelper.getDocumentBuilder(XmlProcessor.domDefaultValidationAttributes, null, true);
            } else {
                SecurityManager manager;
                Hashtable attributes = XmlProcessor.domDefaultValidationAttributes;
                boolean allowXXE = XmlProcessor.getAllowXXE(xmlParserOptions);
                if (!allowXXE) {
                    validator.setAllowXXE(false);
                }
                if ((manager = XmlProcessor.getXMLSecurityManager(xmlParserOptions)) != XmlProcessor.xmlSecurityManager) {
                    attributes = (Hashtable)attributes.clone();
                    attributes.put("http://apache.org/xml/properties/security-manager", manager);
                }
                builder = DocBuilderHelper.getDocumentBuilder(attributes, null, true);
            }
            builder.setErrorHandler(validator);
            builder.setEntityResolver(validator);
            doc = builder.parse(input);
        }
        catch (FactoryConfigurationError e) {
            throw new XmlFactoryConfigurationException("Parser");
        }
        catch (SAXException e) {
            throw new XmlProcessException("Parsing", e.getMessage());
        }
        catch (IOException e) {
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        if (validator.getValidationStatus()) {
            return new XmlNodeList(doc, caseSensitive);
        }
        throw new XmlProcessException("parsing", validator.getPrimaryErrorMessage());
    }
}

