/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.filter.ApplicationFilter;
import coldfusion.filter.AxisFilter;
import coldfusion.filter.BrowserDebugFilter;
import coldfusion.filter.BrowserFilter;
import coldfusion.filter.CFCFlushFilter;
import coldfusion.filter.ClientScopePersistenceFilter;
import coldfusion.filter.ComponentFilter;
import coldfusion.filter.DatasourceFilter;
import coldfusion.filter.DreamweaverDebugFilter;
import coldfusion.filter.ExceptionFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.GlobalsFilter;
import coldfusion.filter.IPFilterUtils;
import coldfusion.filter.LicenseFilter;
import coldfusion.filter.MonitoringFilter;
import coldfusion.filter.NoCacheFilter;
import coldfusion.filter.PathFilter;
import coldfusion.filter.RequestMonitorFilter;
import coldfusion.license.LicenseManager;
import coldfusion.runtime.RequestLifecycleListener;
import coldfusion.runtime.ServletConfigWrapper;
import coldfusion.server.DebuggingService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.XmlRpcService;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.DynamicSemaphore;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class CFCServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String WSDL = "wsdl";
    private static final String WSDL2 = "wsdl2";
    private static CFCServlet cfcServlet;
    private DynamicSemaphore cfcGate;
    private DynamicSemaphore webserviceGate;
    private int cfcTimeouts = 0;
    private int wsTimeouts = 0;
    public Object cfAxisServlet;
    public Object cfAxis2Servlet;
    private static final Object serveltInitializedMutex;

    public static CFCServlet getCFCServlet() {
        return cfcServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init((ServletConfig)new ServletConfigWrapper(config));
        cfcServlet = this;
        ServletContext application = this.getServletConfig().getServletContext();
        String web_inf = application.getRealPath("/WEB-INF");
        if (web_inf == null) {
            throw new ServletException(RB.getString((Object)this, "CFCServlet.NoWEBINF"));
        }
        File dir = new File(web_inf + File.separator + "cfc-skeletons");
        if (ServerlessUtil.isLambdaEnv()) {
            dir = new File("/tmp/cfusion/wwwroot/WEB-INF/cfc-skeletons");
        }
        dir.mkdirs();
        application.setAttribute("coldfusion.xml.rpc.CFCServlet.outputdir", (Object)dir.getPath());
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService();
        if (xmlRpcService != null) {
            this.cfAxisServlet = xmlRpcService.initCFAxisServlet(config);
            this.cfAxis2Servlet = xmlRpcService.initCFAxis2Servlet(config);
        }
        if (!ServiceFactory.getLicenseService().isStandard()) {
            RuntimeService runtime = ServiceFactory.getRuntimeService();
            this.cfcGate = new DynamicSemaphore(runtime.getQueueLimit("cfc"), true);
            this.webserviceGate = new DynamicSemaphore(runtime.getQueueLimit("webservice"), true);
        }
        Object object = serveltInitializedMutex;
        synchronized (object) {
            serveltInitializedMutex.notifyAll();
        }
    }

    private FusionContext getFusionContext(ServletRequest request, ServletResponse response) {
        FusionContext context = new FusionContext();
        context.setServletObjects((Servlet)this, request, response);
        context.setIsRemoting(true);
        return context;
    }

    private void invoke(FusionFilter filter, FusionContext context, boolean isWebService) throws ServletException, IOException {
        FusionContext oldCtx = FusionContext.setCurrent(context);
        boolean lockAcquired = false;
        try {
            lockAcquired = this.lock(isWebService);
            filter.invoke(context);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (TimeoutException ex) {
            this.processTimeout(isWebService, context.getResponse());
        }
        catch (Throwable ex) {
            throw new ServletException(ex);
        }
        finally {
            if (lockAcquired) {
                if (isWebService) {
                    this.webserviceGate.release();
                } else {
                    this.cfcGate.release();
                }
            }
            FusionContext.setCurrent(oldCtx);
            RequestLifecycleListener.onRequestEnd(2, null);
        }
    }

    private boolean lock(boolean isWebservice) throws InterruptedException, TimeoutException {
        if (ServiceFactory.getLicenseService().isStandard()) {
            return false;
        }
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        if (this.cfcGate == null || this.webserviceGate == null) {
            this.cfcGate = new DynamicSemaphore(runtime.getQueueLimit("cfc"), true);
            this.webserviceGate = new DynamicSemaphore(runtime.getQueueLimit("webservice"), true);
        }
        DynamicSemaphore gate = isWebservice ? this.webserviceGate : this.cfcGate;
        long timeout = -1L;
        if (runtime.timeoutRequests()) {
            timeout = runtime.getQueueTimeout();
        }
        if (timeout <= 0L) {
            gate.acquire();
        } else if (!gate.tryAcquire(timeout, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        return true;
    }

    private void processTimeout(boolean isWebservice, HttpServletResponse response) {
        String msg;
        ServiceFactory.getMetricsService().updateMetric("errorCount", 1);
        if (isWebservice) {
            ++this.wsTimeouts;
            msg = RB.getString((Object)this, "CFCServet.webserviceTimeout");
        } else {
            ++this.cfcTimeouts;
            msg = RB.getString((Object)this, "CFCServet.cfcTimeout");
        }
        try {
            response.sendError(503, msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doAxisGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
        xmlRpcService.doAxisGet(this.cfAxisServlet, request, response);
    }

    public void doAxis2Get(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
        xmlRpcService.doAxis2Get(this.cfAxis2Servlet, request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isWebService;
        String query = Utils.getQueryString(request);
        boolean bl = isWebService = WSDL.equalsIgnoreCase(query) || WSDL2.equalsIgnoreCase(query);
        if (ServerlessUtil.isLambdaEnv()) {
            isWebService = query.equalsIgnoreCase("wsdl=") || query.equalsIgnoreCase("wsdl2=");
        }
        FusionFilter filter = isWebService ? this.getWSDLFilterChain() : this.getCFCFilterChain((ServletRequest)request);
        FusionContext fusionContext = this.getFusionContext((ServletRequest)request, (ServletResponse)response);
        if (!isWebService) {
            IPFilterUtils.checkAdminAccess(fusionContext.getRequest());
        }
        this.invoke(filter, fusionContext, isWebService);
    }

    public void doAxisPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
        xmlRpcService.doAxisPost(this.cfAxisServlet, request, response);
    }

    public void doAxis2Post(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
        xmlRpcService.doAxis2Post(this.cfAxis2Servlet, request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isWebService;
        String query = Utils.getQueryString(request);
        boolean bl = isWebService = WSDL.equalsIgnoreCase(query) || WSDL2.equalsIgnoreCase(query) || request.getHeader("SOAPAction") != null || null != request.getHeader("Content-Type") && request.getHeader("Content-Type").contains("application/soap+xml");
        if (ServerlessUtil.isLambdaEnv()) {
            isWebService = isWebService || query.equalsIgnoreCase("wsdl=") || query.equalsIgnoreCase("wsdl2=");
        }
        FusionFilter filter = !isWebService ? this.getCFCFilterChain((ServletRequest)request) : this.getAxisFilterChain(2);
        FusionContext fusionContext = this.getFusionContext((ServletRequest)request, (ServletResponse)response);
        if (!isWebService) {
            IPFilterUtils.checkAdminAccess(fusionContext.getRequest());
        }
        this.invoke(filter, fusionContext, isWebService);
    }

    private FusionFilter getCFCFilterChain(ServletRequest request) {
        DebuggingService debuggingService;
        FusionFilter filter = new ComponentFilter();
        filter = new ApplicationFilter(filter, 3);
        if (RequestMonitorFilter.isFilterEnabled()) {
            filter = new RequestMonitorFilter(filter);
        }
        if ((debuggingService = ServiceFactory.getDebuggingService()) != null && debuggingService.isEnabled()) {
            filter = DreamweaverDebugFilter.isDreamweaver(request) ? new DreamweaverDebugFilter(filter) : new BrowserDebugFilter(filter);
        }
        filter = new MonitoringFilter(filter, "CFC REQUEST");
        filter = new PathFilter(filter, (Servlet)this);
        if (LicenseManager.isSingleIP()) {
            filter = new LicenseFilter(filter);
        }
        filter = new ExceptionFilter(filter);
        filter = new ClientScopePersistenceFilter(filter);
        filter = new BrowserFilter(filter);
        filter = new NoCacheFilter(filter);
        boolean needsFormScope = true;
        filter = new GlobalsFilter(filter, true);
        filter = new DatasourceFilter(filter);
        return filter;
    }

    private FusionFilter getAxisFilterChain(int method) {
        FusionFilter filter = new AxisFilter(this, method);
        filter = new ApplicationFilter(filter, 1);
        if (RequestMonitorFilter.isFilterEnabled()) {
            filter = new RequestMonitorFilter(filter);
        }
        filter = new MonitoringFilter(filter, "WEB SERVICE REQUEST");
        filter = new PathFilter(filter, (Servlet)this);
        if (LicenseManager.isSingleIP()) {
            filter = new LicenseFilter(filter);
        }
        filter = new ExceptionFilter(filter);
        filter = new ClientScopePersistenceFilter(filter);
        boolean needsFormScope = false;
        filter = new GlobalsFilter(filter, false);
        filter = new DatasourceFilter(filter);
        return filter;
    }

    private FusionFilter getWSDLFilterChain() {
        FusionFilter filter = new AxisFilter(this, 1);
        filter = new ApplicationFilter(filter, 2);
        filter = new PathFilter(filter, (Servlet)this);
        if (LicenseManager.isSingleIP()) {
            filter = new LicenseFilter(filter);
        }
        filter = new ExceptionFilter(filter);
        filter = new ClientScopePersistenceFilter(filter);
        filter = new CFCFlushFilter(filter);
        boolean needsFormScope = false;
        filter = new GlobalsFilter(filter, false);
        filter = new DatasourceFilter(filter);
        return filter;
    }

    public boolean isDevelopment() {
        DebuggingService ds = ServiceFactory.getDebuggingService();
        if (ds != null) {
            return ds.isRobustEnabled();
        }
        return false;
    }

    public String getServletInfo() {
        return "CFC";
    }

    protected void setCFCRequestLimit(int limit) {
        if (this.cfcGate != null) {
            this.cfcGate.setLimit(limit);
        }
    }

    public int getCFCRequestLimit() {
        if (this.cfcGate == null) {
            return 0;
        }
        return this.cfcGate.getLimit();
    }

    public int getCFCRequestsQueued() {
        if (this.cfcGate == null) {
            return 0;
        }
        return this.cfcGate.getQueueLength();
    }

    public int getCFCRequestsRunning() {
        if (this.cfcGate == null) {
            return 0;
        }
        return this.cfcGate.getLimit() - this.cfcGate.availablePermits();
    }

    public int getCFCRequestsTimedout() {
        if (this.cfcGate == null) {
            return 0;
        }
        return this.cfcTimeouts;
    }

    protected void setWebServiceRequestLimit(int limit) {
        if (this.webserviceGate != null) {
            this.webserviceGate.setLimit(limit);
        }
    }

    public int getWebServiceRequestLimit() {
        if (this.webserviceGate == null) {
            return 0;
        }
        return this.webserviceGate.getLimit();
    }

    public int getWebServiceRequestsQueued() {
        if (this.webserviceGate == null) {
            return 0;
        }
        return this.webserviceGate.getQueueLength();
    }

    public int getWebServiceRequestsRunning() {
        if (this.webserviceGate == null) {
            return 0;
        }
        return this.webserviceGate.getLimit() - this.webserviceGate.availablePermits();
    }

    public int getWebServiceRequestsTimedout() {
        if (this.webserviceGate == null) {
            return 0;
        }
        return this.wsTimeouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitTillServletInitialized() {
        if (cfcServlet == null) {
            Object object = serveltInitializedMutex;
            synchronized (object) {
                try {
                    serveltInitializedMutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (cfcServlet == null) {
                CFCServlet.waitTillServletInitialized();
            }
        }
    }

    static {
        serveltInitializedMutex = new Object();
    }

    private class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

