/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.server.ServiceFactory;
import coldfusion.server.XmlRpcService;
import coldfusion.util.FastHashtable;
import java.io.IOException;
import java.lang.reflect.Method;

public class MethodParam {
    private Class c;
    private Object preader;
    private FastHashtable names = new FastHashtable();
    private FastHashtable types = new FastHashtable();

    public MethodParam(Class c) throws IOException {
        this.c = c;
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService();
        if (xmlRpcService != null) {
            this.preader = xmlRpcService.getParamReaderInstance(c);
        }
    }

    public String[] getParamNames(String method, int size) {
        Method m;
        String[] param_names = (String[])this.names.get(method + " " + size);
        if (param_names == null && (m = this.findMethod(method, size)) != null) {
            XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService();
            String[] paramNames = null;
            if (xmlRpcService != null && size != 0) {
                paramNames = xmlRpcService.getParameterNames(this.preader, m);
            }
            param_names = size == 0 ? new String[]{} : paramNames;
            this.names.put(method + " " + size, (Object)param_names);
        }
        return param_names;
    }

    public Class[] getParamTypes(String method, int size) {
        Method m;
        Class[] classes = (Class[])this.types.get(method + " " + size);
        if (classes == null && (m = this.findMethod(method, size)) != null) {
            classes = m.getParameterTypes();
            this.types.put(method + " " + size, (Object)classes);
        }
        return classes;
    }

    private Method findMethod(String method, int size) {
        Method[] methods = this.c.getMethods();
        for (int i = 0; methods != null && i < methods.length; ++i) {
            Method m = methods[i];
            String name = m.getName();
            Class<?>[] classes = m.getParameterTypes();
            if (!name.equalsIgnoreCase(method) || size != -1 && classes.length != size) continue;
            return m;
        }
        return null;
    }
}

