/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.security.BasicPolicy;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.server.XmlRpcService;
import coldfusion.util.FastHashtable;
import coldfusion.util.SoftCache;
import coldfusion.util.SoftPool;
import coldfusion.xml.rpc.BaseSkeletonClassLoader;
import coldfusion.xml.rpc.CFComponentSkeleton;
import jakarta.servlet.http.HttpServletRequest;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMapping;

public class SkeletonClassLoader
extends BaseSkeletonClassLoader {
    private TypeMapping tm;
    private static final FastHashtable typeMappings = new FastHashtable();
    private static final SoftCache skel_cache;
    private static BasicPolicy policy;

    public SkeletonClassLoader(String outputdir, NeoPageContext pageContext) {
        super(outputdir, pageContext);
    }

    public static final boolean isCFC(String type) {
        if (type == null) {
            return false;
        }
        if ("void".equalsIgnoreCase(type)) {
            return false;
        }
        if (type.equals(SkeletonClassLoader.convertType(type))) {
            if (type.endsWith("[]")) {
                return false;
            }
            return !type.startsWith("query[") || !type.endsWith("]");
        }
        return false;
    }

    public static final boolean isCFCArray(String type) {
        if (type == null) {
            return false;
        }
        if ("void".equalsIgnoreCase(type)) {
            return false;
        }
        if (type.equals(SkeletonClassLoader.convertType(type))) {
            if (type.endsWith("[]")) {
                return true;
            }
            if (type.startsWith("query[") && type.endsWith("]")) {
                return false;
            }
            return false;
        }
        return false;
    }

    public static final boolean isQuery(String type) {
        if (type == null) {
            return false;
        }
        if ("void".equalsIgnoreCase(type)) {
            return false;
        }
        if (type.equals(SkeletonClassLoader.convertType(type))) {
            if (type.endsWith("[]")) {
                return false;
            }
            return type.startsWith("query[") && type.endsWith("]");
        }
        return false;
    }

    public static final String convertType(String type) {
        String val = (String)typeMappings.get(type);
        return val == null ? type : val;
    }

    private static QName getQName(String className) {
        int index = className.lastIndexOf(".");
        String name = index == -1 ? className : className.substring(index + 1);
        XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
        if (xmlRpcService != null) {
            return new QName(xmlRpcService.makeNamespace(className), name);
        }
        return null;
    }

    public static final CFComponentSkeleton newInstance(String path, NeoPageContext pageContext, Object msgContext) throws Throwable {
        SkeletonClassLoader loader = new SkeletonClassLoader((String)pageContext.getServletContext().getAttribute("coldfusion.xml.rpc.CFCServlet.outputdir"), pageContext);
        return SkeletonClassLoader.newInstance(path, pageContext, msgContext, loader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFComponentSkeleton newInstance(String path, NeoPageContext pageContext, Object msgContext, ClassLoader loader, TemplateProxy proxy) throws Throwable {
        if (policy == null && (policy = ServiceFactory.getSecurityService().getBasicPolicy()) != null) {
            policy.setClassCache(skel_cache);
        }
        try {
            boolean useCache = ServiceFactory.getRuntimeService().isTrustedCache();
            CFComponentSkeleton skel = null;
            SoftPool pool = null;
            if (useCache) {
                String context_path = ((HttpServletRequest)pageContext.getRequest()).getContextPath();
                SoftCache softCache = skel_cache;
                synchronized (softCache) {
                    pool = (SoftPool)skel_cache.get(context_path + path);
                    skel = (CFComponentSkeleton)pool.checkOut();
                }
            } else {
                skel_cache.clear();
            }
            if (null == proxy) {
                proxy = TemplateProxyFactory.resolvePath(path, pageContext);
            }
            if (skel == null) {
                Class clazz = SkeletonClassLoader.loadSkeleton(loader, proxy, pageContext, msgContext);
                skel = (CFComponentSkeleton)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            skel.__setTemplateProxy(proxy);
            skel.__setPageContext(pageContext);
            skel.__setPool(pool);
            return skel;
        }
        catch (Throwable t) {
            while (t instanceof ClassNotFoundException && ((ClassNotFoundException)t).getException() != null) {
                t = ((ClassNotFoundException)t).getException();
            }
            if (t instanceof CfJspPage.NoSuchTemplateException) {
                throw new UnresolvedCFCDataTypeException(((CfJspPage.NoSuchTemplateException)t).missingFileName);
            }
            throw t;
        }
    }

    public static final CFComponentSkeleton newInstance(String path, NeoPageContext pageContext) throws Throwable {
        return SkeletonClassLoader.newInstance(path, pageContext, null);
    }

    private static Class loadSkeleton(ClassLoader loader, TemplateProxy proxy, NeoPageContext pageContext, Object msgContext) throws Throwable {
        AttributeCollection metadata = (AttributeCollection)proxy.getMetadata();
        TypeMapping tm = null;
        if (null != msgContext) {
            XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
            tm = xmlRpcService.getTypeMapping(metadata, msgContext);
        }
        if (loader instanceof SkeletonClassLoader) {
            ((SkeletonClassLoader)loader).setTm(tm);
        }
        return loader.loadClass((String)metadata.get("name"));
    }

    protected static final String getSafeJavaName(String p) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(p, ".");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            String x;
            if (!first) {
                buf.append('.');
            }
            if (!Character.isJavaIdentifierStart((x = tok.nextToken()).charAt(0))) {
                buf.append("_");
            }
            char[] c = x.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                char ch = c[i];
                if (!Character.isJavaIdentifierPart(ch)) continue;
                buf.append(ch);
            }
            first = false;
        }
        if (SystemInfo.isWindows()) {
            return SkeletonClassLoader.normalizePackageName(buf.toString());
        }
        return buf.toString();
    }

    private static final String normalizePackageName(String p) {
        int dotIndex = p.lastIndexOf(46);
        if (dotIndex == -1) {
            return p;
        }
        String pckage = p.substring(0, dotIndex + 1);
        return pckage.toLowerCase() + SkeletonClassLoader.capitalizeFirstChar(p.substring(dotIndex + 1));
    }

    public static String capitalizeFirstChar(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char start = name.charAt(0);
        if (Character.isLowerCase(start)) {
            start = Character.toUpperCase(start);
            return start + name.substring(1);
        }
        return name;
    }

    @Override
    protected Class findClass(String className) throws ClassNotFoundException {
        Class clazz = super.findClass(className);
        if (this.isClassNotFound(className)) {
            XmlRpcService xmlRpcService;
            String javaName = SkeletonClassLoader.getSafeJavaName(className);
            QName qn = SkeletonClassLoader.getQName(javaName);
            if (this.tm != null && (xmlRpcService = ServiceFactory.getXmlRpcService(true)) != null) {
                xmlRpcService.register(this.tm, clazz, qn);
            }
        }
        return clazz;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = super.loadClass(name, resolve);
        if ("coldfusion.xml.rpc.CFComponentSkeleton".equals(name)) {
            QName qn = SkeletonClassLoader.getQName(name);
            if (this.tm != null) {
                try {
                    XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService(true);
                    if (xmlRpcService != null) {
                        xmlRpcService.register(this.tm, clazz, qn);
                    }
                }
                catch (JAXRPCException jAXRPCException) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    public void setTm(TypeMapping tm) {
        this.tm = tm;
    }

    static {
        typeMappings.put("string", (Object)"java.lang.String");
        typeMappings.put("uuid", (Object)"java.lang.String");
        typeMappings.put("guid", (Object)"java.lang.String");
        typeMappings.put("query", (Object)"coldfusion.xml.rpc.QueryBean");
        typeMappings.put("documentquery", (Object)"coldfusion.xml.rpc.DocumentQueryBean");
        typeMappings.put("void", (Object)"void");
        typeMappings.put("numeric", (Object)"java.lang.Double");
        typeMappings.put("boolean", (Object)"java.lang.Boolean");
        typeMappings.put("date", (Object)"java.util.Calendar");
        typeMappings.put("any", (Object)"java.lang.Object");
        typeMappings.put("array", (Object)"java.lang.Object[]");
        typeMappings.put("binary", (Object)"byte[]");
        typeMappings.put("struct", (Object)"java.util.Map");
        typeMappings.put("xml", (Object)"org.w3c.dom.Document");
        skel_cache = new SoftCache(){

            @Override
            public Object fetchSerial(Object key) {
                return new SoftPool();
            }
        };
    }

    public static class UnresolvedCFCDataTypeException
    extends ApplicationException {
        public String type;

        UnresolvedCFCDataTypeException(String t) {
            this.type = t;
        }
    }
}

