/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.runtime.ApplicationException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

public class WebServiceUtil {
    private static final Map<String, String> cfcPathVsServiceName = new ConcurrentSkipListMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public static String getServiceName(String urlString) {
        String cfcFullPathName = WebServiceUtil.getCFCName(urlString);
        if (cfcPathVsServiceName.containsKey(cfcFullPathName)) {
            return cfcPathVsServiceName.get(cfcFullPathName);
        }
        String serviceName = cfcFullPathName.replaceAll("/", ".");
        cfcPathVsServiceName.put(cfcFullPathName, serviceName);
        return serviceName;
    }

    private static String getCFCName(String urlString) {
        int ipindex = urlString.indexOf("//");
        String serviceName = null;
        if (ipindex >= 0) {
            serviceName = urlString.substring(ipindex + 2, urlString.length());
            int slashIndex = serviceName.indexOf("/");
            serviceName = serviceName.substring(slashIndex + 1);
        }
        return serviceName;
    }

    public static void registerServiceName(String urlString, String serviceName) {
        String cfcFullPathName = WebServiceUtil.getCFCName(urlString);
        Set<Map.Entry<String, String>> entrySet = cfcPathVsServiceName.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!entry.getValue().equals(serviceName) || entry.getKey().equalsIgnoreCase(cfcFullPathName)) continue;
            throw new DisplayNameAlreadyExistsException(serviceName, entry.getKey());
        }
        cfcPathVsServiceName.put(cfcFullPathName, serviceName);
    }

    public static String getCFCPathForEndpoint(String serviceName) {
        Set<Map.Entry<String, String>> entrySet = cfcPathVsServiceName.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!entry.getValue().equals(serviceName)) continue;
            return entry.getKey();
        }
        return serviceName;
    }

    public static class DisplayNameAlreadyExistsException
    extends ApplicationException {
        private final String name;
        private final String url;

        DisplayNameAlreadyExistsException(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

