/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import com.oreilly.servlet.multipart.BufferedServletInputStream;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.LimitedServletInputStream;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class MultipartParser {
    private ServletInputStream in;
    private String boundary;
    private FilePart lastFilePart;
    private byte[] buf = new byte[8192];
    private static String DEFAULT_ENCODING = "ISO-8859-1";
    private String encoding = DEFAULT_ENCODING;
    private byte[] headerbuff = null;

    public MultipartParser(HttpServletRequest req, long maxSize) throws IOException {
        this(req, maxSize, true, true);
    }

    public MultipartParser(HttpServletRequest req, long maxSize, boolean buffer, boolean limitLength) throws IOException {
        String type = null;
        String type1 = req.getHeader("Content-Type");
        String type2 = req.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        long length = req.getContentLengthLong();
        if (length > maxSize) {
            throw new IOException("Posted content length of " + length + " exceeds limit of " + maxSize);
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        ServletInputStream in = req.getInputStream();
        if (buffer) {
            in = new BufferedServletInputStream(in);
        }
        if (limitLength) {
            in = new LimitedServletInputStream(in, length);
        }
        this.in = in;
        this.boundary = boundary;
        if (length > 0L) {
            String line = this.readLine();
            if (line == null) {
                throw new IOException("Corrupt form data: premature ending");
            }
            if (!line.startsWith(boundary)) {
                throw new IOException("Corrupt form data: no leading boundary: " + line + " != " + boundary);
            }
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Part readNextPart() throws IOException {
        if (this.lastFilePart != null) {
            this.lastFilePart.getInputStream().close();
            this.lastFilePart = null;
        }
        Vector<String> headers = new Vector<String>();
        Object line = this.readLine(true);
        if (line == null) {
            return null;
        }
        if (((String)line).length() == 0) {
            return null;
        }
        while (line != null && ((String)line).length() > 0) {
            String nextLine = null;
            boolean getNextLine = true;
            while (getNextLine) {
                nextLine = this.readLine();
                if (nextLine != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                    line = (String)line + nextLine;
                    continue;
                }
                getNextLine = false;
            }
            headers.addElement((String)line);
            line = nextLine;
        }
        if (line == null) {
            return null;
        }
        String name = null;
        String filename = null;
        String origname = null;
        String contentType = "text/plain";
        String charset = this.encoding;
        Enumeration headersEnum = headers.elements();
        while (headersEnum.hasMoreElements()) {
            String type;
            String headerline = (String)headersEnum.nextElement();
            if (headerline.toLowerCase().startsWith("content-disposition:")) {
                String[] dispInfo = this.extractDispositionInfo(headerline);
                name = dispInfo[1];
                filename = dispInfo[2];
                origname = dispInfo[3];
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:") || (type = this.extractContentType(headerline)) == null) continue;
            contentType = type;
            int csindex = type.indexOf("charset=");
            if (csindex == -1) continue;
            String cs = type.substring(csindex + "charset=".length());
            if (cs.indexOf(59) != -1) {
                cs = cs.substring(0, cs.indexOf(59));
            }
            charset = cs;
        }
        if (filename == null) {
            return new ParamPart(name, this.in, this.boundary, charset);
        }
        if (filename.equals("")) {
            filename = null;
        }
        this.lastFilePart = new FilePart(name, this.in, this.boundary, contentType, filename, this.headerbuff, origname);
        return this.lastFilePart;
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        Object boundary = line.substring(index + 9);
        if (((String)boundary).charAt(0) == '\"') {
            index = ((String)boundary).lastIndexOf(34);
            boundary = ((String)boundary).substring(1, index);
        }
        boundary = "--" + (String)boundary;
        return boundary;
    }

    public String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[4];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 6);
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String name = origline.substring(start + 6, end);
        String filename = null;
        String origname = null;
        start = line.indexOf("filename=\"", end + 2);
        end = origline.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origname = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        retval[3] = origname;
        return retval;
    }

    private String extractContentType(String line) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException("Content type corrupt: " + origline);
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new IOException("Malformed line after disposition: " + origline);
        }
        return contentType;
    }

    private String readLine() throws IOException {
        return this.readLine(false);
    }

    private String readLine(boolean populateHeaderBuff) throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            result = this.in.readLine(this.buf, 0, this.buf.length);
            if (populateHeaderBuff && result != -1) {
                this.headerbuff = new byte[result];
                System.arraycopy(this.buf, 0, this.headerbuff, 0, result);
            }
            if (result == -1) continue;
            sbuf.append(new String(this.buf, 0, result, this.encoding));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len >= 2 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else if (len >= 1 && sbuf.charAt(len - 1) == '\n') {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }
}

