/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc;

import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.osgi.services.DDDatabaseService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.RB;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import macromedia.jdbc.DriverNotSupportedException;

public class MacromediaDriver
implements Driver {
    private static ResourceBundle messages = ResourceBundle.getBundle("macromedia/jdbc/resource");
    private static String sqlserverID = "";
    private static String oracleID = "";
    private static String informixID = "";
    private static String db2ID = "";
    private static String sequeLinkID = "";
    private static String mySQLID = "";
    private Driver sql;
    private Driver db2;
    private Driver informix;
    private Driver oracle;
    private Driver slAccess;
    private Driver slSocket;
    private Driver mysql;
    private Driver driver;
    private String driverClassName;
    private int majorVersion;
    private int minorVersion;
    static final String SQLSERVER_DRIVER = "macromedia.jdbc.sqlserver.SQLServerDriver";
    static final String DB2_DRIVER = "macromedia.jdbc.db2.DB2Driver";
    static final String INFORMIX_DRIVER = "macromedia.jdbc.informix.InformixDriver";
    static final String ORACLE_DRIVER = "macromedia.jdbc.oracle.OracleDriver";
    static final String MYSQL_DRIVER = "macromedia.jdbc.mysql.MySQLDriver";
    static final String SEQUELINK_DRIVER = "macromedia.jdbc.sequelink.SequeLinkDriver";
    public static Map<String, String> driverNamesMapping = new HashMap<String, String>();

    public static void setSQLServerID(String newID) {
        sqlserverID = newID;
    }

    public static void setOracleID(String newID) {
        oracleID = newID;
    }

    public static void setInformixID(String newID) {
        informixID = newID;
    }

    public static void setDB2ID(String newID) {
        db2ID = newID;
    }

    public static void setSequeLinkID(String newID) {
        sequeLinkID = newID;
    }

    public static void setMySQLID(String newID) {
        mySQLID = newID;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException, DriverNotSupportedException {
        block36: {
            if (info == null) {
                info = new Properties();
            }
            info.setProperty("embedded", "true");
            Object classLoader = ServerlessUtil.isLambdaEnv() ? BootstrapClassLoader.instance() : MacromediaDriver.class.getClassLoader();
            try {
                DDDatabaseService driverSvc;
                if (((String)url).indexOf("macromedia:sql") != -1) {
                    driverSvc = ServiceFactory.getSqlServerDriverService(true);
                    if (this.sql == null) {
                        this.sql = driverSvc.getDriver();
                    }
                    this.driver = this.sql;
                    break block36;
                }
                if (((String)url).indexOf("macromedia:db2") != -1) {
                    driverSvc = ServiceFactory.getDb2DriverService(true);
                    if (this.db2 == null) {
                        this.db2 = driverSvc.getDriver();
                    }
                    this.driver = this.db2;
                    break block36;
                }
                if (((String)url).indexOf("macromedia:inf") != -1) {
                    driverSvc = ServiceFactory.getInformixDriverService(true);
                    if (this.informix == null) {
                        this.informix = driverSvc.getDriver();
                    }
                    this.driver = this.informix;
                    break block36;
                }
                if (((String)url).indexOf("macromedia:oracle") != -1) {
                    driverSvc = ServiceFactory.getOracleDriverService(true);
                    if (this.oracle == null) {
                        this.oracle = driverSvc.getDriver();
                    }
                    this.driver = this.oracle;
                    break block36;
                }
                if (((String)url).indexOf("macromedia:mysql") != -1) {
                    driverSvc = ServiceFactory.getMySQLDriverService(true);
                    if (this.mysql == null) {
                        this.mysql = driverSvc.getDriver();
                    }
                    this.driver = this.mysql;
                    break block36;
                }
                if (((String)url).indexOf("jdbc:sequelink:msaccess") != -1) {
                    driverSvc = ServiceFactory.getSequelinkService(true);
                    url = ((String)url).substring(0, "jdbc:sequelink:".length() - 1) + ((String)url).substring("jdbc:sequelink:msaccess:".length() - 1, ((String)url).length());
                    if (this.slAccess == null) {
                        this.slAccess = driverSvc.getDriver();
                    }
                    this.driver = this.slAccess;
                    break block36;
                }
                if (((String)url).indexOf("jdbc:sequelink:odbcsocket") != -1) {
                    driverSvc = ServiceFactory.getSequelinkService(true);
                    url = ((String)url).substring(0, "jdbc:sequelink:".length() - 1) + ((String)url).substring("jdbc:sequelink:odbcsocket:".length() - 1, ((String)url).length());
                    if (this.slSocket == null) {
                        this.slSocket = driverSvc.getDriver();
                    }
                    this.driver = this.slSocket;
                    break block36;
                }
                if (((String)url).indexOf("macromedia:syb") != -1) {
                    throw new DriverNotSupportedException("Sybase");
                }
                return null;
            }
            catch (DriverNotSupportedException e) {
                throw e;
            }
            catch (Exception e) {
                String dbDriverName = "";
                String[] urlSplits = ((String)url).split(":");
                if (((String)url).startsWith("jdbc:macromedia") && urlSplits.length > 2) {
                    dbDriverName = urlSplits[2];
                } else if (((String)url).startsWith("jdbc:") && urlSplits.length > 1) {
                    dbDriverName = urlSplits[1];
                }
                String dbDriverModuleName = driverNamesMapping.get(dbDriverName);
                if (dbDriverModuleName == null) {
                    dbDriverModuleName = dbDriverName;
                }
                String scriptName = SystemInfo.isWindows() ? "cfpm.bat" : "cfpm.sh";
                String scriptPath = ServiceFactory.getRuntimeService().getRootDir().replace("\\", "/") + "/bin/" + scriptName;
                throw new SQLException(RB.getString((Object)this, "JDBCPool.noModule", (Object)dbDriverModuleName, (Object)scriptPath));
            }
        }
        this.majorVersion = this.driver.getMajorVersion();
        this.minorVersion = this.driver.getMinorVersion();
        this.driverClassName = this.driver.getClass().getName();
        if (!this.driverClassName.equals(SEQUELINK_DRIVER)) {
            url = this.fixURL((String)url);
        }
        Connection conn = this.driver.connect((String)url, info);
        if (this.driverClassName.equals(SQLSERVER_DRIVER)) {
            this.unlock(ServiceFactory.getSqlServerDriverService(true), sqlserverID, conn);
        } else if (this.driverClassName.equals(ORACLE_DRIVER)) {
            this.unlock(ServiceFactory.getOracleDriverService(true), oracleID, conn);
        } else if (this.driverClassName.equals(MYSQL_DRIVER)) {
            this.unlock(ServiceFactory.getMySQLDriverService(true), mySQLID, conn);
        } else if (this.driverClassName.equals(INFORMIX_DRIVER)) {
            this.unlock(ServiceFactory.getInformixDriverService(true), informixID, conn);
        } else if (this.driverClassName.equals(DB2_DRIVER)) {
            this.unlock(ServiceFactory.getDb2DriverService(true), db2ID, conn);
        } else if (this.driverClassName.equals(SEQUELINK_DRIVER)) {
            if (sequeLinkID.length() == 0) {
                System.out.println("THROW EXCEPTION IN MACRDRIVER....");
                throw new InvalidLicenseException();
            }
            this.setOemId(sequeLinkID, conn);
        }
        return conn;
    }

    private void setOemId(String id, Connection conn) throws SQLException {
        if (id.length() == 0) {
            throw new InvalidLicenseException();
        }
        ServiceFactory.getSequelinkService(true).setOemId(id, conn);
    }

    private void unlock(final DDDatabaseService ddDatabaseService, final String id, final Connection conn) throws SQLException {
        if (id.length() == 0) {
            throw new InvalidLicenseException();
        }
        if (ddDatabaseService.isInstanceOfExtEmbeddedConnection(conn)) {
            if (System.getSecurityManager() == null) {
                ddDatabaseService.ulockExtEmbeddedConnection(conn);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ddDatabaseService.ulockExtEmbeddedConnection(conn);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    Exception e = ex.getException();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw (SQLException)e;
                }
            }
        } else if (ddDatabaseService.isInstanceOfExtEmbeddedConnectionDB(conn)) {
            if (System.getSecurityManager() == null) {
                ddDatabaseService.unlockExtEmbeddedConnectionDB(conn, id);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ddDatabaseService.unlockExtEmbeddedConnectionDB(conn, id);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    Exception e = ex.getException();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw (SQLException)e;
                }
            }
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.startsWith("jdbc:macromedia:")) {
            return true;
        }
        return url.startsWith("jdbc:sequelink:");
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        url = this.fixURL((String)url);
        try {
            if (((String)url).indexOf("macromedia:sql") != -1) {
                if (this.sql == null) {
                    this.sql = (Driver)Class.forName(SQLSERVER_DRIVER).newInstance();
                }
                return this.sql.getPropertyInfo((String)url, info);
            }
            if (((String)url).indexOf("macromedia:db2") != -1) {
                if (this.db2 == null) {
                    this.db2 = (Driver)Class.forName(DB2_DRIVER).newInstance();
                }
                return this.db2.getPropertyInfo((String)url, info);
            }
            if (((String)url).indexOf("macromedia:inf") != -1) {
                if (this.informix == null) {
                    this.informix = (Driver)Class.forName(INFORMIX_DRIVER).newInstance();
                }
                return this.informix.getPropertyInfo((String)url, info);
            }
            if (((String)url).indexOf("macromedia:oracle") != -1) {
                if (this.oracle == null) {
                    this.oracle = (Driver)Class.forName(ORACLE_DRIVER).newInstance();
                }
                return this.oracle.getPropertyInfo((String)url, info);
            }
            if (((String)url).indexOf("macromedia:mysql") != -1) {
                if (this.mysql == null) {
                    this.mysql = (Driver)Class.forName(MYSQL_DRIVER).newInstance();
                }
                return this.mysql.getPropertyInfo((String)url, info);
            }
            if (((String)url).indexOf("jdbc:sequelink:msaccess") != -1) {
                if (this.slAccess == null) {
                    this.slAccess = (Driver)Class.forName(SEQUELINK_DRIVER).newInstance();
                }
                url = ((String)url).substring(0, "jdbc:sequelink:".length() - 1) + ((String)url).substring("jdbc:sequelink:msaccess:".length() - 1, ((String)url).length());
                return this.slAccess.getPropertyInfo((String)url, info);
            }
            if (((String)url).indexOf("jdbc:sequelink:odbcsocket") != -1) {
                if (this.slSocket == null) {
                    this.slSocket = (Driver)Class.forName(SEQUELINK_DRIVER).newInstance();
                }
                url = ((String)url).substring(0, "jdbc:sequelink:".length() - 1) + ((String)url).substring("jdbc:sequelink:odbcsocket:".length() - 1, ((String)url).length());
                return this.slSocket.getPropertyInfo((String)url, info);
            }
        }
        catch (ClassNotFoundException e) {
            String dbDriverName = "";
            String[] urlSplits = ((String)url).split(":");
            if (((String)url).startsWith("jdbc:macromedia") && urlSplits.length > 2) {
                dbDriverName = urlSplits[2];
            } else if (((String)url).startsWith("jdbc:") && urlSplits.length > 1) {
                dbDriverName = urlSplits[1];
            }
            String scriptName = "cfpm.bat";
            if (!SystemInfo.isWindows()) {
                scriptName = "cfpm.sh";
            }
            String scriptPath = ServiceFactory.getRuntimeService().getRootDir().replace("\\", "/") + "/bin/" + scriptName;
            throw new SQLException(RB.getString((Object)this, "JDBCPool.noModule", (Object)dbDriverName, (Object)scriptPath));
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private String fixURL(String url) {
        String mm_piece = ":macromedia";
        int i = url.indexOf(mm_piece);
        if (i == -1) {
            return url;
        }
        return url.substring(0, i + mm_piece.length()) + "_direct" + url.substring(i + mm_piece.length());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        driverNamesMapping.put("sequelink", "odbc");
        driverNamesMapping.put("derby", "derby");
        driverNamesMapping.put("oracle", "oracle");
        driverNamesMapping.put("mysql", "mysql");
        driverNamesMapping.put("sqlserver", "sqlserver");
        driverNamesMapping.put("db2", "db2");
        driverNamesMapping.put("postgresql", "postgresql");
        try {
            DriverManager.registerDriver(new MacromediaDriver());
        }
        catch (SQLException sqle) {
            throw new RuntimeException(messages.getString("MacromediaDriver.RegisterFail") + " " + sqle.getMessage());
        }
    }

    class InvalidLicenseException
    extends UnsupportedOperationException {
        public InvalidLicenseException() {
            super(messages.getString("MacromediaDriver.NoLicense"));
        }
    }
}

