/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.org.apache.bcel.classfile;

import com.jnbridge.org.apache.bcel.classfile.Constant;
import com.jnbridge.org.apache.bcel.classfile.ConstantObject;
import com.jnbridge.org.apache.bcel.classfile.ConstantPool;
import com.jnbridge.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantDouble
extends Constant
implements ConstantObject {
    private double bytes;

    public ConstantDouble(double bytes) {
        super((byte)6);
        this.bytes = bytes;
    }

    public ConstantDouble(ConstantDouble c) {
        this(c.getBytes());
    }

    ConstantDouble(DataInputStream file) throws IOException {
        this(file.readDouble());
    }

    public void accept(Visitor v) {
        v.visitConstantDouble(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeDouble(this.bytes);
    }

    public final double getBytes() {
        return this.bytes;
    }

    public final void setBytes(double bytes) {
        this.bytes = bytes;
    }

    public final String toString() {
        return String.valueOf(super.toString()) + "(bytes = " + this.bytes + ")";
    }

    public Object getConstantValue(ConstantPool cp) {
        return new Double(this.bytes);
    }
}

