/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.org.apache.bcel.classfile;

import com.jnbridge.org.apache.bcel.Constants;
import com.jnbridge.org.apache.bcel.classfile.Annotation;
import com.jnbridge.org.apache.bcel.classfile.ConstantPool;
import com.jnbridge.org.apache.bcel.classfile.Node;
import com.jnbridge.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ElementValue
implements Constants,
Cloneable,
Node,
Serializable {
    private int tag;
    private int const_value_index;
    private int type_name_index;
    private int const_name_index;
    private int class_info_index;
    private Annotation annotation_value = null;
    private int num_values;
    private ElementValue[] values = null;
    private ConstantPool constant_pool;

    public ElementValue(ElementValue c) {
        this.tag = c.getTag();
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.const_value_index = c.getConstValueIndex();
                break;
            }
            case 101: {
                this.type_name_index = c.getTypeNameIndex();
                this.const_name_index = c.getConstNameIndex();
                break;
            }
            case 99: {
                this.class_info_index = c.getClassInfoIndex();
                break;
            }
            case 64: {
                this.annotation_value = c.getAnnotationValue();
                break;
            }
            case 91: {
                this.num_values = c.getNumValues();
                this.values = c.getValues();
                break;
            }
            default: {
                throw new BadTagException(this.tag);
            }
        }
    }

    ElementValue(DataInputStream file, ConstantPool constant_pool) throws IOException {
        this.tag = file.readUnsignedByte();
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.const_value_index = file.readUnsignedShort();
                break;
            }
            case 101: {
                this.type_name_index = file.readUnsignedShort();
                this.const_name_index = file.readUnsignedShort();
                break;
            }
            case 99: {
                this.class_info_index = file.readUnsignedShort();
                break;
            }
            case 64: {
                this.annotation_value = new Annotation(file, constant_pool);
                break;
            }
            case 91: {
                this.num_values = file.readUnsignedShort();
                this.values = new ElementValue[this.num_values];
                int i = 0;
                while (i < this.num_values) {
                    this.values[i] = new ElementValue(file, constant_pool);
                    ++i;
                }
                break;
            }
            default: {
                throw new BadTagException(this.tag);
            }
        }
    }

    public ElementValue(int tag, int index) {
        this.tag = tag;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.const_value_index = index;
                break;
            }
            case 99: {
                this.class_info_index = index;
                break;
            }
            default: {
                throw new BadTagException(tag);
            }
        }
    }

    public ElementValue(int tag, int typeNameIndex, int constNameIndex) {
        this.tag = tag;
        switch (tag) {
            case 101: {
                this.type_name_index = typeNameIndex;
                this.const_name_index = constNameIndex;
                break;
            }
            default: {
                throw new BadTagException(tag);
            }
        }
    }

    public ElementValue(int tag, Annotation annotation_value) {
        this.tag = tag;
        switch (tag) {
            case 64: {
                this.annotation_value = annotation_value;
                break;
            }
            default: {
                throw new BadTagException(tag);
            }
        }
    }

    public ElementValue(int tag, int num_values, ElementValue[] values) {
        this.tag = tag;
        switch (tag) {
            case 91: {
                this.num_values = num_values;
                this.values = values;
                break;
            }
            default: {
                throw new BadTagException(tag);
            }
        }
    }

    public void accept(Visitor v) {
        v.visitElementValue(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                file.writeShort(this.const_value_index);
                break;
            }
            case 101: {
                file.writeShort(this.type_name_index);
                file.writeShort(this.const_name_index);
                break;
            }
            case 99: {
                file.writeShort(this.class_info_index);
                break;
            }
            case 64: {
                this.annotation_value.dump(file);
                break;
            }
            case 91: {
                file.writeShort(this.num_values);
                int i = 0;
                while (i < this.num_values) {
                    this.values[i].dump(file);
                    ++i;
                }
                break;
            }
            default: {
                throw new BadTagException(this.tag);
            }
        }
    }

    public final int getTag() {
        return this.tag;
    }

    public final void setTag(int tag) {
        this.tag = tag;
    }

    public final int getConstValueIndex() {
        return this.const_value_index;
    }

    public final void setConstValueIndex(int const_value_index) {
        this.const_value_index = const_value_index;
    }

    public final int getTypeNameIndex() {
        return this.type_name_index;
    }

    public final void setTypeNameIndex(int type_name_index) {
        this.type_name_index = type_name_index;
    }

    public final int getConstNameIndex() {
        return this.const_name_index;
    }

    public final void setConstNameIndex(int const_name_index) {
        this.const_name_index = const_name_index;
    }

    public final int getClassInfoIndex() {
        return this.class_info_index;
    }

    public final void setClassInfoIndex(int class_info_index) {
        this.class_info_index = class_info_index;
    }

    public final Annotation getAnnotationValue() {
        return this.annotation_value;
    }

    public final void setAnnotationValue(Annotation annotation_value) {
        this.annotation_value = annotation_value;
    }

    public final int getNumValues() {
        return this.num_values;
    }

    public final void setNumValues(int num_values) {
        this.num_values = num_values;
    }

    public final ElementValue[] getValues() {
        return this.values;
    }

    public final void setValues(ElementValue[] values) {
        this.values = values;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ElementValue: tag = " + this.tag + "\n");
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                buf.append("ElementValue: const_value_index = " + this.const_value_index + "\n");
                break;
            }
            case 101: {
                buf.append("ElementValue: type_name_index = " + this.type_name_index + "\n");
                buf.append("ElementValue: const_name_index = " + this.const_name_index + "\n");
                break;
            }
            case 99: {
                buf.append("ElementValue: class_info_index = " + this.class_info_index + "\n");
                break;
            }
            case 64: {
                buf.append("ElementValue: annotation_value = " + this.annotation_value + "\n");
                break;
            }
            case 91: {
                buf.append("ElementValue: num_values = " + this.num_values + "\n");
                int i = 0;
                while (i < this.num_values) {
                    buf.append("ElementValue: values[" + i + "] = " + this.values[i] + "\n");
                    ++i;
                }
                break;
            }
            default: {
                throw new BadTagException(this.tag);
            }
        }
        return buf.toString();
    }

    public ElementValue copy() {
        try {
            ElementValue c = (ElementValue)this.clone();
            c.tag = this.tag;
            c.const_value_index = this.const_name_index;
            c.type_name_index = this.type_name_index;
            c.const_name_index = this.const_name_index;
            c.class_info_index = this.class_info_index;
            c.annotation_value = this.annotation_value.copy();
            c.num_values = this.num_values;
            c.values = new ElementValue[this.num_values];
            int i = 0;
            while (i < this.num_values) {
                c.values[i] = this.values[i].copy();
                ++i;
            }
            c.constant_pool = this.constant_pool;
            return c;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static class BadTagException
    extends RuntimeException {
        int tag;

        public BadTagException(int tag) {
            this.tag = tag;
        }

        public String getMessage() {
            return Integer.toString(this.tag);
        }
    }
}

