/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.org.apache.bcel.classfile;

import com.jnbridge.org.apache.bcel.Constants;
import com.jnbridge.org.apache.bcel.classfile.Annotation;
import com.jnbridge.org.apache.bcel.classfile.ConstantPool;
import com.jnbridge.org.apache.bcel.classfile.Node;
import com.jnbridge.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ParameterAnnotation
implements Constants,
Cloneable,
Node,
Serializable {
    private int num_annotations;
    private Annotation[] annotations;
    private ConstantPool constant_pool;

    public ParameterAnnotation(ParameterAnnotation c) {
        this(c.getNumAnnotations(), c.getAnnotations(), c.getConstantPool());
    }

    ParameterAnnotation(DataInputStream file, ConstantPool constant_pool) throws IOException {
        this.num_annotations = file.readUnsignedShort();
        this.annotations = new Annotation[this.num_annotations];
        int i = 0;
        while (i < this.num_annotations) {
            this.annotations[i] = new Annotation(file, constant_pool);
            ++i;
        }
    }

    public ParameterAnnotation(int num_annotations, Annotation[] annotations, ConstantPool constant_pool) {
        this.num_annotations = num_annotations;
        this.annotations = annotations;
        this.constant_pool = constant_pool;
    }

    public void accept(Visitor v) {
        v.visitParameterAnnotation(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.num_annotations);
        int i = 0;
        while (i < this.num_annotations) {
            this.annotations[i].dump(file);
            ++i;
        }
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final int getNumAnnotations() {
        return this.num_annotations;
    }

    public final void setNumAnnotations(int num_annotations) {
        this.num_annotations = num_annotations;
    }

    public final Annotation[] getAnnotations() {
        return this.annotations;
    }

    public final void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ParameterAnnotation: num_annotations = " + this.num_annotations + "\n");
        int i = 0;
        while (i < this.num_annotations) {
            buf.append("ParameterAnnotation: annotations[" + i + "] = " + this.annotations[i] + "\n");
            ++i;
        }
        return buf.toString();
    }

    public ParameterAnnotation copy() {
        try {
            ParameterAnnotation pa = (ParameterAnnotation)this.clone();
            pa.num_annotations = this.num_annotations;
            pa.annotations = new Annotation[this.num_annotations];
            int i = 0;
            while (i < this.num_annotations) {
                pa.annotations[i] = this.annotations[i].copy();
                ++i;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return null;
    }
}

