/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.osgi.servlet;

import coldfusion.Version;
import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.aws.AWSServiceFactory;
import coldfusion.cloud.gcp.GCPServiceFactory;
import coldfusion.log.CFLogs;
import coldfusion.osgi.servlet.ModulesStatus;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.server.CFService;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.server.UpdateUtil;
import coldfusion.server.felix.CFBundle;
import coldfusion.server.felix.DependentBundle;
import coldfusion.server.felix.FelixUtil;
import coldfusion.util.RB;
import coldfusion.wddx.WddxDeserializer;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.Ansi;
import org.xml.sax.InputSource;

public class ModulesServlet {
    public static boolean lambdaMode = false;
    public static boolean _isStandalone = false;
    public static Map<Integer, ModulesStatus> progressInstallAll;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doProcess(RdsRequest rdreq, RdsResponse rdresp) throws Exception {
        boolean cValue = ServiceFactory.shouldForceInitialize;
        ServiceFactory.shouldForceInitialize = false;
        try {
            String command = rdreq.getMetaString(0).toLowerCase();
            if (command.equals("test")) {
                String string = "OK";
                return string;
            }
            if (command.equals("list")) {
                String string = ModulesServlet.listBundles();
                return string;
            }
            if (command.equals("listall")) {
                String string = ModulesServlet.listBundles();
                return string;
            }
            String bundle = rdreq.getMetaString(1).toLowerCase();
            String version = rdreq.getMetaString(2).toLowerCase();
            if (command.equals("install")) {
                this.installBundle(rdreq);
                String string = RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduleinstalled", (Object)bundle, (Object)version);
                return string;
            }
            if (command.equals("uninstall")) {
                this.uninstallBundle(rdreq);
                String string = RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduleuninstalled", (Object)bundle);
                return string;
            }
            if (command.equals("info")) {
                String string = this.findBundle(rdreq);
                return string;
            }
        }
        finally {
            ServiceFactory.shouldForceInitialize = cValue;
        }
        return "";
    }

    public static String listBundles() {
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        JsonArray bundlesAry = new JsonArray();
        for (CFBundle cfb : cfbundles) {
            JsonObject bundleJobj = new JsonObject();
            bundleJobj.put("name", (Object)cfb.getName());
            bundleJobj.put("version", (Object)cfb.getCurrentVersion());
            bundleJobj.put("installed", cfb.isInstalled());
            bundleJobj.put("versions", cfb.getVersions());
            bundlesAry.put((Object)bundleJobj);
        }
        return bundlesAry.toString();
    }

    public static String listAllBundlesByName() {
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        JsonArray bundlesAry = new JsonArray();
        LinkedHashMap<String, JsonObject> uniqueBundles = new LinkedHashMap<String, JsonObject>();
        for (CFBundle cFBundle : cfbundles) {
            JsonObject bundleJobj = new JsonObject();
            bundleJobj.put("name", (Object)cFBundle.getName());
            bundleJobj.put("version", (Object)cFBundle.getCurrentVersion());
            bundleJobj.put("installed", cFBundle.isInstalled());
            bundleJobj.put("awsserverless", cFBundle.isLambdaSupport());
            JsonObject bundleJobjOld = (JsonObject)uniqueBundles.get(cFBundle.getName());
            if (bundleJobjOld != null) {
                JsonArray versions = (JsonArray)bundleJobjOld.get("versions");
                versions.put((Object)cFBundle.getCurrentVersion());
                bundleJobj.put("versions", (Object)versions);
                uniqueBundles.put(cFBundle.getName(), bundleJobj);
                continue;
            }
            bundleJobj.put("versions", cFBundle.getVersions());
            uniqueBundles.put(cFBundle.getName(), bundleJobj);
        }
        for (Map.Entry entry : uniqueBundles.entrySet()) {
            bundlesAry.put(entry.getValue());
        }
        return bundlesAry.toString();
    }

    private String findBundle(RdsRequest rdreq) throws Exception {
        return ModulesServlet.findBundle(rdreq.getMetaString(1).toLowerCase());
    }

    public static String findBundle(String name) throws Exception {
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        for (CFBundle cfb : cfbundles) {
            if (!cfb.getName().equalsIgnoreCase(name)) continue;
            JsonObject bundleJobj = new JsonObject();
            bundleJobj.put("name", (Object)cfb.getName());
            bundleJobj.put("version", (Object)cfb.getCurrentVersion());
            bundleJobj.put("installed", cfb.isInstalled());
            bundleJobj.put("versions", cfb.getVersions());
            bundleJobj.put("description", (Object)cfb.getDescription());
            bundleJobj.put("category", (Object)cfb.getCategory());
            List<DependentBundle> deps = cfb.getDependentBundles();
            JsonArray jary = new JsonArray();
            for (DependentBundle dp : deps) {
                JsonObject jobj = new JsonObject();
                jobj.put("name", (Object)dp.getName());
                jobj.put("version", (Object)dp.getVersion());
                jobj.put("type", (Object)dp.getType());
                jary.put((Object)jobj);
            }
            bundleJobj.put("dependencies", (Object)jary);
            return bundleJobj.toString();
        }
        throw new Exception(RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotfound", (Object)name));
    }

    private void uninstallBundle(RdsRequest rdreq) throws Exception {
        String bundle = rdreq.getMetaString(1).toLowerCase();
        ModulesServlet.uninstallBundle(bundle);
    }

    public static Map<String, String> uninstallBundle(String commaBundles) throws Exception {
        return ModulesServlet.uninstallBundle(commaBundles, false);
    }

    public static Map<String, String> uninstallBundle(String commaBundles, boolean uninstalDependents) throws Exception {
        commaBundles = commaBundles.toLowerCase();
        commaBundles = ModulesServlet.getOrderedBundles(commaBundles, true);
        String[] bundles = commaBundles.split(",");
        HashMap<String, String> msgs = new HashMap<String, String>();
        for (String bundle : bundles) {
            bundle = bundle.trim();
            String[] iSplit = bundle.split(":");
            String bundleName = iSplit[0];
            if (iSplit.length > 1) {
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.versionforuninstall", (Object)bundle), "success");
            }
            try {
                ModulesServlet._uninstallBundle(bundleName, msgs, uninstalDependents);
            }
            catch (Throwable e) {
                if (!FelixUtil.invokedFromClient) {
                    CFLogs.SERVER_LOG.error((Object)e.getMessage());
                }
                ModulesServlet.addMsg(msgs, e.getMessage(), "error");
            }
        }
        if (FelixUtil.invokedFromClient) {
            msgs.clear();
        }
        return msgs;
    }

    public static void _uninstallBundle(String bundle, Map<String, String> msgs, boolean uninstalDependents) throws Exception {
        if (ModulesServlet.checkRedisSessionStorage(bundle, msgs)) {
            return;
        }
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        boolean installationFound = false;
        boolean isgivenBundleValid = false;
        for (CFBundle bun : cfbundles) {
            if (bun.getName().equalsIgnoreCase(bundle) && bun.isInstalled()) {
                installationFound = true;
            }
            if (!bun.getName().equalsIgnoreCase(bundle)) continue;
            isgivenBundleValid = true;
        }
        if (!isgivenBundleValid) {
            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotfound", (Object)bundle), "error");
            return;
        }
        if (isgivenBundleValid && !installationFound) {
            ModulesServlet.addMsg(msgs, ModulesServlet.getUninstalledExcMsg(bundle), "error");
            return;
        }
        if (!lambdaMode && (bundle.equals("adminapi") || bundle.equals("administrator") || bundle.equals("axis")) && ModulesServlet.isServerRunning()) {
            String dependentBundleName = FelixUtil.getDependentBundleName(bundle);
            if (null != dependentBundleName && !uninstalDependents) {
                throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.uninstalldependency", (Object)bundle, (Object)dependentBundleName));
            }
            ModulesServlet.storeToBeInstalledBundles(bundle + ":UNINSTALLED");
            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.serverrunningerror", (Object)bundle), "error");
            return;
        }
        if (!lambdaMode && !bundle.equals("odbc")) {
            if (!ModulesServlet.isServerRunning()) {
                ModulesServlet.storeToBeInstalledBundles(bundle + ":UNINSTALLED");
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.serverrunningerror", (Object)bundle), "error");
                return;
            }
            if (!FelixUtil.invokedFromClient && bundle.equalsIgnoreCase("axis")) {
                CFLogs.SERVER_LOG.info((Object)"Stopping package : axis");
                String xmlRpcService = ServiceFactory.getXmlRpcService();
                if (xmlRpcService != null) {
                    xmlRpcService.stop();
                }
            }
        }
        try {
            FelixUtil.undeployBundle(bundle, uninstalDependents);
            switch (bundle) {
                case "spreadsheet": {
                    ServiceFactory.setExcelService(null);
                    break;
                }
                case "presentation": {
                    ServiceFactory.setPresentationService(null);
                    break;
                }
                case "chart": {
                    ServiceFactory.setNewGraphingService(null);
                    break;
                }
                case "security": {
                    if (ServiceFactory.getSecurityService() == null) {
                        throw new Exception(ModulesServlet.getUninstalledExcMsg(bundle));
                    }
                    ServiceFactory.setSecurityService(null);
                    break;
                }
                case "pdf": {
                    ServiceFactory.setPDFService(null);
                    break;
                }
                case "print": {
                    ServiceFactory.setPrintService(null);
                    break;
                }
                case "ftp": {
                    ServiceFactory.setFTPService(null);
                    break;
                }
                case "document": {
                    ServiceFactory.setDocumentService(null);
                    break;
                }
                case "awss3": {
                    ServiceFactory.setS3Service(null);
                    AWSServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.S3);
                    break;
                }
                case "azureblob": {
                    ServiceFactory.setAzureBlobService(null);
                    AWSServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.AZURE_BLOB);
                    break;
                }
                case "awssns": {
                    ServiceFactory.setSnsService(null);
                    AWSServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.SNS);
                    break;
                }
                case "awssqs": {
                    ServiceFactory.setSqsService(null);
                    AWSServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.SQS);
                    break;
                }
                case "azureservicebus": {
                    ServiceFactory.setServiceBusService(null);
                    AWSServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.SERVICE_BUS);
                    break;
                }
                case "awsdynamodb": {
                    ServiceFactory.setDynamoDBService(null);
                    AWSServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.DYNAMODB);
                    break;
                }
                case "derby": {
                    ServiceFactory.setApacheDerbyService(null);
                    break;
                }
                case "oracle": {
                    ServiceFactory.setOracleDriverService(null);
                    break;
                }
                case "mysql": {
                    ServiceFactory.setMySQLDriverService(null);
                    break;
                }
                case "db2": {
                    ServiceFactory.setDb2DriverService(null);
                    break;
                }
                case "informix": {
                    ServiceFactory.setInformixDriverService(null);
                    break;
                }
                case "sqlserver": {
                    ServiceFactory.setSqlServerDriverService(null);
                    break;
                }
                case "postgresql": {
                    ServiceFactory.setPostgreSQLDriverService(null);
                    break;
                }
                case "odbc": {
                    ServiceFactory.setSequelinkService(null);
                    FelixUtil.uninstallOdbcService(ModulesServlet.getServerRoot());
                    break;
                }
                case "corba": {
                    ServiceFactory.setCorbaService(null);
                    break;
                }
                case "dotnet": {
                    ServiceFactory.setDotNetService(null);
                    break;
                }
                case "eventgateways": {
                    ServiceFactory.setEventProcessorService(null);
                    break;
                }
                case "search": {
                    ServiceFactory.setSolrService(null);
                    break;
                }
                case "java": {
                    ServiceFactory.setLanguageService(null);
                    break;
                }
                case "orm": {
                    ServiceFactory.setOrmService(null);
                    break;
                }
                case "ormsearch": {
                    ServiceFactory.setOrmSearchService(null);
                    break;
                }
                case "rest": {
                    ServiceFactory.setJaxRsService(null);
                    break;
                }
                case "report": {
                    ServiceFactory.setReportService(null);
                    break;
                }
                case "scheduler": {
                    ServiceFactory.setCronService(null);
                    break;
                }
                case "saml": {
                    ServiceFactory.setSamlService(null);
                    break;
                }
                case "debugger": {
                    ServiceFactory.setDebuggingService(null);
                    break;
                }
                case "websocket": {
                    ServiceFactory.setWebsocketService(null);
                    break;
                }
                case "awss3legacy": {
                    ServiceFactory.setStoreService(null);
                    break;
                }
                case "mail": {
                    ServiceFactory.setMailSpoolService(null);
                    break;
                }
                case "image": {
                    ServiceFactory.setImageService(null);
                    break;
                }
                case "redissessionstorage": {
                    ServiceFactory.setSessionStorageService(null);
                    break;
                }
                case "ajax": {
                    ServiceFactory.isAjaxEnabled = false;
                    break;
                }
                case "caching": {
                    ServiceFactory.setCachingService(null);
                    break;
                }
                case "pmtagent": {
                    ServiceFactory.setMonitoringService(null);
                    break;
                }
                case "axis": {
                    ServiceFactory.setXmlRpcService(null);
                    break;
                }
                case "htmltopdf": {
                    ServiceFactory.setPDFGService(null);
                    break;
                }
                case "awslambda": {
                    ServiceFactory.setLambdaService(null);
                    break;
                }
                case "graphqlclient": {
                    ServiceFactory.setGraphQLClientService(null);
                    break;
                }
                case "gcpfirestore": {
                    ServiceFactory.setFirestoreService(null);
                    GCPServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.FIRESTORE);
                    break;
                }
                case "gcppubsub": {
                    ServiceFactory.setPubSubService(null);
                    GCPServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.PUBSUB);
                    break;
                }
                case "gcpstorage": {
                    ServiceFactory.setStorageService(null);
                    GCPServiceFactory.unregisterServiceProducer((CloudServiceName)CloudServiceName.STORAGE);
                    break;
                }
                case "msgraph": {
                    ServiceFactory.setMsGraphService(null);
                }
            }
            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduleuninstalled", (Object)bundle), "success");
        }
        catch (ServiceFactory.ServiceNotAvailableException sne) {
            ModulesServlet.addMsg(msgs, ModulesServlet.getUninstalledExcMsg(bundle), "error");
            return;
        }
    }

    private static boolean checkRedisSessionStorage(String bundle, Map<String, String> msgs) {
        if (!FelixUtil.invokedFromClient || !bundle.equalsIgnoreCase("redissessionstorage")) {
            return false;
        }
        String file = FelixUtil.libFolder + File.separator + "neo-runtime.xml";
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = null;
        try {
            source = new InputSource(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
            return false;
        }
        try {
            Vector v = (Vector)deserializer.deserialize(source);
            ConfigMap map = (ConfigMap)v.elementAt(14);
            String storage = ((String)map.get((Object)"sessionStorage")).toLowerCase();
            if (storage.equals("redis")) {
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.redissessionstorage"), "error");
                return true;
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
        return false;
    }

    private static String getUninstalledExcMsg(String bundle) {
        return RB.getString(ModulesServlet.class, (String)"ModulesServlet.alreadyuninstalled", (Object)bundle);
    }

    private void installBundle(RdsRequest rdreq) throws Exception {
        String bundles = rdreq.getMetaString(1).toLowerCase();
        ModulesServlet.installBundle(bundles, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeToBeInstalledBundles(String commaBundles) {
        OutputStreamWriter fw = null;
        FileReader fr = null;
        String toInstallBundlesPath = ModulesServlet.getServerLibPath() + File.separator + "toInstallBundles.txt";
        if (lambdaMode) {
            toInstallBundlesPath = ModulesServlet.getServerLibPath() + File.separator + "installedBundles.txt";
        }
        try {
            fr = new FileReader(toInstallBundlesPath);
            Properties bundlesProps = new Properties();
            bundlesProps.load(fr);
            String existingPackages = bundlesProps.getProperty("packages");
            fw = new FileWriter(toInstallBundlesPath);
            if (existingPackages == null) {
                bundlesProps.put("packages", commaBundles);
            } else {
                commaBundles = existingPackages + "," + (String)commaBundles;
                commaBundles = ModulesServlet.removeDuplicates((String)commaBundles);
                bundlesProps.put("packages", commaBundles);
            }
            bundlesProps.store(fw, "");
        }
        catch (IOException e) {
            if (FelixUtil.invokedFromClient) {
                ModulesServlet.printError(e.getMessage());
            } else {
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
            }
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    if (FelixUtil.invokedFromClient) {
                        ModulesServlet.printError(e.getMessage());
                    }
                    CFLogs.SERVER_LOG.error((Object)e.getMessage());
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    if (FelixUtil.invokedFromClient) {
                        ModulesServlet.printError(e.getMessage());
                    }
                    CFLogs.SERVER_LOG.error((Object)e.getMessage());
                }
            }
        }
        if (!lambdaMode) {
            String[] bundlesSplit;
            String downloadPath = ModulesServlet.getServerRoot() + "/../bundles";
            String dependsFilePathTo = downloadPath + File.separator + "bundlesdependency.json";
            try {
                FelixUtil.downloadBundleFromCFDownloadRepository(dependsFilePathTo, "bundlesdependency.json");
            }
            catch (Exception e) {
                ModulesServlet.printError(e.getMessage());
            }
            for (String bun : bundlesSplit = ((String)commaBundles).split(",")) {
                String version;
                if (bun.length() == 0) continue;
                bun = bun.trim();
                String[] iSplit = bun.split(":");
                String bundle = iSplit[0];
                if (iSplit.length != 2 || (version = iSplit[1]).equals("UNINSTALLED")) continue;
                try {
                    FelixUtil.downloadDependencies(bundle, ModulesServlet.getServerLibPath(), version);
                }
                catch (Exception e) {
                    ModulesServlet.printError(e.getMessage());
                }
            }
        }
        return commaBundles;
    }

    public static ModulesStatus updateAllBundles(int id) throws Exception {
        List<CFBundle> cfbundles = FelixUtil.getListOfLatestVersionedBundlesOfInstalledBundles();
        Object commaBundles = "";
        for (CFBundle cfbundle : cfbundles) {
            commaBundles = (String)commaBundles + cfbundle.getName() + ":" + cfbundle.getCurrentVersion() + ",";
        }
        if (((String)commaBundles).endsWith(",")) {
            commaBundles = ((String)commaBundles).substring(0, ((String)commaBundles).length() - 1);
        }
        return ModulesServlet.installBundle((String)commaBundles, id);
    }

    public static ModulesStatus installBundle(String commaBundles) throws Exception {
        return ModulesServlet.installBundle(commaBundles, 0);
    }

    public static ModulesStatus installBundle(String commaBundles, int id) throws Exception {
        return ModulesServlet.installBundle(commaBundles, id, false);
    }

    public static int getUpdateLevel() {
        int currentServerUpdateLevel = 0;
        currentServerUpdateLevel = FelixUtil.invokedFromClient ? Integer.parseInt(Version.getUpdateLevel((String)ModulesServlet.getServerRoot(), (boolean)true)) : Integer.parseInt(Version.getUpdateLevel((String)ModulesServlet.getServerRoot()));
        return currentServerUpdateLevel;
    }

    public static ModulesStatus installBundle(String commaBundles, int id, boolean installLatestCoreUpdate) throws Exception {
        int serversAvailableLatestUpdate;
        ModulesStatus mStatus = new ModulesStatus();
        boolean isCoreServerUpdateApplied = false;
        HashMap<String, String> msgs = new HashMap<String, String>();
        mStatus.setLog(msgs);
        progressInstallAll.put(id, mStatus);
        boolean isServerRunning = ModulesServlet.isServerRunning();
        String initialListOfBundles = commaBundles = ModulesServlet.getVersionedBundles(commaBundles);
        int currentServerUpdateLevel = ModulesServlet.getUpdateLevel();
        int serverUpdateLevelRequired = FelixUtil.getServerUpdateLevelRequiredForInstall(commaBundles);
        String bundlesAtGivenUpdateLevel = FelixUtil.getBundlesThatRequireServerAtGivenUpdateLevel(commaBundles, serverUpdateLevelRequired);
        if (installLatestCoreUpdate && (serversAvailableLatestUpdate = FelixUtil.getLatestUpdateLevel()) > 0 && serversAvailableLatestUpdate > currentServerUpdateLevel) {
            serverUpdateLevelRequired = serversAvailableLatestUpdate;
            isCoreServerUpdateApplied = true;
        }
        List installedUpdateLevelsInAscOrder = UpdateUtil.getInstalledUpdateLevelsInAscOrder((String)ModulesServlet.getServerRoot());
        int installedUpdatesSize = installedUpdateLevelsInAscOrder.size();
        boolean canBeDowngraded = false;
        int previousUpdateLevel = 0;
        if (installedUpdatesSize >= 2) {
            previousUpdateLevel = (Integer)installedUpdateLevelsInAscOrder.get(installedUpdatesSize - 2);
        }
        if (currentServerUpdateLevel != previousUpdateLevel) {
            canBeDowngraded = ModulesServlet.areBundlesGivenDowngradableFromCurrentUpdateLevel(commaBundles, currentServerUpdateLevel, previousUpdateLevel);
        }
        if (canBeDowngraded) {
            serverUpdateLevelRequired = previousUpdateLevel;
            commaBundles = ModulesServlet.getListOfBundlesForUpgradeOrDowngrade(commaBundles, serverUpdateLevelRequired);
            commaBundles = ModulesServlet.getDependentCFBundles(commaBundles, true, true);
            if (!_isStandalone) {
                if (serverUpdateLevelRequired < currentServerUpdateLevel) {
                    String message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.corehotfixdowngrade.jee", (Object)serverUpdateLevelRequired, (Object)currentServerUpdateLevel);
                    ModulesServlet.printMessage(message);
                } else {
                    ModulesServlet.logAllInstallingModule(commaBundles);
                    ModulesServlet.storeToBeInstalledBundles(commaBundles);
                }
                return mStatus;
            }
            ModulesServlet.logAllInstallingModule(commaBundles);
            message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulecorehotfixdowngrade", (Object)bundlesAtGivenUpdateLevel, (Object)serverUpdateLevelRequired, (Object)currentServerUpdateLevel);
            if (initialListOfBundles.split(",").length > 1) {
                message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulescorehotfixdowngrade", (Object)bundlesAtGivenUpdateLevel, (Object)serverUpdateLevelRequired, (Object)currentServerUpdateLevel);
            }
            ModulesServlet.printMessage(message);
            String downgradeNote = RB.getString(ModulesServlet.class, (String)"ModulesServlet.corehotfixdowngradenote");
            ModulesServlet.printMessage(downgradeNote);
            String dependentBundlesDowngradeNote = ModulesServlet.getDependentBundlesMessage(initialListOfBundles, commaBundles, serverUpdateLevelRequired, CoreHotfixAction.DOWNGRADE);
            confirm = ModulesServlet.getUserConfirmation(dependentBundlesDowngradeNote);
            if (!confirm) {
                return mStatus;
            }
            ModulesServlet.storeToBeInstalledBundles(commaBundles);
            isCoreServerUpdateApplied = true;
            FelixUtil.uninstallGivenHotfixUpdateLevel(currentServerUpdateLevel, previousUpdateLevel);
        } else if (currentServerUpdateLevel < serverUpdateLevelRequired) {
            commaBundles = ModulesServlet.getListOfBundlesForUpgradeOrDowngrade(commaBundles, serverUpdateLevelRequired);
            commaBundles = ModulesServlet.getDependentCFBundles(commaBundles, true, true);
            if (!_isStandalone) {
                String message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.corehotfixupgrade.jee", (Object)serverUpdateLevelRequired, (Object)currentServerUpdateLevel);
                if (FelixUtil.invokedFromClient) {
                    System.out.println(message);
                } else {
                    FelixUtil.auditLog(message);
                }
                return mStatus;
            }
            ModulesServlet.logAllInstallingModule(commaBundles);
            message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulecorehotfixupgrade", (Object)bundlesAtGivenUpdateLevel, (Object)serverUpdateLevelRequired, (Object)currentServerUpdateLevel);
            if (bundlesAtGivenUpdateLevel.split(",").length > 1) {
                message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulescorehotfixupgrade", (Object)bundlesAtGivenUpdateLevel, (Object)serverUpdateLevelRequired, (Object)currentServerUpdateLevel);
            }
            if (installLatestCoreUpdate) {
                message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.corehotfixupgrade", (Object)serverUpdateLevelRequired, (Object)currentServerUpdateLevel);
            }
            ModulesServlet.printMessage(message);
            String upgradeNote = RB.getString(ModulesServlet.class, (String)"ModulesServlet.corehotfixupgradenote");
            ModulesServlet.printMessage(upgradeNote);
            String dependentBundlesUpgradeNote = ModulesServlet.getDependentBundlesMessage(initialListOfBundles, commaBundles, serverUpdateLevelRequired, CoreHotfixAction.UPGRADE);
            confirm = ModulesServlet.getUserConfirmation(dependentBundlesUpgradeNote);
            if (!confirm) {
                return mStatus;
            }
            ModulesServlet.storeToBeInstalledBundles(commaBundles);
            isCoreServerUpdateApplied = true;
            String updatesURL = "";
            updatesURL = FelixUtil.getUpdatesURL(ModulesServlet.getServerRoot());
            String[] updatesData = FelixUtil.getcoreServerUpdatesData(updatesURL, serverUpdateLevelRequired);
            if (updatesData == null || updatesData != null && updatesData[3] == null) {
                String errorMsg = RB.getString(FelixUtil.class, (String)"FelixUtil.updatenotfound", (Object)serverUpdateLevelRequired, (Object)updatesURL);
                if (FelixUtil.invokedFromClient) {
                    ModulesServlet.printError(errorMsg);
                } else {
                    ModulesServlet.addMsg(msgs, errorMsg, "error");
                }
                mStatus.setErrors((String)msgs.get("error"));
                return mStatus;
            }
            FelixUtil.downloadAndInstallCoreHotfix(serverUpdateLevelRequired);
        }
        commaBundles = ModulesServlet.getOrderedBundles(commaBundles, false);
        String[] bundlesSplit = commaBundles.split(",");
        ArrayList<String> sucBundles = new ArrayList<String>();
        if (isCoreServerUpdateApplied) {
            int retrycount = 0;
            if (FelixUtil.invokedFromClient) {
                System.out.print(RB.getString(ModulesServlet.class, (String)"ModulesServlet.startingserver2"));
                System.out.println();
                System.exit(0);
            }
            int isServerStartComplete = ModulesServlet.isServerStartComplete();
            while (retrycount < 50 && isServerStartComplete == 0) {
                System.out.print(" .");
                Thread.sleep(1500L);
                isServerStartComplete = ModulesServlet.isServerStartComplete();
                ++retrycount;
            }
            if (isServerStartComplete != 0 || retrycount >= 50) {
                System.out.println();
                FelixUtil.loadCFBundles(ModulesServlet.getServerLibPath(), true);
                List<CFBundle> bundlesWithUpdates = FelixUtil.getListOfLatestVersionOfEachBundle();
                for (String bun : bundlesSplit) {
                    if (bun.length() == 0) continue;
                    bun = bun.trim();
                    iSplit = bun.split(":");
                    bundle = iSplit[0];
                    version = "0.0.1-SNAPSHOT";
                    if (iSplit.length == 1) {
                        for (CFBundle bundleUpd : bundlesWithUpdates) {
                            if (!bundleUpd.getName().equals(bundle)) continue;
                            version = bundleUpd.getCurrentVersion();
                            break;
                        }
                    }
                    if (iSplit.length > 1) {
                        version = iSplit[1];
                    }
                    try {
                        boolean status = FelixUtil.isModuleInstalled(bundle, version);
                        if (status) {
                            sucBundles.add(bundle);
                            continue;
                        }
                        ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotinstalled", (Object)bundle), "error");
                    }
                    catch (Throwable e) {
                        if (bundlesSplit.length == 1) {
                            ModulesServlet.addMsg(msgs, e.getMessage(), "error");
                        }
                        ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotinstalled", (Object)bundle) + "Error:" + e.getMessage(), "error");
                    }
                }
            }
        } else if (currentServerUpdateLevel >= serverUpdateLevelRequired) {
            commaBundles = ModulesServlet.getDependentCFBundles(commaBundles, true, true);
            commaBundles = ModulesServlet.getOrderedBundles(commaBundles, false);
            bundlesSplit = commaBundles.split(",");
            if (!isServerRunning) {
                ModulesServlet.storeToBeInstalledBundles(commaBundles);
                for (String bun : bundlesSplit) {
                    if (bun.length() == 0) continue;
                    bun = bun.trim();
                    String[] iSplit = bun.split(":");
                    String bundle = iSplit[0];
                    String version = iSplit[1];
                    ModulesServlet.installBundle(bundle, version, msgs);
                }
            } else {
                ModulesServlet.logAllInstallingModule(commaBundles);
                if (!FelixUtil.invokedFromClient) {
                    ModulesServlet.uninstallBundle(commaBundles);
                }
                int count = 0;
                int totalCount = bundlesSplit.length;
                if (bundlesSplit.length > 10 && FelixUtil.invokedFromClient) {
                    int time = bundlesSplit.length * 20 / 60;
                    ModulesServlet.printInfo(RB.getString(ModulesServlet.class, (String)"ModulesServlet.timetoinstall", (Object)("" + bundlesSplit.length), (Object)("" + time)));
                }
                for (String bun : bundlesSplit) {
                    block51: {
                        if (bun.length() == 0) continue;
                        float perc = ++count * 100 / totalCount;
                        progressInstallAll.get(id).setComplete(perc);
                        bun = bun.trim();
                        iSplit = bun.split(":");
                        bundle = iSplit[0];
                        version = iSplit[1];
                        if (bundle.equals("adminapi") && FelixUtil.isModuleInstalled("adminapi") || bundle.equals("administrator") && FelixUtil.isModuleInstalled("administrator") || bundle.equals("axis") && FelixUtil.isModuleInstalled("axis")) {
                            ModulesServlet.storeToBeInstalledBundles(bun);
                            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.restartserver", (Object)bundle, (Object)version), "error");
                            continue;
                        }
                        try {
                            boolean status = ModulesServlet.installBundle(bundle, version, msgs);
                            if (!status) break block51;
                            sucBundles.add(bundle);
                        }
                        catch (Throwable e) {
                            if (bundlesSplit.length == 1) {
                                ModulesServlet.addMsg(msgs, e.getMessage(), "error");
                            }
                            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotinstalled", (Object)bundle) + "Error:" + e.getMessage(), "error");
                            continue;
                        }
                    }
                    if (bundlesSplit.length > 10 && FelixUtil.invokedFromClient) {
                        ModulesServlet.printInfo2(RB.getString(ModulesServlet.class, (String)"ModulesServlet.numbermodulesinstalled", (Object)("" + bundlesSplit.length), (Object)("" + count)));
                    }
                    Thread.sleep(500L);
                }
            }
        } else {
            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.packagesnotinstalled"), "error");
            mStatus.setErrors((String)msgs.get("error"));
            mStatus.setInfo((String)msgs.get("success"));
            return mStatus;
        }
        Object sucBundlesStr = "";
        for (String b : sucBundles) {
            sucBundlesStr = (String)sucBundlesStr + b + ",";
        }
        if (((String)sucBundlesStr).endsWith(",")) {
            sucBundlesStr = ((String)sucBundlesStr).substring(0, ((String)sucBundlesStr).length() - 1);
        }
        if (msgs.containsKey("success") && !isServerRunning) {
            if (((String)sucBundlesStr).split(",").length > 1) {
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulesdependenciesinfo", (Object)sucBundlesStr), "success");
            } else {
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduledependenciesinfo", (Object)sucBundlesStr), "success");
            }
        }
        mStatus.setSuccessfullyInstalledModules((String)sucBundlesStr);
        mStatus.setErrors((String)msgs.get("error"));
        mStatus.setInfo((String)msgs.get("success"));
        return mStatus;
    }

    public static void logAllInstallingModule(String bundles) {
        ModulesServlet.printMessage(RB.getString(ModulesServlet.class, (String)"ModulesServlet.scaninfo1", (Object)bundles));
    }

    public static String setupPreInstallationSteps(String typeOfUpdate) {
        List installedUpdateLevelsInAscOrder = UpdateUtil.getInstalledUpdateLevelsInAscOrder((String)ModulesServlet.getServerRoot());
        int installedUpdatesSize = installedUpdateLevelsInAscOrder.size();
        int previousUpdateLevel = 0;
        if (installedUpdatesSize >= 2) {
            previousUpdateLevel = (Integer)installedUpdateLevelsInAscOrder.get(installedUpdatesSize - 2);
        }
        return ModulesServlet.setupPreInstallationSteps(null, previousUpdateLevel);
    }

    public static String setupPreInstallationSteps(String commaBundles, int serverUpdateLevelRequired) {
        commaBundles = ModulesServlet.getListOfBundlesForUpgradeOrDowngrade(commaBundles, serverUpdateLevelRequired);
        commaBundles = ModulesServlet.getDependentCFBundles(commaBundles, true, true);
        return ModulesServlet.storeToBeInstalledBundles(commaBundles);
    }

    public static String getListOfBundlesForDowngrade(String commaBundles) {
        int updateLevelToConsider = 0;
        List installedUpdateLevelsInAscOrder = UpdateUtil.getInstalledUpdateLevelsInAscOrder((String)ModulesServlet.getServerRoot());
        int installedUpdatesSize = installedUpdateLevelsInAscOrder.size();
        if (installedUpdatesSize >= 2) {
            updateLevelToConsider = (Integer)installedUpdateLevelsInAscOrder.get(installedUpdatesSize - 2);
        }
        return ModulesServlet.getListOfBundlesForUpgradeOrDowngrade(commaBundles, updateLevelToConsider);
    }

    public static List<CFBundle> getUpgradeDowngradeAffectedBundles(int currentUpdatelevel, int serverUpdateLevelRequired) {
        ArrayList<CFBundle> modulesToBeChanged = new ArrayList<CFBundle>();
        if (currentUpdatelevel == serverUpdateLevelRequired) {
            return modulesToBeChanged;
        }
        List<String> installedBundles = FelixUtil.getInstalledModules();
        Map<String, CFBundle> installedBundlesMap = FelixUtil.getInstalledBundlesMap();
        List<CFBundle> bundlesAtUpdateLevel = FelixUtil.getListOfLatestVersionedBundlesOfGivenUpdate(serverUpdateLevelRequired);
        for (String installedBundle : installedBundles) {
            for (CFBundle bundle : bundlesAtUpdateLevel) {
                int minSerVersionRequiredInstalled;
                int minSerVersionRequiredDesired;
                if (bundle == null || !bundle.getName().equals(installedBundle) || (minSerVersionRequiredDesired = bundle.getMinimumCoreServerUpdateRequired()) == (minSerVersionRequiredInstalled = installedBundlesMap.get(installedBundle).getMinimumCoreServerUpdateRequired())) continue;
                modulesToBeChanged.add(bundle);
            }
        }
        return modulesToBeChanged;
    }

    public static boolean areBundlesGivenCompatibleWithCurrentUpdateLevel(String commaBundles, int currentServerUpdateLevel) {
        String[] bundlesSplit;
        List<CFBundle> latestVersionedBundlesOfCurrentUpdate = FelixUtil.getListOfLatestVersionedBundlesOfGivenUpdate(currentServerUpdateLevel);
        if (commaBundles == null) {
            commaBundles = "";
        }
        commaBundles = ModulesServlet.getOrderedBundles(commaBundles, false);
        for (String bun : bundlesSplit = commaBundles.split(",")) {
            if (bun.length() == 0) continue;
            bun = bun.trim();
            String[] iSplit = bun.split(":");
            String bundleName = iSplit[0];
            String updVersion = FelixUtil.getDefaultVersion();
            if (iSplit.length > 1) {
                updVersion = iSplit[1];
            }
            double bundleVersionCurr = 0.0;
            double bundleVersionGiven = FelixUtil.getVersionAsNumber(updVersion);
            for (CFBundle latestBundleUpd : latestVersionedBundlesOfCurrentUpdate) {
                if (!latestBundleUpd.getName().equals(bundleName)) continue;
                bundleVersionCurr = FelixUtil.getVersionAsNumber(latestBundleUpd.getCurrentVersion());
                break;
            }
            if (bundleVersionCurr == bundleVersionGiven) continue;
            return false;
        }
        return true;
    }

    public static boolean areBundlesGivenDowngradableFromCurrentUpdateLevel(String commaBundles, int currentServerUpdateLevel, int previousUpdateLevel) {
        String[] bundlesSplit;
        List<CFBundle> latestVersionedBundlesOfCurrentUpdate = FelixUtil.getListOfLatestVersionedBundlesOfGivenUpdate(currentServerUpdateLevel);
        List<CFBundle> latestVersionedBundlesOfPreviousUpdate = FelixUtil.getListOfLatestVersionedBundlesOfGivenUpdate(previousUpdateLevel);
        if (commaBundles == null) {
            commaBundles = "";
        }
        commaBundles = ModulesServlet.getOrderedBundles(commaBundles, false);
        for (String bun : bundlesSplit = commaBundles.split(",")) {
            if (bun.length() == 0) continue;
            bun = bun.trim();
            String[] iSplit = bun.split(":");
            String bundleName = iSplit[0];
            String updVersion = FelixUtil.getDefaultVersion();
            if (iSplit.length > 1) {
                updVersion = iSplit[1];
            }
            double bundleVersionCurr = 0.0;
            double bundleVersionPrev = 0.0;
            double bundleVersionGiven = FelixUtil.getVersionAsNumber(updVersion);
            block1: for (CFBundle latestBundleUpd : latestVersionedBundlesOfCurrentUpdate) {
                if (!latestBundleUpd.getName().equals(bundleName)) continue;
                bundleVersionCurr = FelixUtil.getVersionAsNumber(latestBundleUpd.getCurrentVersion());
                bundleVersionPrev = 0.0;
                for (CFBundle prevBundleUpd : latestVersionedBundlesOfPreviousUpdate) {
                    if (!prevBundleUpd.getName().equals(bundleName)) continue;
                    bundleVersionPrev = FelixUtil.getVersionAsNumber(prevBundleUpd.getCurrentVersion());
                    break block1;
                }
            }
            if (bundleVersionCurr > bundleVersionPrev && bundleVersionGiven == bundleVersionPrev) continue;
            return false;
        }
        return true;
    }

    public static String getListOfBundlesForUpgradeOrDowngrade(String commaBundles, int serverUpdateLevelRequired) {
        String[] givenBundlesSplit;
        List<CFBundle> latestVersionedBundlesOfGivenUpdate = FelixUtil.getListOfLatestVersionedBundlesOfGivenUpdate(serverUpdateLevelRequired);
        if (commaBundles == null) {
            commaBundles = "";
        }
        ArrayList<String> commaBundlesList = new ArrayList<String>();
        for (String bun : givenBundlesSplit = ((String)commaBundles).split(",")) {
            String[] iSplit = bun.split(":");
            String bundleName = iSplit[0];
            commaBundlesList.add(bundleName);
        }
        List<CFBundle> affectedBundles = ModulesServlet.getUpgradeDowngradeAffectedBundles(ModulesServlet.getUpdateLevel(), serverUpdateLevelRequired);
        for (CFBundle affectedBundle : affectedBundles) {
            if (commaBundlesList.contains(affectedBundle.getName())) continue;
            commaBundles = (String)commaBundles + "," + affectedBundle.getName() + ":" + affectedBundle.getCurrentVersion();
        }
        if (((String)commaBundles).startsWith(",")) {
            commaBundles = ((String)commaBundles).substring(1, ((String)commaBundles).length());
        }
        commaBundles = ModulesServlet.getOrderedBundles((String)commaBundles, false);
        String[] bundlesSplit = ((String)commaBundles).split(",");
        Object commaBundlesDerived = "";
        block2: for (String bun : bundlesSplit) {
            if (bun.length() == 0) continue;
            bun = bun.trim();
            String[] iSplit = bun.split(":");
            String bundleName = iSplit[0];
            String updVersion = FelixUtil.getDefaultVersion();
            if (iSplit.length == 1) {
                for (CFBundle latestBundleUpd : latestVersionedBundlesOfGivenUpdate) {
                    if (!latestBundleUpd.getName().equals(bundleName)) continue;
                    updVersion = latestBundleUpd.getCurrentVersion();
                    commaBundlesDerived = (String)commaBundlesDerived + latestBundleUpd.getName() + ":" + updVersion + ",";
                    continue block2;
                }
                continue;
            }
            commaBundlesDerived = (String)commaBundlesDerived + bun + ",";
        }
        if (((String)commaBundlesDerived).endsWith(",")) {
            commaBundlesDerived = ((String)commaBundlesDerived).substring(0, ((String)commaBundlesDerived).length() - 1);
        }
        return commaBundlesDerived;
    }

    public static String getVersionedBundles(String commaBundles) {
        List<CFBundle> bundlesWithUpdates = FelixUtil.getListOfLatestVersionOfEachBundle();
        Object commaBundlesVersioned = "";
        for (String bun : commaBundles.split(",")) {
            if (bun.length() == 0) continue;
            bun = bun.trim();
            String[] iSplit = bun.split(":");
            String bundle = iSplit[0];
            String version = FelixUtil.getDefaultVersion();
            if (iSplit.length == 1) {
                for (CFBundle bundleUpd : bundlesWithUpdates) {
                    if (!bundleUpd.getName().equals(bundle)) continue;
                    version = bundleUpd.getCurrentVersion();
                    break;
                }
            } else if (iSplit.length > 1) {
                version = iSplit[1];
            }
            if (bundle.equals("felixclassloader")) continue;
            commaBundlesVersioned = bundle + ":" + version + "," + (String)commaBundlesVersioned;
        }
        if (((String)commaBundlesVersioned).endsWith(",")) {
            commaBundlesVersioned = ((String)commaBundlesVersioned).substring(0, ((String)commaBundlesVersioned).length() - 1);
        }
        return commaBundlesVersioned;
    }

    public static String getOrderedBundles(String commaBundles, boolean reverse) {
        Object bundlesOrdered = "";
        boolean image = false;
        boolean pdf = false;
        boolean document = false;
        boolean print = false;
        boolean htmltopdf = false;
        boolean ormsearch = false;
        boolean orm = false;
        boolean caching = false;
        boolean perfmon = false;
        boolean presentation = false;
        boolean adminapi = false;
        boolean administrator = false;
        boolean sharepoint = false;
        boolean axis = false;
        boolean report = false;
        HashMap<String, String> bundleNameVersion = new HashMap<String, String>();
        for (String bundle : commaBundles.split(",")) {
            String[] iSplit = bundle.split(":");
            String bundleName = iSplit[0];
            Object version = "";
            if (iSplit.length > 1) {
                version = ":" + iSplit[1];
            }
            bundleNameVersion.put(bundleName, (String)version);
            if (bundleName.startsWith("image")) {
                image = true;
                continue;
            }
            if (bundleName.equals("pdf")) {
                pdf = true;
                continue;
            }
            if (bundleName.equals("document")) {
                document = true;
                continue;
            }
            if (bundleName.equals("print")) {
                print = true;
                continue;
            }
            if (bundleName.equals("htmltopdf")) {
                htmltopdf = true;
                continue;
            }
            if (bundleName.equals("ormsearch")) {
                ormsearch = true;
                continue;
            }
            if (bundleName.equals("orm")) {
                orm = true;
                continue;
            }
            if (bundleName.equals("caching")) {
                caching = true;
                continue;
            }
            if (bundleName.equals("pmtagent")) {
                perfmon = true;
                continue;
            }
            if (bundleName.equals("presentation")) {
                presentation = true;
                continue;
            }
            if (bundleName.equals("adminapi")) {
                adminapi = true;
                continue;
            }
            if (bundleName.equals("administrator")) {
                administrator = true;
                continue;
            }
            if (bundleName.equals("sharepoint")) {
                sharepoint = true;
                continue;
            }
            if (bundleName.equals("axis")) {
                axis = true;
                continue;
            }
            if (bundleName.equals("report")) {
                report = true;
                continue;
            }
            bundlesOrdered = (String)bundlesOrdered + bundle + ",";
        }
        if (!reverse) {
            if (htmltopdf) {
                bundlesOrdered = "htmltopdf" + (String)bundleNameVersion.get("htmltopdf") + "," + (String)bundlesOrdered;
            }
            if (print) {
                bundlesOrdered = "print" + (String)bundleNameVersion.get("print") + "," + (String)bundlesOrdered;
            }
            if (pdf) {
                bundlesOrdered = "pdf" + (String)bundleNameVersion.get("pdf") + "," + (String)bundlesOrdered;
            }
            if (image) {
                bundlesOrdered = "image" + (String)bundleNameVersion.get("image") + "," + (String)bundlesOrdered;
            }
            if (presentation) {
                bundlesOrdered = "presentation" + (String)bundleNameVersion.get("presentation") + "," + (String)bundlesOrdered;
            }
            if (report) {
                bundlesOrdered = "report" + (String)bundleNameVersion.get("report") + "," + (String)bundlesOrdered;
            }
            if (document) {
                bundlesOrdered = "document" + (String)bundleNameVersion.get("document") + "," + (String)bundlesOrdered;
            }
            if (ormsearch) {
                bundlesOrdered = "ormsearch" + (String)bundleNameVersion.get("ormsearch") + "," + (String)bundlesOrdered;
            }
            if (orm) {
                bundlesOrdered = "orm" + (String)bundleNameVersion.get("orm") + "," + (String)bundlesOrdered;
            }
            if (perfmon) {
                bundlesOrdered = "pmtagent" + (String)bundleNameVersion.get("pmtagent") + "," + (String)bundlesOrdered;
            }
            if (caching) {
                bundlesOrdered = "caching" + (String)bundleNameVersion.get("caching") + "," + (String)bundlesOrdered;
            }
            if (administrator) {
                bundlesOrdered = "administrator" + (String)bundleNameVersion.get("administrator") + "," + (String)bundlesOrdered;
            }
            if (adminapi) {
                bundlesOrdered = "adminapi" + (String)bundleNameVersion.get("adminapi") + "," + (String)bundlesOrdered;
            }
            if (sharepoint) {
                bundlesOrdered = "sharepoint" + (String)bundleNameVersion.get("sharepoint") + "," + (String)bundlesOrdered;
            }
            if (axis) {
                bundlesOrdered = "axis" + (String)bundleNameVersion.get("axis") + "," + (String)bundlesOrdered;
            }
        } else {
            if (document) {
                bundlesOrdered = "document" + (String)bundleNameVersion.get("document") + "," + (String)bundlesOrdered;
            }
            if (report) {
                bundlesOrdered = "report" + (String)bundleNameVersion.get("report") + "," + (String)bundlesOrdered;
            }
            if (presentation) {
                bundlesOrdered = "presentation" + (String)bundleNameVersion.get("presentation") + "," + (String)bundlesOrdered;
            }
            if (image) {
                bundlesOrdered = "image" + (String)bundleNameVersion.get("image") + "," + (String)bundlesOrdered;
            }
            if (pdf) {
                bundlesOrdered = "pdf" + (String)bundleNameVersion.get("pdf") + "," + (String)bundlesOrdered;
            }
            if (print) {
                bundlesOrdered = "print" + (String)bundleNameVersion.get("print") + "," + (String)bundlesOrdered;
            }
            if (htmltopdf) {
                bundlesOrdered = "htmltopdf" + (String)bundleNameVersion.get("htmltopdf") + "," + (String)bundlesOrdered;
            }
            if (caching) {
                bundlesOrdered = "caching" + (String)bundleNameVersion.get("caching") + "," + (String)bundlesOrdered;
            }
            if (perfmon) {
                bundlesOrdered = "pmtagent" + (String)bundleNameVersion.get("pmtagent") + "," + (String)bundlesOrdered;
            }
            if (orm) {
                bundlesOrdered = "orm" + (String)bundleNameVersion.get("orm") + "," + (String)bundlesOrdered;
            }
            if (ormsearch) {
                bundlesOrdered = "ormsearch" + (String)bundleNameVersion.get("ormsearch") + "," + (String)bundlesOrdered;
            }
            if (adminapi) {
                bundlesOrdered = "adminapi" + (String)bundleNameVersion.get("adminapi") + "," + (String)bundlesOrdered;
            }
            if (administrator) {
                bundlesOrdered = "administrator" + (String)bundleNameVersion.get("administrator") + "," + (String)bundlesOrdered;
            }
            if (axis) {
                bundlesOrdered = "axis" + (String)bundleNameVersion.get("axis") + "," + (String)bundlesOrdered;
            }
            if (sharepoint) {
                bundlesOrdered = "sharepoint" + (String)bundleNameVersion.get("sharepoint") + "," + (String)bundlesOrdered;
            }
        }
        if (((String)bundlesOrdered).endsWith(",")) {
            bundlesOrdered = ((String)bundlesOrdered).substring(0, ((String)bundlesOrdered).length() - 1);
        }
        return bundlesOrdered;
    }

    public static void checkInstalledStatusOfBundles(String bundles, String sucBundlesStr) {
        boolean isServerRunning = false;
        try {
            isServerRunning = ModulesServlet.isServerRunning();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        List<String> installedBundlesList = ModulesServlet.getInstalledBundlesListFromFelixCache();
        if (isServerRunning) {
            if (sucBundlesStr.split(",").length > 1) {
                System.out.println(RB.getString(ModulesServlet.class, (String)"ModulesServlet.checkingstatus"));
            }
            int attempts = 20;
            for (String bun : sucBundlesStr.split(",")) {
                String[] split = bun.split(":");
                if (!sucBundlesStr.contains(bun = split[0])) continue;
                String b = bun;
                if (b.equals("redissessionstorage")) {
                    b = "sessionstorage";
                }
                if (b.equals("odbc")) {
                    b = "sequelink";
                }
                if (b.equals("chart")) {
                    b = "graph";
                }
                if (b.equals("pmtagent")) {
                    b = "perfmon";
                }
                boolean hasModuleInstalled = installedBundlesList.contains(b);
                int attempt = 0;
                while (!hasModuleInstalled && attempt < attempts) {
                    FelixUtil.auditLog("Package " + bun + " not installed yet. Checking status after 1 second again. Attempt number : " + ++attempt + ".Currently installed packages : " + installedBundlesList);
                    try {
                        Thread.sleep(1000L);
                        if (bun.equals("ajax") || bun.equals("axis")) {
                            try {
                                if (attempt == 1) {
                                    Thread.sleep(5000L);
                                }
                                FelixUtil.loadCFBundles(null, true);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (FelixUtil.listBundlesStr().contains("ajax") && bun.equals("ajax")) {
                                installedBundlesList.add(bun);
                            }
                            if (FelixUtil.listBundlesStr().contains("axis") && bun.equals("axis")) {
                                installedBundlesList.add(bun);
                            }
                        } else {
                            installedBundlesList = ModulesServlet.getInstalledBundlesListFromFelixCache();
                        }
                        hasModuleInstalled = installedBundlesList.contains(b);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!hasModuleInstalled) {
                    ModulesServlet.printError(RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotinstalledserver", (Object)bun));
                    continue;
                }
                ModulesServlet.printInfo(RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduleinstalledserver", (Object)bun));
            }
        }
    }

    private static List<String> getInstalledBundlesListFromFelixCache() {
        ArrayList<String> installedBundlesList = new ArrayList<String>();
        String felixCache = FelixUtil.getFelixCache(FelixUtil.libFolder);
        File felixCacheFolder = new File(felixCache);
        if (felixCacheFolder.exists()) {
            String[] installedBundles;
            block7: for (String installedBundle : installedBundles = felixCacheFolder.list()) {
                String infoFile = felixCache + File.separator + installedBundle + File.separator + "bundle.info";
                if (!new File(infoFile).exists()) continue;
                String installedBundlePath = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(infoFile));){
                    String line = "";
                    int counter = 0;
                    while (line != null) {
                        line = reader.readLine();
                        if (counter == 1) {
                            installedBundlePath = line.substring(5, line.length());
                        }
                        if (installedBundlePath != null) {
                            installedBundlePath = installedBundlePath.substring(installedBundlePath.lastIndexOf("/") + 1);
                            installedBundlesList.add(installedBundlePath.split("-")[0]);
                            continue block7;
                        }
                        ++counter;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return installedBundlesList;
    }

    public static boolean isServerStartComplete() throws Exception {
        if (lambdaMode) {
            return false;
        }
        String file = CFService.getServerStatusFile();
        if (!new File(file).exists()) {
            return false;
        }
        String contents = new String(Files.readAllBytes(Paths.get(file, new String[0])));
        Properties prop = new Properties();
        prop.load(new StringReader(contents));
        if (prop.containsKey("status")) {
            String status = prop.getProperty("status");
            return status.equals("started");
        }
        return false;
    }

    public static int serverStatusCheckTimeOut() {
        String timeOutS = System.getProperty("TIMEOUT_SERVERSTATUS_CHECK");
        int timeOutN = 5;
        if (timeOutS != null && timeOutS.length() > 0) {
            try {
                timeOutN = Integer.parseInt(timeOutS);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeOutN;
    }

    public static boolean isServerRunning() throws Exception {
        if (lambdaMode) {
            return false;
        }
        if (ServiceFactory.isRuntimeServiceInitialized()) {
            return true;
        }
        String cfScriptPath = ModulesServlet.getServerRoot() + "/bin/coldfusion";
        if (SystemInfo.isWindows()) {
            cfScriptPath = ModulesServlet.getServerRoot() + "\\bin\\coldfusion.exe";
        }
        if (new File(cfScriptPath).exists()) {
            String command;
            String classPathSep = ":";
            if (SystemInfo.isWindows()) {
                classPathSep = ";";
            }
            String exceutionResult = "";
            String javaPath = System.getProperty("java.home") + "/bin/java";
            if (javaPath.contains(" ")) {
                javaPath = "\"" + javaPath + "\"";
            }
            return (exceutionResult = FelixUtil.execute(command = javaPath + " -Dcoldfusion.home=" + ModulesServlet.getServerRoot() + " -classpath " + ModulesServlet.getServerRoot() + "/runtime/bin/tomcat-juli.jar" + classPathSep + ModulesServlet.getServerRoot() + "/bin/cf-bootstrap.jar com.adobe.coldfusion.bootstrap.Bootstrap -status", true, ModulesServlet.serverStatusCheckTimeOut())).toLowerCase().contains("server is running");
        }
        return ModulesServlet.isServerStartComplete();
    }

    private static void addMsg(Map<String, String> msgs, String msg, String type) {
        if (type.equals("error")) {
            if (FelixUtil.invokedFromClient) {
                ModulesServlet.printError(msg);
            }
        } else if (FelixUtil.invokedFromClient) {
            ModulesServlet.printInfo(msg);
        }
        Object m = msg;
        if (msgs.get(type) != null) {
            m = msgs.get(type) + (String)m;
        }
        msgs.put(type, (String)m + "\n\n");
    }

    private static void printMessage(String msg) {
        if (FelixUtil.invokedFromClient) {
            System.out.println(msg);
        } else {
            FelixUtil.auditLog(msg);
        }
    }

    public static void printError(String err) {
        FelixUtil.auditLog(err);
        if (FelixUtil.invokedFromClient) {
            System.out.print(Ansi.ansi().fgBrightRed().bold().a(err).newline().reset());
        }
    }

    public static void printInfo(String info) {
        FelixUtil.auditLog(info);
        if (FelixUtil.invokedFromClient) {
            System.out.print(Ansi.ansi((int)10).fgBrightGreen().a(info).newline().reset());
        }
    }

    public static void printInfo2(String info) {
        FelixUtil.auditLog(info);
        if (FelixUtil.invokedFromClient) {
            System.out.print(Ansi.ansi((int)10).fgBrightMagenta().a(info).newline().reset());
        }
    }

    public static ModulesStatus installBundle(String bundle, String version) throws Exception {
        Object bundleVersionForInstall = bundle + ":" + version;
        if (version == null || version != null && version.length() == 0) {
            bundleVersionForInstall = bundle;
        }
        return ModulesServlet.installBundle((String)bundleVersionForInstall);
    }

    public static String getServerRoot() {
        String libPath = FelixUtil.libFolder;
        Object rootPath = "";
        rootPath = libPath != null ? libPath + "/../" : CFService.getPath();
        if (lambdaMode) {
            rootPath = System.getProperty("CFUSION_HOME");
        }
        if (rootPath == null) {
            return null;
        }
        try {
            rootPath = new File((String)rootPath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rootPath;
    }

    public static boolean installBundle(String bundle, String version, Map<String, String> msgs) throws Exception {
        boolean status = false;
        List<CFBundle> cfbundles = null;
        try {
            if (version == null || version.equals("0.0.1-SNAPSHOT") || version.trim().length() == 0) {
                version = FelixUtil.getDefaultVersion();
            }
            boolean cValue = ServiceFactory.shouldForceInitialize;
            ServiceFactory.shouldForceInitialize = false;
            cfbundles = FelixUtil.listBundles();
            bundle = bundle.toLowerCase();
            boolean found = false;
            if (Boolean.getBoolean("LAMBDAMODE") && bundle.equals("felixclassloader")) {
                found = true;
                CFService.setupFelixclassloader();
            }
            for (CFBundle bun : cfbundles) {
                if (!bun.getName().equalsIgnoreCase(bundle) || !bun.getCurrentVersion().equalsIgnoreCase(version)) continue;
                found = true;
                if (lambdaMode && !bun.isLambdaSupport()) {
                    ModulesServlet.addMsg(msgs, bun.getName() + " package is not supported in AWS Serverless ColdFusion", "error");
                    return false;
                }
                if (!bun.getVersions().contains(version)) {
                    ModulesServlet.addMsg(msgs, "Version " + version + " is not available for the bundle " + bundle + ". Available versions are : " + bun.getVersions(), "error");
                    return false;
                }
                if (!bun.isInstalled()) break;
                if (bun.getCurrentVersion().equalsIgnoreCase(version)) {
                    ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.alreadyinstalled", (Object)bundle, (Object)version), "error");
                    return false;
                }
                ModulesServlet.uninstallBundle(bundle);
                break;
            }
            if (!found && version != null && version.length() > 0) {
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotfound", (Object)bundle), "error");
                return false;
            }
            if (bundle.equalsIgnoreCase("odbc") && !SystemInfo.isWindows()) {
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotapplicable", (Object)bundle), "error");
                return false;
            }
            switch (bundle) {
                case "presentation": {
                    CFService.setupPresentationService((String)version);
                    break;
                }
                case "spreadsheet": {
                    CFService.setupExcelService((String)version);
                    break;
                }
                case "chart": {
                    CFService.setupGraphing((String)version);
                    break;
                }
                case "databasecore": {
                    CFService.setupDatabasecoreService((String)version);
                    break;
                }
                case "pdf": {
                    CFService.setupPDF((String)version);
                    break;
                }
                case "document": {
                    CFService.setupDocument((String)version);
                    break;
                }
                case "print": {
                    CFService.setupPrint((String)version);
                    break;
                }
                case "ftp": {
                    CFService.setupFTPService((String)version);
                    break;
                }
                case "awss3": {
                    CFService.setupS3Service((String)version);
                    break;
                }
                case "azureblob": {
                    CFService.setupAzureBlobService((String)version);
                    break;
                }
                case "awssns": {
                    CFService.setupSNSService((String)version);
                    break;
                }
                case "awssqs": {
                    CFService.setupSQSService((String)version);
                    break;
                }
                case "azureservicebus": {
                    CFService.setupServiceBusService((String)version);
                    break;
                }
                case "awsdynamodb": {
                    CFService.setupDynamoDBService((String)version);
                    break;
                }
                case "oracle": {
                    CFService.setupOracleDriverService((String)version);
                    break;
                }
                case "mysql": {
                    CFService.setupMySQLDriverService((String)version);
                    break;
                }
                case "db2": {
                    CFService.setupDB2DriverService((String)version);
                    break;
                }
                case "informix": {
                    CFService.setupInformixDriverService((String)version);
                    break;
                }
                case "sqlserver": {
                    CFService.setupSQLServerDriverService((String)version);
                    break;
                }
                case "postgresql": {
                    CFService.setupPostgreSQLDriverService((String)version);
                    break;
                }
                case "exchange": {
                    CFService.setupExchangeService((String)version);
                    break;
                }
                case "odbc": {
                    CFService.setupSequeLinkODBC((String)version);
                    break;
                }
                case "corba": {
                    CFService.setupCorba((String)version);
                    break;
                }
                case "sharepoint": {
                    CFService.setupSharePointService((String)version);
                    break;
                }
                case "dotnet": {
                    String serviceStatus;
                    if (SystemInfo.isWindows() && (serviceStatus = FelixUtil.executeService("query", "ColdFusion 2025 .NET Service", true)) != null && !serviceStatus.contains("RUNNING")) {
                        ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.dotnetnotrunning", (Object)bundle), "error");
                    }
                    CFService.setupDotNetService((String)version);
                    break;
                }
                case "eventgateways": {
                    CFService.setupEventProcessor((String)version);
                    break;
                }
                case "search": {
                    CFService.setupSolr((String)version);
                    break;
                }
                case "java": {
                    CFService.setupLanguageService((String)version);
                    break;
                }
                case "cfmongodb": {
                    CFService.setupMongoDB((String)version);
                    break;
                }
                case "orm": {
                    CFService.setupORM((String)version);
                    break;
                }
                case "ormsearch": {
                    CFService.setupORMSearch((String)version);
                    break;
                }
                case "rest": {
                    CFService.setupJaxrs((String)version);
                    break;
                }
                case "feed": {
                    CFService.setupFeedService((String)version);
                    break;
                }
                case "derby": {
                    CFService.setupDerbyService((String)version);
                    break;
                }
                case "report": {
                    CFService.setupReportService((String)version);
                    break;
                }
                case "scheduler": {
                    CFService.setupCron((String)version);
                    break;
                }
                case "saml": {
                    CFService.setupSAMLService((String)version);
                    break;
                }
                case "debugger": {
                    CFService.setupDebugging((String)version);
                    break;
                }
                case "websocket": {
                    CFService.setupWebSocketService((String)version);
                    break;
                }
                case "awss3legacy": {
                    CFService.setupS3OldService((String)version);
                    break;
                }
                case "mail": {
                    CFService.setupMail((String)version);
                    break;
                }
                case "zip": {
                    CFService.setupZip((String)version);
                    break;
                }
                case "image": {
                    CFService.setupImageService((String)version);
                    break;
                }
                case "redissessionstorage": {
                    CFService.setupSessionStorageService((String)version);
                    break;
                }
                case "ajax": {
                    CFService.setupAjax((String)version);
                    break;
                }
                case "adminapi": {
                    CFService.setupAdminAPI((String)version);
                    break;
                }
                case "administrator": {
                    CFService.setupAdministrator((String)version);
                    break;
                }
                case "ccs": {
                    CFService.setupCCS((String)version);
                    break;
                }
                case "caching": {
                    CFService.setupCachingService((String)version);
                    break;
                }
                case "pmtagent": {
                    CFService.setupMonitoringService((String)version);
                    break;
                }
                case "axis": {
                    CFService.setupXmlrpc((String)version);
                    break;
                }
                case "htmltopdf": {
                    CFService.setupPDFGService((String)version);
                    break;
                }
                case "awslambda": {
                    CFService.setupAwsLambdaService((String)version);
                    break;
                }
                case "gcpfirestore": {
                    CFService.setupFirestoreService((String)version);
                    break;
                }
                case "gcppubsub": {
                    CFService.setupPubSubService((String)version);
                    break;
                }
                case "gcpstorage": {
                    CFService.setupStorageService((String)version);
                    break;
                }
                case "msgraph": {
                    CFService.setupMSGraphService((String)version);
                    break;
                }
                case "graphqlclient": {
                    CFService.setupGraphQLClientService((String)version);
                    if (null == CFService._path) break;
                    CFService.setupGraphQLConfigService();
                }
            }
            ServiceFactory.shouldForceInitialize = cValue;
            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduleinstalled", (Object)bundle, (Object)version), "success");
            status = true;
            if (Boolean.getBoolean("LAMBDAMODE") && !bundle.equals("felixclassloader") && !FelixUtil.isLambdaModuleInstalled("felixclassloader")) {
                HashMap<String, String> newMsgs = new HashMap<String, String>();
                ModulesServlet.installBundle("felixclassloader", null, newMsgs);
            }
        }
        catch (Throwable t) {
            for (CFBundle bun : cfbundles) {
                if (!bun.getName().equalsIgnoreCase(bundle) || !bun.getCurrentVersion().equalsIgnoreCase(version)) continue;
                bun.setInstalled(true);
                break;
            }
            if (!FelixUtil.invokedFromClient) {
                CFLogs.SERVER_LOG.error((Object)RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduleinstallerror2", (Object)bundle, (Object)t.getMessage()));
            }
            ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.moduleinstallerror2", (Object)bundle, (Object)t.getMessage()), "error");
            if (bundle.equals("odbc") && !FelixUtil.invokedFromClient) {
                String scriptPath = ServiceFactory.getRuntimeService().getRootDir().replace("\\", "/") + "/bin/cfpm.bat";
                ModulesServlet.addMsg(msgs, RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotinstalledprivuser", (Object)bundle, (Object)scriptPath), "error");
            }
            ModulesServlet.uninstallBundle(bundle);
        }
        return status;
    }

    public static String convertListToCommaBundles(List<CFBundle> cfbundles) {
        Object bundles = "";
        for (CFBundle bundle : cfbundles) {
            if (bundle.isInstalled()) continue;
            bundles = (String)bundles + bundle.getName() + ":" + bundle.getCurrentVersion() + ",";
        }
        if (((String)bundles).endsWith(",")) {
            bundles = ((String)bundles).substring(0, ((String)bundles).length() - 1);
        }
        return bundles;
    }

    public static int installBundles(List<CFBundle> cfbundles, boolean async) {
        return ModulesServlet.installBundles(cfbundles, async, false);
    }

    public static int installBundles(List<CFBundle> cfbundles, boolean async, final boolean installLatestCoreUpdate) {
        FelixUtil.invokedFromClient = true;
        if (CFService.felix != null) {
            FelixUtil.invokedFromClient = false;
        }
        String bundles = "";
        bundles = ModulesServlet.convertListToCommaBundles(cfbundles);
        if (bundles.length() == 0) {
            ModulesServlet.printError(RB.getString(ModulesServlet.class, (String)"ModulesServlet.allmodulesinstalled"));
            return -1;
        }
        final int id = progressInstallAll.size() + 1;
        final String bundlesFinal = bundles;
        if (async) {
            new Thread(){

                @Override
                public void run() {
                    ModulesServlet.handleInstallCommand(bundlesFinal, id, installLatestCoreUpdate);
                }
            }.start();
        } else {
            ModulesServlet.handleInstallCommand(bundles, id, installLatestCoreUpdate);
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return id;
    }

    public static int handleInstallBaseAllCommand(boolean async) {
        List<CFBundle> cfbundles = FelixUtil.getListOfDefaultVersionBundles();
        return ModulesServlet.installBundles(cfbundles, async);
    }

    public static int handleInstallAllCommand(boolean async) {
        List<CFBundle> cfbundles = FelixUtil.getListOfLatestVersionOfEachBundle();
        if (lambdaMode) {
            cfbundles.removeIf(bundle -> !bundle.isLambdaSupport());
        }
        return ModulesServlet.installBundles(cfbundles, async, true);
    }

    public static int handleUpdateAllCommand(boolean async) {
        List<CFBundle> cfbundles = FelixUtil.getListOfLatestVersionedBundlesOfInstalledBundles();
        return ModulesServlet.installBundles(cfbundles, async, true);
    }

    public static void waitForServerStart() {
        try {
            int retrycount;
            System.out.print(RB.getString(ModulesServlet.class, (String)"ModulesServlet.startingserver"));
            boolean isServerStartComplete = ModulesServlet.isServerStartComplete();
            for (retrycount = 0; retrycount < 50 && !isServerStartComplete; ++retrycount) {
                System.out.print(" .");
                Thread.sleep(1500L);
                isServerStartComplete = ModulesServlet.isServerStartComplete();
            }
            if (isServerStartComplete || retrycount >= 50) {
                System.out.println();
                FelixUtil.loadCFBundles(ModulesServlet.getServerLibPath(), true);
            }
        }
        catch (Exception e) {
            if (FelixUtil.invokedFromClient) {
                ModulesServlet.printError(e.getMessage());
            }
            FelixUtil.auditLog(e.getMessage());
        }
    }

    public static boolean updateCoreServerToLatestHotfix() {
        int currentServerUpdateLevel = ModulesServlet.getUpdateLevel();
        int latestAvailableServerUpdateLevel = 0;
        try {
            latestAvailableServerUpdateLevel = FelixUtil.getLatestUpdateLevel();
        }
        catch (Exception e) {
            if (FelixUtil.invokedFromClient) {
                ModulesServlet.printError(e.getMessage());
            } else {
                FelixUtil.auditLog(e.getMessage());
            }
            return false;
        }
        if (latestAvailableServerUpdateLevel > currentServerUpdateLevel) {
            if (!_isStandalone) {
                String message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.corehotfixupgrade.jee", (Object)latestAvailableServerUpdateLevel, (Object)currentServerUpdateLevel);
                if (FelixUtil.invokedFromClient) {
                    ModulesServlet.printInfo(message);
                } else {
                    FelixUtil.auditLog(message);
                }
                return false;
            }
            String message = RB.getString(ModulesServlet.class, (String)"ModulesServlet.corehotfixupgrade", (Object)latestAvailableServerUpdateLevel, (Object)currentServerUpdateLevel);
            if (FelixUtil.invokedFromClient) {
                ModulesServlet.printInfo(message);
            } else {
                FelixUtil.auditLog(message);
            }
            try {
                FelixUtil.downloadAndInstallCoreHotfix(latestAvailableServerUpdateLevel);
            }
            catch (Exception e) {
                if (FelixUtil.invokedFromClient) {
                    ModulesServlet.printError(e.getMessage());
                }
                FelixUtil.auditLog(e.getMessage());
            }
            return true;
        }
        return true;
    }

    public static int handleUpdateCommand(boolean async) {
        int currentServerUpdateLevel = ModulesServlet.getUpdateLevel();
        List<CFBundle> cfbundles = FelixUtil.getListOfLatestVersionedBundlesOfGivenUpdate(currentServerUpdateLevel);
        ArrayList<CFBundle> cfbundlesToInstall = new ArrayList<CFBundle>();
        List<String> allInstalledBundleNames = FelixUtil.getAllInstalledBundleNames();
        for (CFBundle cfbundle : cfbundles) {
            if (!allInstalledBundleNames.contains(cfbundle.getName()) || cfbundle.isInstalled()) continue;
            cfbundlesToInstall.add(cfbundle);
        }
        return ModulesServlet.installBundles(cfbundlesToInstall, async);
    }

    public static String handleInstallCommand(String bun) {
        int currentServerUpdateLevel = ModulesServlet.getUpdateLevel();
        String versionedBundles = FelixUtil.getLatestVersionedBundlesForGivenBundlesAtGivenUpdate(bun, currentServerUpdateLevel);
        return ModulesServlet.handleInstallCommand(versionedBundles, 0);
    }

    public static int handleInstallCommand(String bun, boolean async) {
        final int id = progressInstallAll.size() + 1;
        final String bundlesFinal = bun;
        if (async) {
            new Thread(){

                @Override
                public void run() {
                    ModulesServlet.handleInstallCommand(bundlesFinal, id);
                }
            }.start();
        } else {
            ModulesServlet.handleInstallCommand(bun, id);
        }
        return id;
    }

    public static String getServerLibPath() {
        String libPath = null;
        if (ServiceFactory.isRuntimeServiceInitialized()) {
            libPath = ServiceFactory.getRuntimeService().getLibDir();
        }
        if (libPath == null) {
            libPath = FelixUtil.libFolder;
        }
        return libPath;
    }

    private static String handleInstallCommand(String bun, int id) {
        return ModulesServlet.handleInstallCommand(bun, id, false);
    }

    private static String handleInstallCommand(String bun, int id, boolean installLatestCoreUpdate) {
        Object resp = "";
        Object sucBundlesStr = null;
        String depBundles = "";
        try {
            depBundles = ModulesServlet.getDependentCFBundles(bun, false, false);
            sucBundlesStr = ModulesServlet.installBundle(bun, id, installLatestCoreUpdate).getSuccessfullyInstalledModules();
        }
        catch (Exception e) {
            if (FelixUtil.invokedFromClient) {
                ModulesServlet.printError(e.getMessage());
            }
            resp = "Error:" + e.getMessage();
        }
        FelixUtil.updateInstalledBundlesFile(null);
        if (FelixUtil.invokedFromClient && null != sucBundlesStr && ((String)sucBundlesStr).length() > 0) {
            Object fBuns = bun;
            if (depBundles.length() > 0) {
                fBuns = bun + "," + depBundles;
                sucBundlesStr = (String)sucBundlesStr + "," + depBundles;
                sucBundlesStr = ModulesServlet.removeDuplicates((String)sucBundlesStr);
            }
            ModulesServlet.checkInstalledStatusOfBundles((String)fBuns, (String)sucBundlesStr);
        }
        return resp;
    }

    public static String removeDuplicates(String commaSepNames) {
        Object commaSepNamesUnigues = "";
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (String bunname : commaSepNames.split(",")) {
            if (uniqueNames.contains(bunname)) continue;
            uniqueNames.add(bunname);
            commaSepNamesUnigues = ((String)commaSepNamesUnigues).length() == 0 ? bunname : (String)commaSepNamesUnigues + "," + bunname;
        }
        return commaSepNamesUnigues;
    }

    public static String getDependentCFBundles(String bundles, boolean mergeGivenAndDependents, boolean includeVersion) {
        Object depBundles = "";
        List<DependentBundle> deps = FelixUtil.getDependentCFBundles(bundles);
        ArrayList<Object> depsnodupes = new ArrayList<Object>();
        for (DependentBundle dep : deps) {
            String depName = dep.getName();
            String depVersion = dep.getVersion();
            Object dependent = "";
            dependent = includeVersion ? depName + ":" + depVersion : depName;
            if (depsnodupes.contains(dependent)) continue;
            depsnodupes.add(dependent);
            if (FelixUtil.isModuleInstalled(depName, depVersion)) continue;
            depBundles = (String)depBundles + (String)dependent + ",";
        }
        if (mergeGivenAndDependents) {
            for (String bundle : bundles.split(",")) {
                String[] iSplit = bundle.split(":");
                String bundleName = iSplit[0];
                String version = "";
                if (iSplit.length > 1) {
                    version = iSplit[1];
                }
                Object bundleNV = "";
                bundleNV = includeVersion ? (version.length() > 0 ? bundleName + ":" + version : bundleName) : bundleName;
                depBundles = (String)depBundles + (String)bundleNV + ",";
            }
        }
        if (((String)depBundles).endsWith(",")) {
            depBundles = ((String)depBundles).substring(0, ((String)depBundles).length() - 1);
        }
        depBundles = ModulesServlet.removeDuplicates((String)depBundles);
        return depBundles;
    }

    public static ModulesStatus getInstallAllStatus(int id) {
        return progressInstallAll.get(id);
    }

    public static String handleUninstallCommand(String bun) {
        boolean uninstallDependents = false;
        if (bun.split(",").length > 1) {
            uninstallDependents = true;
        }
        Object resp = "";
        try {
            Map<String, String> msgs = ModulesServlet.uninstallBundle(bun, uninstallDependents);
            if (msgs.containsKey("error")) {
                ModulesServlet.printError(msgs.get("error"));
            }
            if (msgs.containsKey("success")) {
                ModulesServlet.printInfo(msgs.get("success"));
            }
        }
        catch (Exception e) {
            resp = "Error:" + e.getMessage();
        }
        FelixUtil.updateInstalledBundlesFile(null);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public static void handleUninstallallCommand(String exclude) {
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        Object bundles = "";
        for (CFBundle bundle : cfbundles) {
            if (!bundle.isInstalled() || null != exclude && exclude.contains(bundle.getName())) continue;
            bundles = (String)bundles + bundle.getName() + ",";
        }
        if (((String)bundles).length() == 0) {
            ModulesServlet.printError(RB.getString(ModulesServlet.class, (String)"ModulesServlet.allmodulesuninstalled"));
            return;
        }
        ModulesServlet.handleUninstallCommand((String)bundles);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String handleScanCommand(String cmd, String path, String server) {
        Object resp = "";
        path = path.replace("\\", "/");
        try {
            URL url = new URL(server + "/mcs?path=" + path);
            resp = ModulesServlet.makeHTTPRequest("", url, "GET");
            if (((String)resp).equals("pathnotfound")) {
                resp = "Error: CODEBASEPATH " + path + " not found";
            }
        }
        catch (MalformedURLException me) {
            ModulesServlet.printError(RB.getString(ModulesServlet.class, (String)"ModulesServlet.invalidurl", (Object)cmd));
            return null;
        }
        catch (ConnectException ce) {
            ModulesServlet.printError(RB.getString(ModulesServlet.class, (String)"ModulesServlet.conexc", (Object)server));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (cmd.equals("scanandinstall")) {
            ModulesServlet.printInfo(RB.getString(ModulesServlet.class, (String)"ModulesServlet.scaninfo1", (Object)resp));
            ModulesServlet.handleInstallCommand((String)resp);
            System.out.println("\n");
            resp = RB.getString(ModulesServlet.class, (String)"ModulesServlet.scaninfo2");
        }
        return resp;
    }

    private static String makeHTTPRequest(String data, URL url, String type) throws Exception {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(type);
        con.setDoOutput(true);
        DataOutputStream wr = null;
        try {
            String output;
            wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(data);
            wr.flush();
            wr.close();
            BufferedReader br = null;
            boolean error = false;
            if (200 <= con.getResponseCode() && con.getResponseCode() <= 299) {
                br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            } else if (con.getErrorStream() != null) {
                br = new BufferedReader(new InputStreamReader(con.getErrorStream()));
                error = true;
            }
            if (br == null) {
                throw new Exception("Could not connect to server : " + url.getHost());
            }
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            Object resp = sb.toString();
            if (error) {
                resp = "Error:" + (String)resp;
            }
            if (((String)resp).split(":").length == 3) {
                resp = ((String)resp).split(":")[2];
            }
            if (((String)resp).split(":").length > 3) {
                String[] ary = ((String)resp).split(":");
                resp = "";
                int x = 0;
                for (String a : ary) {
                    if (++x <= 2) continue;
                    resp = (String)resp + ":" + a;
                }
            }
            if (((String)resp).startsWith(":")) {
                resp = ((String)resp).substring(1, ((String)resp).length());
            }
            Object object = resp;
            return object;
        }
        catch (IOException exception) {
            throw exception;
        }
        finally {
            try {
                if (wr != null) {
                    wr.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String getDependentBundlesMessage(String initialListOfBundles, String commaBundles, int serverUpdateLevelRequired, CoreHotfixAction type) {
        String affectedBundles = StringUtils.difference((String)initialListOfBundles, (String)commaBundles);
        String dependentBundlesMessage = "";
        String key = "ModulesServlet.dependentmodulesupgradenote";
        if (type == CoreHotfixAction.DOWNGRADE) {
            key = "ModulesServlet.dependentmodulesdowngradenote";
        }
        if (affectedBundles.length() > 0 && affectedBundles.startsWith(",")) {
            affectedBundles = affectedBundles.substring(1);
            dependentBundlesMessage = RB.getString(ModulesServlet.class, (String)key, (Object)affectedBundles, (Object)serverUpdateLevelRequired);
        }
        return dependentBundlesMessage;
    }

    private static boolean getUserConfirmation(String confirmNote) {
        boolean response = true;
        if (FelixUtil.invokedFromClient) {
            if (confirmNote != null && confirmNote != "") {
                ModulesServlet.printMessage(confirmNote);
            }
            System.out.print(RB.getString(ModulesServlet.class, (String)"ModulesServlet.continueinstall"));
            Scanner scan = new Scanner(System.in);
            String command = "";
            while (!command.equalsIgnoreCase("y") && !command.equalsIgnoreCase("n")) {
                if (!scan.hasNextLine()) continue;
                command = scan.nextLine();
            }
            scan.close();
            if (command.equalsIgnoreCase("n")) {
                response = false;
            }
        }
        return response;
    }

    static {
        lambdaMode = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Boolean.getBoolean("LAMBDAMODE");
            }
        });
        File instanceFile = new File(ModulesServlet.getServerLibPath() + "/../../config/instances.xml");
        if (instanceFile != null && instanceFile.exists()) {
            _isStandalone = true;
        }
        progressInstallAll = new HashMap<Integer, ModulesStatus>();
    }

    private static enum CoreHotfixAction {
        UPGRADE,
        DOWNGRADE;

    }
}

