/*
 * Decompiled with CFR 0.152.
 */
package allaire.cfide;

import allaire.cfide.CFNetRouter;
import allaire.cfide.CFRPCServerException;
import netscape.application.Alert;
import netscape.application.Application;
import netscape.application.Button;
import netscape.application.ExternalWindow;
import netscape.application.Label;
import netscape.application.RootView;
import netscape.application.Target;
import netscape.application.TextField;
import netscape.util.Enumeration;
import netscape.util.Vector;

public class CFServiceControl
extends Application
implements Target {
    static final String SERVICE_PARAM = "ServiceName";
    static final String PASS_PARAM = "passkey";
    static final String DEFAULT_SERVICE = "Cold Fusion Application Server";
    static final String SERVICE_ACTION = "Service";
    static final String GET_STATE_COMMAND = "State";
    static final String START_COMMAND = "Start";
    static final String STOP_COMMAND = "Stop";
    static final String COMMAND_OK = "OK";
    static final String COMMAND_CANCEL = "Cancel";
    static final String STARTED_STATE = "Started";
    static final String STOPPED_STATE = "Stopped";
    static final int INVALID_PASSWORD = -100;
    static final String START_TITLE = "Start";
    static final String STOP_TITLE = "Stop";
    static final int X_PADDING = 2;
    static final int HORIZ_OFFSET = 4;
    static final int VERT_OFFSET = 4;
    static final int BUTTON_WIDTH = 60;
    static final int BUTTON_HEIGHT = 20;
    static final int FIELD_HEIGHT = 20;
    static final int PROMPT_WIDTH = 256;
    static final int PROMPT_HEIGHT = 120;
    private ExternalWindow m_prompt;
    private Button m_startButton;
    private Button m_stopButton;
    private Label m_label;
    private TextField m_passwordField;
    private Button m_buttonOK;
    private Button m_buttonCancel;
    private CFNetRouter netRouter;
    private String m_serviceName;
    private String m_username;
    private String m_password;
    private int m_ErrorCode;
    private String m_strLastErrorMessage;

    public void init() {
        try {
            super.init();
            this.m_strLastErrorMessage = "";
            this.m_serviceName = this.getParameter(SERVICE_PARAM, DEFAULT_SERVICE);
            this.m_password = this.getParameter(PASS_PARAM, "");
            this.netRouter = new CFNetRouter("", this.m_password);
            this.m_startButton = new Button(1, 1, 60, 20);
            this.m_startButton.setTitle("Start");
            this.m_startButton.setCommand("Start");
            this.m_startButton.setTarget(this);
            int n = this.m_startButton.x() + this.m_startButton.width() + 2;
            this.m_stopButton = new Button(n, 1, 60, 20);
            this.m_stopButton.setTitle("Stop");
            this.m_stopButton.setCommand("Stop");
            this.m_stopButton.setTarget(this);
            RootView rootView = this.mainRootView();
            rootView.addSubview(this.m_startButton);
            rootView.addSubview(this.m_stopButton);
            this.m_prompt = new ExternalWindow();
            this.m_prompt.sizeTo(256, 120);
            this.m_prompt.setResizable(true);
            this.m_label = new Label();
            this.m_label.setTitle("Password: ");
            this.m_label.sizeToMinSize();
            this.m_label.moveTo(4, 4);
            this.m_prompt.addSubview(this.m_label);
            this.m_passwordField = new TextField(this.m_label.bounds().x + this.m_label.bounds().width, 4, this.m_prompt.contentSize().width - 8 - this.m_label.bounds().width, 20);
            this.m_passwordField.setDrawableCharacter('*');
            this.m_prompt.addSubview(this.m_passwordField);
            Button button = new Button(this.m_passwordField.bounds().x + this.m_passwordField.bounds().width - 60 + 1, this.m_passwordField.bounds().y + this.m_passwordField.height() + 4, 60, 20);
            button.setTitle(COMMAND_CANCEL);
            button.setCommand(COMMAND_CANCEL);
            button.setTarget(this);
            this.m_prompt.addSubview(button);
            Button button2 = new Button(button.bounds().x - 60 - 4, button.bounds().y, 60, 20);
            button2.setTitle(COMMAND_OK);
            button2.setCommand(COMMAND_OK);
            button2.setTarget(this);
            this.m_prompt.addSubview(button2);
            this.performCommand(GET_STATE_COMMAND, "");
        }
        catch (Exception exception) {
            this.m_strLastErrorMessage = exception.getMessage();
            this.reportError(this.m_strLastErrorMessage);
        }
    }

    public void performCommand(String string, Object object) {
        try {
            if (string.equals(COMMAND_OK)) {
                this.m_prompt.hide();
                return;
            }
            if (string.equals(COMMAND_CANCEL)) {
                this.reportError("Access denied.");
                this.m_passwordField.setStringValue("");
                this.m_prompt.hide();
                return;
            }
            this.m_strLastErrorMessage = "";
            Vector vector = this.netRouter.callRPC(SERVICE_ACTION, string, this.m_serviceName);
            String string2 = "";
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
            }
            this.m_startButton.setEnabled(!string2.equalsIgnoreCase(STARTED_STATE));
            this.m_stopButton.setEnabled(!string2.equalsIgnoreCase(STOPPED_STATE));
        }
        catch (CFRPCServerException cFRPCServerException) {
            String string3;
            this.m_ErrorCode = cFRPCServerException.getErrorCode();
            if (this.m_ErrorCode == -100 && (string3 = this.getPassword()).length() >= 1) {
                this.netRouter.changePassword(string3);
                this.performCommandLater(this, string, null);
                return;
            }
        }
        catch (Exception exception) {
            this.reportError(exception.getMessage());
            this.m_startButton.setEnabled(true);
            this.m_stopButton.setEnabled(true);
        }
    }

    private String getParameter(String string, String string2) {
        String string3 = this.parameterNamed(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private void reportError(String string) {
        string.trim();
        if (string == null) {
            string = "An unknown error occurred.";
        } else if (string.startsWith("<HTML>")) {
            string = "The Cold Fusion IDE service is not running.\nIt must be started from the server in order to control\nother Cold Fusion services from this page.";
        }
        Alert.runAlertInternally(Alert.notificationImage(), this.m_serviceName + " error", string, COMMAND_OK, null, null);
    }

    private String getPassword() {
        this.m_prompt.center();
        this.m_prompt.showModally();
        return this.m_passwordField.stringValue();
    }
}

