/*
 * Decompiled with CFR 0.152.
 */
package allaire.controls;

import allaire.controls.CFTreeItem;
import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.Graphics;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.ScrollGroup;
import netscape.application.ScrollView;
import netscape.application.Target;
import netscape.application.View;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class CFTree
extends View
implements Target {
    public static final String COMMAND_ITEM_WAS_SELECTED = "ItemWasSelected";
    private boolean m_firstDraw = true;
    public boolean m_showURLs = true;
    public boolean m_appendKeys = true;
    private Hashtable m_bitmapHash;
    private int m_xExtent;
    private int m_yExtent;
    private int m_yIncrement;
    private Vector m_bitmaps;
    private Font m_font;
    protected CFTreeItem m_selectedItem = null;
    protected CFTreeItem m_rootItem;
    protected Vector m_allItems = null;
    public ScrollGroup m_scrollGroup;
    public Target m_Target;
    public static final int folderImage = 0;
    public static final int computerImage = 2;
    public static final int floppyImage = 4;
    public static final int fixedImage = 6;
    public static final int remoteImage = 8;
    public static final int cdImage = 10;
    public static final int documentImage = 12;
    public static final int elementsImage = 14;

    public int addItem(String string, int n) {
        return this.addItem(string, string, n);
    }

    public int addItem(String string, String string2, int n) {
        CFTreeItem cFTreeItem = n >= 0 ? this.itemAt(n) : null;
        CFTreeItem cFTreeItem2 = new CFTreeItem(this, string, string2);
        if (cFTreeItem == null) {
            this.m_rootItem.addChild(cFTreeItem2);
        } else {
            cFTreeItem.addChild(cFTreeItem2);
            cFTreeItem2.setParent(cFTreeItem);
        }
        int n2 = this.m_allItems.size();
        this.m_allItems.addElement(cFTreeItem2);
        return n2;
    }

    public int addItem(String string, int n, int n2) {
        int n3 = this.addItem(string, string, n);
        CFTreeItem cFTreeItem = this.itemAt(n3);
        if (n2 >= 0 && n2 < this.m_bitmaps.size()) {
            cFTreeItem.m_imageIndex = n2;
        }
        return n3;
    }

    public int addItem(String string, String string2, int n, int n2) {
        int n3 = this.addItem(string, string2, n);
        CFTreeItem cFTreeItem = this.itemAt(n3);
        if (n2 >= 0 && n2 < this.m_bitmaps.size()) {
            cFTreeItem.m_imageIndex = n2;
        }
        return n3;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public void setTarget(Target target) {
        this.m_Target = target;
    }

    public Bitmap bitmap(int n) {
        Bitmap bitmap = (Bitmap)this.m_bitmaps.elementAt(n);
        return bitmap;
    }

    public CFTree(View view) {
        this.init(0, 0);
        view.addSubview(this.m_scrollGroup);
    }

    public CFTree(int n, int n2, int n3, int n4, View view) {
        super(0, 0, n3, n4);
        this.init(n, n2);
        view.addSubview(this.m_scrollGroup);
    }

    public String currentItem() {
        String string = "";
        if (this.m_selectedItem != null) {
            string = this.m_selectedItem.m_internalCaption;
        }
        return string;
    }

    public String currentPath(String string) {
        String string2 = "";
        if (this.m_selectedItem != null) {
            string2 = this.m_selectedItem.getPath(string);
        }
        return string2;
    }

    public String currentCompletePath(String string) {
        String string2 = "";
        if (this.m_selectedItem != null) {
            string2 = this.m_selectedItem.getCompletePath(string);
        }
        return string2;
    }

    public void doubleClicked(CFTreeItem cFTreeItem) {
    }

    public int drawItem(Graphics graphics, FontMetrics fontMetrics, CFTreeItem cFTreeItem, int n, int n2, Vector vector, Rect rect) {
        boolean bl;
        if (cFTreeItem != this.m_rootItem) {
            if (n >= rect.y - this.m_yIncrement) {
                boolean bl2 = n > rect.y + rect.height + this.m_yIncrement;
                cFTreeItem.draw(graphics, fontMetrics, n, n2, vector, bl2);
            }
            n += this.m_yIncrement;
            bl = cFTreeItem.m_exploded;
        } else {
            bl = true;
        }
        if (bl) {
            Enumeration enumeration = cFTreeItem.children();
            while (enumeration.hasMoreElements()) {
                CFTreeItem cFTreeItem2 = (CFTreeItem)enumeration.nextElement();
                n = this.drawItem(graphics, fontMetrics, cFTreeItem2, n, n2 + 1, vector, rect);
            }
        }
        return n;
    }

    public void drawView(Graphics graphics) {
        Font font = this.m_font == null ? Font.defaultFont() : this.m_font;
        FontMetrics fontMetrics = font.fontMetrics();
        graphics.setFont(font);
        Rect rect = graphics.clipRect();
        graphics.setColor(Color.white);
        graphics.fillRect(rect);
        graphics.setColor(Color.black);
        Vector vector = new Vector();
        this.m_xExtent = 0;
        this.m_yExtent = 0;
        this.drawItem(graphics, fontMetrics, this.m_rootItem, 0, -1, vector, rect);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CFTreeItem cFTreeItem = (CFTreeItem)enumeration.nextElement();
            cFTreeItem.drawHotBox(graphics, fontMetrics);
        }
        if (this.m_firstDraw) {
            this.m_firstDraw = false;
            Application.application().performCommandLater(this, "RESET_SCROLLBARS", null);
        }
    }

    public Rect extents(int n) {
        Font font = this.m_font == null ? Font.defaultFont() : this.m_font;
        FontMetrics fontMetrics = font.fontMetrics();
        this.extentsRecurse(fontMetrics, this.m_rootItem, 0, -1);
        Rect rect = new Rect(0, n, this.m_xExtent, this.m_yExtent - n);
        return rect;
    }

    public int extentsRecurse(FontMetrics fontMetrics, CFTreeItem cFTreeItem, int n, int n2) {
        boolean bl;
        if (cFTreeItem != this.m_rootItem) {
            cFTreeItem.setExtents(fontMetrics, n, n2);
            n += this.m_yIncrement;
            bl = cFTreeItem.m_exploded;
        } else {
            bl = true;
        }
        if (bl) {
            Enumeration enumeration = cFTreeItem.children();
            while (enumeration.hasMoreElements()) {
                CFTreeItem cFTreeItem2 = (CFTreeItem)enumeration.nextElement();
                n = this.extentsRecurse(fontMetrics, cFTreeItem2, n, n2 + 1);
            }
        }
        return n;
    }

    public void hideChildren(CFTreeItem cFTreeItem) {
        if (cFTreeItem.m_exploded) {
            cFTreeItem.m_exploded = false;
            Enumeration enumeration = cFTreeItem.children();
            while (enumeration.hasMoreElements()) {
                CFTreeItem cFTreeItem2 = (CFTreeItem)enumeration.nextElement();
                this.hideChildren(cFTreeItem2);
            }
        }
    }

    private CFTreeItem hitTest(CFTreeItem cFTreeItem, MouseEvent mouseEvent) {
        boolean bl;
        CFTreeItem cFTreeItem2 = null;
        CFTreeItem cFTreeItem3 = null;
        if (cFTreeItem != this.m_rootItem) {
            if (cFTreeItem.wasClicked(mouseEvent)) {
                return cFTreeItem;
            }
            bl = cFTreeItem.m_exploded;
        } else {
            bl = true;
        }
        if (bl && cFTreeItem3 == null) {
            Enumeration enumeration = cFTreeItem.children();
            while (enumeration.hasMoreElements() && cFTreeItem3 == null) {
                cFTreeItem2 = (CFTreeItem)enumeration.nextElement();
                cFTreeItem3 = this.hitTest(cFTreeItem2, mouseEvent);
            }
        }
        return cFTreeItem3;
    }

    private void init(int n, int n2) {
        this.m_scrollGroup = new ScrollGroup(n, n2, this.width(), this.height());
        this.m_scrollGroup.setContentView(this);
        this.m_scrollGroup.setBackgroundColor(Color.white);
        this.m_allItems = new Vector();
        this.m_bitmapHash = new Hashtable();
        this.m_rootItem = new CFTreeItem(this, "");
        this.m_scrollGroup.setBorder(new EmptyBorder());
        this.m_yIncrement = 16;
        Application application = Application.application();
        this.m_bitmaps = new Vector();
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("FolderClosed.gif"));
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("FolderOpen.gif"));
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("Computer.gif", false));
        this.m_bitmaps.addElement(this.m_bitmaps.lastElement());
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("Floppy.gif", false));
        this.m_bitmaps.addElement(this.m_bitmaps.lastElement());
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("HardDrive.gif", false));
        this.m_bitmaps.addElement(this.m_bitmaps.lastElement());
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("NetworkDrive.gif", false));
        this.m_bitmaps.addElement(this.m_bitmaps.lastElement());
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("CDDrive.gif", false));
        this.m_bitmaps.addElement(this.m_bitmaps.lastElement());
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("Document.gif", false));
        this.m_bitmaps.addElement(this.m_bitmaps.lastElement());
        this.m_bitmaps.addElement(Bitmap.bitmapNamed("Elements.gif", false));
        this.m_bitmaps.addElement(this.m_bitmaps.lastElement());
        ScrollView scrollView = this.m_scrollGroup.scrollView();
        this.m_font = null;
        Font font = Font.defaultFont();
        scrollView.setBuffered(true);
    }

    public CFTreeItem itemAt(int n) {
        CFTreeItem cFTreeItem = n < this.m_allItems.size() ? (CFTreeItem)this.m_allItems.elementAt(n) : null;
        return cFTreeItem;
    }

    public void itemSelected(CFTreeItem cFTreeItem) {
        if (this.m_Target != null) {
            this.m_Target.performCommand(COMMAND_ITEM_WAS_SELECTED, cFTreeItem);
        }
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        CFTreeItem cFTreeItem = this.hitTest(this.m_rootItem, mouseEvent);
        if (cFTreeItem == null) {
            return true;
        }
        if (mouseEvent.clickCount() > 1) {
            switch (cFTreeItem.clickedState()) {
                case 2: 
                case 3: {
                    this.selectItem(cFTreeItem);
                }
            }
            cFTreeItem.explode();
            this.resetScrollBars();
        } else {
            switch (cFTreeItem.clickedState()) {
                case 1: {
                    cFTreeItem.explode();
                    this.resetScrollBars();
                    break;
                }
                case 2: 
                case 3: {
                    this.selectItem(cFTreeItem);
                }
            }
        }
        return true;
    }

    public void performCommand(String string, Object object) {
        if (string.equalsIgnoreCase("RESET_SCROLLBARS")) {
            this.resetScrollBars();
        }
    }

    public void populateChildren(CFTreeItem cFTreeItem) {
    }

    public void resetScrollBars() {
        if (this.m_scrollGroup.hasHorizScrollBar() || this.m_scrollGroup.hasVertScrollBar()) {
            Rect rect = this.extents(0);
            int n = Math.max(this.m_scrollGroup.width(), rect.width);
            int n2 = Math.max(this.m_scrollGroup.height(), rect.height);
            Rect rect2 = this.bounds();
            this.setBounds(rect2.x, rect2.y, n, n2);
        }
    }

    public void selectItem(CFTreeItem cFTreeItem) {
        if (this.m_selectedItem == cFTreeItem) {
            return;
        }
        if (this.m_selectedItem != null) {
            this.m_selectedItem.select(false);
        }
        cFTreeItem.select(true);
        if (cFTreeItem.m_selected) {
            this.m_selectedItem = cFTreeItem;
            this.itemSelected(cFTreeItem);
        }
    }

    public void selectItemWithCaption(String string) {
        CFTreeItem cFTreeItem = this.getItemForCaption(string);
        if (cFTreeItem != null) {
            System.out.println("Selecting Item : " + cFTreeItem.toString());
            this.selectItem(cFTreeItem);
        }
    }

    public CFTreeItem getItemForCaption(String string) {
        int n = 0;
        while (n < this.m_allItems.count()) {
            CFTreeItem cFTreeItem = (CFTreeItem)this.m_allItems.elementAt(n);
            if (cFTreeItem.m_caption.equalsIgnoreCase(string)) {
                System.out.println("Found Item : " + cFTreeItem.m_caption);
                return cFTreeItem;
            }
            ++n;
        }
        return null;
    }

    public void setBorder(boolean bl) {
        if (bl) {
            this.m_scrollGroup.setBorder(new BezelBorder(1, Color.lightGray));
        } else {
            this.m_scrollGroup.setBorder(new EmptyBorder());
        }
    }

    public void setExtents(int n, int n2) {
        if (n > this.m_xExtent) {
            this.m_xExtent = n;
        }
        if (n2 > this.m_yExtent) {
            this.m_yExtent = n2;
        }
    }

    public void setItemImageURL(int n, String string, String string2) {
        URL uRL;
        Bitmap bitmap = null;
        Bitmap bitmap2 = null;
        boolean bl = true;
        boolean bl2 = true;
        CFTreeItem cFTreeItem = this.itemAt(n);
        if (cFTreeItem == null) {
            return;
        }
        if (string.length() <= 0) {
            return;
        }
        Applet applet = AWTCompatibility.awtApplet();
        URL uRL2 = applet.getDocumentBase();
        bitmap = (Bitmap)this.m_bitmapHash.get(string);
        if (bitmap == null) {
            try {
                uRL = string.toLowerCase().startsWith("http://") ? new URL(string) : new URL(uRL2, string);
                bitmap = Bitmap.bitmapFromURL(uRL);
                bl = false;
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("CFTree: Malformed URL on default image");
            }
        }
        if (string2.length() > 0) {
            if (string2.compareTo(string) != 0) {
                bitmap2 = (Bitmap)this.m_bitmapHash.get(string2);
                if (bitmap2 == null) {
                    try {
                        uRL = string2.toLowerCase().startsWith("http://") ? new URL(string2) : new URL(uRL2, string2);
                        bitmap2 = Bitmap.bitmapFromURL(uRL);
                        bl2 = false;
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.out.println("CFTree: Malformed URL on open image");
                    }
                }
            } else {
                bitmap2 = bitmap;
            }
        } else {
            bitmap2 = bitmap;
        }
        if (bitmap != null && bitmap2 != null) {
            cFTreeItem.m_imageIndex = this.m_bitmaps.size();
            this.m_bitmaps.addElement(bitmap);
            this.m_bitmaps.addElement(bitmap2);
            if (!bl) {
                this.m_bitmapHash.put(string, bitmap);
            }
            if (!bl2) {
                this.m_bitmapHash.put(string2, bitmap2);
            }
        }
    }

    public void setItemURL(int n, String string, String string2, boolean bl) {
        CFTreeItem cFTreeItem = this.itemAt(n);
        if (cFTreeItem != null) {
            cFTreeItem.setURL(string, string2, bl);
        }
    }

    public void setHScroll(boolean bl) {
        this.m_scrollGroup.setHasHorizScrollBar(bl);
    }

    public void setVScroll(boolean bl) {
        this.m_scrollGroup.setHasVertScrollBar(bl);
    }

    public void showURLs(boolean bl) {
        this.m_showURLs = bl;
    }

    public void appendKeys(boolean bl) {
        this.m_appendKeys = bl;
    }

    public int xExtent() {
        return this.m_xExtent;
    }

    public int yExtent() {
        return this.m_yExtent;
    }
}

