/*
 * Decompiled with CFR 0.152.
 */
package allaire.controls;

import allaire.controls.CFTree;
import java.applet.Applet;
import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.FontMetrics;
import netscape.application.Graphics;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.util.Enumeration;
import netscape.util.Vector;

public class CFTreeItem {
    public static final int NOTCLICKED = 0;
    public static final int HOTBOXCLICKED = 1;
    public static final int IMAGECLICKED = 2;
    public static final int TEXTCLICKED = 3;
    public boolean m_exploded = true;
    public boolean m_selected = false;
    public CFTreeItem m_parent = null;
    public int m_imageIndex;
    public String m_caption = "";
    public String m_internalCaption = "";
    private boolean m_hasChildren = false;
    private boolean m_hasSibling = false;
    private boolean m_URLfromCodeBase = false;
    private CFTree m_parentControl;
    private int m_clickedState = 0;
    private int m_textWidth = -1;
    private int m_xOffset = -1;
    private int m_yOffset = -1;
    private String m_URL = "";
    private String m_URLDestination = "";
    private Vector m_childItems;

    public void addChild(CFTreeItem cFTreeItem) {
        this.m_childItems.addElement(cFTreeItem);
        this.m_hasChildren = true;
    }

    public CFTreeItem(CFTree cFTree, String string) {
        this.init();
        this.m_caption = string;
        this.m_internalCaption = string;
        this.m_parentControl = cFTree;
    }

    public CFTreeItem(CFTree cFTree, String string, String string2) {
        this.init();
        this.m_caption = string;
        this.m_internalCaption = string2;
        this.m_parentControl = cFTree;
    }

    public Enumeration children() {
        return this.m_childItems.elements();
    }

    public int clickedState() {
        return this.m_clickedState;
    }

    public void draw(Graphics graphics, FontMetrics fontMetrics, int n, int n2, Vector vector, boolean bl) {
        int n3 = 0;
        this.m_yOffset = n;
        if (this.m_textWidth == -1) {
            this.m_textWidth = fontMetrics.stringWidth(this.m_caption) + 2;
        }
        if (this.m_parent != null) {
            graphics.setColor(Color.gray);
            graphics.drawLine((n3 += (n2 - 1) * 19) + 19, n + 8, n3 + 8, n + 8);
            graphics.drawLine(n3 + 8, n + 8, n3 + 8, this.m_parent.m_yOffset + 16);
            graphics.setColor(Color.black);
            this.m_xOffset = n3;
            if (this.m_hasChildren && !bl) {
                vector.addElement(this);
            }
            n3 += 19;
        } else {
            this.m_xOffset = 0;
        }
        if (bl) {
            return;
        }
        int n4 = this.m_exploded && this.m_hasChildren ? this.m_imageIndex + 1 : this.m_imageIndex;
        Bitmap bitmap = this.m_parentControl.bitmap(n4);
        if (bitmap != null && bitmap.isValid()) {
            graphics.drawBitmapAt(bitmap, n3, n);
        }
        n3 += 22;
        if (this.m_selected) {
            graphics.setColor(new Color(0, 0, 128));
            graphics.fillRect(n3, n + 2, this.m_textWidth, 14);
            graphics.setColor(Color.white);
        }
        if (this.m_URL.length() > 0 && this.m_parentControl.m_showURLs) {
            if (!this.m_selected) {
                graphics.setColor(new Color(0, 0, 255));
            }
            graphics.drawLine(n3 + 1, n + 14, n3 + 1 + this.m_textWidth, n + 14);
        }
        graphics.drawString(this.m_caption, n3 + 1, n + 13);
        this.m_parentControl.setExtents(n3 + 1 + this.m_textWidth, n + 16);
        graphics.setColor(Color.black);
    }

    public void drawHotBox(Graphics graphics, FontMetrics fontMetrics) {
        graphics.setColor(Color.white);
        graphics.fillRect(this.m_xOffset + 4, this.m_yOffset + 4, 9, 9);
        graphics.setColor(Color.gray);
        graphics.drawRect(this.m_xOffset + 4, this.m_yOffset + 4, 9, 9);
        graphics.setColor(Color.black);
        graphics.drawLine(this.m_xOffset + 6, this.m_yOffset + 8, this.m_xOffset + 10, this.m_yOffset + 8);
        if (!this.m_exploded) {
            graphics.drawLine(this.m_xOffset + 8, this.m_yOffset + 6, this.m_xOffset + 8, this.m_yOffset + 10);
        }
    }

    public void explode() {
        Rect rect = null;
        if (!this.m_hasChildren) {
            this.m_parentControl.doubleClicked(this);
        }
        if (this.m_exploded) {
            rect = this.m_parentControl.extents(this.m_yOffset);
        }
        boolean bl = this.m_exploded = !this.m_exploded;
        if (this.m_exploded) {
            if (this.m_hasChildren && this.m_childItems.size() == 0) {
                this.m_parentControl.populateChildren(this);
                if (this.m_childItems.size() == 0) {
                    this.m_hasChildren = false;
                }
            }
            rect = this.m_parentControl.extents(this.m_yOffset);
        }
        this.m_parentControl.addDirtyRect(rect);
        this.m_parentControl.rootView().drawDirtyViews();
    }

    public String getPath(String string) {
        String string2 = this.m_internalCaption;
        CFTreeItem cFTreeItem = this.m_parent;
        while (cFTreeItem != null) {
            if (cFTreeItem.m_parent != null) {
                string2 = cFTreeItem.m_internalCaption + string + string2;
            }
            cFTreeItem = cFTreeItem.m_parent;
        }
        if (string2.endsWith(":")) {
            string2 = string2 + "\\";
        }
        return string2;
    }

    public String getCompletePath(String string) {
        String string2 = this.m_internalCaption;
        CFTreeItem cFTreeItem = this.m_parent;
        while (cFTreeItem != null) {
            string2 = cFTreeItem.m_internalCaption + string + string2;
            cFTreeItem = cFTreeItem.m_parent;
        }
        if (string2.endsWith(":")) {
            string2 = string2 + "\\";
        }
        return string2;
    }

    private void init() {
        this.m_childItems = new Vector();
        this.m_imageIndex = 0;
    }

    public void select(boolean bl) {
        block7: {
            if (this.m_URL.length() > 0) {
                Applet applet = AWTCompatibility.awtApplet();
                AppletContext appletContext = applet.getAppletContext();
                try {
                    URL uRL;
                    String string = URLEncoder.encode(this.m_internalCaption);
                    String string2 = this.m_parentControl.m_appendKeys ? (this.m_URL.indexOf("?") > 0 ? this.m_URL + "&CFTREEITEMKEY=" + string : this.m_URL + "?CFTREEITEMKEY=" + string) : this.m_URL;
                    if (this.m_URLfromCodeBase) {
                        URL uRL2 = Application.application().codeBase();
                        String string3 = uRL2.getHost();
                        uRL = new URL(uRL2.getProtocol(), string3, string2);
                    } else {
                        URL uRL3 = applet.getDocumentBase();
                        uRL = string2.toLowerCase().startsWith("http://") ? new URL(string2) : new URL(uRL3, string2);
                    }
                    if (this.m_URLDestination.length() > 0) {
                        appletContext.showDocument(uRL, this.m_URLDestination);
                        break block7;
                    }
                    appletContext.showDocument(uRL);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                this.m_selected = bl;
                Rect rect = new Rect(this.m_xOffset, this.m_yOffset + 2, this.m_textWidth + 41, 14);
                this.m_parentControl.addDirtyRect(rect);
                this.m_parentControl.rootView().drawDirtyViews();
            }
        }
    }

    public void setDefaultPath(String string, String string2) {
        CFTreeItem cFTreeItem = this;
        while (string.length() > 0) {
            String string3;
            int n = string.indexOf(string2);
            if (n == -1) {
                n = string.length() - 1;
                string3 = string;
            } else {
                string3 = string.substring(0, n);
            }
            boolean bl = false;
            Enumeration enumeration = cFTreeItem.children();
            while (!bl && enumeration.hasMoreElements()) {
                CFTreeItem cFTreeItem2 = (CFTreeItem)enumeration.nextElement();
                if (!string3.equalsIgnoreCase(cFTreeItem2.m_internalCaption)) continue;
                this.m_parentControl.selectItem(cFTreeItem2);
                if (n != string.length() - 1) {
                    cFTreeItem2.explode();
                }
                bl = true;
                string = string.substring(n + 1);
                cFTreeItem = cFTreeItem2;
            }
            if (bl) continue;
            string = "";
        }
        this.m_parentControl.resetScrollBars();
    }

    public void setExtents(FontMetrics fontMetrics, int n, int n2) {
        int n3 = 0;
        int n4 = fontMetrics.stringWidth(this.m_caption) + 2;
        if (this.m_parent != null) {
            n3 += (n2 - 1) * 19;
            n3 += 19;
        }
        this.m_parentControl.setExtents((n3 += 22) + 1 + n4, n + 16);
    }

    public void setHasChildren() {
        if (!this.m_hasChildren) {
            this.m_exploded = false;
            this.m_hasChildren = true;
        }
    }

    public void setParent(CFTreeItem cFTreeItem) {
        this.m_parent = cFTreeItem;
    }

    public void setURL(String string, String string2, boolean bl) {
        this.m_URLfromCodeBase = bl;
        this.m_URL = string;
        this.m_URLDestination = string2;
    }

    public boolean wasClicked(MouseEvent mouseEvent) {
        boolean bl = false;
        this.m_clickedState = 0;
        if (mouseEvent.y >= this.m_yOffset && mouseEvent.y <= this.m_yOffset + 16) {
            if (this.m_parent != null) {
                if (this.m_hasChildren && mouseEvent.x >= this.m_xOffset && mouseEvent.x <= this.m_xOffset + 19) {
                    bl = true;
                    this.m_clickedState = 1;
                }
                if (!bl) {
                    if (mouseEvent.x >= this.m_xOffset + 19 && mouseEvent.x <= this.m_xOffset + 19 + 21) {
                        bl = true;
                        this.m_clickedState = 2;
                    } else if (mouseEvent.x >= this.m_xOffset + 19 + 22 && mouseEvent.x <= this.m_xOffset + 19 + 22 + this.m_textWidth) {
                        bl = true;
                        this.m_clickedState = 3;
                    }
                }
            } else if (mouseEvent.x >= this.m_xOffset && mouseEvent.x <= this.m_xOffset + 21) {
                bl = true;
                this.m_clickedState = 2;
            } else if (mouseEvent.x >= this.m_xOffset + 22 && mouseEvent.x <= this.m_xOffset + 22 + this.m_textWidth) {
                bl = true;
                this.m_clickedState = 3;
            }
        }
        return bl;
    }
}

