/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Image;
import java.awt.image.ImageObserver;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Target;

class BitmapObserver
implements ImageObserver {
    Application application;
    Bitmap bitmap;
    int lastInfo;

    BitmapObserver(Application application, Bitmap bitmap) {
        this.application = application;
        this.bitmap = bitmap;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Target target;
        this.lastInfo = n;
        if (image == null) {
            return true;
        }
        if ((n & 1) != 0 || (n & 2) != 0 || (n & 4) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 0x80) != 0) {
            this.notifyAll();
            return true;
        }
        if (!this.bitmap.loadsIncrementally()) {
            return true;
        }
        if ((n & 8) != 0) {
            this.bitmap.unionWithUpdateRect(n2, n3, n4, n5);
            Target target2 = this.bitmap.updateTarget();
            if (target2 != null) {
                this.application.performCommandLater(target2, this.bitmap.updateCommand(), this.bitmap, true);
            }
        } else if ((n & 0x10) != 0 && (target = this.bitmap.updateTarget()) != null) {
            this.application.performCommandLater(target, this.bitmap.updateCommand(), this.bitmap, true);
        }
        return true;
    }

    synchronized boolean allBitsPresent() {
        return (this.lastInfo & 0x20) != 0;
    }

    synchronized boolean imageHasProblem() {
        return (this.lastInfo & 0x40) != 0 || (this.lastInfo & 0x80) != 0;
    }
}

