/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.DebugGraphics;
import netscape.application.DebugGraphicsInfo;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.GraphicsState;
import netscape.application.Point;
import netscape.application.Polygon;
import netscape.application.Rect;
import netscape.application.View;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Graphics {
    Vector graphicsStates = new Vector();
    java.awt.Graphics primaryAwtGraphics;
    java.awt.Graphics currentAwtGraphics;
    static int graphicsCount;
    int graphicsID = graphicsCount++;
    Rect primaryClipRect;
    Bitmap buffer;
    public static final int LEFT_JUSTIFIED = 0;
    public static final int CENTERED = 1;
    public static final int RIGHT_JUSTIFIED = 2;

    public Graphics(View view) {
        Rect rect = view.convertRectToView(null, view.bounds);
        rect.x -= view.bounds.x;
        rect.y -= view.bounds.y;
        this.buffer = null;
        this.init(rect, view.rootView().panel.getGraphics());
    }

    public Graphics(Bitmap bitmap) {
        this.buffer = bitmap;
        this.init(new Rect(0, 0, bitmap.width(), bitmap.height()), bitmap.awtImage.getGraphics());
    }

    Graphics(Rect rect, java.awt.Graphics graphics) {
        this.init(new Rect(rect), graphics);
    }

    static Graphics newGraphics(View view) {
        if (Graphics.debugViewCount() == 0) {
            return new Graphics(view);
        }
        return new DebugGraphics(view);
    }

    static Graphics newGraphics(Bitmap bitmap) {
        if (Graphics.debugViewCount() == 0) {
            return new Graphics(bitmap);
        }
        return new DebugGraphics(bitmap);
    }

    void init(Rect rect, java.awt.Graphics graphics) {
        GraphicsState graphicsState = new GraphicsState();
        this.graphicsStates.addElement(graphicsState);
        graphicsState.absoluteClipRect = rect;
        this.currentAwtGraphics = this.primaryAwtGraphics = graphics;
        this.primaryAwtGraphics.clipRect(rect.x, rect.y, rect.width, rect.height);
        this.primaryClipRect = rect;
        graphicsState.xOffset = rect.x;
        graphicsState.yOffset = rect.y;
    }

    public void pushState() {
        GraphicsState graphicsState = this.state();
        GraphicsState graphicsState2 = graphicsState != null ? (GraphicsState)graphicsState.clone() : new GraphicsState();
        this.graphicsStates.addElement(graphicsState2);
    }

    final void restoreAwtGraphics(java.awt.Graphics graphics, GraphicsState graphicsState) {
        if (graphicsState.font != null) {
            if (graphicsState.font.wasDownloaded()) {
                graphics.setFont(null);
            } else {
                graphics.setFont(graphicsState.font._awtFont);
            }
        }
        if (graphicsState.color == null) {
            graphics.setColor(null);
            return;
        }
        graphics.setColor(graphicsState.color._color);
        if (graphicsState.xorColor != null) {
            graphics.setXORMode(graphicsState.xorColor._color);
            return;
        }
        graphics.setPaintMode();
    }

    public void popState() {
        GraphicsState graphicsState = this.state();
        this.graphicsStates.removeLastElement();
        if (graphicsState.awtGraphics != null) {
            graphicsState.awtGraphics.dispose();
            this.currentAwtGraphics = this.awtGraphics();
        }
        if ((graphicsState = this.state()) != null) {
            this.restoreAwtGraphics(this.currentAwtGraphics, graphicsState);
        }
    }

    final GraphicsState state() {
        return (GraphicsState)this.graphicsStates.lastElement();
    }

    java.awt.Graphics awtGraphics() {
        int n = this.graphicsStates.count();
        while (n-- > 0) {
            GraphicsState graphicsState = (GraphicsState)this.graphicsStates.elementAt(n);
            if (graphicsState.awtGraphics == null) continue;
            return graphicsState.awtGraphics;
        }
        return this.primaryAwtGraphics;
    }

    public void setFont(Font font) {
        GraphicsState graphicsState = this.state();
        graphicsState.font = font;
        if (font == null || font.wasDownloaded()) {
            this.currentAwtGraphics.setFont(null);
            return;
        }
        this.currentAwtGraphics.setFont(font._awtFont);
    }

    public Font font() {
        return this.state().font;
    }

    public void setColor(Color color) {
        GraphicsState graphicsState = this.state();
        graphicsState.color = color;
        this.currentAwtGraphics.setColor(color == null ? null : color._color);
    }

    public Color color() {
        return this.state().color;
    }

    public void translate(int n, int n2) {
        GraphicsState graphicsState = this.state();
        graphicsState.xOffset += n;
        graphicsState.yOffset += n2;
        graphicsState.clipRect = null;
    }

    public int xTranslation() {
        GraphicsState graphicsState = this.state();
        return graphicsState.xOffset;
    }

    public int yTranslation() {
        GraphicsState graphicsState = this.state();
        return graphicsState.yOffset;
    }

    public Point translation() {
        GraphicsState graphicsState = this.state();
        return new Point(graphicsState.xOffset, graphicsState.yOffset);
    }

    public void setClipRect(Rect rect, boolean bl) {
        Rect rect2;
        GraphicsState graphicsState = this.state();
        Rect rect3 = this.absoluteClipRect();
        if (rect == null) {
            Rect rect4 = rect2 = this.primaryClipRect;
            rect2 = new Rect(rect2);
        } else {
            Rect rect5 = rect;
            rect2 = new Rect(rect);
            rect2.moveBy(graphicsState.xOffset, graphicsState.yOffset);
        }
        if (bl) {
            rect2.intersectWith(rect3);
        }
        if (!rect2.equals(rect3)) {
            if (!bl && graphicsState.awtGraphics != null) {
                graphicsState.awtGraphics.dispose();
                graphicsState.awtGraphics = null;
            }
            if (graphicsState.awtGraphics == null) {
                this.currentAwtGraphics = graphicsState.awtGraphics = this.primaryAwtGraphics.create();
                if (graphicsState.color != null) {
                    this.currentAwtGraphics.setColor(Color.white._color);
                    this.currentAwtGraphics.setColor(graphicsState.color._color);
                }
            }
            this.currentAwtGraphics.clipRect(rect2.x, rect2.y, rect2.width, rect2.height);
            graphicsState.absoluteClipRect = rect2;
            graphicsState.clipRect = null;
            this.restoreAwtGraphics(this.currentAwtGraphics, graphicsState);
        }
    }

    public void setClipRect(Rect rect) {
        this.setClipRect(rect, true);
    }

    public Rect clipRect() {
        GraphicsState graphicsState = this.state();
        if (graphicsState.clipRect != null) {
            return graphicsState.clipRect;
        }
        int n = this.graphicsStates.count();
        while (n-- > 0) {
            GraphicsState graphicsState2 = (GraphicsState)this.graphicsStates.elementAt(n);
            if (graphicsState2.absoluteClipRect == null) continue;
            graphicsState.clipRect = new Rect(graphicsState2.absoluteClipRect);
            graphicsState.clipRect.moveBy(-graphicsState.xOffset, -graphicsState.yOffset);
            return graphicsState.clipRect;
        }
        return null;
    }

    Rect absoluteClipRect() {
        int n = this.graphicsStates.count();
        while (n-- > 0) {
            GraphicsState graphicsState = (GraphicsState)this.graphicsStates.elementAt(n);
            if (graphicsState.absoluteClipRect == null) continue;
            return graphicsState.absoluteClipRect;
        }
        return null;
    }

    public void clearClipRect() {
        this.setClipRect(null, false);
    }

    public Bitmap buffer() {
        return this.buffer;
    }

    public boolean isDrawingBuffer() {
        return this.buffer != null;
    }

    public void dispose() {
        int n = this.graphicsStates.count();
        while (n-- > 0) {
            GraphicsState graphicsState = (GraphicsState)this.graphicsStates.elementAt(n);
            if (graphicsState.awtGraphics == null) continue;
            graphicsState.awtGraphics.dispose();
        }
        this.graphicsStates.removeAllElements();
        this.primaryAwtGraphics.dispose();
        this.primaryAwtGraphics = null;
        this.currentAwtGraphics = null;
    }

    public void sync() {
        Application.application().syncGraphics();
    }

    public void setPaintMode() {
        GraphicsState graphicsState = this.state();
        graphicsState.xorColor = null;
        this.currentAwtGraphics.setPaintMode();
    }

    public void setXORMode(Color color) {
        if (color == null) {
            this.setPaintMode();
            return;
        }
        GraphicsState graphicsState = this.state();
        graphicsState.xorColor = color;
        this.currentAwtGraphics.setXORMode(color._color);
    }

    public void drawRect(Rect rect) {
        this.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.drawRect(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3 - 1, n4 - 1);
    }

    public void fillRect(Rect rect) {
        this.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.fillRect(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3, n4);
    }

    public void drawRoundedRect(Rect rect, int n, int n2) {
        this.drawRoundedRect(rect.x, rect.y, rect.width, rect.height, n, n2);
    }

    public void drawRoundedRect(int n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.drawRoundRect(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3 - 1, n4 - 1, n5, n6);
    }

    public void fillRoundedRect(Rect rect, int n, int n2) {
        this.fillRoundedRect(rect.x, rect.y, rect.width, rect.height, n, n2);
    }

    public void fillRoundedRect(int n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.fillRoundRect(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.drawLine(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3 += graphicsState.xOffset, n4 += graphicsState.yOffset);
    }

    public void drawPoint(int n, int n2) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.drawLine(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n, n2);
    }

    public void drawOval(Rect rect) {
        this.drawOval(rect.x, rect.y, rect.width - 1, rect.height - 1);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.drawOval(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3, n4);
    }

    public void fillOval(Rect rect) {
        this.fillOval(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.fillOval(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3, n4);
    }

    public void drawArc(Rect rect, int n, int n2) {
        this.drawArc(rect.x, rect.y, rect.width, rect.height, n, n2);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.drawArc(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3, n4, n5, n6);
    }

    public void fillArc(Rect rect, int n, int n2) {
        this.fillArc(rect.x, rect.y, rect.width, rect.height, n, n2);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.fillArc(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3, n4, n5, n6);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        GraphicsState graphicsState = this.state();
        if (graphicsState.xOffset != 0 || graphicsState.yOffset != 0) {
            this.currentAwtGraphics.translate(graphicsState.xOffset, graphicsState.yOffset);
            this.currentAwtGraphics.drawPolygon(nArray, nArray2, n);
            this.currentAwtGraphics.translate(-graphicsState.xOffset, -graphicsState.yOffset);
            return;
        }
        this.currentAwtGraphics.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xPoints, polygon.yPoints, polygon.numPoints);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        GraphicsState graphicsState = this.state();
        if (graphicsState.xOffset != 0 || graphicsState.yOffset != 0) {
            this.currentAwtGraphics.translate(graphicsState.xOffset, graphicsState.yOffset);
            this.currentAwtGraphics.fillPolygon(nArray, nArray2, n);
            this.currentAwtGraphics.translate(-graphicsState.xOffset, -graphicsState.yOffset);
            return;
        }
        this.currentAwtGraphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xPoints, polygon.yPoints, polygon.numPoints);
    }

    public void drawBitmapAt(Bitmap bitmap, int n, int n2) {
        GraphicsState graphicsState = this.state();
        n += graphicsState.xOffset;
        n2 += graphicsState.yOffset;
        if (bitmap == null) {
            return;
        }
        if (!bitmap.loadsIncrementally()) {
            bitmap.loadData();
        }
        if (!bitmap.isValid()) {
            System.err.println("Graphics.drawBitmapAt() - Invalid bitmap: " + bitmap.name());
            return;
        }
        this.currentAwtGraphics.drawImage(bitmap.awtImage, n, n2, bitmap.bitmapObserver());
    }

    public void drawBitmapScaled(Bitmap bitmap, int n, int n2, int n3, int n4) {
        GraphicsState graphicsState = this.state();
        if (bitmap == null) {
            return;
        }
        n += graphicsState.xOffset;
        n2 += graphicsState.yOffset;
        bitmap.createScaledVersion(n3, n4);
        if (!bitmap.isValid()) {
            System.err.println("Graphics.drawBitmapScaled() - Invalid bitmap: " + bitmap.name());
            return;
        }
        this.currentAwtGraphics.drawImage(bitmap.awtImage, n, n2, n3, n4, bitmap.bitmapObserver());
    }

    public void drawStringInRect(String string, int n, int n2, int n3, int n4, int n5) {
        if (this.font() == null) {
            throw new InconsistencyException("No font set");
        }
        FontMetrics fontMetrics = this.font().fontMetrics();
        if (fontMetrics == null) {
            throw new InconsistencyException("No metrics for Font " + this.font());
        }
        int n6 = fontMetrics.stringWidth(string);
        if (n6 > n3) {
            n6 = n3;
        }
        int n7 = n5 == 1 ? n + (n3 - n6) / 2 : (n5 == 2 ? n + n3 - n6 : n);
        int n8 = (n4 - fontMetrics.ascent() - fontMetrics.descent()) / 2;
        if (n8 < 0) {
            n8 = 0;
        }
        int n9 = n2 + n4 - n8 - fontMetrics.descent();
        this.drawString(string, n7, n9);
    }

    public void drawStringInRect(String string, Rect rect, int n) {
        if (rect == null) {
            throw new InconsistencyException("Null Rect passed to drawStringInRect.");
        }
        this.drawStringInRect(string, rect.x, rect.y, rect.width, rect.height, n);
    }

    public void drawString(String string, int n, int n2) {
        if (string == null) {
            throw new InconsistencyException("Null String passed to drawString.");
        }
        Font font = this.font();
        if (font == null || !font.wasDownloaded()) {
            GraphicsState graphicsState = this.state();
            this.currentAwtGraphics.drawString(string, n += graphicsState.xOffset, n2 += graphicsState.yOffset);
            return;
        }
        FontMetrics fontMetrics = font.fontMetrics();
        int[] nArray = fontMetrics.widthsArray();
        int n3 = fontMetrics.widthsArrayBase();
        Vector vector = font.glyphVector();
        n2 -= fontMetrics.ascent();
        int n4 = 0;
        while (n4 < string.length()) {
            int n5 = string.charAt(n4) - n3;
            if (n5 < 0 || n5 >= nArray.length - n3) {
                if (string.charAt(n4) == ' ') {
                    n += nArray[32];
                }
            } else {
                this.drawBitmapAt((Bitmap)vector.elementAt(n5), n, n2);
                n += nArray[string.charAt(n4)];
            }
            ++n4;
        }
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        Font font = this.font();
        if (font == null || !font.wasDownloaded()) {
            GraphicsState graphicsState = this.state();
            this.currentAwtGraphics.drawBytes(byArray, n, n2, n3 += graphicsState.xOffset, n4 += graphicsState.yOffset);
            return;
        }
        FontMetrics fontMetrics = font.fontMetrics();
        int[] nArray = fontMetrics.widthsArray();
        int n5 = fontMetrics.widthsArrayBase();
        Vector vector = font.glyphVector();
        n4 -= fontMetrics.ascent();
        int n6 = 0;
        while (n6 < n2) {
            int n7 = byArray[n6] - n5;
            if (n7 < 0 || n7 >= nArray.length - n5) {
                if ((char)byArray[n6] == ' ') {
                    n3 += nArray[32];
                }
            } else {
                this.drawBitmapAt((Bitmap)vector.elementAt(n7), n3, n4);
                n3 += nArray[byArray[n6]];
            }
            ++n6;
        }
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        Font font = this.font();
        if (font == null) {
            return;
        }
        if (!font.wasDownloaded()) {
            GraphicsState graphicsState = this.state();
            this.currentAwtGraphics.drawChars(cArray, n, n2, n3 += graphicsState.xOffset, n4 += graphicsState.yOffset);
            return;
        }
        FontMetrics fontMetrics = font.fontMetrics();
        int[] nArray = fontMetrics.widthsArray();
        int n5 = fontMetrics.widthsArrayBase();
        Vector vector = font.glyphVector();
        n4 -= fontMetrics.ascent();
        int n6 = 0;
        while (n6 < n2) {
            int n7 = cArray[n6] - n5;
            if (n7 < 0 || n7 >= nArray.length - n5) {
                if (cArray[n6] == ' ') {
                    n3 += nArray[32];
                }
            } else {
                this.drawBitmapAt((Bitmap)vector.elementAt(n7), n3, n4);
                n3 += nArray[cArray[n6]];
            }
            ++n6;
        }
    }

    void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsState graphicsState = this.state();
        this.currentAwtGraphics.copyArea(n += graphicsState.xOffset, n2 += graphicsState.yOffset, n3, n4, (n5 += graphicsState.xOffset) - n, (n6 += graphicsState.yOffset) - n2);
    }

    public String toString() {
        int n = this.graphicsStates.count();
        String string = this.buffer != null ? " for Bitmap " : " ";
        StringBuffer stringBuffer = new StringBuffer("Graphics" + string + n + " states:\n");
        while (n-- > 0) {
            GraphicsState graphicsState = (GraphicsState)this.graphicsStates.elementAt(n);
            stringBuffer.append(graphicsState.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("Graphics" + (this.isDrawingBuffer() ? "<B>" : "") + "(" + this.graphicsID + ")");
        int n = this.graphicsStates.count();
        while (n-- > 0) {
            stringBuffer.append("-");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public void setDebugOptions(int n) {
        if (n != 0) {
            throw new InconsistencyException("Can't set non zero debugOptions on a Graphics.  Use DebugGraphics instead.");
        }
    }

    public int debugOptions() {
        return 0;
    }

    static DebugGraphicsInfo info() {
        Application application = Application.application();
        if (application.debugGraphicsInfo == null) {
            application.debugGraphicsInfo = new DebugGraphicsInfo();
        }
        return application.debugGraphicsInfo;
    }

    void setDebug(View view) {
    }

    static void setViewDebug(View view, int n) {
        DebugGraphicsInfo debugGraphicsInfo = Graphics.info();
        debugGraphicsInfo.setViewDebug(view, n);
    }

    static int shouldViewDebug(View view) {
        Application application = Application.application();
        if (application.debugGraphicsInfo == null) {
            return 0;
        }
        DebugGraphicsInfo debugGraphicsInfo = application.debugGraphicsInfo;
        int n = 0;
        while (view != null) {
            n |= debugGraphicsInfo.viewDebug(view);
            view = view._superview;
        }
        return n;
    }

    static int viewDebug(View view) {
        Application application = Application.application();
        if (application.debugGraphicsInfo == null) {
            return 0;
        }
        DebugGraphicsInfo debugGraphicsInfo = application.debugGraphicsInfo;
        return debugGraphicsInfo.viewDebug(view);
    }

    static int debugViewCount() {
        Application application = Application.application();
        if (application != null && application.debugGraphicsInfo != null && application.debugGraphicsInfo.viewToDebug != null) {
            return application.debugGraphicsInfo.viewToDebug.count();
        }
        return 0;
    }
}

