/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Event;
import netscape.application.RootView;

public class KeyEvent
extends Event {
    public int key;
    public int modifiers;
    public static final int KEY_DOWN = -11;
    public static final int KEY_UP = -12;
    public static final int NO_MODIFIERS_MASK = 0;
    public static final int ALT_MASK = 8;
    public static final int CONTROL_MASK = 2;
    public static final int SHIFT_MASK = 1;
    public static final int META_MASK = 4;
    public static final int RETURN_KEY = 10;
    public static final int BACKSPACE_KEY = 8;
    public static final int DELETE_KEY = 127;
    public static final int ESCAPE_KEY = 27;
    public static final int TAB_KEY = 9;
    public static final int UP_ARROW_KEY = 1004;
    public static final int DOWN_ARROW_KEY = 1005;
    public static final int LEFT_ARROW_KEY = 1006;
    public static final int RIGHT_ARROW_KEY = 1007;
    public static final int HOME_KEY = 1000;
    public static final int END_KEY = 1001;
    public static final int PAGE_UP_KEY = 1002;
    public static final int PAGE_DOWN_KEY = 1003;
    public static final int F1_KEY = 1008;
    public static final int F2_KEY = 1009;
    public static final int F3_KEY = 1010;
    public static final int F4_KEY = 1011;
    public static final int F5_KEY = 1012;
    public static final int F6_KEY = 1013;
    public static final int F7_KEY = 1014;
    public static final int F8_KEY = 1015;
    public static final int F9_KEY = 1016;
    public static final int F10_KEY = 1017;
    public static final int F11_KEY = 1018;
    public static final int F12_KEY = 1019;

    public KeyEvent() {
    }

    public KeyEvent(long l, int n, int n2, boolean bl) {
        this();
        this.timeStamp = l;
        this.type = bl ? -11 : -12;
        this.key = n;
        this.modifiers = n2;
    }

    public boolean isShiftKeyDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlKeyDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaKeyDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAltKeyDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isReturnKey() {
        return this.key == 10;
    }

    public boolean isBackspaceKey() {
        return this.key == 8;
    }

    public boolean isDeleteKey() {
        return this.key == 127;
    }

    public boolean isEscapeKey() {
        return this.key == 27;
    }

    public boolean isTabKey() {
        return this.key == 9 && !this.isShiftKeyDown();
    }

    public boolean isBackTabKey() {
        return this.key == 9 && this.isShiftKeyDown();
    }

    public boolean isUpArrowKey() {
        return this.key == 1004;
    }

    public boolean isDownArrowKey() {
        return this.key == 1005;
    }

    public boolean isLeftArrowKey() {
        return this.key == 1006;
    }

    public boolean isRightArrowKey() {
        return this.key == 1007;
    }

    public boolean isArrowKey() {
        return this.key == 1004 || this.key == 1005 || this.key == 1006 || this.key == 1007;
    }

    public boolean isHomeKey() {
        return this.key == 1000;
    }

    public boolean isEndKey() {
        return this.key == 1001;
    }

    public boolean isPageUpKey() {
        return this.key == 1002;
    }

    public boolean isPageDownKey() {
        return this.key == 1003;
    }

    public int isFunctionKey() {
        if (this.key == 1008) {
            return 1;
        }
        if (this.key == 1009) {
            return 2;
        }
        if (this.key == 1010) {
            return 3;
        }
        if (this.key == 1011) {
            return 4;
        }
        if (this.key == 1012) {
            return 5;
        }
        if (this.key == 1013) {
            return 6;
        }
        if (this.key == 1014) {
            return 7;
        }
        if (this.key == 1015) {
            return 8;
        }
        if (this.key == 1016) {
            return 9;
        }
        if (this.key == 1017) {
            return 10;
        }
        if (this.key == 1018) {
            return 11;
        }
        if (this.key == 1019) {
            return 12;
        }
        return 0;
    }

    public boolean isPrintableKey() {
        return this.key >= 32 && !this.isArrowKey() && !this.isHomeKey() && !this.isEndKey() && this.isFunctionKey() == 0;
    }

    public void setRootView(RootView rootView) {
        this.processor = rootView;
    }

    public RootView rootView() {
        return (RootView)this.processor;
    }

    public String toString() {
        String string = this.type == -11 ? "KeyDown" : "KeyUp";
        if (this.key < 32) {
            return string + ":'' (0x" + Integer.toString(this.key, 16) + ")':" + this.modifiers;
        }
        return string + ":'" + (char)this.key + "' (0x" + Integer.toString(this.key, 16) + ")':" + this.modifiers;
    }
}

