/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.ExtendedTarget;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.KeyEvent;
import netscape.application.MouseEvent;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.TextFieldOwner;
import netscape.application.TextFilter;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class TextField
extends View
implements ExtendedTarget,
FormElement {
    TextFieldOwner _owner;
    TextFilter _filter;
    Target _tabTarget;
    Target _backtabTarget;
    Target _contentsChangedTarget;
    Target _commitTarget;
    Vector _keyVector;
    Border border = BezelBorder.loweredBezel();
    Font _font;
    Color _textColor;
    Color _backgroundColor;
    Color _selectionColor;
    Color _caretColor;
    String _tabCommand;
    String _backtabCommand;
    String _contentsChangedCommand;
    String _commitCommand;
    FastStringBuffer _contents;
    FastStringBuffer _oldContents;
    Timer blinkTimer;
    char _drawableCharacter;
    int _selectionAnchorChar = -1;
    int _selectionEndChar = -1;
    int _justification;
    int _scrollOffset;
    int _fontHeight;
    int _initialAnchorChar = -1;
    int _clickCount;
    boolean _editing;
    boolean _caretShowing;
    boolean _canBlink;
    boolean _editable;
    boolean _selectable;
    boolean _mouseDragging;
    boolean _shadowed;
    boolean _textChanged = false;
    boolean _canWrap;
    boolean transparent = false;
    boolean wantsAutoscrollEvents = false;
    boolean isScrollable = true;
    boolean hasFocus = false;
    boolean _ignoreWillBecomeSelected;
    public static char ANY_CHARACTER = (char)65535;
    public static final String SELECT_TEXT = "selectText";
    static final String BLINK_CARET = "blinkCaret";
    static final String OWNER_KEY = "owner";
    static final String FILTER_KEY = "filter";
    static final String TABREC_KEY = "tabTarget";
    static final String BACKTABREC_KEY = "backtabTarget";
    static final String CONTENTSCHANGEDREC_KEY = "contentsChangedTarget";
    static final String COMMITREC_KEY = "commitTarget";
    static final String BORDER_KEY = "border";
    static final String FONT_KEY = "font";
    static final String TEXTC_KEY = "textColor";
    static final String BACKGROUNDC_KEY = "backgroundColor";
    static final String SELECTIONC_KEY = "selectionColor";
    static final String CARETC_KEY = "caretColor";
    static final String TABCOM_KEY = "tabCommand";
    static final String BACKTABCOM_KEY = "backtabCommand";
    static final String CONTENTSCHANGEDCOM_KEY = "contentsChangedCommand";
    static final String COMMITCOM_KEY = "commitCommand";
    static final String CONTENTS_KEY = "contents";
    static final String SELECTIONANCH_KEY = "selectionAnchorChar";
    static final String SELECTIONEND_KEY = "selectionEndChar";
    static final String JUSTIFICATION_KEY = "justification";
    static final String SCROLLOFFSET_KEY = "scrollOffset";
    static final String EDITABLE_KEY = "editable";
    static final String SELECTABLE_KEY = "selectable";
    static final String SHADOWED_KEY = "shadowed";
    static final String CANWRAP_KEY = "canWrap";
    static final String AUTOSCROLLEVENT_KEY = "wantsAutoscrollEvents";
    static final String TRANSPARENT_KEY = "transparent";
    static final String DRAWABLE_CHAR_KEY = "drawableCharacter";
    static final String DRAWABLE_CHAR_STRING_KEY = "drawable char";
    static final String SCROLLABLE_KEY = "isScrollable";

    public TextField() {
        this(0, 0, 0, 0);
    }

    public TextField(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public TextField(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this._keyVector = new Vector();
        this._contents = new FastStringBuffer();
        this._drawableCharacter = ANY_CHARACTER;
        this._textColor = Color.black;
        this._backgroundColor = Color.white;
        this._selectionColor = Color.lightGray;
        this._caretColor = Color.black;
        this.setEditable(true);
        this.setFont(Font.defaultFont());
    }

    public static TextField createLabel(String string, Font font) {
        FontMetrics fontMetrics = font.fontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.stringHeight();
        TextField textField = new TextField(0, 0, n, n2);
        textField.setBorder(null);
        textField.setStringValue(string);
        textField.setFont(font);
        textField.setTransparent(true);
        textField.setEditable(false);
        textField.setSelectable(false);
        return textField;
    }

    public static TextField createLabel(String string) {
        return TextField.createLabel(string, Font.defaultFont());
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int leftIndent() {
        int n = this.border.leftMargin();
        if (n > 2) {
            n = 2;
        }
        return n;
    }

    public int rightIndent() {
        int n = this.border.rightMargin() + 1;
        if (n > 3) {
            n = 3;
        }
        return n;
    }

    private int widthIndent() {
        return this.leftIndent() + this.rightIndent();
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        Size size = this._font.fontMetrics().stringSize(this.drawableString());
        Rect rect = this.interiorRect();
        if (this.horizResizeInstruction() != 2 && this._canWrap && !this.isEditable() && size.width > rect.width) {
            Vector vector = this.stringVectorForContents(rect.width);
            size.sizeTo(rect.width, size.height * vector.count());
        }
        Rect.returnRect(rect);
        size.sizeBy(this.border.widthMargin() + this.widthIndent(), this.border.heightMargin());
        return size;
    }

    public void setDrawableCharacter(char c) {
        this._drawableCharacter = c;
        this._scrollOffset = 0;
        this._computeScrollOffset();
        this.setDirty(true);
    }

    public char drawableCharacter() {
        return this._drawableCharacter;
    }

    public void setFont(Font font) {
        this._font = font == null ? Font.defaultFont() : font;
        Size size = this._font.fontMetrics().stringSize(null);
        this._fontHeight = size.height;
        this.setDirty(true);
    }

    public Font font() {
        return this._font;
    }

    public void setTextColor(Color color) {
        this._textColor = color;
        if (this._textColor == null) {
            this._textColor = Color.black;
        }
        this.setDirty(true);
    }

    public Color textColor() {
        return this._textColor;
    }

    public void setBackgroundColor(Color color) {
        this._backgroundColor = color;
        if (this._backgroundColor == null) {
            this._backgroundColor = Color.white;
        }
        this.setDirty(true);
    }

    public Color backgroundColor() {
        return this._backgroundColor;
    }

    public void setSelectionColor(Color color) {
        this._selectionColor = color;
        if (this._selectionColor == null) {
            this._selectionColor = Color.lightGray;
        }
        this.setDirty(true);
    }

    public Color selectionColor() {
        return this._selectionColor;
    }

    public void setCaretColor(Color color) {
        this._caretColor = color;
        if (this._caretColor == null) {
            this._caretColor = Color.black;
        }
    }

    public Color caretColor() {
        return this._caretColor;
    }

    public void setBorder(Border border) {
        if (border == null) {
            border = EmptyBorder.emptyBorder();
        }
        this.border = border;
    }

    public Border border() {
        return this.border;
    }

    public void setDrawsDropShadow(boolean bl) {
        this._shadowed = bl;
        this.setDirty(true);
    }

    public boolean drawsDropShadow() {
        return this._shadowed;
    }

    public void setJustification(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        if (n != this._justification) {
            this._justification = n;
            this._scrollOffset = 0;
        }
    }

    public int justification() {
        return this._justification;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        if (this.transparent) {
            this.setBorder(null);
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setSelectable(boolean bl) {
        if (this._selectable != bl) {
            RootView rootView;
            this._selectable = bl;
            this.wantsAutoscrollEvents = bl;
            if (!this._selectable && this._scrollOffset != 0) {
                this._scrollOffset = 0;
                this.drawInterior();
            }
            if ((rootView = this.rootView()) != null) {
                rootView.updateCursor();
            }
        }
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public boolean wantsAutoscrollEvents() {
        return this.wantsAutoscrollEvents;
    }

    public void setWrapsContents(boolean bl) {
        this._canWrap = bl;
        if (bl && this.isEditable()) {
            this.setEditable(false);
        }
        this.drawInterior();
    }

    public boolean wrapsContents() {
        return this._canWrap;
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            this._editable = bl;
            this.setSelectable(bl);
            if (bl && this.wrapsContents()) {
                this.setWrapsContents(false);
            }
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isBeingEdited() {
        return this._editing;
    }

    public int cursorForPoint(int n, int n2) {
        if (this.isEditable() || this.isSelectable()) {
            return 2;
        }
        return 0;
    }

    public void setOwner(TextFieldOwner textFieldOwner) {
        this._owner = textFieldOwner;
    }

    public TextFieldOwner owner() {
        return this._owner;
    }

    public void setFilter(TextFilter textFilter) {
        this._filter = textFilter;
    }

    public TextFilter filter() {
        return this._filter;
    }

    public void setContentsChangedCommandAndTarget(String string, Target target) {
        this._contentsChangedCommand = string;
        this._contentsChangedTarget = target;
    }

    public Target contentsChangedTarget() {
        return this._contentsChangedTarget;
    }

    public String contentsChangedCommand() {
        return this._contentsChangedCommand;
    }

    public void setTabField(TextField textField) {
        if (textField == null) {
            this._tabTarget = null;
            this._tabCommand = null;
        } else {
            this._tabTarget = textField;
            this._tabCommand = SELECT_TEXT;
        }
        this.invalidateKeyboardSelectionOrder();
    }

    public TextField tabField() {
        if (this._tabTarget instanceof TextField) {
            return (TextField)this._tabTarget;
        }
        return null;
    }

    public void setBacktabField(TextField textField) {
        if (textField == null) {
            this._backtabTarget = null;
            this._backtabCommand = null;
        } else if (textField != this) {
            this._backtabTarget = textField;
            this._backtabCommand = SELECT_TEXT;
        }
        this.invalidateKeyboardSelectionOrder();
    }

    public TextField backtabField() {
        if (this._backtabTarget instanceof TextField) {
            return (TextField)this._backtabTarget;
        }
        return null;
    }

    public void setTarget(Target target) {
        this._commitTarget = target;
    }

    public void setCommand(String string) {
        this._commitCommand = string;
    }

    public Target target() {
        return this._commitTarget;
    }

    public String command() {
        return this._commitCommand;
    }

    public void setStringValue(String string) {
        if (string != null && string.equals(this.stringValue())) {
            if (this.isBeingEdited()) {
                this.cancelEditing();
            }
            return;
        }
        if (string == null) {
            string = "";
        }
        this.replaceRangeWithString(new Range(0, this.charCount()), string);
        this._oldContents = null;
        if (this.isBeingEdited()) {
            this.cancelEditing();
            return;
        }
        this.setDirty(true);
    }

    public String stringValue() {
        if (this._contents == null) {
            return "";
        }
        return this._contents.toString();
    }

    public void replaceRangeWithString(Range range, String string) {
        String string2 = this.stringValue();
        Range range2 = new Range();
        range2.index = range.index;
        range2.length = range.length;
        range2.intersectWith(new Range(0, string2.length()));
        if (range2.isNullRange()) {
            range2.index = string2.length();
            range2.length = 0;
        }
        String string3 = string2.substring(0, range2.index);
        String string4 = string2.substring(range2.index + range2.length);
        this._contents = string != null ? new FastStringBuffer(string3 + string + string4) : new FastStringBuffer(string3 + string4);
        if (this.isBeingEdited()) {
            range2.index = 0;
            range2.length = this._contents.length();
            Range range3 = this.selectedRange();
            range3.intersectWith(range2);
            if (range3.isNullRange()) {
                this.selectRange(new Range(this._contents.length, 0));
                return;
            }
            this.selectRange(range3);
            return;
        }
        this.setDirty(true);
    }

    public String stringForRange(Range range) {
        String string = this.stringValue();
        Range range2 = new Range();
        range2.index = range.index;
        range2.length = range.length;
        range2.intersectWith(new Range(0, string.length()));
        if (range2.isNullRange()) {
            return "";
        }
        return string.substring(range2.index, range2.index + range2.length());
    }

    public String selectedStringValue() {
        if (this.hasInsertionPoint()) {
            return "";
        }
        int n = this.selectionStart();
        int n2 = this.selectionStop();
        if (n == -1 || n2 == -1) {
            return "";
        }
        if (n2 == this._contents.length()) {
            return this._contents.toString().substring(n);
        }
        return this._contents.toString().substring(n, n2);
    }

    public void setIntValue(int n) {
        this.setStringValue(Integer.toString(n));
    }

    public int intValue() {
        return TextField.parseInt(this._contents.toString());
    }

    public boolean isEmpty() {
        return this.charCount() == 0;
    }

    public int charCount() {
        return this._contents.length();
    }

    public int baseline() {
        String string = this.drawableString();
        Size size = this._font.fontMetrics().stringSize(string);
        Rect rect = Rect.newRect();
        this.border.computeInteriorRect(0, 0, this.bounds.width, this.bounds.height, rect);
        int n = rect.maxY() - (rect.height - size.height) / 2 - this._font.fontMetrics().descent();
        Rect.returnRect(rect);
        return n;
    }

    public void selectRange(Range range) {
        if (range.length < 0 || range.index < 0) {
            throw new InconsistencyException("TextField - invalid range: " + range);
        }
        this.selectRange(range.index, range.index + range.length);
    }

    protected void selectRange(int n, int n2) {
        if (!this.isSelectable()) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n > this._contents.length()) {
            n = this._contents.length();
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this._contents.length()) {
            n2 = this._contents.length();
        }
        this._selectionAnchorChar = n;
        this._selectionEndChar = n2;
        if (this.isEditable() && !this.isBeingEdited()) {
            this._startEditing(true);
        }
        this.drawInterior();
    }

    public void selectText() {
        this.selectRange(0, this.charCount());
    }

    public void setInsertionPoint(int n) {
        this.selectRange(n, n);
    }

    int selectionAnchorPoint() {
        return this._selectionAnchorChar;
    }

    int selectionEndPoint() {
        return this._selectionEndChar;
    }

    public Range selectedRange() {
        if (this.hasInsertionPoint()) {
            return new Range(this._selectionAnchorChar, 0);
        }
        if (this._selectionAnchorChar == -1 || this._selectionEndChar == -1) {
            return new Range();
        }
        return Range.rangeFromIndices(this.selectionStart(), this.selectionStop());
    }

    int selectionStart() {
        if (this._selectionAnchorChar < this._selectionEndChar) {
            return this._selectionAnchorChar;
        }
        return this._selectionEndChar;
    }

    int selectionStop() {
        if (this._selectionAnchorChar < this._selectionEndChar) {
            return this._selectionEndChar;
        }
        return this._selectionAnchorChar;
    }

    public boolean hasSelection() {
        return this._selectionAnchorChar != this._selectionEndChar;
    }

    public boolean hasInsertionPoint() {
        return this._selectionAnchorChar == this._selectionEndChar && this._selectionAnchorChar != -1;
    }

    Rect caretRect() {
        int n;
        FontMetrics fontMetrics = this._font.fontMetrics();
        if (fontMetrics == null) {
            return null;
        }
        Rect rect = this.interiorRect();
        int n2 = rect.maxY() - (rect.height - this._fontHeight) / 2;
        int n3 = n2 - fontMetrics.charHeight();
        if (n3 < (n = this.border.topMargin())) {
            n3 = n;
        }
        Rect.returnRect(rect);
        return Rect.newRect(this.xPositionOfCharacter(this._selectionEndChar), n3, 1, n2 - n3);
    }

    Rect interiorRect() {
        Rect rect = Rect.newRect();
        this.border.computeInteriorRect(0, 0, this.width(), this.height(), rect);
        return rect;
    }

    Rect rectForRange(int n, int n2) {
        int n3 = this.xPositionOfCharacter(n);
        Rect rect = this.interiorRect();
        rect.setBounds(n3, rect.y, this.xPositionOfCharacter(n2) - n3 + 1, rect.height);
        return rect;
    }

    public int xPositionOfCharacter(int n) {
        FontMetrics fontMetrics = this._font.fontMetrics();
        String string = this.drawableString();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = this.absoluteXOriginForStringWithWidth(n2);
        if (n <= 0) {
            return n3;
        }
        return n3 + fontMetrics.stringWidth(string.substring(0, n));
    }

    public int charNumberForPoint(int n) {
        String string;
        int n2 = this._contents.length();
        if (n2 == 0) {
            return 0;
        }
        FontMetrics fontMetrics = this._font.fontMetrics();
        int n3 = fontMetrics.stringWidth(string = this.drawableString());
        int n4 = this.absoluteXOriginForStringWithWidth(n3);
        if (n < n4) {
            return 0;
        }
        if (n > n4 + n3) {
            return n2;
        }
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            int n7 = fontMetrics.stringWidth(string.substring(0, n6));
            int n8 = n7 - n5;
            if (n <= n4 + n7) {
                if (n > n4 + n5 + n8 / 2) {
                    return n6;
                }
                return n6 - 1;
            }
            n5 = n7;
            ++n6;
        }
        return n2;
    }

    void drawViewCaret(Graphics graphics) {
        if (!this._caretShowing || this._selectionAnchorChar == -1 || this._selectionAnchorChar != this._selectionEndChar || !this.hasFocus) {
            return;
        }
        graphics.setColor(this._caretColor);
        Rect rect = this.caretRect();
        graphics.drawLine(rect.x, rect.y, rect.x, rect.maxY() - 1);
        Rect.returnRect(rect);
    }

    Vector stringVectorForContents(int n) {
        Vector vector = new Vector();
        String string = this.drawableString();
        char[] cArray = new char[1];
        FontMetrics fontMetrics = this.font().fontMetrics();
        int[] nArray = fontMetrics.widthsArray();
        int n2 = 0;
        int n3 = string.length();
        int n4 = n2;
        int n5 = 0;
        int n6 = -1;
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c == ' ' || c == '\t') {
                n6 = n2;
            }
            if (c == '\n') {
                vector.addElement(string.substring(n4, n2));
                n4 = ++n2;
                n5 = 0;
                n6 = -1;
                continue;
            }
            if (c < '\u0100') {
                n5 += nArray[c];
            } else {
                cArray[0] = c;
                n5 += fontMetrics.stringWidth(new String(cArray));
            }
            if (n5 > n) {
                if (n2 == n4) {
                    vector.addElement(string.substring(n4, n4 + 1));
                    n4 = ++n2;
                }
                if (n6 == -1) {
                    vector.addElement(string.substring(n4, n2));
                    n4 = n2;
                } else {
                    vector.addElement(string.substring(n4, n6));
                    n2 = n4 = n6 + 1;
                }
                n5 = 0;
                n6 = -1;
                continue;
            }
            ++n2;
        }
        if (n4 < n3) {
            vector.addElement(string.substring(n4));
        }
        return vector;
    }

    public void drawViewStringAt(Graphics graphics, String string, int n, int n2) {
        if (this._shadowed) {
            graphics.setColor(Color.black);
            graphics.drawString(string, n + 2, n2 + 2);
        }
        graphics.setColor(this._textColor);
        graphics.drawString(string, n, n2);
    }

    int absoluteXOriginForStringWithWidth(int n) {
        int n2 = this._justification == 2 ? this.width() - this.border.rightMargin() - this.rightIndent() - n - this._scrollOffset : (this._justification == 1 ? this.border.leftMargin() + this.leftIndent() + (this.width() - (this.border.widthMargin() + this.widthIndent()) - n) / 2 - this._scrollOffset : this.border.leftMargin() + this.leftIndent() - this._scrollOffset);
        return n2;
    }

    void drawViewLine(Graphics graphics, String string, Size size, int n) {
        if (size == null) {
            size = this._font.fontMetrics().stringSize(string);
        }
        int n2 = this.absoluteXOriginForStringWithWidth(size.width);
        this.drawViewStringAt(graphics, string, n2, n);
    }

    public void drawViewInterior(Graphics graphics, Rect rect) {
        int n = this.baseline();
        graphics.pushState();
        graphics.setClipRect(rect);
        if (!this.isTransparent()) {
            graphics.setColor(this._backgroundColor);
            graphics.fillRect(rect);
        }
        if (this._selectionAnchorChar != this._selectionEndChar && this.hasFocus && this.isSelectable()) {
            int n2 = this.xPositionOfCharacter(this.selectionStart());
            int n3 = this.xPositionOfCharacter(this.selectionStop());
            Rect rect2 = this.caretRect();
            graphics.setColor(this._selectionColor);
            graphics.fillRect(n2, rect2.y, n3 - n2, rect2.height);
            Rect.returnRect(rect2);
        }
        graphics.setFont(this._font);
        String string = this.drawableString();
        Size size = this._font.fontMetrics().stringSize(string);
        if (!this._canWrap || this.isEditable()) {
            this.drawViewLine(graphics, string, size, n);
        } else {
            Vector vector = this.stringVectorForContents(rect.width);
            int n4 = vector.count();
            if (n4 > 1) {
                n += (rect.height - size.height) / 2;
                int n5 = (rect.height - size.height * n4) / 2;
                n -= n5 + (n4 - 1) * size.height;
            }
            int n6 = 0;
            while (n6 < n4) {
                this.drawViewLine(graphics, (String)vector.elementAt(n6), null, n);
                n += size.height;
                ++n6;
            }
        }
        if (this.isBeingEdited() && this._caretShowing) {
            this.drawViewCaret(graphics);
        }
        graphics.popState();
    }

    public void drawViewBorder(Graphics graphics) {
        if (this.border != null) {
            this.border.drawInRect(graphics, 0, 0, this.width(), this.height());
            return;
        }
        if (!this.isTransparent() && this._backgroundColor != null) {
            graphics.setColor(this._backgroundColor);
            graphics.fillRect(0, 0, this.width(), this.height());
        }
    }

    public void drawView(Graphics graphics) {
        this.drawViewBorder(graphics);
        Rect rect = this.interiorRect();
        this.drawViewInterior(graphics, rect);
        Rect.returnRect(rect);
    }

    void drawCaret() {
        Rect rect = this.caretRect();
        this.addDirtyRect(rect);
        Rect.returnRect(rect);
    }

    void hideCaret() {
        this._caretShowing = false;
        this.drawCaret();
    }

    void showCaret() {
        this._caretShowing = true;
        this.drawCaret();
    }

    public void drawInterior() {
        Rect rect = this.interiorRect();
        this.addDirtyRect(rect);
        Rect.returnRect(rect);
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        Rect rect = null;
        this._clickCount = mouseEvent.clickCount();
        if (this._clickCount > 3) {
            return true;
        }
        if (!this.isSelectable()) {
            return false;
        }
        if (!this.isBeingEdited()) {
            if (this.isEditable()) {
                this._startEditing(true);
            } else if (this.isSelectable()) {
                this._startEditing(false);
            }
        }
        if (!this.rootView().mouseStillDown()) {
            int n = this.charNumberForPoint(mouseEvent.x);
            this._clickCount = 0;
            this.selectRange(new Range(n, 0));
            if (!this.hasSelection() && this.isEditable()) {
                this._canBlink = true;
                this._caretShowing = true;
                this.drawCaret();
                this._startBlinkTimer();
            }
            return true;
        }
        boolean bl = this._caretShowing;
        this._caretShowing = false;
        this._canBlink = false;
        this._mouseDragging = true;
        if (this.hasSelection()) {
            rect = this.rectForRange(this.selectionStart(), this.selectionStop());
        } else if (bl) {
            this.hideCaret();
        }
        Range range = this.selectedRange();
        if (mouseEvent.isShiftKeyDown() && this._clickCount == 1) {
            this._selectionEndChar = this.charNumberForPoint(mouseEvent.x);
            if (rect != null) {
                rect.unionWith(this.rectForRange(this.selectionStart(), this.selectionStop()));
            } else {
                rect = this.rectForRange(this.selectionStart(), this.selectionStop());
            }
        } else {
            this._selectionEndChar = this._initialAnchorChar = this.charNumberForPoint(mouseEvent.x);
            this._selectionAnchorChar = this._initialAnchorChar;
        }
        switch (this._clickCount) {
            case 2: {
                Range range2 = this.groupForIndex(this._selectionAnchorChar);
                if (!range2.isNullRange()) {
                    if (mouseEvent.isShiftKeyDown()) {
                        Range range3 = new Range(range);
                        range3.unionWith(range2);
                        this.selectRange(range3);
                    } else {
                        this.selectRange(range2);
                    }
                }
                rect = null;
                break;
            }
            case 3: {
                this.selectRange(new Range(0, this.charCount()));
                rect = null;
                break;
            }
        }
        if (rect != null) {
            this.addDirtyRect(rect);
            Rect.returnRect(rect);
        }
        return true;
    }

    void _computeScrollOffset() {
        if (!this.isScrollable) {
            this._scrollOffset = 0;
            return;
        }
        int n = this.border.leftMargin() + this.leftIndent();
        int n2 = this.border.rightMargin() + this.rightIndent();
        Rect rect = this.caretRect();
        Rect rect2 = this.interiorRect();
        String string = this.drawableString();
        if (rect2.width - (this.leftIndent() + this.rightIndent()) > this._font.fontMetrics().stringWidth(string)) {
            this._scrollOffset = 0;
            return;
        }
        if (rect.x >= n && rect.x < this.bounds.width - n2) {
            Rect.returnRect(rect);
            return;
        }
        this._scrollOffset = rect.x < n ? (this._scrollOffset += rect.x - n) : (this._scrollOffset += rect.x - (this.bounds.width - n2));
        Rect.returnRect(rect);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Range range;
        Range range2;
        Range range3;
        boolean bl = true;
        if (!this.isSelectable()) {
            return;
        }
        if (this._clickCount > 2) {
            return;
        }
        int n = this._selectionEndChar;
        this._selectionEndChar = this.charNumberForPoint(mouseEvent.x);
        if (this._clickCount == 2 && !(range3 = Range.rangeFromUnion(range2 = this.groupForIndex(this._initialAnchorChar), range = this.groupForIndex(this._selectionEndChar))).isNullRange()) {
            if (range.index > range2.index) {
                this._selectionAnchorChar = range2.index;
                this._selectionEndChar = range.index + range.length;
            } else {
                this._selectionAnchorChar = range2.index + range2.length;
                this._selectionEndChar = range.index;
            }
        }
        if (!this.containsPointInVisibleRect(mouseEvent.x, 1)) {
            int n2 = this._scrollOffset;
            this._computeScrollOffset();
            if (this._scrollOffset != n2) {
                this.drawInterior();
                bl = false;
            }
        }
        if (bl && this._selectionEndChar != n) {
            int n3;
            int n4;
            if (this._selectionEndChar < this._selectionAnchorChar && n > this._selectionAnchorChar || this._selectionEndChar > this._selectionAnchorChar && n < this._selectionAnchorChar) {
                n4 = this.selectionStart();
                n3 = this.selectionStop();
                if (n < n4) {
                    n4 = n;
                }
                if (n > n3) {
                    n3 = n;
                }
            } else if (this._selectionEndChar > n) {
                n4 = n;
                n3 = this._selectionEndChar;
            } else {
                n4 = this._selectionEndChar;
                n3 = n;
            }
            Rect rect = this.rectForRange(n4, n3);
            this.addDirtyRect(rect);
            Rect.returnRect(rect);
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this._mouseDragging = false;
        if (!this.hasSelection() && this.isEditable()) {
            this._canBlink = true;
            this._caretShowing = true;
            this.drawCaret();
        }
        this._initialAnchorChar = -1;
        this._clickCount = 0;
    }

    void _keyDown(KeyEvent keyEvent) {
        if (keyEvent.isReturnKey() || keyEvent.isTabKey() || keyEvent.isBackTabKey()) {
            int n = keyEvent.isReturnKey() ? 2 : (keyEvent.isTabKey() ? 0 : 1);
            if (this._owner != null && !this._owner.textEditingWillEnd(this, n, this._textChanged)) {
                return;
            }
            boolean bl = this._textChanged;
            this._completeEditing();
            if (this._owner != null) {
                this._owner.textEditingDidEnd(this, n, bl);
            }
            if (keyEvent.isBackTabKey()) {
                this.sendBacktabCommand();
                if (bl) {
                    this.sendCommitCommand();
                    return;
                }
            } else if (keyEvent.isTabKey()) {
                this.sendTabCommand();
                if (bl) {
                    this.sendCommitCommand();
                    return;
                }
            } else {
                this.sendCommitCommand();
            }
            return;
        }
        if (keyEvent.isLeftArrowKey()) {
            if (keyEvent.isShiftKeyDown()) {
                int n = this._scrollOffset;
                this.selectRange(this._selectionAnchorChar, this._selectionEndChar - 1);
                this._computeScrollOffset();
                if (this._scrollOffset != n) {
                    this.drawInterior();
                    return;
                }
            } else {
                int n = this._selectionAnchorChar;
                boolean bl = false;
                if (this._selectionAnchorChar != this._selectionEndChar) {
                    bl = true;
                    this._selectionAnchorChar = this.selectionStart();
                    n = -1;
                } else if (this._selectionAnchorChar > 0) {
                    this.hideCaret();
                    --this._selectionAnchorChar;
                }
                this._selectionEndChar = this._selectionAnchorChar;
                if (n != this._selectionAnchorChar) {
                    int n2 = this._scrollOffset;
                    this._computeScrollOffset();
                    if (n2 != this._scrollOffset || bl) {
                        this._caretShowing = true;
                        this.drawInterior();
                        return;
                    }
                    this.showCaret();
                }
            }
            return;
        }
        if (keyEvent.isRightArrowKey()) {
            if (keyEvent.isShiftKeyDown()) {
                int n = this._scrollOffset;
                this.selectRange(this._selectionAnchorChar, this._selectionEndChar + 1);
                this._computeScrollOffset();
                if (this._scrollOffset != n) {
                    this.drawInterior();
                    return;
                }
            } else {
                int n = this._selectionAnchorChar;
                boolean bl = false;
                if (this._selectionAnchorChar != this._selectionEndChar) {
                    bl = true;
                    this._selectionAnchorChar = this.selectionStop();
                    n = -1;
                } else if (this._selectionAnchorChar < this._contents.length()) {
                    this.hideCaret();
                    ++this._selectionAnchorChar;
                    if (this._selectionAnchorChar > this._contents.length()) {
                        this._selectionAnchorChar = this._contents.length();
                    }
                }
                this._selectionEndChar = this._selectionAnchorChar;
                if (n != this._selectionAnchorChar) {
                    int n3 = this._scrollOffset;
                    this._computeScrollOffset();
                    if (n3 != this._scrollOffset || bl) {
                        this._caretShowing = true;
                        this.drawInterior();
                        return;
                    }
                    this.showCaret();
                }
            }
            return;
        }
        if (keyEvent.isHomeKey()) {
            this.selectedRange();
            if (keyEvent.isShiftKeyDown()) {
                this.selectRange(this._selectionAnchorChar, 0);
            } else {
                this.selectRange(new Range(0, 0));
            }
            int n = this._scrollOffset;
            this._computeScrollOffset();
            if (this._scrollOffset != n) {
                this.drawInterior();
            }
            return;
        }
        if (keyEvent.isEndKey()) {
            this.selectedRange();
            int n = this._contents.length();
            if (keyEvent.isShiftKeyDown()) {
                this.selectRange(this._selectionAnchorChar, n);
            } else {
                this.selectRange(new Range(n, 0));
            }
            int n4 = this._scrollOffset;
            this._computeScrollOffset();
            if (this._scrollOffset != n4) {
                this.drawInterior();
            }
            return;
        }
        if (!(keyEvent.isBackspaceKey() || keyEvent.isDeleteKey() || keyEvent.isPrintableKey())) {
            return;
        }
        if (this._oldContents == null) {
            this._oldContents = new FastStringBuffer(this._contents.toString());
        }
        this.hideCaret();
        if (this._selectionAnchorChar != this._selectionEndChar) {
            String string = this._contents.toString();
            int n = this.selectionStart();
            this._contents = new FastStringBuffer(string.substring(0, n));
            this._contents.append(string.substring(this.selectionStop()));
            this._selectionAnchorChar = this._selectionEndChar = n;
            if (keyEvent.isBackspaceKey() || keyEvent.isDeleteKey()) {
                keyEvent = null;
            }
        }
        if (keyEvent != null) {
            if (keyEvent.isBackspaceKey()) {
                if (this._contents.length() == 0 || this._selectionAnchorChar == 0) {
                    this.showCaret();
                    return;
                }
                this._contents.removeCharAt(this._selectionAnchorChar - 1);
                --this._selectionAnchorChar;
            } else if (keyEvent.isDeleteKey()) {
                if (this._selectionAnchorChar < this._contents.length()) {
                    this._contents.removeCharAt(this._selectionAnchorChar);
                } else {
                    this.showCaret();
                }
            } else {
                this._contents.insert((char)keyEvent.key, this._selectionAnchorChar++);
            }
            this._selectionEndChar = this._selectionAnchorChar;
        }
        this._computeScrollOffset();
        this.drawInterior();
        this.showCaret();
        if (this._owner != null) {
            this._owner.textWasModified(this);
            this._textChanged = true;
            return;
        }
        if (!this._textChanged) {
            this._textChanged = true;
        }
    }

    public void keyDown(KeyEvent keyEvent) {
        if (!this.isEditable()) {
            return;
        }
        if (this._filter != null) {
            if (this._filter.acceptsEvent(this, keyEvent, this._keyVector)) {
                this._keyVector.addElement(keyEvent);
            }
        } else {
            this._keyVector.addElement(keyEvent);
        }
        while (!this._keyVector.isEmpty()) {
            KeyEvent keyEvent2 = (KeyEvent)this._keyVector.removeFirstElement();
            this._keyDown(keyEvent2);
        }
    }

    public void setFocusedView() {
        if (!this._editing && this.isEditable()) {
            this._startEditing(true);
            return;
        }
        super.setFocusedView();
    }

    private void _startEditing(boolean bl) {
        if (this._superview != null) {
            if (this.isEditable()) {
                this._canBlink = this._caretShowing = this.hasInsertionPoint();
            } else {
                this._caretShowing = false;
                this._canBlink = false;
            }
            this._editing = true;
            if (this.isSelectable()) {
                this.setFocusedView();
            }
            if (this.hasInsertionPoint() && this.isEditable()) {
                this.showCaret();
            }
            if (bl && this._owner != null) {
                this._owner.textEditingDidBegin(this);
            }
        }
    }

    private void _completeEditing() {
        this._oldContents = null;
        boolean bl = this._textChanged;
        this._editing = false;
        if (this._superview != null) {
            this._ignoreWillBecomeSelected = true;
            this._superview.setFocusedView(null);
            this._ignoreWillBecomeSelected = false;
        }
        if (bl) {
            this.sendContentsChangedCommand();
        }
    }

    void _startBlinkTimer() {
        if (this.blinkTimer == null) {
            this.blinkTimer = new Timer(this, BLINK_CARET, 750);
            this.blinkTimer.start();
        }
    }

    void _validateSelection() {
        this.stringValue();
        if (this._selectionAnchorChar == -1) {
            this.selectRange(new Range(0, 0));
            return;
        }
        if (this._selectionAnchorChar < 0) {
            this._selectionAnchorChar = 0;
        } else if (this._selectionAnchorChar > this._contents.length()) {
            this._selectionAnchorChar = this._contents.length();
        }
        if (this._selectionEndChar < 0) {
            this._selectionEndChar = 0;
            return;
        }
        if (this._selectionEndChar > this._contents.length()) {
            this._selectionEndChar = this._contents.length();
        }
    }

    public void startFocus() {
        this._validateSelection();
        this.hasFocus = true;
        if (this.isEditable()) {
            this._startBlinkTimer();
        }
        this.setDirty(true);
    }

    public void stopFocus() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
        }
        this.hasFocus = false;
        this._scrollOffset = 0;
        if (this._editing && this._owner != null && this.isEditable()) {
            this._owner.textEditingWillEnd(this, 3, this._textChanged);
        }
        this._canBlink = false;
        this._caretShowing = false;
        if (this._editing && this.isEditable()) {
            if (this._owner != null) {
                this._owner.textEditingDidEnd(this, 3, this._textChanged);
            }
            if (this._textChanged) {
                this.sendCommitCommand();
            }
        }
        this._textChanged = false;
        this._editing = false;
        this.drawInterior();
    }

    public void pauseFocus() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
            this.hideCaret();
        }
    }

    public void resumeFocus() {
        if (this.isEditable()) {
            this._startBlinkTimer();
        }
    }

    public void cancelEditing() {
        if (!this.isBeingEdited()) {
            return;
        }
        if (this._oldContents != null) {
            this._contents = this._oldContents;
            this._oldContents = null;
        }
        this._editing = false;
        if (this._superview != null) {
            this._ignoreWillBecomeSelected = true;
            this._superview.setFocusedView(null);
            this._ignoreWillBecomeSelected = false;
        }
    }

    public void completeEditing() {
        boolean bl = this._textChanged;
        if (!this.isBeingEdited()) {
            return;
        }
        if (this._owner != null && !this._owner.textEditingWillEnd(this, 4, bl)) {
            return;
        }
        this._completeEditing();
        if (this._owner != null) {
            this._owner.textEditingDidEnd(this, 4, bl);
        }
    }

    void sendCommand(String string, Target target) {
        if (target != null) {
            target.performCommand(string, this);
        }
    }

    void sendTabCommand() {
        if (this._tabCommand != null && this._tabTarget != null) {
            this.sendCommand(this._tabCommand, this._tabTarget);
            return;
        }
        if (this.rootView() != null) {
            this.rootView().selectViewAfter(this);
        }
    }

    void sendBacktabCommand() {
        if (this._backtabCommand != null && this._backtabCommand != null) {
            this.sendCommand(this._backtabCommand, this._backtabTarget);
            return;
        }
        if (this.rootView() != null) {
            this.rootView().selectViewBefore(this);
        }
    }

    void sendContentsChangedCommand() {
        this.sendCommand(this._contentsChangedCommand, this._contentsChangedTarget);
    }

    void sendCommitCommand() {
        if (this._commitCommand == null && this._commitTarget == null && this._tabCommand != null && this._tabTarget != null) {
            this.sendTabCommand();
        }
        this.sendCommand(this._commitCommand, this._commitTarget);
    }

    public boolean canPerformCommand(String string) {
        return BLINK_CARET.equals(string) || SELECT_TEXT.equals(string) || this.isEditable() && "cut".equals(string) || "copy".equals(string) || this.isEditable() && "paste".equals(string);
    }

    public void performCommand(String string, Object object) {
        if (BLINK_CARET.equals(string)) {
            this.blinkCaret();
            return;
        }
        if (SELECT_TEXT.equals(string)) {
            this.selectText();
            return;
        }
        if ("cut".equals(string)) {
            this.cut();
            return;
        }
        if ("copy".equals(string)) {
            this.copy();
            return;
        }
        if ("paste".equals(string)) {
            this.paste();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + string);
    }

    private void blinkCaret() {
        if (this._canBlink) {
            this._caretShowing = !this._caretShowing;
            this.drawCaret();
            return;
        }
        if (!this._mouseDragging && this.hasInsertionPoint()) {
            this._canBlink = true;
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.TextField", 3);
        classInfo.addField(CONTENTS_KEY, (byte)16);
        classInfo.addField(OWNER_KEY, (byte)18);
        classInfo.addField(FILTER_KEY, (byte)18);
        classInfo.addField(TABREC_KEY, (byte)18);
        classInfo.addField(BACKTABREC_KEY, (byte)18);
        classInfo.addField(CONTENTSCHANGEDREC_KEY, (byte)18);
        classInfo.addField(COMMITREC_KEY, (byte)18);
        classInfo.addField(BORDER_KEY, (byte)18);
        classInfo.addField(FONT_KEY, (byte)18);
        classInfo.addField(TEXTC_KEY, (byte)18);
        classInfo.addField(BACKGROUNDC_KEY, (byte)18);
        classInfo.addField(SELECTIONC_KEY, (byte)18);
        classInfo.addField(CARETC_KEY, (byte)18);
        classInfo.addField(TABCOM_KEY, (byte)16);
        classInfo.addField(BACKTABCOM_KEY, (byte)16);
        classInfo.addField(CONTENTSCHANGEDCOM_KEY, (byte)16);
        classInfo.addField(COMMITCOM_KEY, (byte)16);
        classInfo.addField(SELECTIONANCH_KEY, (byte)8);
        classInfo.addField(SELECTIONEND_KEY, (byte)8);
        classInfo.addField(JUSTIFICATION_KEY, (byte)8);
        classInfo.addField(SCROLLOFFSET_KEY, (byte)8);
        classInfo.addField(EDITABLE_KEY, (byte)0);
        classInfo.addField(SELECTABLE_KEY, (byte)0);
        classInfo.addField(SHADOWED_KEY, (byte)0);
        classInfo.addField(CANWRAP_KEY, (byte)0);
        classInfo.addField(AUTOSCROLLEVENT_KEY, (byte)0);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
        classInfo.addField(DRAWABLE_CHAR_KEY, (byte)2);
        classInfo.addField(SCROLLABLE_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeString(CONTENTS_KEY, this._contents.toString());
        encoder.encodeObject(OWNER_KEY, (Codable)((Object)this._owner));
        encoder.encodeObject(FILTER_KEY, (Codable)((Object)this._filter));
        encoder.encodeObject(TABREC_KEY, (Codable)((Object)this._tabTarget));
        encoder.encodeObject(BACKTABREC_KEY, (Codable)((Object)this._backtabTarget));
        encoder.encodeObject(CONTENTSCHANGEDREC_KEY, (Codable)((Object)this._contentsChangedTarget));
        encoder.encodeObject(COMMITREC_KEY, (Codable)((Object)this._commitTarget));
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
        } else {
            encoder.encodeObject(BORDER_KEY, this.border);
        }
        encoder.encodeObject(FONT_KEY, this._font);
        encoder.encodeObject(TEXTC_KEY, this._textColor);
        encoder.encodeObject(BACKGROUNDC_KEY, this._backgroundColor);
        encoder.encodeObject(SELECTIONC_KEY, this._selectionColor);
        encoder.encodeObject(CARETC_KEY, this._caretColor);
        encoder.encodeString(TABCOM_KEY, this._tabCommand);
        encoder.encodeString(BACKTABCOM_KEY, this._backtabCommand);
        encoder.encodeString(CONTENTSCHANGEDCOM_KEY, this._contentsChangedCommand);
        encoder.encodeString(COMMITCOM_KEY, this._commitCommand);
        encoder.encodeInt(SELECTIONANCH_KEY, this._selectionAnchorChar);
        encoder.encodeInt(SELECTIONEND_KEY, this._selectionEndChar);
        encoder.encodeInt(JUSTIFICATION_KEY, this._justification);
        encoder.encodeInt(SCROLLOFFSET_KEY, this._scrollOffset);
        encoder.encodeBoolean(EDITABLE_KEY, this._editable);
        encoder.encodeBoolean(SELECTABLE_KEY, this._selectable);
        encoder.encodeBoolean(SHADOWED_KEY, this._shadowed);
        encoder.encodeBoolean(CANWRAP_KEY, this._canWrap);
        encoder.encodeBoolean(AUTOSCROLLEVENT_KEY, this.wantsAutoscrollEvents);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeChar(DRAWABLE_CHAR_KEY, this._drawableCharacter);
        encoder.encodeBoolean(SCROLLABLE_KEY, this.isScrollable);
    }

    public void decode(Decoder decoder) throws CodingException {
        int n = decoder.versionForClassName("netscape.application.TextField");
        super.decode(decoder);
        String string = decoder.decodeString(CONTENTS_KEY);
        if (string != null) {
            this._contents = new FastStringBuffer(string);
        }
        this._owner = (TextFieldOwner)decoder.decodeObject(OWNER_KEY);
        this._filter = (TextFilter)decoder.decodeObject(FILTER_KEY);
        this._tabTarget = (Target)decoder.decodeObject(TABREC_KEY);
        this._backtabTarget = (Target)decoder.decodeObject(BACKTABREC_KEY);
        this._contentsChangedTarget = (Target)decoder.decodeObject(CONTENTSCHANGEDREC_KEY);
        this._commitTarget = (Target)decoder.decodeObject(COMMITREC_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
        this._font = (Font)decoder.decodeObject(FONT_KEY);
        this._textColor = (Color)decoder.decodeObject(TEXTC_KEY);
        this._backgroundColor = (Color)decoder.decodeObject(BACKGROUNDC_KEY);
        this._selectionColor = (Color)decoder.decodeObject(SELECTIONC_KEY);
        this._caretColor = (Color)decoder.decodeObject(CARETC_KEY);
        this._tabCommand = decoder.decodeString(TABCOM_KEY);
        this._backtabCommand = decoder.decodeString(BACKTABCOM_KEY);
        this._contentsChangedCommand = decoder.decodeString(CONTENTSCHANGEDCOM_KEY);
        this._commitCommand = decoder.decodeString(COMMITCOM_KEY);
        this._selectionAnchorChar = decoder.decodeInt(SELECTIONANCH_KEY);
        this._selectionEndChar = decoder.decodeInt(SELECTIONEND_KEY);
        this._justification = decoder.decodeInt(JUSTIFICATION_KEY);
        this._scrollOffset = decoder.decodeInt(SCROLLOFFSET_KEY);
        this._editable = decoder.decodeBoolean(EDITABLE_KEY);
        this._selectable = decoder.decodeBoolean(SELECTABLE_KEY);
        this._shadowed = decoder.decodeBoolean(SHADOWED_KEY);
        this._canWrap = decoder.decodeBoolean(CANWRAP_KEY);
        this.wantsAutoscrollEvents = decoder.decodeBoolean(AUTOSCROLLEVENT_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        this._drawableCharacter = n >= 2 ? decoder.decodeChar(DRAWABLE_CHAR_KEY) : ANY_CHARACTER;
        if (n >= 3) {
            this.isScrollable = decoder.decodeBoolean(SCROLLABLE_KEY);
            return;
        }
        this.isScrollable = true;
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        this.setFont(this._font);
    }

    boolean isWordCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    Range groupForIndex(int n) {
        int n2 = this.charCount();
        if (n2 == 0) {
            return new Range();
        }
        if (this._drawableCharacter != ANY_CHARACTER) {
            return new Range(0, this.charCount());
        }
        if (n < 0) {
            n = 0;
        } else if (n >= n2) {
            n = n2 - 1;
        }
        int n3 = n;
        char c = this._contents.charAt(n3);
        if (c == '\n') {
            return new Range(n3, 1);
        }
        if (c == ' ' || c == '\t') {
            while (n3 > 0) {
                c = this._contents.charAt(n3);
                if (c != ' ' && c != '\t') break;
                --n3;
            }
            int n4 = n3 + 1;
            n3 = n;
            while (n3 < n2) {
                c = this._contents.charAt(n3);
                if (c != ' ' && c != '\t') break;
                ++n3;
            }
            int n5 = n3 - 1;
            return new Range(n4, n5 - n4 + 1);
        }
        if (!this.isWordCharacter(c)) {
            return new Range(n, 1);
        }
        int n6 = n3;
        while (n6 > 0) {
            c = this._contents.charAt(n6 - 1);
            if (!this.isWordCharacter(c)) break;
            --n6;
        }
        int n7 = n3;
        while (n7 < n2 - 1) {
            c = this._contents.charAt(n7 + 1);
            if (!this.isWordCharacter(c)) break;
            ++n7;
        }
        return new Range(n6, n7 - n6 + 1);
    }

    private String drawableString() {
        if (this._drawableCharacter == ANY_CHARACTER) {
            if (this._contents != null) {
                return this._contents.toString();
            }
            return "";
        }
        if (this._contents != null && this._contents.length() > 0) {
            char[] cArray = new char[this._contents.length()];
            int n = 0;
            int n2 = cArray.length;
            while (n < n2) {
                cArray[n] = this._drawableCharacter;
                ++n;
            }
            return new String(cArray);
        }
        return "";
    }

    public void willBecomeSelected() {
        if (!this._ignoreWillBecomeSelected) {
            this.selectText();
        }
    }

    public boolean canBecomeSelectedView() {
        return this.isEditable();
    }

    public View nextSelectableView() {
        if (this._tabTarget != null && this._tabTarget instanceof View) {
            return (View)((Object)this._tabTarget);
        }
        return null;
    }

    public View previousSelectableView() {
        if (this._backtabTarget != null && this._backtabTarget instanceof View) {
            return (View)((Object)this._backtabTarget);
        }
        return null;
    }

    public void copy() {
        Application.setClipboardText(this.stringForRange(this.selectedRange()));
    }

    public void cut() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            if (range == null || range.index < 0) {
                return;
            }
            Application.setClipboardText(this.stringForRange(range));
            this.replaceRangeWithString(range, "");
            this.selectRange(new Range(range.index(), 0));
        }
    }

    public void paste() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            String string = Application.clipboardText();
            if (range == null || string == null) {
                return;
            }
            this.replaceRangeWithString(range, string);
            this.selectRange(new Range(range.index() + string.length(), 0));
        }
    }

    public boolean isScrollable() {
        return this.isScrollable;
    }

    public void setScrollable(boolean bl) {
        this.isScrollable = bl;
    }

    public String formElementText() {
        return this.stringValue();
    }
}

