/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.Graphics;
import netscape.application.InternalWindow;
import netscape.application.KeyEvent;
import netscape.application.KeyStroke;
import netscape.application.LayoutManager;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.VectorCache;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class View
implements Codable {
    View _superview;
    Size _minSize;
    Bitmap drawingBuffer;
    private Vector subviews;
    private Vector kbdOrder;
    LayoutManager layoutManager;
    Hashtable _keyboardBindings;
    public Rect bounds = new Rect();
    Rect dirtyRect;
    byte resizeInstr = (byte)4;
    int drawingDisabled;
    boolean autoResizeSubviews = true;
    boolean buffered;
    boolean drawingBufferValid;
    boolean drawingBufferIsBitCache;
    boolean isDirty;
    boolean needFocus;
    boolean focusPaused;
    boolean wantsKeyboardArrow;
    public static final int RIGHT_MARGIN_CAN_CHANGE = 0;
    public static final int LEFT_MARGIN_CAN_CHANGE = 1;
    public static final int WIDTH_CAN_CHANGE = 2;
    public static final int CENTER_HORIZ = 32;
    public static final int BOTTOM_MARGIN_CAN_CHANGE = 4;
    public static final int TOP_MARGIN_CAN_CHANGE = 8;
    public static final int HEIGHT_CAN_CHANGE = 16;
    public static final int CENTER_VERT = 64;
    private static final int DEFAULT_RESIZE_INSTR = 4;
    private static final int VERT_MASK = 92;
    private static final int HORZ_MASK = 35;
    static final String MINSIZE_KEY = "minSize";
    static final String BOUNDS_KEY = "bounds";
    static final String SUBVIEWS_KEY = "subviews";
    static final String RESIZE_KEY = "resizeInstr";
    static final String DRAWINGDISABLED_KEY = "drawingDisabled";
    static final String AUTORESIZE_KEY = "autoResizeSubviews";
    static final String BUFFERED_KEY = "buffered";
    static final String LAYOUTMANAGER_KEY = "layoutManager";
    static final String KEYBOARD_BINDINGS_KEY = "keyboardBindings";
    private static final String KBD_COMMAND_KEY = "kbdCmd";
    private static final String KBD_WHEN = "when";
    private static final String KBD_DATA_KEY = "kbdData";
    static final int DEFAULT_CURSOR = -1;
    public static final int ARROW_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    public static final int WHEN_SELECTED = 0;
    public static final int WHEN_IN_MAIN_WINDOW = 1;
    public static final int ALWAYS = 2;

    public View() {
        this(0, 0, 0, 0);
    }

    public View(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public View(int n, int n2, int n3, int n4) {
        this._setBounds(n, n2, n3, n4);
    }

    void _setBounds(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
    }

    int subviewCount() {
        if (this.subviews == null) {
            return 0;
        }
        return this.subviews.count();
    }

    public Vector subviews() {
        if (this.subviews == null) {
            this.subviews = new Vector();
        }
        return this.subviews;
    }

    public Vector peersForSubview(View view) {
        if (this.subviewCount() == 0 || !this.subviews().contains(view)) {
            return new Vector();
        }
        Vector vector = new Vector();
        vector.addElementsIfAbsent(this.subviews);
        return vector;
    }

    public boolean descendsFrom(View view) {
        if (view == this) {
            return true;
        }
        if (this._superview == null || view == null) {
            return false;
        }
        if (this._superview == view) {
            return true;
        }
        return this._superview.descendsFrom(view);
    }

    public InternalWindow window() {
        if (this._superview == null) {
            return null;
        }
        return this._superview.window();
    }

    public Rect bounds() {
        return new Rect(this.bounds);
    }

    public int x() {
        return this.bounds.x;
    }

    public int y() {
        return this.bounds.y;
    }

    public int width() {
        return this.bounds.width;
    }

    public int height() {
        return this.bounds.height;
    }

    public View superview() {
        return this._superview;
    }

    public void setHorizResizeInstruction(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 32) {
            throw new IllegalArgumentException("invalid horz resize instruction " + n);
        }
        this.resizeInstr = (byte)(this.resizeInstr & 0x5C);
        this.resizeInstr = (byte)(this.resizeInstr | n);
    }

    public int horizResizeInstruction() {
        return this.resizeInstr & 0x23;
    }

    public void setVertResizeInstruction(int n) {
        if (n != 4 && n != 8 && n != 16 && n != 64) {
            throw new IllegalArgumentException("invalid vert resize instruction " + n);
        }
        this.resizeInstr = (byte)(this.resizeInstr & 0x23);
        this.resizeInstr = (byte)(this.resizeInstr | n);
    }

    public int vertResizeInstruction() {
        return this.resizeInstr & 0x5C;
    }

    public boolean wantsAutoscrollEvents() {
        return false;
    }

    public DragDestination acceptsDrag(DragSession dragSession, int n, int n2) {
        return null;
    }

    public void setAutoResizeSubviews(boolean bl) {
        this.autoResizeSubviews = bl;
    }

    public boolean doesAutoResizeSubviews() {
        return this.autoResizeSubviews;
    }

    public void didMoveBy(int n, int n2) {
    }

    public void didSizeBy(int n, int n2) {
        if (!this.autoResizeSubviews) {
            return;
        }
        this.layoutView(n, n2);
    }

    public void setBounds(Rect rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = n - this.bounds.x;
        int n6 = n2 - this.bounds.y;
        int n7 = n3 - this.bounds.width;
        int n8 = n4 - this.bounds.height;
        boolean bl2 = n5 != 0 || n6 != 0;
        boolean bl3 = bl = n7 != 0 || n8 != 0;
        if (!bl2 && !bl) {
            return;
        }
        this._setBounds(n, n2, n3, n4);
        if (this.buffered && bl) {
            if (this.drawingBuffer != null) {
                this.drawingBuffer.flush();
            }
            this.drawingBuffer = n3 > 0 && n4 > 0 ? this.createBuffer() : null;
            this.drawingBufferValid = false;
        }
        if (bl2) {
            if (this._superview != null) {
                this._superview.subviewDidMove(this);
            }
            this.didMoveBy(n5, n6);
        }
        if (bl) {
            if (this._superview != null) {
                this._superview.subviewDidResize(this);
            }
            this.didSizeBy(n7, n8);
        }
    }

    public void moveBy(int n, int n2) {
        this.setBounds(this.bounds.x + n, this.bounds.y + n2, this.bounds.width, this.bounds.height);
    }

    public void moveTo(int n, int n2) {
        this.setBounds(n, n2, this.bounds.width, this.bounds.height);
    }

    public void sizeBy(int n, int n2) {
        this.setBounds(this.bounds.x, this.bounds.y, this.bounds.width + n, this.bounds.height + n2);
    }

    public void sizeTo(int n, int n2) {
        this.setBounds(this.bounds.x, this.bounds.y, n, n2);
    }

    public void setMinSize(int n, int n2) {
        if (n == -1 || n2 == -1) {
            this._minSize = null;
            return;
        }
        this._minSize = new Size(n, n2);
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        return new Size();
    }

    public void sizeToMinSize() {
        Size size = this.minSize();
        this.sizeTo(size.width, size.height);
    }

    public void subviewDidResize(View view) {
        if (this._superview != null) {
            this._superview.subviewDidResize(view);
        }
    }

    public void subviewDidMove(View view) {
        if (this._superview != null) {
            this._superview.subviewDidMove(view);
        }
    }

    private void setSuperview(View view) {
        this._superview = view;
        this.ancestorWasAddedToViewHierarchy(view);
        RootView rootView = this.rootView();
        if (rootView != null) {
            rootView.updateCursorLater();
            rootView.viewHierarchyChanged();
        }
    }

    public void addSubview(View view) {
        if (view == null) {
            return;
        }
        this.invalidateKeyboardSelectionOrder();
        if (this.subviews == null) {
            this.subviews = new Vector();
        } else if (this.subviews.contains(view)) {
            return;
        }
        this.subviews.addElement(view);
        view.setSuperview(this);
        if (this.layoutManager != null) {
            this.layoutManager.addSubview(view);
        }
    }

    protected void ancestorWasAddedToViewHierarchy(View view) {
        if (this.buffered) {
            this.setBuffered(true);
        }
        if (this.needFocus) {
            this.setFocusedView();
        }
        int n = this.subviewCount();
        while (n-- > 0) {
            View view2 = (View)this.subviews.elementAt(n);
            view2.ancestorWasAddedToViewHierarchy(view);
        }
    }

    protected void removeSubview(View view) {
        this.invalidateKeyboardSelectionOrder();
        if (this.subviews != null) {
            this.subviews.removeElement(view);
        }
        if (this.layoutManager != null) {
            this.layoutManager.removeSubview(view);
        }
    }

    public void removeFromSuperview() {
        if (this._superview != null) {
            RootView rootView = this.rootView();
            if (rootView != null) {
                rootView.updateCursorLater();
            }
            this.ancestorWillRemoveFromViewHierarchy(this);
            this._superview.removeSubview(this);
            this._superview = null;
            if (rootView != null) {
                rootView.viewHierarchyChanged();
            }
        }
    }

    protected void ancestorWillRemoveFromViewHierarchy(View view) {
        RootView rootView;
        if (this.drawingBuffer != null) {
            this.drawingBuffer.flush();
            this.drawingBuffer = null;
        }
        if ((rootView = this.rootView()) != null) {
            if (rootView.mouseView() == this) {
                rootView.setMouseView(null);
            }
            if (rootView._moveView == this) {
                rootView._moveView = null;
            }
        }
        if (this.isDirty) {
            this.setDirty(false);
        }
        int n = this.subviewCount();
        while (n-- > 0) {
            View view2 = (View)this.subviews.elementAt(n);
            view2.ancestorWillRemoveFromViewHierarchy(view);
        }
    }

    public boolean containsPoint(int n, int n2) {
        return Rect.contains(0, 0, this.width(), this.height(), n, n2);
    }

    public boolean containsPointInVisibleRect(int n, int n2) {
        Rect rect = Rect.newRect();
        this.computeVisibleRect(rect);
        boolean bl = rect.contains(n, n2);
        Rect.returnRect(rect);
        return bl;
    }

    View _viewForRect(Rect rect, View view) {
        Rect rect2;
        View view2 = null;
        if (rect == null) {
            return null;
        }
        if (view != null) {
            if (!this.bounds.contains(rect)) {
                return null;
            }
            rect2 = Rect.newRect();
            view.convertRectToView(this, rect, rect2);
        } else {
            rect2 = Rect.newRect(rect);
        }
        int n = this.subviewCount();
        while (n-- > 0) {
            View view3 = (View)this.subviews.elementAt(n);
            view2 = view3._viewForRect(rect2, this);
            if (view2 != null) break;
        }
        Rect.returnRect(rect2);
        if (view2 != null) {
            return view2;
        }
        if (this.isTransparent() && view != null) {
            return null;
        }
        return this;
    }

    public View viewForMouse(int n, int n2) {
        if (!this.containsPoint(n, n2)) {
            return null;
        }
        int n3 = this.subviewCount();
        while (n3-- > 0) {
            View view;
            View view2 = (View)this.subviews.elementAt(n3);
            if (view2 instanceof InternalWindow || (view = view2.viewForMouse(n - view2.bounds.x, n2 - view2.bounds.y)) == null) continue;
            return view;
        }
        return this;
    }

    public int cursorForPoint(int n, int n2) {
        return 0;
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyDown(KeyEvent keyEvent) {
        if (this._superview != null) {
            this._superview.keyDown(keyEvent);
        }
    }

    public void keyUp(KeyEvent keyEvent) {
        if (this._superview != null) {
            this._superview.keyUp(keyEvent);
        }
    }

    View scrollingView() {
        if (this._superview != null) {
            return this._superview.scrollingView();
        }
        return null;
    }

    public void scrollRectToVisible(Rect rect) {
        if (this._superview != null) {
            this._superview.scrollRectToVisible(this.convertRectToView(this._superview, rect));
        }
    }

    public void disableDrawing() {
        ++this.drawingDisabled;
    }

    public void reenableDrawing() {
        --this.drawingDisabled;
        if (this.drawingDisabled < 0) {
            this.drawingDisabled = 0;
        }
    }

    public boolean isDrawingEnabled() {
        return this.drawingDisabled == 0;
    }

    public boolean isInViewHierarchy() {
        RootView rootView = this.rootView();
        return rootView != null && rootView.isVisible();
    }

    public RootView rootView() {
        if (this._superview == null) {
            return null;
        }
        return this._superview.rootView();
    }

    public boolean canDraw() {
        if (this.drawingDisabled > 0 || this._superview == null) {
            return false;
        }
        return this._superview.canDraw();
    }

    public void computeVisibleRect(Rect rect) {
        if (this._superview == null) {
            rect.setBounds(0, 0, this.width(), this.height());
            return;
        }
        this._superview.computeVisibleRect(rect);
        this._superview.convertRectToView(this, rect, rect);
        rect.intersectWith(0, 0, this.width(), this.height());
    }

    public boolean isTransparent() {
        return true;
    }

    public boolean wantsMouseEventCoalescing() {
        return true;
    }

    View opaqueAncestor() {
        if (this.isTransparent() && this._superview != null) {
            return this._superview.opaqueAncestor();
        }
        return this;
    }

    public void addDirtyRect(Rect rect) {
        if (rect == null) {
            this.setDirty(true);
            return;
        }
        if (this.isDirty) {
            if (this.dirtyRect != null) {
                this.dirtyRect.unionWith(rect);
                return;
            }
        } else {
            RootView rootView = this.rootView();
            if (rootView != null) {
                this.dirtyRect = new Rect(rect);
                rootView.markDirty(this);
                this.isDirty = true;
            }
        }
    }

    public void setDirty(boolean bl) {
        RootView rootView;
        if (bl) {
            RootView rootView2;
            if (!this.isDirty && (rootView2 = this.rootView()) != null) {
                rootView2.markDirty(this);
                this.isDirty = true;
            }
        } else if (this.isDirty && (rootView = this.rootView()) != null) {
            rootView.markClean(this);
            this.isDirty = false;
        }
        this.dirtyRect = null;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void drawView(Graphics graphics) {
    }

    public void drawSubviews(Graphics graphics) {
        Rect rect = null;
        if (this.drawingDisabled > 0) {
            return;
        }
        Rect rect2 = graphics.clipRect();
        int n = this.subviewCount();
        int n2 = 0;
        while (n2 < n) {
            View view = (View)this.subviews.elementAt(n2);
            boolean bl = view.isDrawingEnabled();
            if (rect == null) {
                rect = Rect.newRect();
            }
            this.convertRectToView(view, rect2, rect);
            rect.intersectWith(0, 0, view.bounds.width, view.bounds.height);
            if (bl && !rect.isEmpty()) {
                view._drawView(graphics, rect, false);
            }
            ++n2;
        }
        if (rect != null) {
            Rect.returnRect(rect);
        }
    }

    void _drawView(Graphics graphics, Rect rect, boolean bl) {
        if (this.drawingDisabled > 0) {
            return;
        }
        graphics.pushState();
        graphics.setDebug(this);
        if (!bl) {
            graphics.translate(this.bounds.x, this.bounds.y);
        }
        if (rect == null) {
            Rect rect2 = Rect.newRect(0, 0, this.width(), this.height());
            graphics.setClipRect(rect2);
            Rect.returnRect(rect2);
        } else {
            graphics.setClipRect(rect);
        }
        if (this.drawingBuffer != null && bl && !graphics.isDrawingBuffer()) {
            this.drawingBuffer.drawAt(graphics, 0, 0);
        } else {
            this.drawView(graphics);
            this.drawSubviews(graphics);
        }
        graphics.popState();
    }

    void clipAndDrawView(Graphics graphics, Rect rect) {
        Rect rect2;
        if (graphics.isDrawingBuffer()) {
            rect2 = Rect.newRect(0, 0, this.width(), this.height());
        } else {
            rect2 = Rect.newRect();
            this.computeVisibleRect(rect2);
        }
        rect2.intersectWith(rect);
        rect = rect2;
        Vector vector = this == this.rootView() && rect.x == 0 && rect.y == 0 && rect.width == this.width() && rect.height == this.height() || graphics.isDrawingBuffer() ? null : this.rootView().windowRects(this.convertRectToView(null, rect), this.window());
        if (vector == null || vector.isEmpty()) {
            this._drawView(graphics, rect, true);
            Rect.returnRect(rect);
        } else {
            int n;
            Vector vector2 = VectorCache.newVector();
            Vector vector3 = VectorCache.newVector();
            rect.x += this.absoluteX();
            rect.y += this.absoluteY();
            vector3.addElement(rect);
            Vector vector4 = VectorCache.newVector();
            int n2 = vector.count();
            while (n2-- > 0) {
                Rect rect3 = (Rect)vector.elementAt(n2);
                n = vector3.count();
                while (n-- > 0) {
                    Rect rect4 = (Rect)vector3.elementAt(n);
                    rect4.computeDisunionRects(rect3, vector2);
                    if (!vector2.isEmpty()) {
                        vector4.addElementsIfAbsent(vector2);
                        vector2.removeAllElements();
                        continue;
                    }
                    if (rect3.contains(rect4)) continue;
                    vector4.addElement(rect4);
                    vector3.removeElement(rect4);
                }
                Vector vector5 = vector3;
                vector3 = vector4;
                vector4 = vector5;
                Rect.returnRects(vector4);
            }
            VectorCache.returnVector(vector2);
            VectorCache.returnVector(vector4);
            int n3 = vector3.count();
            n2 = 0;
            while (n2 < n3) {
                Rect rect5 = (Rect)vector3.elementAt(n2);
                n = n3;
                while (n-- > 0) {
                    Rect rect6 = (Rect)vector3.elementAt(n);
                    if (rect6 == rect5 || !rect5.contains(rect6)) continue;
                    Rect.returnRect((Rect)vector3.removeElementAt(n));
                    --n3;
                    n2 = -1;
                    break;
                }
                ++n2;
            }
            n2 = vector3.count();
            while (n2-- > 0) {
                rect = (Rect)vector3.elementAt(n2);
                if (rect.isEmpty()) continue;
                rect.x -= this.absoluteX();
                rect.y -= this.absoluteY();
                this._drawView(graphics, rect, true);
            }
            Rect.returnRects(vector3);
            VectorCache.returnVector(vector3);
        }
        Rect.returnRects(vector);
        VectorCache.returnVector(vector);
    }

    void _draw(Graphics graphics, Rect rect) {
        boolean bl;
        boolean bl2 = bl = this.drawingBuffer != null && !graphics.isDrawingBuffer() ? false : this.isTransparent();
        if (bl && !(this instanceof InternalWindow)) {
            Rect rect2 = Rect.newRect();
            View view = this.opaqueAncestor();
            this.convertRectToView(view, rect, rect2);
            graphics.pushState();
            graphics.translate(rect.x - rect2.x, rect.y - rect2.y);
            view.draw(graphics, rect2);
            Rect.returnRect(rect2);
            graphics.popState();
            return;
        }
        this.updateInvalidDrawingBuffers(rect);
        this.clipAndDrawView(graphics, rect);
    }

    public void draw(Graphics graphics, Rect rect) {
        if (rect != null) {
            rect = Rect.newRect(rect);
            rect.intersectWith(0, 0, this.width(), this.height());
            if (rect.isEmpty()) {
                Rect.returnRect(rect);
                return;
            }
        } else {
            rect = Rect.newRect(0, 0, this.width(), this.height());
        }
        boolean bl = this.canDraw();
        if (graphics == null || !graphics.isDrawingBuffer()) {
            if (this.drawingBuffer == null) {
                if (!bl) {
                    Rect.returnRect(rect);
                    return;
                }
                View view = this.ancestorWithDrawingBuffer();
                if (view != null && view != this) {
                    Rect rect2 = Rect.newRect();
                    this.computeVisibleRect(rect2);
                    rect2.intersectWith(rect);
                    this.convertRectToView(view, rect2, rect2);
                    view.drawingBufferValid = false;
                    if (graphics == null) {
                        graphics = view.createGraphics();
                        view.draw(graphics, rect2);
                        graphics.dispose();
                        graphics = null;
                    } else {
                        Point point = new Point(0, 0);
                        this.convertPointToView(view, point, point);
                        graphics.pushState();
                        try {
                            graphics.translate(-point.x, -point.y);
                            view.draw(graphics, rect2);
                        }
                        finally {
                            Object var9_7 = null;
                            graphics.popState();
                        }
                    }
                    Rect.returnRect(rect2);
                    Rect.returnRect(rect);
                    return;
                }
            } else if (!this.drawingBufferIsBitCache) {
                this.updateDrawingBuffer(rect);
            }
            Rect rect3 = this.convertRectToView(this.rootView(), rect);
            this.rootView().redrawTransparentWindows(rect3, this.window());
        }
        if (graphics != null && graphics.isDrawingBuffer() || bl) {
            if (graphics == null) {
                graphics = this.createGraphics();
                this._draw(graphics, rect);
                graphics.dispose();
                graphics = null;
            } else {
                this._draw(graphics, rect);
            }
        }
        Rect.returnRect(rect);
    }

    public void draw(Rect rect) {
        if (this.isInViewHierarchy()) {
            this.draw(null, rect);
        }
    }

    public void draw() {
        if (this.isInViewHierarchy()) {
            this.draw(null, null);
        }
    }

    public void setBuffered(boolean bl) {
        this.buffered = bl;
        if (bl && this.drawingBuffer == null) {
            if (this.bounds.width != 0 && this.bounds.height != 0) {
                this.drawingBuffer = this.createBuffer();
            }
            this.drawingBufferValid = false;
            return;
        }
        if (!bl && this.drawingBuffer != null) {
            this.drawingBuffer.flush();
            this.drawingBuffer = null;
        }
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public Bitmap drawingBuffer() {
        return this.drawingBuffer;
    }

    void updateDrawingBuffer(Rect rect) {
        if (!rect.intersects(0, 0, this.width(), this.height())) {
            return;
        }
        if (this.drawingBuffer != null) {
            Bitmap bitmap = this.drawingBuffer;
            synchronized (bitmap) {
                Graphics graphics = Graphics.newGraphics(this.drawingBuffer);
                this.drawingBufferValid = true;
                graphics.setDebugOptions(this.shouldDebugGraphics());
                this.draw(graphics, rect);
                if (!this.canDraw()) {
                    this.drawingBufferValid = false;
                }
                graphics.dispose();
                graphics = null;
                return;
            }
        }
    }

    void updateInvalidDrawingBuffers(Rect rect) {
        Rect rect2 = null;
        int n = this.subviewCount();
        while (n-- > 0) {
            View view = (View)this.subviews.elementAt(n);
            if (rect2 == null) {
                rect2 = Rect.newRect();
            }
            this.convertRectToView(view, rect, rect2);
            if (!rect2.intersects(0, 0, view.width(), view.height())) continue;
            if (view.drawingBuffer != null && !view.drawingBufferValid) {
                view.updateDrawingBuffer(rect2);
            }
            view.updateInvalidDrawingBuffers(rect2);
        }
        if (rect2 != null) {
            Rect.returnRect(rect2);
        }
    }

    View ancestorWithDrawingBuffer() {
        if (this.drawingBuffer != null) {
            return this;
        }
        if (this._superview == null) {
            return null;
        }
        return this._superview.ancestorWithDrawingBuffer();
    }

    void _startFocus() {
        if (this.focusPaused) {
            this.focusPaused = false;
            this.resumeFocus();
            return;
        }
        this.startFocus();
    }

    void _stopFocus() {
        this.focusPaused = false;
        this.stopFocus();
    }

    void _pauseFocus() {
        this.focusPaused = true;
        this.pauseFocus();
    }

    public void startFocus() {
    }

    public void stopFocus() {
    }

    public void pauseFocus() {
    }

    public void resumeFocus() {
    }

    void setFocusedView(View view) {
        if (this._superview != null) {
            this._superview.setFocusedView(view);
        }
    }

    public void setFocusedView() {
        if (this._superview != null && (this.isInViewHierarchy() || this.window() != null)) {
            this._superview.setFocusedView(this);
            this.needFocus = false;
            return;
        }
        this.needFocus = true;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.View", 2);
        classInfo.addField(BOUNDS_KEY, (byte)18);
        classInfo.addField(MINSIZE_KEY, (byte)18);
        classInfo.addField(SUBVIEWS_KEY, (byte)18);
        classInfo.addField(RESIZE_KEY, (byte)4);
        classInfo.addField(DRAWINGDISABLED_KEY, (byte)8);
        classInfo.addField(AUTORESIZE_KEY, (byte)0);
        classInfo.addField(BUFFERED_KEY, (byte)0);
        classInfo.addField(LAYOUTMANAGER_KEY, (byte)18);
        classInfo.addField(KEYBOARD_BINDINGS_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(BOUNDS_KEY, this.bounds);
        encoder.encodeObject(MINSIZE_KEY, this._minSize);
        if (this.subviewCount() == 0) {
            encoder.encodeObject(SUBVIEWS_KEY, null);
        } else {
            encoder.encodeObject(SUBVIEWS_KEY, this.subviews);
        }
        encoder.encodeByte(RESIZE_KEY, this.resizeInstr);
        encoder.encodeInt(DRAWINGDISABLED_KEY, this.drawingDisabled);
        encoder.encodeBoolean(AUTORESIZE_KEY, this.autoResizeSubviews);
        encoder.encodeBoolean(BUFFERED_KEY, this.buffered);
        encoder.encodeObject(LAYOUTMANAGER_KEY, this.layoutManager);
        encoder.encodeObject(KEYBOARD_BINDINGS_KEY, this._keyboardBindings);
    }

    public void decode(Decoder decoder) throws CodingException {
        int n = decoder.versionForClassName("netscape.application.View");
        this.bounds = (Rect)decoder.decodeObject(BOUNDS_KEY);
        this._minSize = (Size)decoder.decodeObject(MINSIZE_KEY);
        Object object = decoder.decodeObject(SUBVIEWS_KEY);
        if (object != null) {
            this.subviews = (Vector)object;
        }
        this.resizeInstr = decoder.decodeByte(RESIZE_KEY);
        this.drawingDisabled = decoder.decodeInt(DRAWINGDISABLED_KEY);
        boolean bl = decoder.decodeBoolean(AUTORESIZE_KEY);
        if (bl) {
            this.setAutoResizeSubviews(bl);
        }
        if (bl = decoder.decodeBoolean(BUFFERED_KEY)) {
            this.setBuffered(bl);
        }
        this.layoutManager = (LayoutManager)decoder.decodeObject(LAYOUTMANAGER_KEY);
        if (n >= 2) {
            this._keyboardBindings = (Hashtable)decoder.decodeObject(KEYBOARD_BINDINGS_KEY);
        }
    }

    public void finishDecoding() throws CodingException {
        int n = this.subviewCount();
        while (n-- > 0) {
            View view = (View)this.subviews.elementAt(n);
            view.setSuperview(this);
            view._setBounds(view.bounds.x, view.bounds.y, view.bounds.width, view.bounds.height);
        }
        this._setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    Application application() {
        return Application.application();
    }

    public void convertToView(View view, int n, int n2, Point point) {
        int n3 = n;
        int n4 = n2;
        if (this._superview == view) {
            n3 += this.bounds.x;
            n4 += this.bounds.y;
        } else if (view != null && view._superview == this) {
            n3 -= view.bounds.x;
            n4 -= view.bounds.y;
        } else {
            View view2 = this;
            while (view2._superview != null) {
                n3 += view2.bounds.x;
                n4 += view2.bounds.y;
                view2 = view2._superview;
            }
            if (view != null) {
                View view3 = view;
                while (view3._superview != null) {
                    n3 -= view3.bounds.x;
                    n4 -= view3.bounds.y;
                    view3 = view3._superview;
                }
                if (view2 != view3) {
                    throw new InconsistencyException("Can't convert between " + this + " and " + view + ", no common ancestor");
                }
            }
        }
        point.x = n3;
        point.y = n4;
    }

    public Point convertToView(View view, int n, int n2) {
        Point point = new Point();
        this.convertToView(view, n, n2, point);
        return point;
    }

    public void convertRectToView(View view, Rect rect, Rect rect2) {
        Point point = Point.newPoint();
        this.convertToView(view, rect.x, rect.y, point);
        rect2.setBounds(point.x, point.y, rect.width, rect.height);
        Point.returnPoint(point);
    }

    public void convertPointToView(View view, Point point, Point point2) {
        this.convertToView(view, point.x, point.y, point2);
    }

    public Rect convertRectToView(View view, Rect rect) {
        Rect rect2 = new Rect();
        this.convertRectToView(view, rect, rect2);
        return rect2;
    }

    public Point convertPointToView(View view, Point point) {
        Point point2 = new Point();
        this.convertPointToView(view, point, point2);
        return point2;
    }

    public MouseEvent convertEventToView(View view, MouseEvent mouseEvent) {
        Point point = Point.newPoint();
        MouseEvent mouseEvent2 = (MouseEvent)mouseEvent.clone();
        this.convertToView(view, mouseEvent.x, mouseEvent.y, point);
        mouseEvent2.x = point.x;
        mouseEvent2.y = point.y;
        Point.returnPoint(point);
        return mouseEvent2;
    }

    public void setGraphicsDebugOptions(int n) {
        Graphics.setViewDebug(this, n);
    }

    public int graphicsDebugOptions() {
        return Graphics.viewDebug(this);
    }

    int shouldDebugGraphics() {
        return Graphics.shouldViewDebug(this);
    }

    int absoluteX() {
        int n = 0;
        View view = this;
        while (view != null) {
            n += view.bounds.x;
            view = view._superview;
        }
        return n;
    }

    int absoluteY() {
        int n = 0;
        View view = this;
        while (view != null) {
            n += view.bounds.y;
            view = view._superview;
        }
        return n;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public LayoutManager layoutManager() {
        return this.layoutManager;
    }

    public void layoutView(int n, int n2) {
        if (this.layoutManager == null) {
            this.relativeLayoutView(n, n2);
            return;
        }
        this.layoutManager.layoutView(this, n, n2);
    }

    private void relativeLayoutView(int n, int n2) {
        int n3 = this.subviewCount();
        while (n3-- > 0) {
            View view = (View)this.subviews.elementAt(n3);
            int n4 = view.bounds.x;
            int n5 = view.bounds.y;
            int n6 = view.bounds.width;
            int n7 = view.bounds.height;
            switch (view.horizResizeInstruction()) {
                case 1: {
                    n4 += n;
                    break;
                }
                case 2: {
                    n6 += n;
                    break;
                }
                case 32: {
                    n4 = (this.bounds.width - view.bounds.width) / 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid horz resize instruction: " + view.horizResizeInstruction());
                }
                case 0: 
            }
            switch (view.vertResizeInstruction()) {
                case 8: {
                    n5 += n2;
                    break;
                }
                case 16: {
                    n7 += n2;
                    break;
                }
                case 64: {
                    n5 = (this.bounds.height - view.bounds.height) / 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid vert resize instruction: " + view.vertResizeInstruction());
                }
                case 4: 
            }
            view.setBounds(n4, n5, n6, n7);
        }
    }

    public Rect localBounds() {
        return new Rect(0, 0, this.bounds.width, this.bounds.height);
    }

    public Graphics createGraphics() {
        return Graphics.newGraphics(this);
    }

    protected Bitmap createBuffer() {
        return new Bitmap(this.width(), this.height());
    }

    public String toString() {
        return super.toString() + this.bounds.toString();
    }

    public boolean canBecomeSelectedView() {
        return false;
    }

    public boolean hidesSubviewsFromKeyboard() {
        return false;
    }

    public View nextSelectableView() {
        return null;
    }

    public View previousSelectableView() {
        return null;
    }

    public void invalidateKeyboardSelectionOrder() {
        this.kbdOrder = null;
    }

    public void willBecomeSelected() {
        this.wantsKeyboardArrow = true;
    }

    public void willBecomeUnselected() {
        this.wantsKeyboardArrow = false;
    }

    public void setCommandForKey(String string, Object object, int n, int n2, int n3) {
        KeyStroke keyStroke = new KeyStroke(n, n2);
        if (this._keyboardBindings == null) {
            this._keyboardBindings = new Hashtable();
        }
        if (string == null) {
            this._keyboardBindings.remove(keyStroke);
            return;
        }
        Hashtable hashtable = new Hashtable();
        hashtable.put(KBD_COMMAND_KEY, string);
        hashtable.put(KBD_WHEN, "" + n3);
        if (object != null) {
            hashtable.put(KBD_DATA_KEY, object);
        }
        this._keyboardBindings.put(keyStroke, hashtable);
    }

    public void setCommandForKey(String string, int n, int n2) {
        this.setCommandForKey(string, this, n, 0, n2);
    }

    public void removeCommandForKey(int n) {
        this.setCommandForKey(null, null, n, 0, 0);
    }

    public void removeAllCommandsForKeys() {
        this._keyboardBindings = null;
    }

    boolean hasKeyboardBindings() {
        return this._keyboardBindings != null && this._keyboardBindings.count() > 0;
    }

    boolean performCommandForKeyStroke(KeyStroke keyStroke, int n) {
        if (!(this instanceof Target)) {
            return false;
        }
        if (this._keyboardBindings != null) {
            Enumeration enumeration = this._keyboardBindings.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke2 = (KeyStroke)enumeration.nextElement();
                if (!keyStroke2.equals(keyStroke)) continue;
                boolean bl = false;
                Hashtable hashtable = (Hashtable)this._keyboardBindings.get(keyStroke2);
                String string = (String)hashtable.get(KBD_WHEN);
                int n2 = Integer.parseInt(string);
                switch (n2) {
                    case 0: {
                        if (n != 0) break;
                        bl = true;
                        break;
                    }
                    case 1: {
                        if (n != 0 && n != 1) break;
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = true;
                        break;
                    }
                    default: {
                        throw new InconsistencyException("Wrong condition:" + n2);
                    }
                }
                if (!bl) continue;
                String string2 = (String)hashtable.get(KBD_COMMAND_KEY);
                ((Target)((Object)this)).performCommand(string2, hashtable.get(KBD_DATA_KEY));
                return true;
            }
        }
        return false;
    }

    public Rect keyboardRect() {
        return this.localBounds();
    }

    View _firstSubview(Vector vector) {
        View view;
        if (vector.count() == 0) {
            return null;
        }
        View view2 = (View)vector.elementAt(0);
        int n = view2.y();
        int n2 = 1;
        int n3 = vector.count();
        while (n2 < n3) {
            view = (View)vector.elementAt(n2);
            if (view.y() < n) {
                view2 = view;
                n = view.y();
            }
            ++n2;
        }
        View view3 = view2;
        int n4 = view2.x();
        n2 = 0;
        n3 = vector.count();
        while (n2 < n3) {
            view = (View)vector.elementAt(n2);
            if (view != view3 && (int)Math.sqrt((view.y() - view3.y()) * (view.y() - view3.y())) <= 10 && view.x() < n4) {
                view3 = view;
                n4 = view.x();
            }
            ++n2;
        }
        return view3;
    }

    private void validateKeyboardOrder() {
        if (this.kbdOrder == null) {
            Vector vector = new Vector();
            int n = 0;
            int n2 = this.subviews.count();
            while (n < n2) {
                vector.addElement(this.subviews.elementAt(n));
                ++n;
            }
            this.kbdOrder = new Vector();
            block1: while (vector.count() > 0) {
                View view;
                View view2 = this._firstSubview(vector);
                this.kbdOrder.addElement(view2);
                vector.removeElement(view2);
                while ((view = view2.nextSelectableView()) != null) {
                    if (vector.indexOfIdentical(view) == -1) continue block1;
                    this.kbdOrder.addElement(view);
                    vector.removeElement(view);
                    view2 = view;
                }
            }
        }
    }

    View firstSubview() {
        this.validateKeyboardOrder();
        if (this.kbdOrder.count() > 0) {
            return (View)this.kbdOrder.elementAt(0);
        }
        return null;
    }

    View lastSubview() {
        this.validateKeyboardOrder();
        if (this.kbdOrder.count() > 0) {
            return (View)this.kbdOrder.elementAt(this.kbdOrder.count() - 1);
        }
        return null;
    }

    View viewAfter(View view) {
        this.validateKeyboardOrder();
        int n = this.kbdOrder.indexOfIdentical(view);
        if (n != -1 && n < this.kbdOrder.count() - 1) {
            return (View)this.kbdOrder.elementAt(n + 1);
        }
        return null;
    }

    View viewBefore(View view) {
        this.validateKeyboardOrder();
        int n = this.kbdOrder.indexOfIdentical(view);
        if (n > 0) {
            return (View)this.kbdOrder.elementAt(n - 1);
        }
        return null;
    }

    boolean wantsKeyboardArrow() {
        return this.wantsKeyboardArrow;
    }

    void getDirtyRect(Rect rect) {
        int n;
        if (this.isDirty() && this.dirtyRect == null) {
            if (rect.isEmpty()) {
                rect.setBounds(this.bounds);
                return;
            }
            rect.unionWith(this.bounds);
            return;
        }
        if (this.dirtyRect != null) {
            if (rect.isEmpty()) {
                rect.setBounds(this.dirtyRect.x + this.bounds.x, this.dirtyRect.y + this.bounds.y, this.dirtyRect.width, this.dirtyRect.height);
            } else {
                rect.unionWith(this.dirtyRect.x + this.bounds.x, this.dirtyRect.y + this.bounds.y, this.dirtyRect.width, this.dirtyRect.height);
            }
        }
        if ((n = this.subviewCount()) != 0) {
            rect.moveBy(-this.bounds.x, -this.bounds.y);
            while (n-- > 0) {
                ((View)this.subviews.elementAt(n)).getDirtyRect(rect);
            }
            rect.moveBy(this.bounds.x, this.bounds.y);
        }
    }
}

