/*
 * Decompiled with CFR 0.152.
 */
package netscape.constructor;

import netscape.application.Application;
import netscape.application.Color;
import netscape.application.Font;
import netscape.application.Graphics;
import netscape.application.LineBorder;
import netscape.application.Target;
import netscape.application.View;
import netscape.constructor.Constructor;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ViewProxy
extends View
implements Target,
Codable {
    String viewClassName;
    String[] commands = new String[0];
    String shortName;
    private View _replacingView;
    public static final String CLASS_NAME_KEY = "viewClassName";
    public static final String COMMANDS_KEY = "commands";
    public static final String VIEWPROXY_CLASS_NAME = "netscape.constructor.ViewProxy";

    public ViewProxy() {
        this(0, 0, 0, 0);
    }

    public ViewProxy(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setViewClassName(VIEWPROXY_CLASS_NAME);
    }

    public void setViewClassName(String string) {
        int n;
        this.viewClassName = string;
        if (this.viewClassName == null || "".equals(this.viewClassName)) {
            this.viewClassName = VIEWPROXY_CLASS_NAME;
        }
        if ((n = this.viewClassName.lastIndexOf(46)) != -1) {
            this.shortName = this.viewClassName.substring(n + 1);
            return;
        }
        this.shortName = this.viewClassName;
    }

    public String viewClassName() {
        return this.viewClassName;
    }

    public void setCommands(String[] stringArray) {
        if (stringArray != null) {
            this.commands = stringArray;
            return;
        }
        this.commands = new String[0];
    }

    public String[] commands() {
        return this.commands;
    }

    public void drawView(Graphics graphics) {
        graphics.setColor(Color.gray);
        graphics.fillRect(this.localBounds());
        graphics.setColor(Color.white);
        graphics.setFont(Font.defaultFont());
        graphics.drawStringInRect(this.shortName, this.localBounds(), 1);
        LineBorder.blackLine().drawInRect(graphics, this.localBounds());
    }

    public boolean isTransparent() {
        return false;
    }

    public void performCommand(String string, Object object) {
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass(VIEWPROXY_CLASS_NAME, 1);
        classInfo.addField(CLASS_NAME_KEY, (byte)16);
        classInfo.addField(COMMANDS_KEY, (byte)17);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeString(CLASS_NAME_KEY, this.viewClassName);
        encoder.encodeStringArray(COMMANDS_KEY, this.commands, 0, this.commands.length);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.setViewClassName(decoder.decodeString(CLASS_NAME_KEY));
        this.setCommands(decoder.decodeStringArray(COMMANDS_KEY));
        if (Application.application() instanceof Constructor && (((Constructor)((Object)Application.application())).inConstructionMode() || VIEWPROXY_CLASS_NAME.equals(this.viewClassName))) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(this.viewClassName);
            if (clazz != null) {
                Object obj = clazz.newInstance();
                if (!(obj instanceof View)) {
                    System.err.println("CustomView: " + this + " decode error: " + this.viewClassName + " is not a View subclass.");
                    return;
                }
                this._replacingView = (View)obj;
                decoder.replaceObject(this._replacingView);
                return;
            }
        }
        catch (InstantiationException instantiationException) {
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        if (this._replacingView != null) {
            this.setAttributesToReplacingView(this._replacingView);
        }
        this._replacingView = null;
    }

    public void setAttributesToReplacingView(View view) {
        Vector vector = this.subviews();
        view.setBounds(this.bounds);
        view.setHorizResizeInstruction(this.horizResizeInstruction());
        view.setVertResizeInstruction(this.vertResizeInstruction());
        view.setBuffered(this.isBuffered());
        if (vector != null) {
            int n = vector.count();
            int n2 = 0;
            while (n2 < n) {
                view.addSubview((View)vector.elementAt(n2));
                ++n2;
            }
        }
    }
}

